/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pa extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TR = "\u0a24\u0a41\u0a30\u0a15\u0a40";
        final String metaValue_ar = "\u0a05\u0a30\u0a2c\u0a40";
        final String metaValue_bn = "\u0a2c\u0a70\u0a17\u0a3e\u0a32\u0a40";
        final String metaValue_bo = "\u0a24\u0a3f\u0a71\u0a2c\u0a24\u0a40";
        final String metaValue_gu = "\u0a17\u0a41\u0a1c\u0a30\u0a3e\u0a24\u0a40";
        final String metaValue_he = "\u0a39\u0a3f\u0a2c\u0a30\u0a42";
        final String metaValue_hy = "\u0a05\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a06\u0a08";
        final String metaValue_ja = "\u0a1c\u0a2a\u0a3e\u0a28\u0a40";
        final String metaValue_ka = "\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06\u0a08";
        final String metaValue_km = "\u0a16\u0a2e\u0a47\u0a30";
        final String metaValue_kn = "\u0a15\u0a70\u0a28\u0a5c";
        final String metaValue_ko = "\u0a15\u0a4b\u0a30\u0a40\u0a06\u0a08";
        final String metaValue_la = "\u0a32\u0a3e\u0a24\u0a40\u0a28\u0a40";
        final String metaValue_lo = "\u0a32\u0a3e\u0a13";
        final String metaValue_ml = "\u0a2e\u0a32\u0a3f\u0a06\u0a32\u0a2e";
        final String metaValue_mn = "\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40\u0a05\u0a28";
        final String metaValue_or = "\u0a09\u0a5c\u0a40\u0a06";
        final String metaValue_si = "\u0a38\u0a3f\u0a70\u0a39\u0a3e\u0a32\u0a3e";
        final String metaValue_ta = "\u0a24\u0a2e\u0a3f\u0a32";
        final String metaValue_te = "\u0a24\u0a47\u0a32\u0a17\u0a42";
        final String metaValue_th = "\u0a25\u0a3e\u0a08";
        final Object[][] data = new Object[][] {
            { "sbp", "\u0a38\u0a47\u0a02\u0a17\u0a4b" },
            { "nyn", "\u0a28\u0a3f\u0a06\u0a02\u0a15\u0a4b\u0a32\u0a47" },
            { "luo", "\u0a32\u0a42\u0a13" },
            { "Zsym", "\u0a1a\u0a3f\u0a70\u0a28\u0a4d\u0a39" },
            { "fil", "\u0a2b\u0a3f\u0a32\u0a40\u0a2a\u0a3f\u0a28\u0a4b" },
            { "luy", "\u0a32\u0a42\u0a08\u0a06" },
            { "egy", "\u0a2a\u0a41\u0a30\u0a3e\u0a24\u0a28 \u0a2e\u0a3f\u0a38\u0a30\u0a40" },
            { "raj", "\u0a30\u0a3e\u0a1c\u0a38\u0a25\u0a3e\u0a28\u0a40" },
            { "es_ES", "\u0a2f\u0a42\u0a30\u0a2a\u0a40 \u0a38\u0a2a\u0a47\u0a28\u0a40" },
            { "teo", "\u0a1f\u0a47\u0a38\u0a4b" },
            { "ab", "\u0a05\u0a2c\u0a16\u0a3e\u0a1c\u0a3c\u0a40\u0a05\u0a28" },
            { "AC", "\u0a05\u0a38\u0a48\u0a02\u0a38\u0a3c\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "AD", "\u0a05\u0a70\u0a21\u0a4b\u0a30\u0a3e" },
            { "AE", "\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a05\u0a30\u0a2c \u0a05\u0a2e\u0a40\u0a30\u0a3e\u0a24" },
            { "nl_BE", "\u0a2b\u0a32\u0a48\u0a2e\u0a3f\u0a38\u0a3c" },
            { "AF", "\u0a05\u0a2b\u0a3c\u0a17\u0a3e\u0a28\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "af", "\u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a40" },
            { "AG", "\u0a10\u0a02\u0a1f\u0a40\u0a17\u0a41\u0a06 \u0a05\u0a24\u0a47 \u0a2c\u0a3e\u0a30\u0a2c\u0a41\u0a21\u0a3e" },
            { "AI", "\u0a05\u0a70\u0a17\u0a41\u0a07\u0a32\u0a3e" },
            { "ak", "\u0a05\u0a15\u0a3e\u0a28" },
            { "AL", "\u0a05\u0a32\u0a2c\u0a3e\u0a28\u0a40\u0a06" },
            { "AM", "\u0a05\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a06" },
            { "am", "\u0a05\u0a2e\u0a39\u0a3e\u0a30\u0a3f\u0a15" },
            { "Arab", metaValue_ar },
            { "AO", "\u0a05\u0a70\u0a17\u0a4b\u0a32\u0a3e" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u0a05\u0a70\u0a1f\u0a3e\u0a30\u0a15\u0a1f\u0a3f\u0a15\u0a3e" },
            { "ar", metaValue_ar },
            { "AR", "\u0a05\u0a30\u0a1c\u0a28\u0a1f\u0a40\u0a28\u0a3e" },
            { "AS", "\u0a05\u0a2e\u0a48\u0a30\u0a40\u0a15\u0a28 \u0a38\u0a2e\u0a4b\u0a06" },
            { "as", "\u0a05\u0a38\u0a3e\u0a2e\u0a40" },
            { "AT", "\u0a06\u0a38\u0a1f\u0a30\u0a40\u0a06" },
            { "AU", "\u0a06\u0a38\u0a1f\u0a4d\u0a30\u0a47\u0a32\u0a40\u0a06" },
            { "AW", "\u0a05\u0a30\u0a42\u0a2c\u0a3e" },
            { "sdh", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a15\u0a41\u0a30\u0a26\u0a3f\u0a38\u0a3c" },
            { "en_US", "\u0a05\u0a2e\u0a30\u0a40\u0a15\u0a40 \u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "AX", "\u0a05\u0a32\u0a48\u0a02\u0a21 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "AZ", "\u0a05\u0a1c\u0a3c\u0a30\u0a2c\u0a3e\u0a08\u0a1c\u0a3e\u0a28" },
            { "az", "\u0a05\u0a1c\u0a3c\u0a30\u0a2c\u0a3e\u0a08\u0a1c\u0a3e\u0a28\u0a40" },
            { "BA", "\u0a2c\u0a4b\u0a38\u0a28\u0a40\u0a06 \u0a05\u0a24\u0a47 \u0a39\u0a30\u0a1c\u0a3c\u0a47\u0a17\u0a4b\u0a35\u0a40\u0a28\u0a3e" },
            { "ba", "\u0a2c\u0a38\u0a3c\u0a15\u0a40\u0a30" },
            { "BB", "\u0a2c\u0a3e\u0a30\u0a2c\u0a3e\u0a21\u0a4b\u0a38" },
            { "BD", "\u0a2c\u0a70\u0a17\u0a32\u0a3e\u0a26\u0a47\u0a38\u0a3c" },
            { "BE", "\u0a2c\u0a48\u0a32\u0a1c\u0a40\u0a05\u0a2e" },
            { "be", "\u0a2c\u0a47\u0a32\u0a3e\u0a30\u0a42\u0a38\u0a40" },
            { "BF", "\u0a2c\u0a41\u0a30\u0a15\u0a40\u0a28\u0a3e \u0a2b\u0a3c\u0a3e\u0a38\u0a4b" },
            { "BG", "\u0a2c\u0a41\u0a32\u0a17\u0a3e\u0a30\u0a40\u0a06" },
            { "bg", "\u0a2c\u0a41\u0a32\u0a17\u0a3e\u0a30\u0a40\u0a06\u0a08" },
            { "BH", "\u0a2c\u0a39\u0a3f\u0a30\u0a40\u0a28" },
            { "BI", "\u0a2c\u0a41\u0a30\u0a41\u0a70\u0a21\u0a40" },
            { "BJ", "\u0a2c\u0a47\u0a28\u0a3f\u0a28" },
            { "BL", "\u0a38\u0a47\u0a02\u0a1f \u0a2c\u0a3e\u0a30\u0a25\u0a47\u0a32\u0a47\u0a2e\u0a40" },
            { "BM", "\u0a2c\u0a30\u0a2e\u0a42\u0a21\u0a3e" },
            { "bm", "\u0a2c\u0a70\u0a2c\u0a3e\u0a30\u0a3e" },
            { "bn", metaValue_bn },
            { "BN", "\u0a2c\u0a30\u0a42\u0a28\u0a47\u0a08" },
            { "bo", metaValue_bo },
            { "BO", "\u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a06" },
            { "BQ", "\u0a15\u0a48\u0a30\u0a47\u0a2c\u0a40\u0a06\u0a08 \u0a28\u0a40\u0a26\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "BR", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32" },
            { "br", "\u0a2c\u0a30\u0a47\u0a1f\u0a28" },
            { "BS", "\u0a2c\u0a39\u0a3e\u0a2e\u0a3e\u0a38" },
            { "bs", "\u0a2c\u0a4b\u0a38\u0a28\u0a40\u0a06\u0a08" },
            { "xog", "\u0a38\u0a4b\u0a17\u0a3e" },
            { "BT", "\u0a2d\u0a42\u0a1f\u0a3e\u0a28" },
            { "BV", "\u0a2c\u0a4c\u0a35\u0a47\u0a1f \u0a1f\u0a3e\u0a2a\u0a42" },
            { "BW", "\u0a2c\u0a4b\u0a1f\u0a38\u0a35\u0a3e\u0a28\u0a3e" },
            { "Mymr", "\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30" },
            { "BY", "\u0a2c\u0a47\u0a32\u0a3e\u0a30\u0a42\u0a38" },
            { "seh", "\u0a38\u0a47\u0a28\u0a3e" },
            { "BZ", "\u0a2c\u0a47\u0a32\u0a40\u0a1c\u0a3c" },
            { "CA", "\u0a15\u0a48\u0a28\u0a47\u0a21\u0a3e" },
            { "ca", "\u0a15\u0a48\u0a1f\u0a3e\u0a32\u0a3e\u0a28" },
            { "CC", "\u0a15\u0a4b\u0a15\u0a4b\u0a38 (\u0a15\u0a40\u0a32\u0a3f\u0a70\u0a17) \u0a1f\u0a3e\u0a2a\u0a42" },
            { "mzn", "\u0a2e\u0a47\u0a1c\u0a3c\u0a48\u0a02\u0a21\u0a30\u0a3e\u0a28\u0a40" },
            { "ses", "\u0a15\u0a4b\u0a07\u0a30\u0a3e\u0a2c\u0a4b\u0a30\u0a4b \u0a38\u0a47\u0a02\u0a28\u0a40" },
            { "CD", "\u0a15\u0a3e\u0a02\u0a17\u0a4b - \u0a15\u0a3f\u0a70\u0a38\u0a3c\u0a3e\u0a38\u0a3e" },
            { "ce", "\u0a1a\u0a47\u0a1a\u0a28" },
            { "CF", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a40 \u0a17\u0a23\u0a30\u0a3e\u0a1c" },
            { "CG", "\u0a15\u0a3e\u0a02\u0a17\u0a4b - \u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a3e\u0a35\u0a3f\u0a32\u0a47" },
            { "CH", "\u0a38\u0a35\u0a3f\u0a1f\u0a1c\u0a3c\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "CI", "\u0a15\u0a4b\u0a1f \u0a21\u0a40\u0a35\u0a4b\u0a06\u0a30" },
            { "CK", "\u0a15\u0a41\u0a71\u0a15 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "CL", "\u0a1a\u0a3f\u0a32\u0a40" },
            { "CM", "\u0a15\u0a48\u0a2e\u0a30\u0a42\u0a28" },
            { "CN", "\u0a1a\u0a40\u0a28" },
            { "CO", "\u0a15\u0a4b\u0a32\u0a70\u0a2c\u0a40\u0a06" },
            { "co", "\u0a15\u0a4b\u0a30\u0a38\u0a40\u0a15\u0a28" },
            { "CP", "\u0a15\u0a32\u0a3f\u0a71\u0a2a\u0a30\u0a1f\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "Orya", metaValue_or },
            { "CR", "\u0a15\u0a4b\u0a38\u0a1f\u0a3e \u0a30\u0a40\u0a15\u0a3e" },
            { "cs", "\u0a1a\u0a48\u0a15" },
            { "CU", "\u0a15\u0a3f\u0a0a\u0a2c\u0a3e" },
            { "CV", "\u0a15\u0a47\u0a2a \u0a35\u0a30\u0a21\u0a47" },
            { "cv", "\u0a1a\u0a41\u0a35\u0a3e\u0a38\u0a3c" },
            { "CW", "\u0a15\u0a41\u0a30\u0a3e\u0a15\u0a3e\u0a13" },
            { "CX", "\u0a15\u0a4d\u0a30\u0a3f\u0a38\u0a2e\u0a3f\u0a38 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "CY", "\u0a38\u0a3e\u0a07\u0a2a\u0a4d\u0a30\u0a38" },
            { "cy", "\u0a35\u0a48\u0a32\u0a1c\u0a3c" },
            { "CZ", "\u0a1a\u0a48\u0a15 \u0a17\u0a23\u0a30\u0a3e\u0a1c" },
            { "da", "\u0a21\u0a48\u0a28\u0a3f\u0a38\u0a3c" },
            { "pt_PT", "\u0a2f\u0a42\u0a30\u0a2a\u0a40 \u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32\u0a40" },
            { "DE", "\u0a1c\u0a30\u0a2e\u0a28\u0a40" },
            { "de", "\u0a1c\u0a30\u0a2e\u0a28" },
            { "ace", "\u0a05\u0a1a\u0a40\u0a28\u0a40" },
            { "cgg", "\u0a1a\u0a40\u0a17\u0a3e" },
            { "DG", "\u0a21\u0a40\u0a07\u0a17\u0a4b \u0a17\u0a3e\u0a30\u0a38\u0a40\u0a06" },
            { "DJ", "\u0a1c\u0a3c\u0a40\u0a2c\u0a42\u0a24\u0a40" },
            { "DK", "\u0a21\u0a48\u0a28\u0a2e\u0a3e\u0a30\u0a15" },
            { "ach", "\u0a05\u0a15\u0a4b\u0a32\u0a40" },
            { "Brai", "\u0a2c\u0a30\u0a47\u0a32" },
            { "DM", "\u0a21\u0a4b\u0a2e\u0a40\u0a28\u0a3f\u0a15\u0a3e" },
            { "DO", "\u0a21\u0a4b\u0a2e\u0a40\u0a28\u0a3f\u0a15\u0a3e\u0a08 \u0a17\u0a23\u0a30\u0a3e\u0a1c" },
            { "bem", "\u0a2c\u0a47\u0a2e\u0a2c\u0a3e" },
            { "es_419", "\u0a32\u0a3e\u0a24\u0a40\u0a28\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a40 \u0a38\u0a2a\u0a47\u0a28\u0a40" },
            { "DZ", "\u0a05\u0a32\u0a1c\u0a40\u0a30\u0a40\u0a06" },
            { "dz", "\u0a1c\u0a3c\u0a4b\u0a02\u0a17\u0a16\u0a3e" },
            { "bez", "\u0a2c\u0a47\u0a28\u0a3e" },
            { "EA", "\u0a38\u0a3f\u0a13\u0a1f\u0a3e \u0a05\u0a24\u0a47 \u0a2e\u0a47\u0a32\u0a3f\u0a71\u0a32\u0a3e" },
            { "EC", "\u0a07\u0a15\u0a35\u0a47\u0a21\u0a4b\u0a30" },
            { "dje", "\u0a1c\u0a3c\u0a3e\u0a30\u0a2e\u0a3e" },
            { "EE", "\u0a07\u0a38\u0a1f\u0a4b\u0a28\u0a40\u0a06" },
            { "ee", "\u0a08\u0a35\u0a08" },
            { "EG", "\u0a2e\u0a3f\u0a38\u0a30" },
            { "EH", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a38\u0a39\u0a3e\u0a30\u0a3e" },
            { "ro_MD", "\u0a2e\u0a4b\u0a32\u0a21\u0a3e\u0a35\u0a40\u0a06\u0a08" },
            { "el", "\u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40" },
            { "en", "\u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "chm", "\u0a2e\u0a3e\u0a30\u0a40" },
            { "eo", "\u0a07\u0a38\u0a2a\u0a47\u0a30\u0a3e\u0a02\u0a1f\u0a4b" },
            { "chr", "\u0a1a\u0a47\u0a30\u0a4b\u0a15\u0a40" },
            { "ER", "\u0a07\u0a30\u0a40\u0a1f\u0a4d\u0a30\u0a3f\u0a06" },
            { "ES", "\u0a38\u0a2a\u0a47\u0a28" },
            { "es", "\u0a38\u0a2a\u0a47\u0a28\u0a40" },
            { "ET", "\u0a07\u0a25\u0a4b\u0a2a\u0a40\u0a06" },
            { "et", "\u0a07\u0a38\u0a1f\u0a4b\u0a28\u0a40\u0a06\u0a08" },
            { "EU", "\u0a2f\u0a42\u0a30\u0a2a\u0a40 \u0a2f\u0a42\u0a28\u0a40\u0a05\u0a28" },
            { "eu", "\u0a2c\u0a3e\u0a38\u0a15" },
            { "Hang", "\u0a39\u0a70\u0a17\u0a41\u0a32" },
            { "shi", "\u0a1f\u0a1a\u0a47\u0a32\u0a39\u0a3f\u0a1f" },
            { "hsb", "\u0a05\u0a71\u0a2a\u0a30 \u0a38\u0a4b\u0a30\u0a2c\u0a40\u0a05\u0a28" },
            { "Hani", "\u0a39\u0a3e\u0a28" },
            { "shn", "\u0a38\u0a3c\u0a3e\u0a28" },
            { "fa", "\u0a2b\u0a3c\u0a3e\u0a30\u0a38\u0a40" },
            { "Hans", "\u0a38\u0a30\u0a32" },
            { "Hant", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40" },
            { "FI", "\u0a2b\u0a3f\u0a28\u0a32\u0a48\u0a02\u0a21" },
            { "fi", "\u0a2b\u0a3f\u0a28\u0a3f\u0a38\u0a3c" },
            { "FJ", "\u0a2b\u0a3c\u0a3f\u0a1c\u0a40" },
            { "fj", "\u0a2b\u0a3c\u0a3f\u0a1c\u0a3c\u0a40" },
            { "FK", "\u0a2b\u0a3c\u0a3e\u0a15\u0a32\u0a48\u0a02\u0a21 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "FM", "\u0a2e\u0a3e\u0a07\u0a15\u0a4d\u0a30\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "bgn", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a2c\u0a32\u0a42\u0a1a\u0a40" },
            { "FO", "\u0a2b\u0a48\u0a30\u0a4b \u0a1f\u0a3e\u0a2a\u0a42" },
            { "fo", "\u0a2b\u0a3c\u0a47\u0a30\u0a4b\u0a38\u0a47" },
            { "Taml", metaValue_ta },
            { "FR", "\u0a2b\u0a3c\u0a30\u0a3e\u0a02\u0a38" },
            { "fr", "\u0a2b\u0a30\u0a3e\u0a02\u0a38\u0a40\u0a38\u0a40" },
            { "fy", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a2b\u0a4d\u0a30\u0a3f\u0a38\u0a40\u0a05\u0a28" },
            { "grc", "\u0a2a\u0a41\u0a30\u0a3e\u0a24\u0a28 \u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40" },
            { "GA", "\u0a17\u0a2c\u0a4b\u0a28" },
            { "ga", "\u0a06\u0a07\u0a30\u0a40" },
            { "GB", "\u0a2f\u0a42\u0a28\u0a3e\u0a08\u0a1f\u0a21 \u0a15\u0a3f\u0a70\u0a17\u0a21\u0a2e" },
            { "GD", "\u0a17\u0a4d\u0a30\u0a47\u0a28\u0a3e\u0a21\u0a3e" },
            { "GE", "\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06" },
            { "GF", "\u0a2b\u0a3c\u0a30\u0a48\u0a02\u0a1a \u0a17\u0a41\u0a06\u0a28\u0a3e" },
            { "GG", "\u0a17\u0a30\u0a28\u0a1c\u0a40" },
            { "GH", "\u0a18\u0a3e\u0a28\u0a3e" },
            { "GI", "\u0a1c\u0a3f\u0a2c\u0a30\u0a3e\u0a32\u0a1f\u0a30" },
            { "GL", "\u0a17\u0a4d\u0a30\u0a40\u0a28\u0a32\u0a48\u0a02\u0a21" },
            { "gl", "\u0a17\u0a48\u0a32\u0a3f\u0a38\u0a3c\u0a3f\u0a05\u0a28" },
            { "GM", "\u0a17\u0a48\u0a02\u0a2c\u0a40\u0a06" },
            { "GN", "\u0a17\u0a3f\u0a28\u0a40" },
            { "gn", "\u0a17\u0a41\u0a06\u0a30\u0a3e\u0a28\u0a40" },
            { "bho", "\u0a2d\u0a4b\u0a1c\u0a2a\u0a41\u0a30\u0a40" },
            { "GP", "\u0a17\u0a41\u0a06\u0a21\u0a47\u0a32\u0a4b\u0a2a" },
            { "GQ", "\u0a2d\u0a42-\u0a16\u0a70\u0a21\u0a40 \u0a17\u0a3f\u0a28\u0a40" },
            { "und", "\u0a05\u0a17\u0a3f\u0a06\u0a24 \u0a2d\u0a3e\u0a38\u0a3c\u0a3e" },
            { "GR", "\u0a17\u0a4d\u0a30\u0a40\u0a38" },
            { "GS", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06 \u0a05\u0a24\u0a47 \u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a48\u0a02\u0a21\u0a35\u0a3f\u0a1a \u0a1f\u0a3e\u0a2a\u0a42" },
            { "GT", "\u0a17\u0a41\u0a06\u0a1f\u0a47\u0a2e\u0a3e\u0a32\u0a3e" },
            { "gu", metaValue_gu },
            { "GU", "\u0a17\u0a41\u0a06\u0a2e" },
            { "gv", "\u0a2e\u0a48\u0a02\u0a15\u0a38" },
            { "GW", "\u0a17\u0a3f\u0a28\u0a40-\u0a2c\u0a3f\u0a38\u0a3e\u0a09" },
            { "GY", "\u0a17\u0a41\u0a2f\u0a3e\u0a28\u0a3e" },
            { "ha", "\u0a39\u0a4c\u0a38\u0a3e" },
            { "ckb", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a15\u0a41\u0a30\u0a26\u0a3f\u0a38\u0a3c" },
            { "zxx", "\u0a15\u0a4b\u0a08 \u0a2d\u0a3e\u0a38\u0a3c\u0a3e\u0a08 \u0a38\u0a2e\u0a71\u0a17\u0a30\u0a40 \u0a28\u0a39\u0a40\u0a02" },
            { "he", metaValue_he },
            { "hi", "\u0a39\u0a3f\u0a70\u0a26\u0a40" },
            { "de_AT", "\u0a06\u0a38\u0a1f\u0a30\u0a40\u0a06\u0a08 \u0a1c\u0a30\u0a2e\u0a28" },
            { "HK", "\u0a39\u0a3e\u0a02\u0a17 \u0a15\u0a3e\u0a02\u0a17 \u0a10\u0a38\u0a0f\u0a06\u0a30 \u0a1a\u0a40\u0a28" },
            { "HM", "\u0a39\u0a30\u0a21 \u0a24\u0a47 \u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a3e\u0a32\u0a21 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "HN", "\u0a39\u0a4b\u0a02\u0a21\u0a41\u0a30\u0a38" },
            { "HR", "\u0a15\u0a30\u0a4b\u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "hr", "\u0a15\u0a4d\u0a30\u0a4b\u0a0f\u0a38\u0a3c\u0a3f\u0a06\u0a08" },
            { "agq", "\u0a05\u0a17\u0a47\u0a2e" },
            { "gsw", "\u0a38\u0a35\u0a3f\u0a38 \u0a1c\u0a30\u0a2e\u0a28" },
            { "HT", "\u0a39\u0a48\u0a24\u0a40" },
            { "ht", "\u0a39\u0a48\u0a24\u0a40\u0a06\u0a08" },
            { "HU", "\u0a39\u0a70\u0a17\u0a30\u0a40" },
            { "hu", "\u0a39\u0a70\u0a17\u0a30\u0a40\u0a06\u0a08" },
            { "hy", metaValue_hy },
            { "IC", "\u0a15\u0a47\u0a28\u0a3e\u0a30\u0a40 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "ID", "\u0a07\u0a70\u0a21\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "id", "\u0a07\u0a70\u0a21\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06\u0a08" },
            { "IE", "\u0a06\u0a07\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "ig", "\u0a07\u0a17\u0a2c\u0a4b" },
            { "naq", "\u0a28\u0a3e\u0a2e\u0a3e" },
            { "ii", "\u0a38\u0a3f\u0a1a\u0a41\u0a06\u0a28 \u0a2f\u0a40" },
            { "IL", "\u0a07\u0a1c\u0a3c\u0a30\u0a3e\u0a08\u0a32" },
            { "IM", "\u0a06\u0a07\u0a32 \u0a06\u0a2b \u0a2e\u0a48\u0a28" },
            { "IN", "\u0a2d\u0a3e\u0a30\u0a24" },
            { "IO", "\u0a2c\u0a30\u0a24\u0a3e\u0a28\u0a35\u0a40 \u0a39\u0a3f\u0a70\u0a26 \u0a2e\u0a39\u0a3e\u0a02\u0a38\u0a3e\u0a17\u0a30 \u0a2a\u0a4d\u0a30\u0a26\u0a47\u0a38\u0a3c" },
            { "IQ", "\u0a07\u0a30\u0a3e\u0a15" },
            { "IR", "\u0a08\u0a30\u0a3e\u0a28" },
            { "IS", "\u0a06\u0a08\u0a38\u0a32\u0a48\u0a02\u0a21" },
            { "is", "\u0a06\u0a08\u0a38\u0a32\u0a48\u0a02\u0a21\u0a3f\u0a15" },
            { "IT", "\u0a07\u0a1f\u0a32\u0a40" },
            { "it", "\u0a07\u0a24\u0a3e\u0a32\u0a35\u0a40" },
            { "iu", "\u0a07\u0a70\u0a15\u0a1f\u0a40\u0a1f\u0a42\u0a24" },
            { "Zmth", "\u0a17\u0a23\u0a3f\u0a24 \u0a1a\u0a3f\u0a70\u0a28\u0a4d\u0a39-\u0a32\u0a3f\u0a2a\u0a40" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "\u0a1c\u0a30\u0a38\u0a40" },
            { "Beng", metaValue_bn },
            { "JM", "\u0a1c\u0a2e\u0a3e\u0a07\u0a15\u0a3e" },
            { "JO", "\u0a1c\u0a3e\u0a30\u0a21\u0a28" },
            { "JP", "\u0a1c\u0a2a\u0a3e\u0a28" },
            { "sma", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a3e\u0a2e\u0a40" },
            { "jv", "\u0a1c\u0a3e\u0a35\u0a3e\u0a28\u0a40\u0a1c\u0a3c" },
            { "guz", "\u0a17\u0a41\u0a38\u0a40" },
            { "smj", "\u0a32\u0a3f\u0a0a\u0a32 \u0a38\u0a3e\u0a2e\u0a40" },
            { "de_CH", "\u0a38\u0a35\u0a3f\u0a38 \u0a39\u0a3e\u0a08 \u0a1c\u0a30\u0a2e\u0a28" },
            { "mai", "\u0a2e\u0a48\u0a25\u0a32\u0a40" },
            { "smn", "\u0a07\u0a28\u0a3e\u0a30\u0a40 \u0a38\u0a3e\u0a2e\u0a40" },
            { "ka", metaValue_ka },
            { "sms", "\u0a38\u0a15\u0a4c\u0a32\u0a1f \u0a38\u0a3e\u0a2e\u0a40" },
            { "KE", "\u0a15\u0a40\u0a28\u0a40\u0a06" },
            { "419", "\u0a32\u0a3e\u0a24\u0a40\u0a28\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "KG", "\u0a15\u0a3f\u0a30\u0a17\u0a3f\u0a1c\u0a3c\u0a38\u0a24\u0a3e\u0a28" },
            { "KH", "\u0a15\u0a70\u0a2c\u0a4b\u0a21\u0a40\u0a06" },
            { "KI", "\u0a15\u0a3f\u0a30\u0a2c\u0a3e\u0a24\u0a40" },
            { "ki", "\u0a15\u0a3f\u0a15\u0a42\u0a2f\u0a42" },
            { "mas", "\u0a2e\u0a38\u0a3e\u0a08" },
            { "kk", "\u0a15\u0a1c\u0a3c\u0a3e\u0a16\u0a3c" },
            { "kl", "\u0a15\u0a32\u0a3e\u0a05\u0a71\u0a32\u0a40\u0a38\u0a41\u0a1f" },
            { "km", metaValue_km },
            { "KM", "\u0a15\u0a4b\u0a2e\u0a4b\u0a30\u0a4b\u0a38" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "\u0a38\u0a48\u0a02\u0a1f \u0a15\u0a3f\u0a1f\u0a38 \u0a10\u0a02\u0a21 \u0a28\u0a47\u0a35\u0a3f\u0a38" },
            { "fr_CA", "\u0a15\u0a48\u0a28\u0a47\u0a21\u0a40\u0a05\u0a28 \u0a2b\u0a30\u0a3e\u0a02\u0a38\u0a40\u0a38\u0a40" },
            { "ko", metaValue_ko },
            { "KP", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a15\u0a4b\u0a30\u0a40\u0a06" },
            { "KR", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a15\u0a4b\u0a30\u0a40\u0a06" },
            { "ks", "\u0a15\u0a38\u0a3c\u0a2e\u0a40\u0a30\u0a40" },
            { "ku", "\u0a15\u0a41\u0a30\u0a26" },
            { "fr_CH", "\u0a38\u0a35\u0a3f\u0a38 \u0a2b\u0a30\u0a3e\u0a02\u0a38\u0a40\u0a38\u0a40" },
            { "KW", "\u0a15\u0a41\u0a35\u0a48\u0a24" },
            { "kw", "\u0a15\u0a4b\u0a30\u0a28\u0a3f\u0a38\u0a3c" },
            { "KY", "\u0a15\u0a47\u0a2e\u0a48\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "ky", "\u0a15\u0a3f\u0a30\u0a17\u0a40\u0a1c\u0a3c" },
            { "KZ", "\u0a15\u0a1c\u0a3c\u0a3e\u0a16\u0a38\u0a24\u0a3e\u0a28" },
            { "Cyrl", "\u0a38\u0a3f\u0a30\u0a40\u0a32\u0a3f\u0a15" },
            { "la", metaValue_la },
            { "LA", "\u0a32\u0a3e\u0a13\u0a38" },
            { "LB", "\u0a32\u0a48\u0a2c\u0a28\u0a3e\u0a28" },
            { "lb", "\u0a32\u0a15\u0a1c\u0a3c\u0a2e\u0a2c\u0a30\u0a17\u0a3f\u0a38\u0a3c" },
            { "LC", "\u0a38\u0a47\u0a02\u0a1f \u0a32\u0a42\u0a38\u0a40\u0a06" },
            { "lg", "\u0a17\u0a3e\u0a02\u0a21\u0a3e" },
            { "nds", "\u0a32\u0a4b \u0a1c\u0a30\u0a2e\u0a28" },
            { "LI", "\u0a32\u0a3f\u0a1a\u0a47\u0a02\u0a38\u0a1f\u0a3e\u0a07\u0a28" },
            { "LK", "\u0a38\u0a4d\u0a30\u0a40 \u0a32\u0a70\u0a15\u0a3e" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0a32\u0a3f\u0a70\u0a17\u0a3e\u0a32\u0a3e" },
            { "lo", metaValue_lo },
            { "LR", "\u0a32\u0a3e\u0a08\u0a2c\u0a40\u0a30\u0a40\u0a06" },
            { "LS", "\u0a32\u0a47\u0a38\u0a4b\u0a25\u0a4b" },
            { "LT", "\u0a32\u0a3f\u0a25\u0a41\u0a06\u0a28\u0a40\u0a06" },
            { "lt", "\u0a32\u0a3f\u0a25\u0a41\u0a06\u0a28\u0a40\u0a05\u0a28" },
            { "LU", "\u0a32\u0a15\u0a1c\u0a3c\u0a2e\u0a2c\u0a30\u0a17" },
            { "lu", "\u0a32\u0a42\u0a2c\u0a3e-\u0a15\u0a3e\u0a1f\u0a3e\u0a02\u0a17\u0a3e" },
            { "LV", "\u0a32\u0a3e\u0a1f\u0a35\u0a40\u0a06" },
            { "lv", "\u0a32\u0a3e\u0a1f\u0a35\u0a3f\u0a05\u0a28" },
            { "Kana", "\u0a15\u0a3e\u0a1f\u0a3e\u0a15\u0a3e\u0a28\u0a3e" },
            { "LY", "\u0a32\u0a40\u0a2c\u0a40\u0a06" },
            { "vun", "\u0a35\u0a42\u0a70\u0a1c\u0a4b" },
            { "lag", "\u0a32\u0a70\u0a17\u0a3e\u0a08" },
            { "Thaa", "\u0a25\u0a3e\u0a28\u0a3e" },
            { "MA", "\u0a2e\u0a4b\u0a30\u0a71\u0a15\u0a4b" },
            { "MC", "\u0a2e\u0a4b\u0a28\u0a3e\u0a15\u0a4b" },
            { "MD", "\u0a2e\u0a4b\u0a32\u0a21\u0a4b\u0a35\u0a3e" },
            { "ME", "\u0a2e\u0a4b\u0a02\u0a1f\u0a47\u0a28\u0a47\u0a17\u0a30\u0a4b" },
            { "MF", "\u0a38\u0a47\u0a02\u0a1f \u0a2e\u0a3e\u0a30\u0a1f\u0a3f\u0a28" },
            { "MG", "\u0a2e\u0a48\u0a21\u0a3e\u0a17\u0a3e\u0a38\u0a15\u0a30" },
            { "mg", "\u0a2e\u0a47\u0a32\u0a47\u0a17\u0a38\u0a40" },
            { "Thai", metaValue_th },
            { "MH", "\u0a2e\u0a3e\u0a30\u0a38\u0a3c\u0a32 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "mi", "\u0a2e\u0a3e\u0a09\u0a30\u0a40" },
            { "MK", "\u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a40\u0a06" },
            { "mk", "\u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a40\u0a06\u0a08" },
            { "ml", metaValue_ml },
            { "ML", "\u0a2e\u0a3e\u0a32\u0a40" },
            { "MM", "\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30 (\u0a2c\u0a30\u0a2e\u0a3e)" },
            { "mn", metaValue_mn },
            { "MN", "\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40\u0a06" },
            { "MO", "\u0a2e\u0a15\u0a3e\u0a09 \u0a10\u0a38\u0a0f\u0a06\u0a30 \u0a1a\u0a40\u0a28" },
            { "MP", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2e\u0a3e\u0a30\u0a40\u0a06\u0a28\u0a3e \u0a1f\u0a3e\u0a2a\u0a42" },
            { "MQ", "\u0a2e\u0a3e\u0a30\u0a1f\u0a40\u0a28\u0a3f\u0a15" },
            { "MR", "\u0a2e\u0a4b\u0a30\u0a3f\u0a1f\u0a3e\u0a28\u0a40\u0a06" },
            { "mr", "\u0a2e\u0a30\u0a3e\u0a20\u0a40" },
            { "MS", "\u0a2e\u0a4b\u0a02\u0a1f\u0a38\u0a47\u0a30\u0a3e\u0a24" },
            { "ms", "\u0a2e\u0a32\u0a2f" },
            { "MT", "\u0a2e\u0a3e\u0a32\u0a1f\u0a3e" },
            { "mt", "\u0a2e\u0a3e\u0a32\u0a1f\u0a40\u0a1c\u0a3c" },
            { "MU", "\u0a2e\u0a4c\u0a30\u0a3f\u0a38\u0a3c\u0a38" },
            { "MV", "\u0a2e\u0a3e\u0a32\u0a26\u0a40\u0a35" },
            { "MW", "\u0a2e\u0a32\u0a3e\u0a35\u0a40" },
            { "MX", "\u0a2e\u0a48\u0a15\u0a38\u0a40\u0a15\u0a4b" },
            { "MY", "\u0a2e\u0a32\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "my", "\u0a2c\u0a30\u0a2e\u0a40" },
            { "Armn", metaValue_hy },
            { "MZ", "\u0a2e\u0a4b\u0a1c\u0a3c\u0a3e\u0a2e\u0a2c\u0a40\u0a15" },
            { "dsb", "\u0a32\u0a4b\u0a05\u0a30 \u0a38\u0a4b\u0a30\u0a2c\u0a40\u0a05\u0a28" },
            { "NA", "\u0a28\u0a3e\u0a2e\u0a40\u0a2c\u0a40\u0a06" },
            { "nb", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a3f\u0a06\u0a08 \u0a2c\u0a4b\u0a15\u0a2e\u0a32" },
            { "NC", "\u0a28\u0a3f\u0a0a \u0a15\u0a48\u0a32\u0a47\u0a21\u0a4b\u0a28\u0a40\u0a06" },
            { "nd", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a28\u0a21\u0a47\u0a2c\u0a47\u0a32\u0a47" },
            { "NE", "\u0a28\u0a3e\u0a08\u0a1c\u0a30" },
            { "ne", "\u0a28\u0a47\u0a2a\u0a3e\u0a32\u0a40" },
            { "NF", "\u0a28\u0a4b\u0a30\u0a2b\u0a4c\u0a15 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "NG", "\u0a28\u0a3e\u0a08\u0a1c\u0a40\u0a30\u0a40\u0a06" },
            { "NI", "\u0a28\u0a3f\u0a15\u0a3e\u0a30\u0a3e\u0a17\u0a41\u0a06" },
            { "NL", "\u0a28\u0a40\u0a26\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "nl", "\u0a21\u0a71\u0a1a" },
            { "nn", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a3f\u0a06\u0a08 \u0a28\u0a3f\u0a13\u0a28\u0a4c\u0a30\u0a38\u0a15" },
            { "NO", "\u0a28\u0a3e\u0a30\u0a35\u0a47" },
            { "no", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a40\u0a05\u0a28" },
            { "NP", "\u0a28\u0a47\u0a2a\u0a3e\u0a32" },
            { "NR", "\u0a28\u0a3e\u0a09\u0a30\u0a42" },
            { "NU", "\u0a28\u0a3f\u0a2f\u0a42" },
            { "rof", "\u0a30\u0a4b\u0a2e\u0a2c\u0a4b" },
            { "NZ", "\u0a28\u0a3f\u0a0a\u0a1c\u0a3c\u0a40\u0a32\u0a48\u0a02\u0a21" },
            { "kab", "\u0a15\u0a2c\u0a3e\u0a07\u0a32" },
            { "kam", "\u0a15\u0a70\u0a2c\u0a3e" },
            { "ang", "\u0a2a\u0a41\u0a30\u0a3e\u0a23\u0a40 \u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "mer", "\u0a2e\u0a47\u0a30\u0a42" },
            { "OM", "\u0a13\u0a2e\u0a3e\u0a28" },
            { "om", "\u0a13\u0a30\u0a4b\u0a2e\u0a4b" },
            { "or", metaValue_or },
            { "mfe", "\u0a2e\u0a4b\u0a30\u0a40\u0a38\u0a3f\u0a05\u0a28" },
            { "PA", "\u0a2a\u0a28\u0a3e\u0a2e\u0a3e" },
            { "pa", "\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40" },
            { "dua", "\u0a21\u0a42\u0a06\u0a32\u0a3e" },
            { "en_GB", "\u0a2c\u0a30\u0a24\u0a3e\u0a28\u0a35\u0a40 \u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "PE", "\u0a2a\u0a47\u0a30\u0a42" },
            { "PF", "\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a2a\u0a4b\u0a32\u0a40\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "PG", "\u0a2a\u0a3e\u0a2a\u0a42\u0a06 \u0a28\u0a3f\u0a0a \u0a17\u0a3f\u0a28\u0a40" },
            { "PH", "\u0a2b\u0a3f\u0a32\u0a40\u0a2a\u0a40\u0a02\u0a38" },
            { "pi", "\u0a2a\u0a32\u0a40" },
            { "PK", "\u0a2a\u0a3e\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "PL", "\u0a2a\u0a4b\u0a32\u0a48\u0a02\u0a21" },
            { "pl", "\u0a2a\u0a4b\u0a32\u0a48\u0a02\u0a21\u0a40" },
            { "PM", "\u0a38\u0a48\u0a02\u0a1f \u0a2a\u0a40\u0a05\u0a30\u0a47 \u0a10\u0a02\u0a21 \u0a2e\u0a3f\u0a15\u0a47\u0a32\u0a28" },
            { "PN", "\u0a2a\u0a3f\u0a1f\u0a15\u0a47\u0a30\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "PR", "\u0a2a\u0a3f\u0a0a\u0a30\u0a1f\u0a4b \u0a30\u0a3f\u0a15\u0a4b" },
            { "PS", "\u0a2b\u0a3f\u0a32\u0a40\u0a38\u0a24\u0a40\u0a28\u0a40 \u0a16\u0a47\u0a24\u0a30" },
            { "ps", "\u0a2a\u0a38\u0a3c\u0a24\u0a4b" },
            { "PT", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32" },
            { "pt", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32\u0a40" },
            { "PW", "\u0a2a\u0a32\u0a3e\u0a09" },
            { "PY", "\u0a2a\u0a48\u0a30\u0a3e\u0a17\u0a35\u0a47" },
            { "pt_BR", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40\u0a06\u0a08 \u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32\u0a40" },
            { "Hebr", metaValue_he },
            { "mgh", "\u0a2e\u0a16\u0a4b\u0a35\u0a3e-\u0a2e\u0a3f\u0a71\u0a1f\u0a4b" },
            { "QA", "\u0a15\u0a24\u0a30" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0a2e\u0a47\u0a1f\u0a3e" },
            { "QO", "\u0a06\u0a0a\u0a1f\u0a32\u0a3e\u0a07\u0a70\u0a17 \u0a13\u0a38\u0a3c\u0a40\u0a28\u0a40\u0a06" },
            { "qu", "\u0a15\u0a15\u0a47\u0a38\u0a3c\u0a41\u0a06" },
            { "brx", "\u0a2c\u0a4b\u0a21\u0a4b" },
            { "kde", "\u0a2e\u0a15\u0a4b\u0a02\u0a21" },
            { "001", "\u0a38\u0a70\u0a38\u0a3e\u0a30" },
            { "Ethi", "\u0a07\u0a25\u0a40\u0a13\u0a2a\u0a3f\u0a15" },
            { "002", "\u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "003", "\u0a09\u0a71\u0a24\u0a30 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "RE", "\u0a30\u0a3f\u0a2f\u0a42\u0a28\u0a40\u0a05\u0a28" },
            { "005", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "009", "\u0a13\u0a38\u0a3c\u0a47\u0a28\u0a40\u0a06" },
            { "rm", "\u0a30\u0a4b\u0a2e\u0a3e\u0a02\u0a38\u0a3c" },
            { "rn", "\u0a30\u0a41\u0a70\u0a21\u0a40" },
            { "RO", "\u0a30\u0a4b\u0a2e\u0a3e\u0a28\u0a40\u0a06" },
            { "ro", "\u0a30\u0a4b\u0a2e\u0a3e\u0a28\u0a40\u0a06\u0a08" },
            { "RS", "\u0a38\u0a30\u0a2c\u0a40\u0a06" },
            { "RU", "\u0a30\u0a42\u0a38" },
            { "ru", "\u0a30\u0a42\u0a38\u0a40" },
            { "RW", "\u0a30\u0a35\u0a3e\u0a02\u0a21\u0a3e" },
            { "rw", "\u0a15\u0a3f\u0a28\u0a3f\u0a06\u0a30\u0a35\u0a3e\u0a02\u0a21\u0a3e" },
            { "kea", "\u0a15\u0a3e\u0a2c\u0a41\u0a35\u0a47\u0a30\u0a26\u0a3f\u0a06\u0a28\u0a42" },
            { "en_AU", "\u0a06\u0a38\u0a1f\u0a4d\u0a30\u0a47\u0a32\u0a40\u0a06\u0a08 \u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "SA", "\u0a38\u0a3e\u0a0a\u0a26\u0a40 \u0a05\u0a30\u0a2c" },
            { "sa", "\u0a38\u0a70\u0a38\u0a15\u0a4d\u0a30\u0a3f\u0a24" },
            { "SB", "\u0a38\u0a4b\u0a32\u0a4b\u0a2e\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "twq", "\u0a24\u0a3e\u0a38\u0a3e\u0a35\u0a3f\u0a15" },
            { "011", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "SC", "\u0a38\u0a47\u0a38\u0a3c\u0a32\u0a38" },
            { "SD", "\u0a38\u0a42\u0a21\u0a3e\u0a28" },
            { "sd", "\u0a38\u0a3f\u0a70\u0a27\u0a40" },
            { "013", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "SE", "\u0a38\u0a35\u0a40\u0a21\u0a28" },
            { "se", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a38\u0a3e\u0a2e\u0a40" },
            { "014", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "015", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "SG", "\u0a38\u0a3f\u0a70\u0a17\u0a3e\u0a2a\u0a41\u0a30" },
            { "sg", "\u0a38\u0a3e\u0a02\u0a17\u0a4b" },
            { "SH", "\u0a38\u0a47\u0a02\u0a1f \u0a39\u0a47\u0a32\u0a47\u0a28\u0a3e" },
            { "si", metaValue_si },
            { "017", "\u0a2e\u0a71\u0a27 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "SI", "\u0a38\u0a32\u0a4b\u0a35\u0a47\u0a28\u0a40\u0a06" },
            { "018", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "SJ", "\u0a38\u0a35\u0a3e\u0a32\u0a2c\u0a30\u0a21 \u0a05\u0a24\u0a47 \u0a1c\u0a3e\u0a28 \u0a2e\u0a3e\u0a2f\u0a47\u0a28" },
            { "019", "\u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "SK", "\u0a38\u0a32\u0a4b\u0a35\u0a3e\u0a15\u0a40\u0a06" },
            { "sk", "\u0a38\u0a32\u0a4b\u0a35\u0a3e\u0a15" },
            { "SL", "\u0a38\u0a3f\u0a0f\u0a30\u0a3e \u0a32\u0a3f\u0a13\u0a28" },
            { "sl", "\u0a38\u0a32\u0a4b\u0a35\u0a47\u0a28\u0a40\u0a06\u0a08" },
            { "SM", "\u0a38\u0a48\u0a28 \u0a2e\u0a30\u0a40\u0a28\u0a4b" },
            { "SN", "\u0a38\u0a47\u0a28\u0a47\u0a17\u0a32" },
            { "sn", "\u0a38\u0a3c\u0a4b\u0a28\u0a3e" },
            { "SO", "\u0a38\u0a4b\u0a2e\u0a3e\u0a32\u0a40\u0a06" },
            { "so", "\u0a38\u0a4b\u0a2e\u0a3e\u0a32\u0a40" },
            { "arn", "\u0a2e\u0a3e\u0a2a\u0a41\u0a1a\u0a47" },
            { "sq", "\u0a05\u0a32\u0a2c\u0a3e\u0a28\u0a40\u0a06\u0a08" },
            { "SR", "\u0a38\u0a42\u0a30\u0a40\u0a28\u0a3e\u0a2e" },
            { "sr", "\u0a38\u0a30\u0a2c\u0a40\u0a06\u0a08" },
            { "SS", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a42\u0a21\u0a3e\u0a28" },
            { "ST", "\u0a38\u0a3e\u0a13 \u0a1f\u0a4b\u0a2e \u0a05\u0a24\u0a47 \u0a2a\u0a4d\u0a30\u0a3f\u0a70\u0a38\u0a40\u0a2a\u0a47" },
            { "su", "\u0a38\u0a42\u0a70\u0a21\u0a3e\u0a28\u0a40" },
            { "SV", "\u0a05\u0a32 \u0a38\u0a32\u0a35\u0a3e\u0a21\u0a4b\u0a30" },
            { "sv", "\u0a38\u0a35\u0a40\u0a21\u0a3f\u0a38\u0a3c" },
            { "sw", "\u0a38\u0a35\u0a3e\u0a39\u0a3f\u0a32\u0a40" },
            { "SX", "\u0a38\u0a3f\u0a70\u0a1f \u0a2e\u0a3e\u0a30\u0a1f\u0a40\u0a28" },
            { "SY", "\u0a38\u0a40\u0a30\u0a40\u0a06" },
            { "SZ", "\u0a38\u0a35\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a48\u0a02\u0a21" },
            { "ta", metaValue_ta },
            { "TA", "\u0a1f\u0a4d\u0a30\u0a3f\u0a38\u0a1f\u0a3e\u0a28 \u0a26\u0a3e \u0a15\u0a41\u0a70\u0a39\u0a3e" },
            { "asa", "\u0a05\u0a38\u0a42" },
            { "021", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "142", "\u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "TC", "\u0a1f\u0a41\u0a30\u0a15\u0a38 \u0a05\u0a24\u0a47 \u0a15\u0a48\u0a15\u0a4b\u0a38 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "143", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "TD", "\u0a1a\u0a3e\u0a21" },
            { "te", metaValue_te },
            { "145", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "TF", "\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a26\u0a71\u0a16\u0a23\u0a40 \u0a2a\u0a4d\u0a30\u0a26\u0a47\u0a38\u0a3c" },
            { "TG", "\u0a1f\u0a4b\u0a17\u0a4b" },
            { "tg", "\u0a24\u0a3e\u0a1c\u0a3f\u0a15" },
            { "th", metaValue_th },
            { "TH", "\u0a25\u0a3e\u0a08\u0a32\u0a48\u0a02\u0a21" },
            { "ti", "\u0a24\u0a3f\u0a17\u0a4d\u0a30\u0a40\u0a28\u0a3f\u0a06" },
            { "TJ", "\u0a24\u0a3e\u0a1c\u0a3f\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "en_CA", "\u0a15\u0a48\u0a28\u0a47\u0a21\u0a40\u0a05\u0a28 \u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "029", "\u0a15\u0a48\u0a30\u0a47\u0a2c\u0a40\u0a06\u0a08" },
            { "TK", "\u0a1f\u0a4b\u0a15\u0a47\u0a32\u0a3e\u0a09" },
            { "tk", "\u0a24\u0a41\u0a30\u0a15\u0a2e\u0a47\u0a28" },
            { "TL", "\u0a24\u0a3f\u0a2e\u0a4b\u0a30-\u0a32\u0a47\u0a38\u0a24\u0a47" },
            { "TM", "\u0a24\u0a41\u0a30\u0a15\u0a2e\u0a47\u0a28\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "TN", "\u0a1f\u0a3f\u0a0a\u0a28\u0a40\u0a38\u0a3c\u0a40\u0a06" },
            { "TO", "\u0a1f\u0a4c\u0a02\u0a17\u0a3e" },
            { "to", "\u0a1f\u0a4c\u0a02\u0a17\u0a28" },
            { "dyo", "\u0a1c\u0a4b\u0a32\u0a3e-\u0a2b\u0a4b\u0a07\u0a28\u0a40" },
            { "tr", metaValue_TR },
            { "TR", metaValue_TR },
            { "TT", "\u0a1f\u0a4d\u0a30\u0a3f\u0a28\u0a40\u0a21\u0a3e\u0a21 \u0a05\u0a24\u0a47 \u0a1f\u0a4b\u0a2c\u0a3e\u0a17\u0a4b" },
            { "tt", "\u0a24\u0a24\u0a3e\u0a30" },
            { "TV", "\u0a1f\u0a41\u0a35\u0a3e\u0a32\u0a42" },
            { "TW", "\u0a24\u0a3e\u0a07\u0a35\u0a3e\u0a28" },
            { "tw", "\u0a24\u0a4d\u0a35\u0a3f" },
            { "TZ", "\u0a24\u0a28\u0a1c\u0a3c\u0a3e\u0a28\u0a40\u0a06" },
            { "nmg", "\u0a15\u0a35\u0a3e\u0a38\u0a3f\u0a13" },
            { "Zzzz", "\u0a05\u0a23\u0a2a\u0a1b\u0a3e\u0a24\u0a40 \u0a32\u0a3f\u0a2a\u0a40" },
            { "150", "\u0a2f\u0a42\u0a30\u0a2a" },
            { "UA", "\u0a2f\u0a42\u0a15\u0a30\u0a47\u0a28" },
            { "030", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "151", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "154", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "sw_CD", "\u0a15\u0a3e\u0a02\u0a17\u0a4b \u0a38\u0a35\u0a3e\u0a39\u0a3f\u0a32\u0a40" },
            { "034", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "155", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "035", "\u0a26\u0a71\u0a16\u0a23-\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "UG", "\u0a2f\u0a42\u0a17\u0a3e\u0a02\u0a21\u0a3e" },
            { "ug", "\u0a09\u0a07\u0a17\u0a41\u0a30" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u0a38\u0a27\u0a3e\u0a30\u0a28" },
            { "039", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "uk", "\u0a2f\u0a42\u0a15\u0a30\u0a47\u0a28\u0a40\u0a06\u0a08" },
            { "Sinh", metaValue_si },
            { "UM", "\u0a2f\u0a42.\u0a10\u0a38. \u0a26\u0a42\u0a30-\u0a26\u0a41\u0a30\u0a3e\u0a21\u0a47 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "ur", "\u0a09\u0a30\u0a26\u0a42" },
            { "US", "\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a30\u0a3e\u0a1c" },
            { "haw", "\u0a39\u0a35\u0a3e\u0a08" },
            { "UY", "\u0a09\u0a30\u0a42\u0a17\u0a35\u0a47" },
            { "UZ", "\u0a09\u0a1c\u0a3c\u0a2c\u0a47\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "uz", "\u0a09\u0a1c\u0a3c\u0a2c\u0a47\u0a15" },
            { "tzm", "\u0a2e\u0a71\u0a27 \u0a10\u0a1f\u0a32\u0a38 \u0a24\u0a2e\u0a3e\u0a1c\u0a3c\u0a3f\u0a24" },
            { "VA", "\u0a35\u0a48\u0a1f\u0a40\u0a15\u0a28 \u0a38\u0a3f\u0a1f\u0a40" },
            { "nds_NL", "\u0a32\u0a4b \u0a38\u0a48\u0a15\u0a38\u0a28" },
            { "VC", "\u0a38\u0a47\u0a02\u0a1f \u0a35\u0a3f\u0a28\u0a38\u0a48\u0a02\u0a1f \u0a10\u0a02\u0a21 \u0a17\u0a4d\u0a30\u0a47\u0a28\u0a3e\u0a21\u0a40\u0a28\u0a38" },
            { "VE", "\u0a35\u0a47\u0a28\u0a47\u0a1c\u0a3c\u0a42\u0a0f\u0a32\u0a3e" },
            { "VG", "\u0a2c\u0a4d\u0a30\u0a3f\u0a1f\u0a3f\u0a38\u0a3c \u0a35\u0a30\u0a1c\u0a3f\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "VI", "\u0a2f\u0a42 \u0a10\u0a38 \u0a35\u0a30\u0a1c\u0a3f\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "vi", "\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e\u0a40" },
            { "khq", "\u0a15\u0a4b\u0a2f\u0a30\u0a3e \u0a1a\u0a40\u0a28\u0a40" },
            { "VN", "\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e" },
            { "quc", "\u0a15\u0a47\u0a38\u0a3c" },
            { "VU", "\u0a35\u0a3e\u0a28\u0a42\u0a06\u0a1f\u0a42" },
            { "rwk", "\u0a30\u0a35\u0a3e" },
            { "gag", "\u0a17\u0a3e\u0a17\u0a4c\u0a1c\u0a3c" },
            { "053", "\u0a06\u0a38\u0a1f\u0a30\u0a47\u0a32\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "054", "\u0a2e\u0a47\u0a32\u0a3e\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "WF", "\u0a35\u0a3e\u0a32\u0a3f\u0a38 \u0a05\u0a24\u0a47 \u0a2b\u0a42\u0a1f\u0a42\u0a28\u0a3e" },
            { "Grek", "\u0a17\u0a4d\u0a30\u0a40\u0a15" },
            { "057", "\u0a2e\u0a3e\u0a07\u0a15\u0a4d\u0a30\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06\u0a08 \u0a16\u0a47\u0a24\u0a30" },
            { "jgo", "\u0a28\u0a17\u0a4b\u0a02\u0a2c\u0a3e" },
            { "lkt", "\u0a32\u0a15\u0a4b\u0a1f\u0a3e" },
            { "wo", "\u0a35\u0a4b\u0a32\u0a4b\u0a2b" },
            { "zgh", "\u0a2e\u0a3f\u0a06\u0a30\u0a40 \u0a2e\u0a4b\u0a30\u0a4b\u0a15\u0a47\u0a28 \u0a1f\u0a3e\u0a2e\u0a3e\u0a1c\u0a3c\u0a3f\u0a15" },
            { "ar_001", "\u0a06\u0a27\u0a41\u0a28\u0a3f\u0a15 \u0a2e\u0a3f\u0a06\u0a30\u0a40 \u0a05\u0a30\u0a2c\u0a40" },
            { "WS", "\u0a38\u0a3e\u0a2e\u0a4b\u0a06" },
            { "Mong", metaValue_mn },
            { "mni", "\u0a2e\u0a28\u0a40\u0a2a\u0a41\u0a30\u0a40" },
            { "Latn", metaValue_la },
            { "061", "\u0a2a\u0a4b\u0a32\u0a40\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "xh", "\u0a16\u0a4b\u0a38\u0a3e" },
            { "XK", "\u0a15\u0a4b\u0a38\u0a4b\u0a35\u0a4b" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0a05\u0a32\u0a3f\u0a16\u0a24" },
            { "wbp", "\u0a35\u0a3e\u0a32\u0a2a\u0a41\u0a30\u0a40" },
            { "moh", "\u0a2e\u0a4b\u0a39\u0a3e\u0a35\u0a15" },
            { "YE", "\u0a2f\u0a2e\u0a28" },
            { "nqo", "\u0a10\u0a02\u0a15\u0a4b" },
            { "yo", "\u0a2f\u0a4b\u0a30\u0a42\u0a2c\u0a3e" },
            { "es_MX", "\u0a2e\u0a48\u0a15\u0a38\u0a40\u0a15\u0a28 \u0a38\u0a2a\u0a48\u0a28\u0a3f\u0a38\u0a3c" },
            { "YT", "\u0a2e\u0a3e\u0a2f\u0a4b\u0a1f\u0a40" },
            { "vai", "\u0a35\u0a3e\u0a08" },
            { "ZA", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a2b\u0a30\u0a40\u0a15\u0a3e" },
            { "kln", "\u0a15\u0a32\u0a47\u0a1c\u0a3f\u0a28" },
            { "Deva", "\u0a26\u0a47\u0a35\u0a28\u0a3e\u0a17\u0a30\u0a40" },
            { "zh", "\u0a1a\u0a40\u0a28\u0a40" },
            { "Hira", "\u0a39\u0a3f\u0a30\u0a3e\u0a17\u0a3e\u0a28\u0a3e" },
            { "ZM", "\u0a1c\u0a3c\u0a3e\u0a2e\u0a2c\u0a40\u0a06" },
            { "Bopo", "\u0a2c\u0a4b\u0a2a\u0a4b\u0a2e\u0a4b\u0a2b\u0a4b" },
            { "zu", "\u0a1c\u0a3c\u0a41\u0a32\u0a42" },
            { "ZW", "\u0a1c\u0a3c\u0a3f\u0a70\u0a2c\u0a3e\u0a2c\u0a35\u0a47" },
            { "Geor", metaValue_ka },
            { "ZZ", "\u0a05\u0a23\u0a2a\u0a1b\u0a3e\u0a24\u0a3e \u0a16\u0a47\u0a24\u0a30" },
            { "ebu", "\u0a07\u0a70\u0a2c\u0a42" },
            { "jmc", "\u0a2e\u0a1a\u0a3e\u0a2e\u0a47" },
            { "zh_Hans", "\u0a38\u0a30\u0a32 \u0a1a\u0a40\u0a28\u0a40" },
            { "hif", "\u0a2b\u0a3f\u0a1c\u0a40 \u0a39\u0a3f\u0a70\u0a26\u0a40" },
            { "koi", "\u0a15\u0a4b\u0a2e\u0a40-\u0a2a\u0a47\u0a30\u0a2e\u0a3f\u0a06\u0a15" },
            { "kok", "\u0a15\u0a4b\u0a02\u0a15\u0a23\u0a40" },
            { "nus", "\u0a28\u0a41\u0a0f\u0a30" },
            { "dav", "\u0a1f\u0a47\u0a1f\u0a3e" },
            { "lrc", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a32\u0a41\u0a30\u0a40" },
            { "zh_Hant", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40 \u0a1a\u0a40\u0a28\u0a40" },
            { "mua", "\u0a2e\u0a41\u0a70\u0a21\u0a47\u0a02\u0a17" },
            { "Khmr", metaValue_km },
            { "mul", "\u0a15\u0a08 \u0a2d\u0a3e\u0a38\u0a3c\u0a3e\u0a35\u0a3e\u0a02" },
            { "saq", "\u0a38\u0a2e\u0a2c\u0a41\u0a30\u0a42" },
            { "sat", "\u0a38\u0a70\u0a25\u0a3e\u0a32\u0a40" },
            { "Guru", "\u0a17\u0a41\u0a30\u0a2e\u0a41\u0a16\u0a40" },
            { "ksb", "\u0a38\u0a3c\u0a70\u0a2c\u0a3e\u0a32\u0a3e" },
            { "Telu", metaValue_te },
            { "ksf", "\u0a2c\u0a2b\u0a3c\u0a40\u0a06" },
        };
        return data;
    }
}
