/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.JavascriptUtil;

public class URIConverter
extends AbstractConverter {
    private static final Log log = LogFactory.getLog(URIConverter.class);

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String uriString = data.urlDecode();
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException ex) {
            log.warn((Object)("Failed to create URL from string '" + uriString + "'. Returning null"));
            return null;
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        URI uri = (URI)data;
        String escaped = JavascriptUtil.escapeJavaScript(uri.toString());
        return new NonNestedOutboundVariable('\"' + escaped + '\"');
    }
}

