/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractServletOutputStream<S>
extends ServletOutputStream {
    private static final Log log = LogFactory.getLog(AbstractServletOutputStream.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11.upgrade");
    protected final SocketWrapper<S> socketWrapper;
    private final Object fireListenerLock = new Object();
    private final Object writeLock = new Object();
    private volatile boolean closeRequired = false;
    private volatile WriteListener listener = null;
    private volatile boolean fireListener = false;
    private volatile ClassLoader applicationLoader = null;
    private volatile byte[] buffer;
    private volatile int bufferPos;
    private volatile int bufferLimit;
    private final int asyncWriteBufferSize;

    public AbstractServletOutputStream(SocketWrapper<S> socketWrapper, int asyncWriteBufferSize) {
        this.socketWrapper = socketWrapper;
        this.asyncWriteBufferSize = asyncWriteBufferSize;
        this.buffer = new byte[asyncWriteBufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sos.canWrite.ise"));
        }
        Object object = this.fireListenerLock;
        synchronized (object) {
            boolean result = this.bufferLimit == 0;
            this.fireListener = !result;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWriteListener(WriteListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sos.writeListener.null"));
        }
        if (this.listener != null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sos.writeListener.set"));
        }
        this.listener = listener;
        this.applicationLoader = Thread.currentThread().getContextClassLoader();
        Object object = this.fireListenerLock;
        synchronized (object) {
            this.fireListener = true;
        }
        this.socketWrapper.addDispatch(DispatchType.NON_BLOCKING_WRITE);
    }

    final boolean isCloseRequired() {
        return this.closeRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.preWriteChecks();
            this.writeInternal(new byte[]{(byte)b}, 0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.preWriteChecks();
            this.writeInternal(b, off, len);
        }
    }

    public void close() throws IOException {
        this.closeRequired = true;
        this.doClose();
    }

    private void preWriteChecks() {
        if (this.bufferLimit != 0) {
            throw new IllegalStateException(sm.getString("upgrade.sis.write.ise"));
        }
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        if (this.listener == null) {
            this.doWrite(true, b, off, len);
        } else {
            int written = this.doWrite(false, b, off, len);
            if (written < len) {
                if (b == this.buffer) {
                    this.bufferPos += written;
                } else {
                    int bytesLeft = len - written;
                    if (bytesLeft > this.buffer.length) {
                        this.buffer = new byte[bytesLeft];
                    } else if (bytesLeft < this.asyncWriteBufferSize && this.buffer.length > this.asyncWriteBufferSize) {
                        this.buffer = new byte[this.asyncWriteBufferSize];
                    }
                    this.bufferPos = 0;
                    this.bufferLimit = bytesLeft;
                    System.arraycopy(b, off + written, this.buffer, this.bufferPos, this.bufferLimit);
                }
            } else {
                this.bufferLimit = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onWritePossible() {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                if (this.bufferLimit > 0) {
                    this.writeInternal(this.buffer, this.bufferPos, this.bufferLimit - this.bufferPos);
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.onError(t);
            return;
        }
        boolean fire = false;
        Object object = this.fireListenerLock;
        synchronized (object) {
            if (this.bufferLimit == 0 && this.fireListener) {
                this.fireListener = false;
                fire = true;
            }
        }
        if (fire) {
            Thread thread = Thread.currentThread();
            ClassLoader originalClassLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.applicationLoader);
                this.listener.onWritePossible();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                this.onError(t);
            }
            finally {
                thread.setContextClassLoader(originalClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onError(Throwable t) {
        block9: {
            if (this.listener == null) {
                return;
            }
            Thread thread = Thread.currentThread();
            ClassLoader originalClassLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.applicationLoader);
                this.listener.onError(t);
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable((Throwable)t2);
                log.warn((Object)sm.getString("upgrade.sos.onErrorFail"), t2);
            }
            finally {
                thread.setContextClassLoader(originalClassLoader);
            }
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)sm.getString("upgrade.sos.errorCloseFail"), (Throwable)ioe);
            }
        }
    }

    protected abstract int doWrite(boolean var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void doFlush() throws IOException;

    protected abstract void doClose() throws IOException;
}

