/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.internal.classpath.ClassPath;

public class DefaultClassPathRegistry
implements ClassPathRegistry {
    private final List<ClassPathProvider> providers = new ArrayList<ClassPathProvider>();

    public DefaultClassPathRegistry(ClassPathProvider ... providers) {
        this.providers.addAll(Arrays.asList(providers));
    }

    public ClassPath getClassPath(String name) {
        for (ClassPathProvider provider : this.providers) {
            ClassPath classpath = provider.findClassPath(name);
            if (classpath == null) continue;
            return classpath;
        }
        throw new IllegalArgumentException(String.format("unknown classpath '%s' requested.", name));
    }
}

