/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.connect;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.Subscription;
import org.simpleframework.transport.reactor.Operation;

class Acceptor
implements Operation {
    private final ServerSocketChannel server = ServerSocketChannel.open();
    private final ServerSocket socket = this.server.socket();
    private final SSLContext context;
    private final Server handler;

    public Acceptor(SocketAddress address, SSLContext context, Server handler) throws IOException {
        this.handler = handler;
        this.context = context;
        this.bind(address);
    }

    public SocketAddress getAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public SelectableChannel getChannel() {
        return this.server;
    }

    public void run() {
        try {
            this.accept();
        }
        catch (Exception e) {
            this.pause();
        }
    }

    private void pause() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception e) {
            return;
        }
    }

    public void cancel() {
        try {
            this.close();
        }
        finally {
            return;
        }
    }

    private void bind(SocketAddress address) throws IOException {
        this.server.configureBlocking(false);
        this.socket.setReuseAddress(true);
        this.socket.bind(address, 100);
    }

    private void accept() throws IOException {
        SocketChannel channel = this.server.accept();
        while (channel != null) {
            this.configure(channel);
            if (this.context == null) {
                this.process(channel, null);
            } else {
                this.process(channel);
            }
            channel = this.server.accept();
        }
    }

    private void configure(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(true);
        channel.configureBlocking(false);
    }

    private void process(SocketChannel channel) throws IOException {
        SSLEngine engine = this.context.createSSLEngine();
        try {
            this.process(channel, engine);
        }
        catch (Exception e) {
            channel.close();
        }
    }

    private void process(SocketChannel channel, SSLEngine engine) throws IOException {
        Subscription socket = new Subscription(channel, engine);
        try {
            this.handler.process(socket);
        }
        catch (Exception e) {
            channel.close();
        }
    }

    public void close() throws IOException {
        this.server.close();
    }
}

