/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

@NotThreadSafe
public class ComponentSelectionReasonSerializer
implements Serializer<ComponentSelectionReason> {
    private static final BiMap<Byte, ComponentSelectionReasonInternal> REASONS = HashBiMap.create((int)7);
    private final BiMap<String, Integer> customReasons = HashBiMap.create();
    private OperationType lastOperationType = OperationType.read;

    public ComponentSelectionReason read(Decoder decoder) throws IOException {
        this.prepareForOperation(OperationType.read);
        byte id = decoder.readByte();
        ComponentSelectionReasonInternal out = (ComponentSelectionReasonInternal)REASONS.get((Object)id);
        if (out == null) {
            throw new IllegalArgumentException("Unable to find selection reason with id: " + id);
        }
        if (!decoder.readBoolean()) {
            String reason = this.readCustomReason(decoder);
            out = out.withReason(reason);
        }
        return out;
    }

    private String readCustomReason(Decoder decoder) throws IOException {
        boolean alreadyKnown = decoder.readBoolean();
        if (alreadyKnown) {
            return (String)this.customReasons.inverse().get((Object)decoder.readSmallInt());
        }
        String description = decoder.readString();
        this.customReasons.put((Object)description, (Object)this.customReasons.size());
        return description;
    }

    public void write(Encoder encoder, ComponentSelectionReason value) throws IOException {
        this.prepareForOperation(OperationType.write);
        ComponentSelectionReason key = ComponentSelectionReasonSerializer.baseReason(value);
        Byte id = (Byte)REASONS.inverse().get((Object)key);
        if (id == null) {
            throw new IllegalArgumentException("Unknown selection reason: " + value);
        }
        encoder.writeByte(id.byteValue());
        if (key == value) {
            encoder.writeBoolean(true);
        } else {
            this.writeDescription(encoder, value.getDescription());
        }
    }

    private void writeDescription(Encoder encoder, String description) throws IOException {
        encoder.writeBoolean(false);
        Integer index = (Integer)this.customReasons.get((Object)description);
        encoder.writeBoolean(index != null);
        if (index == null) {
            index = this.customReasons.size();
            this.customReasons.put((Object)description, (Object)index);
            encoder.writeString((CharSequence)description);
        } else {
            encoder.writeSmallInt(index.intValue());
        }
    }

    private static ComponentSelectionReason baseReason(ComponentSelectionReason value) {
        if (value == null) {
            return null;
        }
        if (value.isExpected()) {
            if (VersionSelectionReasons.ROOT.getDescription().equals(value.getDescription())) {
                return VersionSelectionReasons.ROOT;
            }
            return VersionSelectionReasons.REQUESTED;
        }
        if (value.isForced()) {
            return VersionSelectionReasons.FORCED;
        }
        if (value.isConflictResolution()) {
            if (value.isSelectedByRule()) {
                return VersionSelectionReasons.CONFLICT_RESOLUTION_BY_RULE;
            }
            return VersionSelectionReasons.CONFLICT_RESOLUTION;
        }
        if (value.isSelectedByRule()) {
            return VersionSelectionReasons.SELECTED_BY_RULE;
        }
        if (value.isCompositeSubstitution()) {
            return VersionSelectionReasons.COMPOSITE_BUILD;
        }
        return value;
    }

    private void prepareForOperation(OperationType operationType) {
        if (operationType != this.lastOperationType) {
            this.customReasons.clear();
            this.lastOperationType = operationType;
        }
    }

    static {
        REASONS.put((Object)1, (Object)VersionSelectionReasons.REQUESTED);
        REASONS.put((Object)2, (Object)VersionSelectionReasons.ROOT);
        REASONS.put((Object)3, (Object)VersionSelectionReasons.FORCED);
        REASONS.put((Object)4, (Object)VersionSelectionReasons.CONFLICT_RESOLUTION);
        REASONS.put((Object)5, (Object)VersionSelectionReasons.SELECTED_BY_RULE);
        REASONS.put((Object)6, (Object)VersionSelectionReasons.CONFLICT_RESOLUTION_BY_RULE);
        REASONS.put((Object)7, (Object)VersionSelectionReasons.COMPOSITE_BUILD);
    }

    private static enum OperationType {
        read,
        write;

    }
}

