/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import com.google.common.collect.Maps;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependenciesMetadata;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public abstract class AbstractDependenciesMetadataAdapter<T extends DependencyMetadata>
extends AbstractList<T>
implements DependenciesMetadata<T> {
    private final List<org.gradle.internal.component.model.DependencyMetadata> dependenciesMetadata;
    protected final Map<Integer, T> dependencyMetadataAdapters;
    private final Instantiator instantiator;
    private final NotationParser<Object, T> dependencyNotationParser;

    public AbstractDependenciesMetadataAdapter(List<org.gradle.internal.component.model.DependencyMetadata> dependenciesMetadata, Instantiator instantiator, NotationParser<Object, T> dependencyNotationParser) {
        this.dependenciesMetadata = dependenciesMetadata;
        this.dependencyMetadataAdapters = Maps.newHashMap();
        this.instantiator = instantiator;
        this.dependencyNotationParser = dependencyNotationParser;
    }

    protected abstract Class<? extends T> adapterImplementationType();

    protected abstract boolean isPending();

    @Override
    public T get(int index) {
        if (!this.dependencyMetadataAdapters.containsKey(index)) {
            this.dependencyMetadataAdapters.put(index, this.instantiator.newInstance(this.adapterImplementationType(), new Object[]{this.dependenciesMetadata, index}));
        }
        return (T)((DependencyMetadata)this.dependencyMetadataAdapters.get(index));
    }

    @Override
    public int size() {
        return this.dependenciesMetadata.size();
    }

    @Override
    public T remove(int index) {
        T componentDependencyMetadata = this.get(index);
        this.dependenciesMetadata.remove(index);
        this.dependencyMetadataAdapters.remove(index);
        return componentDependencyMetadata;
    }

    public void add(String dependencyNotation) {
        this.doAdd(dependencyNotation, null);
    }

    public void add(Map<String, String> dependencyNotation) {
        this.doAdd(dependencyNotation, null);
    }

    public void add(String dependencyNotation, Action<? super T> configureAction) {
        this.doAdd(dependencyNotation, configureAction);
    }

    public void add(Map<String, String> dependencyNotation, Action<? super T> configureAction) {
        this.doAdd(dependencyNotation, configureAction);
    }

    private void doAdd(Object dependencyNotation, @Nullable Action<? super T> configureAction) {
        DependencyMetadata dependencyMetadata = (DependencyMetadata)this.dependencyNotationParser.parseNotation(dependencyNotation);
        if (configureAction != null) {
            configureAction.execute((Object)dependencyMetadata);
        }
        this.dependenciesMetadata.add(this.toDependencyMetadata(dependencyMetadata));
    }

    private org.gradle.internal.component.model.DependencyMetadata toDependencyMetadata(T details) {
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(details.getGroup(), details.getName(), DefaultImmutableVersionConstraint.of(details.getVersionConstraint()));
        return new GradleDependencyMetadata(selector, this.isPending());
    }
}

