/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.vcs;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.api.specs.Spec;
import org.gradle.composite.internal.IncludedBuildRegistry;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.util.CollectionUtils;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.VersionControlSystem;
import org.gradle.vcs.VersionRef;
import org.gradle.vcs.internal.VcsMappingFactory;
import org.gradle.vcs.internal.VcsMappingInternal;
import org.gradle.vcs.internal.VcsMappingsStore;
import org.gradle.vcs.internal.VcsWorkingDirectoryRoot;
import org.gradle.vcs.internal.VersionControlSystemFactory;

public class VcsDependencyResolver
implements DependencyToComponentIdResolver,
ComponentResolvers {
    private final ProjectDependencyResolver projectDependencyResolver;
    private final ServiceRegistry serviceRegistry;
    private final LocalComponentRegistry localComponentRegistry;
    private final VcsMappingsStore vcsMappingsStore;
    private final VcsMappingFactory vcsMappingFactory;
    private final VersionControlSystemFactory versionControlSystemFactory;
    private final File baseWorkingDir;
    private final Map<String, VersionRef> selectedVersionCache = new HashMap<String, VersionRef>();

    public VcsDependencyResolver(VcsWorkingDirectoryRoot vcsWorkingDirRoot, ProjectDependencyResolver projectDependencyResolver, ServiceRegistry serviceRegistry, LocalComponentRegistry localComponentRegistry, VcsMappingsStore vcsMappingsStore, VcsMappingFactory vcsMappingFactory, VersionControlSystemFactory versionControlSystemFactory) {
        this.baseWorkingDir = vcsWorkingDirRoot.getDir();
        this.projectDependencyResolver = projectDependencyResolver;
        this.serviceRegistry = serviceRegistry;
        this.localComponentRegistry = localComponentRegistry;
        this.vcsMappingsStore = vcsMappingsStore;
        this.vcsMappingFactory = vcsMappingFactory;
        this.versionControlSystemFactory = versionControlSystemFactory;
    }

    @Override
    public void resolve(DependencyMetadata dependency, BuildableComponentIdResolveResult result) {
        VcsMappingInternal vcsMappingInternal = this.getVcsMapping(dependency);
        if (vcsMappingInternal != null) {
            final ModuleComponentSelector depSelector = (ModuleComponentSelector)dependency.getSelector();
            this.vcsMappingsStore.getVcsMappingRule().execute((Object)vcsMappingInternal);
            if (vcsMappingInternal.hasRepository()) {
                NestedBuildFactory nestedBuildFactory;
                ConfigurableIncludedBuild includedBuild;
                VersionControlSpec spec = vcsMappingInternal.getRepository();
                VersionControlSystem versionControlSystem = this.versionControlSystemFactory.create(spec);
                VersionRef selectedVersion = this.selectVersionFromCache(spec, depSelector.getVersion());
                if (selectedVersion == null) {
                    selectedVersion = this.selectVersionFromRepository(spec, versionControlSystem, depSelector.getVersion());
                }
                if (selectedVersion == null) {
                    result.failed(new ModuleVersionResolveException((ComponentSelector)depSelector, "Could not resolve " + depSelector.toString() + ". " + spec.getDisplayName() + " does not contain a version matching " + depSelector.getVersion()));
                    return;
                }
                File dependencyWorkingDir = new File(this.populateWorkingDirectory(this.baseWorkingDir, spec, versionControlSystem, selectedVersion), spec.getRootDir());
                if (!new File(dependencyWorkingDir, "settings.gradle").exists() && !new File(dependencyWorkingDir, "settings.gradle.kts").exists()) {
                    throw new GradleException(String.format("Included build from '%s' must contain a settings file.", spec.getDisplayName()));
                }
                IncludedBuildRegistry includedBuildRegistry = (IncludedBuildRegistry)this.serviceRegistry.get(IncludedBuildRegistry.class);
                Collection moduleToProject = includedBuildRegistry.getModuleToProjectMapping((IncludedBuild)(includedBuild = includedBuildRegistry.addImplicitBuild(dependencyWorkingDir, nestedBuildFactory = (NestedBuildFactory)this.serviceRegistry.get(NestedBuildFactory.class))));
                Pair entry = (Pair)CollectionUtils.findFirst((Iterable)moduleToProject, (Spec)new Spec<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>>(){

                    public boolean isSatisfiedBy(Pair<ModuleVersionIdentifier, ProjectComponentIdentifier> entry) {
                        ModuleVersionIdentifier possibleMatch = (ModuleVersionIdentifier)entry.left;
                        return depSelector.getGroup().equals(possibleMatch.getGroup()) && depSelector.getModule().equals(possibleMatch.getName());
                    }
                });
                if (entry == null) {
                    result.failed(new ModuleVersionResolveException(vcsMappingInternal.getRequested(), spec.getDisplayName() + " did not contain a project publishing the specified dependency."));
                } else {
                    LocalComponentMetadata componentMetaData = this.localComponentRegistry.getComponent((ProjectComponentIdentifier)entry.right);
                    if (componentMetaData == null) {
                        result.failed(new ModuleVersionResolveException((ComponentSelector)DefaultProjectComponentSelector.newSelector((IncludedBuild)includedBuild, ((ProjectComponentIdentifier)entry.right).getProjectPath()), vcsMappingInternal.getRepository().getDisplayName() + " could not be resolved into a usable project."));
                    } else {
                        result.resolved(componentMetaData);
                    }
                    return;
                }
            }
        }
        this.projectDependencyResolver.resolve(dependency, result);
    }

    private File populateWorkingDirectory(File baseWorkingDir, VersionControlSpec spec, VersionControlSystem versionControlSystem, VersionRef selectedVersion) {
        String repositoryId = HashUtil.createCompactMD5((String)spec.getUniqueId());
        File versionDirectory = new File(baseWorkingDir, repositoryId + "-" + selectedVersion.getCanonicalId());
        return versionControlSystem.populate(versionDirectory, selectedVersion, spec);
    }

    private VersionRef selectVersionFromCache(VersionControlSpec spec, String version) {
        return this.selectedVersionCache.get(this.cacheKey(spec, version));
    }

    private VersionRef selectVersionFromRepository(VersionControlSpec spec, VersionControlSystem versionControlSystem, String version) {
        Set versions = versionControlSystem.getAvailableVersions(spec);
        for (VersionRef candidate : versions) {
            if (!candidate.getVersion().equals(version)) continue;
            this.selectedVersionCache.put(this.cacheKey(spec, version), candidate);
            return candidate;
        }
        return null;
    }

    private String cacheKey(VersionControlSpec spec, String version) {
        return spec.getUniqueId() + version;
    }

    private VcsMappingInternal getVcsMapping(DependencyMetadata dependency) {
        if (this.vcsMappingsStore.hasRules() && dependency.getSelector() instanceof ModuleComponentSelector) {
            return this.vcsMappingFactory.create(dependency.getSelector());
        }
        return null;
    }

    @Override
    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this;
    }

    @Override
    public ComponentMetaDataResolver getComponentResolver() {
        return this.projectDependencyResolver;
    }

    @Override
    public OriginArtifactSelector getArtifactSelector() {
        return this.projectDependencyResolver;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.projectDependencyResolver;
    }
}

