/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached.ivy;

import java.io.File;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.Factory;
import org.gradle.internal.resource.cached.CachedItem;
import org.gradle.internal.serialize.Serializer;

public abstract class AbstractCachedIndex<K, V extends CachedItem> {
    private final String persistentCacheName;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final CacheLockingManager cacheLockingManager;
    private PersistentIndexedCache<K, V> persistentCache;

    public AbstractCachedIndex(String persistentCacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer, CacheLockingManager cacheLockingManager) {
        this.persistentCacheName = persistentCacheName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.cacheLockingManager = cacheLockingManager;
    }

    private PersistentIndexedCache<K, V> getPersistentCache() {
        if (this.persistentCache == null) {
            this.persistentCache = this.initPersistentCache();
        }
        return this.persistentCache;
    }

    private PersistentIndexedCache<K, V> initPersistentCache() {
        return this.cacheLockingManager.createCache(this.persistentCacheName, this.keySerializer, this.valueSerializer);
    }

    public V lookup(final K key) {
        this.assertKeyNotNull(key);
        return (V)((CachedItem)this.cacheLockingManager.useCache(new Factory<V>(){

            public V create() {
                CachedItem found = (CachedItem)AbstractCachedIndex.this.getPersistentCache().get(key);
                if (found == null) {
                    return null;
                }
                if (found.isMissing() || found.getCachedFile().exists()) {
                    return found;
                }
                AbstractCachedIndex.this.clear(key);
                return null;
            }
        }));
    }

    protected void storeInternal(final K key, V entry) {
        this.cacheLockingManager.useCache(new Runnable((CachedItem)entry){
            final /* synthetic */ CachedItem val$entry;
            {
                this.val$entry = cachedItem;
            }

            @Override
            public void run() {
                AbstractCachedIndex.this.getPersistentCache().put(key, (Object)this.val$entry);
            }
        });
    }

    protected void assertKeyNotNull(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
    }

    protected void assertArtifactFileNotNull(File artifactFile) {
        if (artifactFile == null) {
            throw new IllegalArgumentException("artifactFile cannot be null");
        }
    }

    public void clear(final K key) {
        this.assertKeyNotNull(key);
        this.cacheLockingManager.useCache(new Runnable(){

            @Override
            public void run() {
                AbstractCachedIndex.this.getPersistentCache().remove(key);
            }
        });
    }
}

