/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

public abstract class RedBlackTree<K>
extends AtomicInteger {
    public static boolean VERIFY;
    private int nodeSize;
    protected Node<K> root = null;

    RedBlackTree() {
        this.verifyProperties();
    }

    void incModCount() {
        this.incrementAndGet();
    }

    int getModCount() {
        return this.get();
    }

    protected void rotateLeft(@NotNull Node<K> n) {
        if (n == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RedBlackTree", "rotateLeft"));
        }
        Node<K> r = n.getRight();
        this.replaceNode(n, r);
        n.setRight(r.getLeft());
        if (r.getLeft() != null) {
            r.getLeft().setParent(n);
        }
        r.setLeft(n);
        n.setParent(r);
    }

    protected void rotateRight(@NotNull Node<K> n) {
        if (n == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RedBlackTree", "rotateRight"));
        }
        Node<K> l = n.getLeft();
        this.replaceNode(n, l);
        n.setLeft(l.getRight());
        if (l.getRight() != null) {
            l.getRight().setParent(n);
        }
        l.setRight(n);
        n.setParent(l);
    }

    protected void replaceNode(@NotNull Node<K> oldn, Node<K> newn) {
        if (oldn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldn", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RedBlackTree", "replaceNode"));
        }
        Node<K> parent2 = oldn.getParent();
        if (parent2 == null) {
            this.root = newn;
        } else if (oldn == parent2.getLeft()) {
            parent2.setLeft(newn);
        } else {
            parent2.setRight(newn);
        }
        if (newn != null) {
            newn.setParent(parent2);
        }
    }

    void onInsertNode() {
        ++this.nodeSize;
    }

    void insertCase1(Node<K> n) {
        if (n.getParent() == null) {
            ((Node)n).setBlack();
        } else {
            this.insertCase2(n);
        }
    }

    private void insertCase2(Node<K> n) {
        if (!RedBlackTree.isBlack(n.getParent())) {
            this.insertCase3(n);
        }
    }

    private void insertCase3(Node<K> n) {
        if (!RedBlackTree.isBlack(((Node)n).uncle())) {
            ((Node)n.getParent()).setBlack();
            ((Node)((Node)n).uncle()).setBlack();
            n.grandparent().setRed();
            this.insertCase1(n.grandparent());
        } else {
            this.insertCase4(n);
        }
    }

    private void insertCase4(Node<K> n) {
        if (n == n.getParent().getRight() && n.getParent() == n.grandparent().getLeft()) {
            this.rotateLeft(n.getParent());
            n = n.getLeft();
        } else if (n == n.getParent().getLeft() && n.getParent() == n.grandparent().getRight()) {
            this.rotateRight(n.getParent());
            n = n.getRight();
        }
        this.insertCase5(n);
    }

    private void insertCase5(Node<K> n) {
        ((Node)n.getParent()).setBlack();
        n.grandparent().setRed();
        if (n == n.getParent().getLeft() && n.getParent() == n.grandparent().getLeft()) {
            this.rotateRight(n.grandparent());
        } else {
            assert (n == n.getParent().getRight());
            assert (n.getParent() == n.grandparent().getRight());
            this.rotateLeft(n.grandparent());
        }
    }

    private static <K> void assertParentChild(Node<K> node1) {
        assert (node1 == null || node1.getParent() == null || node1.getParent().getLeft() == node1 || node1.getParent().getRight() == node1);
    }

    protected void deleteNode(@NotNull Node<K> n) {
        Node<K> child;
        if (n == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RedBlackTree", "deleteNode"));
        }
        this.incModCount();
        Node<K> e = n;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        assert (e == this.root) : e;
        if (n.getLeft() != null && n.getRight() != null) {
            Node<K> pred = this.maximumNode(n.getLeft());
            n = this.swapWithMaxPred(n, pred);
        }
        assert (n.getLeft() == null || n.getRight() == null);
        Node<K> node = child = n.getRight() == null ? n.getLeft() : n.getRight();
        if (RedBlackTree.isBlack(n)) {
            n.setColor(RedBlackTree.isBlack(child));
            this.deleteCase1(n);
        }
        this.replaceNode(n, child);
        if (!RedBlackTree.isBlack(this.root)) {
            ((Node)this.root).setBlack();
        }
        assert (this.nodeSize > 0) : this.nodeSize;
        --this.nodeSize;
        this.verifyProperties();
    }

    @NotNull
    protected abstract Node<K> swapWithMaxPred(@NotNull Node<K> var1, @NotNull Node<K> var2);

    @NotNull
    protected Node<K> maximumNode(@NotNull Node<K> n) {
        if (n == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RedBlackTree", "maximumNode"));
        }
        while (n.getRight() != null) {
            n = n.getRight();
        }
        Node<K> node = n;
        if (node == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RedBlackTree", "maximumNode"));
        }
        return node;
    }

    private void deleteCase1(Node<K> n) {
        if (n.getParent() != null) {
            this.deleteCase2(n);
        }
    }

    private void deleteCase2(Node<K> n) {
        if (!RedBlackTree.isBlack(n.sibling())) {
            n.getParent().setRed();
            ((Node)n.sibling()).setBlack();
            if (n == n.getParent().getLeft()) {
                this.rotateLeft(n.getParent());
            } else {
                this.rotateRight(n.getParent());
            }
        }
        this.deleteCase3(n);
    }

    private void deleteCase3(Node<K> n) {
        if (RedBlackTree.isBlack(n.getParent()) && RedBlackTree.isBlack(n.sibling()) && RedBlackTree.isBlack(n.sibling().getLeft()) && RedBlackTree.isBlack(n.sibling().getRight())) {
            n.sibling().setRed();
            this.deleteCase1(n.getParent());
        } else {
            this.deleteCase4(n);
        }
    }

    private void deleteCase4(Node<K> n) {
        if (!RedBlackTree.isBlack(n.getParent()) && RedBlackTree.isBlack(n.sibling()) && RedBlackTree.isBlack(n.sibling().getLeft()) && RedBlackTree.isBlack(n.sibling().getRight())) {
            n.sibling().setRed();
            ((Node)n.getParent()).setBlack();
        } else {
            this.deleteCase5(n);
        }
    }

    private void deleteCase5(Node<K> n) {
        if (n == n.getParent().getLeft() && RedBlackTree.isBlack(n.sibling()) && !RedBlackTree.isBlack(n.sibling().getLeft()) && RedBlackTree.isBlack(n.sibling().getRight())) {
            n.sibling().setRed();
            ((Node)n.sibling().getLeft()).setBlack();
            this.rotateRight(n.sibling());
        } else if (n == n.getParent().getRight() && RedBlackTree.isBlack(n.sibling()) && !RedBlackTree.isBlack(n.sibling().getRight()) && RedBlackTree.isBlack(n.sibling().getLeft())) {
            n.sibling().setRed();
            ((Node)n.sibling().getRight()).setBlack();
            this.rotateLeft(n.sibling());
        }
        this.deleteCase6(n);
    }

    private void deleteCase6(Node<K> n) {
        n.sibling().setColor(RedBlackTree.isBlack(n.getParent()));
        ((Node)n.getParent()).setBlack();
        if (n == n.getParent().getLeft()) {
            assert (!RedBlackTree.isBlack(n.sibling().getRight()));
            ((Node)n.sibling().getRight()).setBlack();
            this.rotateLeft(n.getParent());
        } else {
            assert (!RedBlackTree.isBlack(n.sibling().getLeft()));
            ((Node)n.sibling().getLeft()).setBlack();
            this.rotateRight(n.getParent());
        }
    }

    public int size() {
        return this.nodeSize;
    }

    int nodeSize() {
        return this.nodeSize;
    }

    void verifyProperties() {
        if (VERIFY) {
            RedBlackTree.verifyProperty1(this.root);
            RedBlackTree.verifyProperty2(this.root);
            RedBlackTree.verifyProperty4(this.root);
            RedBlackTree.verifyProperty5(this.root);
        }
    }

    private static void verifyProperty1(Node<?> n) {
        assert (!RedBlackTree.isBlack(n) || RedBlackTree.isBlack(n));
        if (n == null) {
            return;
        }
        assert (n.getParent() != n);
        assert (n.getLeft() != n);
        assert (n.getRight() != n);
        RedBlackTree.assertParentChild(n);
        RedBlackTree.verifyProperty1(n.getLeft());
        RedBlackTree.verifyProperty1(n.getRight());
    }

    private static void verifyProperty2(Node<?> root2) {
        assert (RedBlackTree.isBlack(root2));
    }

    private static boolean isBlack(@Nullable Node<?> n) {
        return n == null || n.isBlack();
    }

    private static void verifyProperty4(Node<?> n) {
        if (!RedBlackTree.isBlack(n)) {
            assert (RedBlackTree.isBlack(n.getLeft()));
            assert (RedBlackTree.isBlack(n.getRight()));
            assert (RedBlackTree.isBlack(n.getParent()));
        }
        if (n == null) {
            return;
        }
        RedBlackTree.verifyProperty4(n.getLeft());
        RedBlackTree.verifyProperty4(n.getRight());
    }

    private static void verifyProperty5(Node<?> root2) {
        RedBlackTree.verifyProperty5Helper(root2, 0, -1);
    }

    private static int verifyProperty5Helper(Node<?> n, int blackCount, int pathBlackCount) {
        if (RedBlackTree.isBlack(n)) {
            ++blackCount;
        }
        if (n == null) {
            if (pathBlackCount == -1) {
                pathBlackCount = blackCount;
            } else assert (blackCount == pathBlackCount);
            return pathBlackCount;
        }
        pathBlackCount = RedBlackTree.verifyProperty5Helper(n.getLeft(), blackCount, pathBlackCount);
        pathBlackCount = RedBlackTree.verifyProperty5Helper(n.getRight(), blackCount, pathBlackCount);
        return pathBlackCount;
    }

    public static abstract class Node<K> {
        protected Node<K> left;
        protected Node<K> right;
        protected Node<K> parent;
        private volatile byte myFlags;

        boolean isFlagSet(byte mask) {
            return BitUtil.isSet(this.myFlags, mask);
        }

        void setFlag(byte mask, boolean value) {
            this.myFlags = BitUtil.set(this.myFlags, mask, value);
        }

        public Node<K> grandparent() {
            assert (this.getParent() != null);
            assert (this.getParent().getParent() != null);
            return this.getParent().getParent();
        }

        public Node<K> sibling() {
            Node<K> parent2 = this.getParent();
            assert (parent2 != null);
            return this == parent2.getLeft() ? parent2.getRight() : parent2.getLeft();
        }

        private Node<K> uncle() {
            assert (this.getParent() != null);
            assert (this.getParent().getParent() != null);
            return this.getParent().sibling();
        }

        public Node<K> getLeft() {
            return this.left;
        }

        public void setLeft(Node<K> left) {
            this.left = left;
        }

        public Node<K> getRight() {
            return this.right;
        }

        public void setRight(Node<K> right) {
            this.right = right;
        }

        public Node<K> getParent() {
            return this.parent;
        }

        public void setParent(Node<K> parent2) {
            this.parent = parent2;
        }

        public boolean isBlack() {
            return this.isFlagSet((byte)1);
        }

        private void setBlack() {
            this.setFlag((byte)1, true);
        }

        void setRed() {
            this.setFlag((byte)1, false);
        }

        public void setColor(boolean isBlack) {
            this.setFlag((byte)1, isBlack);
        }
    }
}

