/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

public final class PsiUtils {
    private PsiUtils() {
    }

    @Nullable
    public static KtSimpleNameExpression getSimpleName(@NotNull KtExpression expression2) {
        if (expression2 instanceof KtSimpleNameExpression) {
            return (KtSimpleNameExpression)expression2;
        }
        if (expression2 instanceof KtQualifiedExpression) {
            return PsiUtils.getSelectorAsSimpleName((KtQualifiedExpression)expression2);
        }
        return null;
    }

    @Nullable
    public static KtSimpleNameExpression getSelectorAsSimpleName(@NotNull KtQualifiedExpression expression2) {
        KtExpression selectorExpression = PsiUtils.getSelector(expression2);
        if (!(selectorExpression instanceof KtSimpleNameExpression)) {
            return null;
        }
        return (KtSimpleNameExpression)selectorExpression;
    }

    @NotNull
    public static KtExpression getSelector(@NotNull KtQualifiedExpression expression2) {
        KtExpression selectorExpression = expression2.getSelectorExpression();
        assert (selectorExpression != null) : "Selector should not be null.";
        return selectorExpression;
    }

    @NotNull
    public static KtSimpleNameExpression getNotNullSimpleNameSelector(@NotNull KtQualifiedExpression expression2) {
        KtSimpleNameExpression selectorAsSimpleName = PsiUtils.getSelectorAsSimpleName(expression2);
        assert (selectorAsSimpleName != null);
        return selectorAsSimpleName;
    }

    @NotNull
    public static KtToken getOperationToken(@NotNull KtOperationExpression expression2) {
        KtSimpleNameExpression operationExpression = expression2.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType instanceof KtToken) : "Expected KtToken type, but " + elementType.getClass() + ", expression: " + expression2.getText();
        return (KtToken)elementType;
    }

    @NotNull
    public static KtExpression getBaseExpression(@NotNull KtUnaryExpression expression2) {
        KtExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null);
        return baseExpression;
    }

    public static boolean isPrefix(@NotNull KtUnaryExpression expression2) {
        return expression2 instanceof KtPrefixExpression;
    }

    public static boolean isAssignment(KtToken token) {
        return token == KtTokens.EQ;
    }

    public static boolean isNegatedOperation(@NotNull KtBinaryExpression binaryExpression) {
        return binaryExpression.getOperationToken() == KtTokens.EXCLEQ || KtPsiUtil.isNotInOperation(binaryExpression);
    }

    @NotNull
    public static List<KtParameter> getPrimaryConstructorParameters(@NotNull KtPureClassOrObject classDeclaration) {
        if (classDeclaration instanceof KtClass) {
            return classDeclaration.getPrimaryConstructorParameters();
        }
        return Collections.emptyList();
    }

    @NotNull
    public static KtExpression getLoopRange(@NotNull KtForExpression expression2) {
        KtExpression rangeExpression = expression2.getLoopRange();
        assert (rangeExpression != null);
        return rangeExpression;
    }

    @NotNull
    public static CallableDescriptor getFunctionDescriptor(ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCandidateDescriptor();
        }
        return resolvedCall2.getCandidateDescriptor();
    }

    @NotNull
    public static JsLocation extractLocationFromPsi(@NotNull PsiElement element, @NotNull SourceFilePathResolver pathResolver) throws IOException {
        PsiFile psiFile = element.getContainingFile();
        int offset2 = element.getNode().getStartOffset();
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        int sourceLine = document.getLineNumber(offset2);
        int sourceColumn = offset2 - document.getLineStartOffset(sourceLine);
        File file = new File(psiFile.getViewProvider().getVirtualFile().getPath());
        return new JsLocation(pathResolver.getPathRelativeToSourceRoots(file), sourceLine, sourceColumn);
    }
}

