/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.plugins.SwiftCompilerPlugin;

@Incubating
public class SwiftBasePlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(NativeBasePlugin.class);
        project.getPluginManager().apply(SwiftCompilerPlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        final ProviderFactory providers = project.getProviders();
        project.getDependencies().getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE).getCompatibilityRules().add(SwiftCppUsageCompatibilityRule.class);
        project.getComponents().withType(DefaultSwiftBinary.class, (Action)new Action<DefaultSwiftBinary>(){

            public void execute(final DefaultSwiftBinary binary) {
                final Names names = binary.getNames();
                SwiftCompile compile = (SwiftCompile)tasks.create(names.getCompileTaskName("swift"), SwiftCompile.class);
                compile.getModules().from(new Object[]{binary.getCompileModules()});
                compile.getSource().from(new Object[]{binary.getSwiftSource()});
                if (binary.isDebuggable()) {
                    compile.setDebuggable(true);
                }
                if (binary.isOptimized()) {
                    compile.setOptimized(true);
                }
                if (binary.isTestable()) {
                    compile.getCompilerArgs().add((Object)"-enable-testing");
                }
                compile.getModuleName().set(binary.getModule());
                compile.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                compile.getModuleFile().set(buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                    @Override
                    public String call() {
                        return "modules/" + names.getDirName() + (String)binary.getModule().get() + ".swiftmodule";
                    }
                })));
                binary.getModuleFile().set((Provider)compile.getModuleFile());
                SwiftPlatform currentPlatform = binary.getTargetPlatform();
                compile.setTargetPlatform(currentPlatform);
                NativeToolChainInternal toolChain = binary.getToolChain();
                compile.setToolChain((NativeToolChain)toolChain);
                binary.getCompileTask().set((Object)compile);
                binary.getObjectsDir().set((Provider)compile.getObjectFileDir());
            }
        });
        project.getComponents().withType(SwiftSharedLibrary.class, (Action)new Action<SwiftSharedLibrary>(){

            public void execute(SwiftSharedLibrary library) {
                ((SwiftCompile)((Object)library.getCompileTask().get())).getCompilerArgs().add((Object)"-parse-as-library");
            }
        });
        project.getComponents().withType(SwiftStaticLibrary.class, (Action)new Action<SwiftStaticLibrary>(){

            public void execute(SwiftStaticLibrary library) {
                ((SwiftCompile)((Object)library.getCompileTask().get())).getCompilerArgs().add((Object)"-parse-as-library");
            }
        });
    }

    static class SwiftCppUsageCompatibilityRule
    implements AttributeCompatibilityRule<Usage> {
        SwiftCppUsageCompatibilityRule() {
        }

        public void execute(CompatibilityCheckDetails<Usage> details) {
            if ("swift-api".equals(((Usage)details.getConsumerValue()).getName()) && "cplusplus-api".equals(((Usage)details.getProducerValue()).getName())) {
                details.compatible();
            }
        }
    }
}

