/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestExecutable;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestSuite;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;

@Incubating
public class CppUnitTestPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;

    @Inject
    public CppUnitTestPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        final DefaultCppTestSuite testComponent = (DefaultCppTestSuite)this.componentFactory.newInstance(CppTestSuite.class, DefaultCppTestSuite.class, "test");
        project.getExtensions().add(CppTestSuite.class, "unitTest", (Object)testComponent);
        project.getComponents().add((Object)testComponent);
        testComponent.getBaseName().set((Object)(project.getName() + "Test"));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                ToolChainSelector.Result result = CppUnitTestPlugin.this.toolChainSelector.select(CppPlatform.class);
                final DefaultCppTestExecutable binary = (DefaultCppTestExecutable)testComponent.addExecutable("executable", (CppPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                TaskContainer tasks = project.getTasks();
                ProductionCppComponent mainComponent = (ProductionCppComponent)project.getComponents().withType(ProductionCppComponent.class).findByName("main");
                if (mainComponent != null) {
                    testComponent.getTestedComponent().set((Object)mainComponent);
                    AbstractLinkTask linkTest = (AbstractLinkTask)binary.getLinkTask().get();
                    Provider mainObjects = mainComponent.getDevelopmentBinary().map((Transformer)new Transformer<FileCollection, CppBinary>(){

                        public FileCollection transform(CppBinary devBinary) {
                            return devBinary.getObjects();
                        }
                    });
                    linkTest.source((Object)mainObjects);
                    linkTest.dependsOn(new Object[]{mainObjects});
                }
                RunTestExecutable testTask = (RunTestExecutable)tasks.create("runTest", RunTestExecutable.class, (Action)new Action<RunTestExecutable>(){

                    public void execute(RunTestExecutable testTask) {
                        testTask.setGroup("verification");
                        testTask.setDescription("Executes C++ unit tests.");
                        InstallExecutable installTask = (InstallExecutable)binary.getInstallTask().get();
                        testTask.onlyIf((Spec)new Spec<Task>(){

                            public boolean isSatisfiedBy(Task element) {
                                return ((Directory)binary.getInstallDirectory().get()).getAsFile().exists();
                            }
                        });
                        testTask.setExecutable(installTask.getRunScript());
                        testTask.dependsOn(new Object[]{testComponent.getTestBinary().map((Transformer)new Transformer<Provider<Directory>, CppTestExecutable>(){

                            public Provider<Directory> transform(CppTestExecutable cppExecutable) {
                                return cppExecutable.getInstallDirectory();
                            }
                        })});
                        testTask.setOutputDir(((Directory)project.getLayout().getBuildDirectory().dir("test-results/unitTest").get()).getAsFile());
                    }
                });
                binary.getRunTask().set((Object)testTask);
                testComponent.getBinaries().realizeNow();
            }
        });
    }
}

