/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.internal.execution;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.io.LineBufferingOutputStream;
import org.gradle.internal.io.TextStream;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.time.Clock;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestDescriptor;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestScraper;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestSelection;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestTestExecutionSpec;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;

public class XCTestExecuter
implements TestExecuter<XCTestTestExecutionSpec> {
    @Inject
    public ExecHandleFactory getExecHandleFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public BuildOperationExecutor getBuildOperationExcecutor() {
        throw new UnsupportedOperationException();
    }

    public IdGenerator<?> getIdGenerator() {
        return new LongIdGenerator();
    }

    @Inject
    public Clock getClock() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public Clock getTimeProvider() {
        throw new UnsupportedOperationException();
    }

    public void execute(XCTestTestExecutionSpec testExecutionSpec, TestResultProcessor testResultProcessor) {
        File executable = testExecutionSpec.getRunScript();
        File workingDir = testExecutionSpec.getWorkingDir();
        XCTestProcessor processor = new XCTestProcessor(this.getClock(), executable, workingDir, this.getExecHandleFactory().newExec(), this.getIdGenerator());
        XCTestDetector detector = new XCTestDetector(processor, testExecutionSpec.getTestSelection());
        Object testTaskOperationId = this.getBuildOperationExcecutor().getCurrentOperation().getParentId();
        new TestMainAction((Runnable)detector, (TestClassProcessor)processor, testResultProcessor, this.getTimeProvider(), testTaskOperationId, (Object)testExecutionSpec.getPath(), "Gradle Test Run " + testExecutionSpec.getPath()).run();
    }

    static class XCTestProcessor
    implements TestClassProcessor {
        private TestResultProcessor resultProcessor;
        private ExecHandle execHandle;
        private final ExecHandleBuilder execHandleBuilder;
        private final IdGenerator<?> idGenerator;
        private final Clock clock;

        @Inject
        public XCTestProcessor(Clock clock, File executable, File workingDir, ExecHandleBuilder execHandleBuilder, IdGenerator<?> idGenerator) {
            this.execHandleBuilder = execHandleBuilder;
            this.idGenerator = idGenerator;
            this.clock = clock;
            execHandleBuilder.executable((Object)executable);
            execHandleBuilder.setWorkingDir(workingDir);
        }

        public void startProcessing(TestResultProcessor resultProcessor) {
            this.resultProcessor = resultProcessor;
        }

        public void processTestClass(TestClassRunInfo testClass) {
            this.execHandle = this.executeTest(testClass.getTestClassName());
            this.execHandle.waitForFinish();
        }

        private ExecHandle executeTest(String testName) {
            this.execHandleBuilder.setArgs(XCTestProcessor.toTestArgs(testName));
            ArrayDeque<XCTestDescriptor> testDescriptors = new ArrayDeque<XCTestDescriptor>();
            XCTestScraper stdOut = new XCTestScraper(TestOutputEvent.Destination.StdOut, this.resultProcessor, this.idGenerator, this.clock, testDescriptors);
            XCTestScraper stdErr = new XCTestScraper(TestOutputEvent.Destination.StdErr, this.resultProcessor, this.idGenerator, this.clock, testDescriptors);
            this.execHandleBuilder.setStandardOutput((OutputStream)new LineBufferingOutputStream((TextStream)stdOut));
            this.execHandleBuilder.setErrorOutput((OutputStream)new LineBufferingOutputStream((TextStream)stdErr));
            ExecHandle handle = this.execHandleBuilder.build();
            return handle.start();
        }

        private static List<String> toTestArgs(String testName) {
            ArrayList args = Lists.newArrayList();
            if (!testName.equals("All")) {
                if (OperatingSystem.current().isMacOsX()) {
                    args.add("-XCTest");
                }
                args.add(testName);
            }
            return args;
        }

        public void stop() {
            if (this.execHandle != null) {
                this.execHandle.abort();
                this.execHandle.waitForFinish();
            }
        }
    }

    private static class XCTestDetector
    implements Runnable {
        private final TestClassProcessor testClassProcessor;
        private final XCTestSelection testSelection;

        XCTestDetector(TestClassProcessor testClassProcessor, XCTestSelection testSelection) {
            this.testClassProcessor = testClassProcessor;
            this.testSelection = testSelection;
        }

        @Override
        public void run() {
            for (String includedTests : this.testSelection.getIncludedTests()) {
                DefaultTestClassRunInfo testClass = new DefaultTestClassRunInfo(includedTests);
                this.testClassProcessor.processTestClass((TestClassRunInfo)testClass);
            }
        }
    }
}

