/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ExperimentalFeatures;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyConfigurationContainer;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.artifact.DefaultIvyArtifactSet;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependencySet;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfigurationContainer;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorSpecInternal;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.GUtil;

public class DefaultIvyPublication
implements IvyPublicationInternal {
    private static final Comparator<? super UsageContext> USAGE_ORDERING = new Comparator<UsageContext>(){

        @Override
        public int compare(UsageContext left, UsageContext right) {
            if (left.getUsage().getName().equals("java-api")) {
                return -1;
            }
            if (right.getUsage().getName().equals("java-api")) {
                return 1;
            }
            return left.getUsage().getName().compareTo(right.getUsage().getName());
        }
    };
    private final String name;
    private final IvyModuleDescriptorSpecInternal descriptor;
    private final IvyPublicationIdentity publicationIdentity;
    private final IvyConfigurationContainer configurations;
    private final DefaultIvyArtifactSet ivyArtifacts;
    private final DefaultIvyDependencySet ivyDependencies;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final ExperimentalFeatures experimentalFeatures;
    private FileCollection ivyDescriptorFile;
    private FileCollection gradleModuleDescriptorFile;
    private SoftwareComponentInternal component;
    private boolean alias;

    public DefaultIvyPublication(String name, Instantiator instantiator, IvyPublicationIdentity publicationIdentity, NotationParser<Object, IvyArtifact> ivyArtifactNotationParser, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory immutableAttributesFactory, ExperimentalFeatures experimentalFeatures) {
        this.name = name;
        this.publicationIdentity = publicationIdentity;
        this.projectDependencyResolver = projectDependencyResolver;
        this.configurations = (IvyConfigurationContainer)instantiator.newInstance(DefaultIvyConfigurationContainer.class, new Object[]{instantiator});
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.experimentalFeatures = experimentalFeatures;
        this.ivyArtifacts = (DefaultIvyArtifactSet)instantiator.newInstance(DefaultIvyArtifactSet.class, new Object[]{name, ivyArtifactNotationParser, fileCollectionFactory});
        this.ivyDependencies = (DefaultIvyDependencySet)((Object)instantiator.newInstance(DefaultIvyDependencySet.class, new Object[0]));
        this.descriptor = (IvyModuleDescriptorSpecInternal)instantiator.newInstance(DefaultIvyModuleDescriptorSpec.class, new Object[]{this});
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public SoftwareComponentInternal getComponent() {
        return this.component;
    }

    @Override
    public IvyModuleDescriptorSpecInternal getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setIvyDescriptorFile(FileCollection descriptorFile) {
        this.ivyDescriptorFile = descriptorFile;
    }

    @Override
    public void setGradleModuleDescriptorFile(FileCollection descriptorFile) {
        this.gradleModuleDescriptorFile = descriptorFile;
    }

    @Override
    public void descriptor(Action<? super IvyModuleDescriptorSpec> configure) {
        configure.execute((Object)this.descriptor);
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.component != null) {
            throw new InvalidUserDataException(String.format("Ivy publication '%s' cannot include multiple components", this.name));
        }
        this.component = (SoftwareComponentInternal)component;
        this.configurations.maybeCreate("default");
        HashSet seenArtifacts = Sets.newHashSet();
        HashSet seenDependencies = Sets.newHashSet();
        for (UsageContext usageContext : this.getSortedUsageContexts()) {
            Usage usage = usageContext.getUsage();
            String conf = this.mapUsage(usage);
            this.configurations.maybeCreate(conf);
            ((IvyConfiguration)this.configurations.getByName("default")).extend(conf);
            for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                if (seenArtifacts.contains(publishArtifact)) continue;
                seenArtifacts.add(publishArtifact);
                this.artifact(publishArtifact).setConf(conf);
            }
            for (ModuleDependency dependency : usageContext.getDependencies()) {
                if (!seenDependencies.add(dependency)) continue;
                String confMapping = String.format("%s->%s", conf, dependency.getTargetConfiguration() == null ? "default" : dependency.getTargetConfiguration());
                if (dependency instanceof ProjectDependency) {
                    this.addProjectDependency((ProjectDependency)dependency, confMapping);
                    continue;
                }
                this.addExternalDependency((ExternalDependency)dependency, confMapping);
            }
        }
    }

    private List<UsageContext> getSortedUsageContexts() {
        ArrayList usageContexts = Lists.newArrayList((Iterable)this.component.getUsages());
        Collections.sort(usageContexts, USAGE_ORDERING);
        return usageContexts;
    }

    private String mapUsage(Usage usage) {
        if ("java-api".equals(usage.getName())) {
            return "compile";
        }
        if ("java-runtime".equals(usage.getName())) {
            return "runtime";
        }
        return usage.getName();
    }

    private void addProjectDependency(ProjectDependency dependency, String confMapping) {
        ModuleVersionIdentifier identifier = this.projectDependencyResolver.resolve(dependency);
        this.ivyDependencies.add(new DefaultIvyDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), confMapping, dependency.isTransitive(), Collections.emptyList(), dependency.getExcludeRules()));
    }

    private void addExternalDependency(ExternalDependency dependency, String confMapping) {
        this.ivyDependencies.add(new DefaultIvyDependency(dependency, confMapping));
    }

    @Override
    public void configurations(Action<? super IvyConfigurationContainer> config) {
        config.execute((Object)this.configurations);
    }

    @Override
    public IvyConfigurationContainer getConfigurations() {
        return this.configurations;
    }

    @Override
    public IvyArtifact artifact(Object source) {
        return this.ivyArtifacts.artifact(source);
    }

    @Override
    public IvyArtifact artifact(Object source, Action<? super IvyArtifact> config) {
        return this.ivyArtifacts.artifact(source, config);
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.ivyArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public DefaultIvyArtifactSet getArtifacts() {
        return this.ivyArtifacts;
    }

    @Override
    public String getOrganisation() {
        return this.publicationIdentity.getOrganisation();
    }

    @Override
    public void setOrganisation(String organisation) {
        this.publicationIdentity.setOrganisation(organisation);
    }

    @Override
    public String getModule() {
        return this.publicationIdentity.getModule();
    }

    @Override
    public void setModule(String module) {
        this.publicationIdentity.setModule(module);
    }

    @Override
    public String getRevision() {
        return this.publicationIdentity.getRevision();
    }

    @Override
    public void setRevision(String revision) {
        this.publicationIdentity.setRevision(revision);
    }

    @Override
    public FileCollection getPublishableFiles() {
        return new UnionFileCollection(new FileCollection[]{this.ivyArtifacts.getFiles(), this.ivyDescriptorFile, this.gradleModuleDescriptorFile});
    }

    @Override
    public IvyPublicationIdentity getIdentity() {
        return this.publicationIdentity;
    }

    @Override
    public Set<IvyDependencyInternal> getDependencies() {
        return this.ivyDependencies;
    }

    @Override
    public IvyNormalizedPublication asNormalisedPublication() {
        return new IvyNormalizedPublication(this.name, this.getIdentity(), DefaultIvyPublication.assertDescriptorFile(this.ivyDescriptorFile), this.maybeGradleDescriptorFile(), (Set<IvyArtifact>)((Object)this.ivyArtifacts));
    }

    private File maybeGradleDescriptorFile() {
        if (this.gradleModuleDescriptorFile == null) {
            return null;
        }
        return this.gradleModuleDescriptorFile.getSingleFile();
    }

    @Override
    public boolean canPublishModuleMetadata() {
        if (this.getComponent() == null) {
            return false;
        }
        if (this.getComponent() instanceof ComponentWithVariants) {
            return true;
        }
        return this.experimentalFeatures.isEnabled();
    }

    private static File assertDescriptorFile(FileCollection ref) {
        if (ref == null) {
            throw new IllegalStateException("descriptorFile not set for publication");
        }
        return ref.getSingleFile();
    }

    public ModuleVersionIdentifier getCoordinates() {
        return new DefaultModuleVersionIdentifier(this.getOrganisation(), this.getModule(), this.getRevision());
    }

    public ImmutableAttributes getAttributes() {
        return this.immutableAttributesFactory.of(ProjectInternal.STATUS_ATTRIBUTE, (Object)this.getDescriptor().getStatus());
    }

    private String getPublishedUrl(PublishArtifact source) {
        return this.getArtifactFileName(source.getClassifier(), source.getExtension());
    }

    private String getArtifactFileName(String classifier, String extension) {
        StringBuilder artifactPath = new StringBuilder();
        ModuleVersionIdentifier coordinates = this.getCoordinates();
        artifactPath.append(coordinates.getName());
        artifactPath.append('-');
        artifactPath.append(coordinates.getVersion());
        if (GUtil.isTrue((Object)classifier)) {
            artifactPath.append('-');
            artifactPath.append(classifier);
        }
        if (GUtil.isTrue((Object)extension)) {
            artifactPath.append('.');
            artifactPath.append(extension);
        }
        return artifactPath.toString();
    }

    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        final String publishedUrl = this.getPublishedUrl(source);
        return new PublicationInternal.PublishedFile(){

            public String getName() {
                return publishedUrl;
            }

            public String getUri() {
                return publishedUrl;
            }
        };
    }
}

