/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.internal.ExperimentalFeatures;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.artifact.IvyArtifactNotationParserFactory;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublication;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.tasks.GenerateIvyDescriptor;
import org.gradle.api.publish.ivy.tasks.PublishToIvyRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;

@Incubating
public class IvyPublishPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FileCollectionFactory fileCollectionFactory;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final ExperimentalFeatures experimentalFeatures;

    @Inject
    public IvyPublishPlugin(Instantiator instantiator, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory immutableAttributesFactory, ExperimentalFeatures experimentalFeatures) {
        this.instantiator = instantiator;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.projectDependencyResolver = projectDependencyResolver;
        this.fileCollectionFactory = fileCollectionFactory;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.experimentalFeatures = experimentalFeatures;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(IvyPublication.class, (NamedDomainObjectFactory)new IvyPublicationFactory(IvyPublishPlugin.this.dependencyMetaDataProvider, IvyPublishPlugin.this.instantiator, IvyPublishPlugin.this.fileResolver));
            }
        });
    }

    private class IvyPublicationFactory
    implements NamedDomainObjectFactory<IvyPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;

        private IvyPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
        }

        public IvyPublication create(String name) {
            Module module = this.dependencyMetaDataProvider.getModule();
            DefaultIvyPublicationIdentity publicationIdentity = new DefaultIvyPublicationIdentity(module.getGroup(), module.getName(), module.getVersion());
            NotationParser<Object, IvyArtifact> notationParser = new IvyArtifactNotationParserFactory(this.instantiator, this.fileResolver, publicationIdentity).create();
            return (IvyPublication)this.instantiator.newInstance(DefaultIvyPublication.class, new Object[]{name, this.instantiator, publicationIdentity, notationParser, IvyPublishPlugin.this.projectDependencyResolver, IvyPublishPlugin.this.fileCollectionFactory, IvyPublishPlugin.this.immutableAttributesFactory, IvyPublishPlugin.this.experimentalFeatures});
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Mutate
        public void createTasks(ModelMap<Task> tasks, PublishingExtension publishingExtension, @Path(value="buildDir") File buildDir) {
            PublicationContainer publications = publishingExtension.getPublications();
            RepositoryHandler repositories = publishingExtension.getRepositories();
            NamedDomainObjectSet mavenPublications = publications.withType(IvyPublicationInternal.class);
            ArrayList<Publication> asPublication = new ArrayList<Publication>((Collection<Publication>)publications);
            for (IvyPublicationInternal publication : publications.withType(IvyPublicationInternal.class)) {
                String publicationName = publication.getName();
                this.createGenerateIvyDescriptorTask(tasks, publicationName, publication, buildDir);
                this.createGenerateMetadataTask(tasks, publication, asPublication, buildDir);
                for (IvyArtifactRepository repository : repositories.withType(IvyArtifactRepository.class)) {
                    String repositoryName = repository.getName();
                    String publishTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationTo" + StringUtils.capitalize((String)repositoryName) + "Repository";
                    this.createPublishToRepositoryTask(tasks, publication, publicationName, repository, repositoryName, publishTaskName);
                }
            }
        }

        private void createPublishToRepositoryTask(ModelMap<Task> tasks, final IvyPublicationInternal publication, final String publicationName, final IvyArtifactRepository repository, final String repositoryName, String publishTaskName) {
            tasks.create(publishTaskName, PublishToIvyRepository.class, (Action)new Action<PublishToIvyRepository>(){

                public void execute(PublishToIvyRepository publishTask) {
                    publishTask.setPublication(publication);
                    publishTask.setRepository(repository);
                    publishTask.setGroup("publishing");
                    publishTask.setDescription("Publishes Ivy publication '" + publicationName + "' to Ivy repository '" + repositoryName + "'.");
                }
            });
            ((Task)tasks.get("publish")).dependsOn(new Object[]{publishTaskName});
        }

        private void createGenerateIvyDescriptorTask(ModelMap<Task> tasks, final String publicationName, final IvyPublicationInternal publication, final @Path(value="buildDir") File buildDir) {
            String descriptorTaskName = "generateDescriptorFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
            tasks.create(descriptorTaskName, GenerateIvyDescriptor.class, (Action)new Action<GenerateIvyDescriptor>(){

                public void execute(GenerateIvyDescriptor descriptorTask) {
                    descriptorTask.setDescription("Generates the Ivy Module Descriptor XML file for publication '" + publicationName + "'.");
                    descriptorTask.setGroup("publishing");
                    descriptorTask.setDescriptor(publication.getDescriptor());
                    descriptorTask.setDestination(new File(buildDir, "publications/" + publicationName + "/ivy.xml"));
                }
            });
            publication.setIvyDescriptorFile(((Task)tasks.get(descriptorTaskName)).getOutputs().getFiles());
        }

        private void createGenerateMetadataTask(ModelMap<Task> tasks, final IvyPublicationInternal publication, final List<Publication> publications, final File buildDir) {
            if (!publication.canPublishModuleMetadata()) {
                return;
            }
            final String publicationName = publication.getName();
            String descriptorTaskName = "generateMetadataFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
            tasks.create(descriptorTaskName, GenerateModuleMetadata.class, (Action)new Action<GenerateModuleMetadata>(){

                public void execute(GenerateModuleMetadata generateTask) {
                    generateTask.setDescription("Generates the Gradle metadata file for publication '" + publicationName + "'.");
                    generateTask.setGroup("publishing");
                    generateTask.getPublication().set((Object)publication);
                    generateTask.getPublications().set((Iterable)publications);
                    generateTask.getOutputFile().set(new File(buildDir, "publications/" + publicationName + "/module.json"));
                }
            });
            publication.setGradleModuleDescriptorFile(((Task)tasks.get(descriptorTaskName)).getOutputs().getFiles());
        }
    }
}

