/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.Padding;
import com.sun.crypto.provider.SunJCE;
import javax.crypto.ShortBufferException;

final class ISO10126Padding
implements Padding {
    private int blockSize;

    ISO10126Padding(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public void padWithLen(byte[] in, int off, int len) throws ShortBufferException {
        if (in == null) {
            return;
        }
        int idx = CipherCore.addExact(off, len);
        if (idx > in.length) {
            throw new ShortBufferException("Buffer too small to hold padding");
        }
        byte paddingOctet = (byte)(len & 0xFF);
        byte[] padding = new byte[len - 1];
        SunJCE.RANDOM.nextBytes(padding);
        System.arraycopy(padding, 0, in, off, len - 1);
        in[idx - 1] = paddingOctet;
    }

    @Override
    public int unpad(byte[] in, int off, int len) {
        if (in == null || len == 0) {
            return 0;
        }
        int idx = CipherCore.addExact(off, len);
        byte lastByte = in[idx - 1];
        int padValue = lastByte & 0xFF;
        if (padValue < 1 || padValue > this.blockSize) {
            return -1;
        }
        int start = idx - padValue;
        if (start < off) {
            return -1;
        }
        return start;
    }

    @Override
    public int padLength(int len) {
        int paddingOctet = this.blockSize - len % this.blockSize;
        return paddingOctet;
    }
}

