/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import javax.naming.CommunicationException;
import javax.naming.NamingException;

class Header {
    static final int HEADER_SIZE = 12;
    static final short QR_BIT = Short.MIN_VALUE;
    static final short OPCODE_MASK = 30720;
    static final int OPCODE_SHIFT = 11;
    static final short AA_BIT = 1024;
    static final short TC_BIT = 512;
    static final short RD_BIT = 256;
    static final short RA_BIT = 128;
    static final short RCODE_MASK = 15;
    int xid;
    boolean query;
    int opcode;
    boolean authoritative;
    boolean truncated;
    boolean recursionDesired;
    boolean recursionAvail;
    int rcode;
    int numQuestions;
    int numAnswers;
    int numAuthorities;
    int numAdditionals;

    Header(byte[] msg, int msgLen) throws NamingException {
        this.decode(msg, msgLen);
    }

    private void decode(byte[] msg, int msgLen) throws NamingException {
        try {
            int pos = 0;
            if (msgLen < 12) {
                throw new CommunicationException("DNS error: corrupted message header");
            }
            this.xid = Header.getShort(msg, pos);
            short flags = (short)Header.getShort(msg, pos += 2);
            pos += 2;
            this.query = (flags & Short.MIN_VALUE) == 0;
            this.opcode = (flags & 0x7800) >>> 11;
            this.authoritative = (flags & 0x400) != 0;
            this.truncated = (flags & 0x200) != 0;
            this.recursionDesired = (flags & 0x100) != 0;
            this.recursionAvail = (flags & 0x80) != 0;
            this.rcode = flags & 0xF;
            this.numQuestions = Header.getShort(msg, pos);
            this.numAnswers = Header.getShort(msg, pos += 2);
            this.numAuthorities = Header.getShort(msg, pos += 2);
            this.numAdditionals = Header.getShort(msg, pos += 2);
            pos += 2;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CommunicationException("DNS error: corrupted message header");
        }
    }

    private static int getShort(byte[] msg, int pos) {
        return (msg[pos] & 0xFF) << 8 | msg[pos + 1] & 0xFF;
    }
}

