/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.toolkit.url.Uri;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import javax.naming.NamingException;

public final class LdapURL
extends Uri {
    private boolean useSsl = false;
    private String DN = null;
    private String attributes = null;
    private String scope = null;
    private String filter = null;
    private String extensions = null;

    public LdapURL(String url) throws NamingException {
        try {
            this.init(url);
            this.useSsl = this.scheme.equalsIgnoreCase("ldaps");
            if (!this.scheme.equalsIgnoreCase("ldap") && !this.useSsl) {
                throw new MalformedURLException("Not an LDAP URL: " + url);
            }
            this.parsePathAndQuery();
        }
        catch (MalformedURLException e) {
            NamingException ne = new NamingException("Cannot parse url: " + url);
            ne.setRootCause(e);
            throw ne;
        }
        catch (UnsupportedEncodingException e) {
            NamingException ne = new NamingException("Cannot parse url: " + url);
            ne.setRootCause(e);
            throw ne;
        }
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    public String getDN() {
        return this.DN;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public static String[] fromList(String urlList) throws NamingException {
        String[] urls = new String[(urlList.length() + 1) / 2];
        int i = 0;
        StringTokenizer st = new StringTokenizer(urlList, " ");
        while (st.hasMoreTokens()) {
            urls[i++] = st.nextToken();
        }
        String[] trimmed = new String[i];
        System.arraycopy(urls, 0, trimmed, 0, i);
        return trimmed;
    }

    public static boolean hasQueryComponents(String url) {
        return url.lastIndexOf(63) != -1;
    }

    static String toUrlString(String host, int port, String dn, boolean useSsl) {
        try {
            String h;
            String string = h = host != null ? host : "";
            if (h.indexOf(58) != -1 && h.charAt(0) != '[') {
                h = "[" + h + "]";
            }
            String p = port != -1 ? ":" + port : "";
            String d = dn != null ? "/" + UrlUtil.encode(dn, "UTF8") : "";
            return useSsl ? "ldaps://" + h + p + d : "ldap://" + h + p + d;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding unavailable");
        }
    }

    private void parsePathAndQuery() throws MalformedURLException, UnsupportedEncodingException {
        int endIndex;
        if (this.path.equals("")) {
            return;
        }
        String string = this.DN = this.path.startsWith("/") ? this.path.substring(1) : this.path;
        if (this.DN.length() > 0) {
            this.DN = UrlUtil.decode(this.DN, "UTF8");
        }
        if (this.query == null || this.query.length() < 2) {
            return;
        }
        int currentIndex = 1;
        int nextQmark = this.query.indexOf(63, currentIndex);
        int n = endIndex = nextQmark == -1 ? this.query.length() : nextQmark;
        if (endIndex - currentIndex > 0) {
            this.attributes = this.query.substring(currentIndex, endIndex);
        }
        if ((currentIndex = endIndex + 1) >= this.query.length()) {
            return;
        }
        nextQmark = this.query.indexOf(63, currentIndex);
        int n2 = endIndex = nextQmark == -1 ? this.query.length() : nextQmark;
        if (endIndex - currentIndex > 0) {
            this.scope = this.query.substring(currentIndex, endIndex);
        }
        if ((currentIndex = endIndex + 1) >= this.query.length()) {
            return;
        }
        nextQmark = this.query.indexOf(63, currentIndex);
        int n3 = endIndex = nextQmark == -1 ? this.query.length() : nextQmark;
        if (endIndex - currentIndex > 0) {
            this.filter = this.query.substring(currentIndex, endIndex);
            this.filter = UrlUtil.decode(this.filter, "UTF8");
        }
        if ((currentIndex = endIndex + 1) >= this.query.length()) {
            return;
        }
        if (this.query.length() - currentIndex > 0) {
            this.extensions = this.query.substring(currentIndex);
            this.extensions = UrlUtil.decode(this.extensions, "UTF8");
        }
    }
}

