/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.encryption;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.encryption.CipherData;
import com.sun.org.apache.xml.internal.security.encryption.CipherReference;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedType;
import com.sun.org.apache.xml.internal.security.encryption.Transforms;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;

public class XMLCipherInput {
    private static Logger logger = Logger.getLogger(XMLCipherInput.class.getName());
    private CipherData cipherData;
    private int mode;
    private boolean secureValidation;

    public XMLCipherInput(CipherData data) throws XMLEncryptionException {
        this.cipherData = data;
        this.mode = 2;
        if (this.cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public XMLCipherInput(EncryptedType input) throws XMLEncryptionException {
        this.cipherData = input == null ? null : input.getCipherData();
        this.mode = 2;
        if (this.cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public void setSecureValidation(boolean secureValidation) {
        this.secureValidation = secureValidation;
    }

    public byte[] getBytes() throws XMLEncryptionException {
        if (this.mode == 2) {
            return this.getDecryptBytes();
        }
        return null;
    }

    private byte[] getDecryptBytes() throws XMLEncryptionException {
        String base64EncodedEncryptedOctets = null;
        if (this.cipherData.getDataType() == 2) {
            Transforms transforms;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Found a reference type CipherData");
            }
            CipherReference cr = this.cipherData.getCipherReference();
            Attr uriAttr = cr.getURIAsAttr();
            XMLSignatureInput input = null;
            try {
                ResourceResolver resolver = ResourceResolver.getInstance(uriAttr, null, this.secureValidation);
                input = resolver.resolve(uriAttr, null, this.secureValidation);
            }
            catch (ResourceResolverException ex) {
                throw new XMLEncryptionException("empty", ex);
            }
            if (input != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Managed to resolve URI \"" + cr.getURI() + "\"");
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Failed to resolve URI \"" + cr.getURI() + "\"");
            }
            if ((transforms = cr.getTransforms()) != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Have transforms in cipher reference");
                }
                try {
                    com.sun.org.apache.xml.internal.security.transforms.Transforms dsTransforms = transforms.getDSTransforms();
                    dsTransforms.setSecureValidation(this.secureValidation);
                    input = dsTransforms.performTransforms(input);
                }
                catch (TransformationException ex) {
                    throw new XMLEncryptionException("empty", ex);
                }
            }
            try {
                return input.getBytes();
            }
            catch (IOException ex) {
                throw new XMLEncryptionException("empty", ex);
            }
            catch (CanonicalizationException ex) {
                throw new XMLEncryptionException("empty", ex);
            }
        }
        if (this.cipherData.getDataType() != 1) {
            throw new XMLEncryptionException("CipherData.getDataType() returned unexpected value");
        }
        base64EncodedEncryptedOctets = this.cipherData.getCipherValue().getValue();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Encrypted octets:\n" + base64EncodedEncryptedOctets);
        }
        try {
            return Base64.decode(base64EncodedEncryptedOctets);
        }
        catch (Base64DecodingException bde) {
            throw new XMLEncryptionException("empty", bde);
        }
    }
}

