/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;
import sun.security.action.GetPropertyAction;

public final class ObjID
implements Serializable {
    public static final int REGISTRY_ID = 0;
    public static final int ACTIVATOR_ID = 1;
    public static final int DGC_ID = 2;
    private static final long serialVersionUID = -6386392263968365220L;
    private static final AtomicLong nextObjNum = new AtomicLong(0L);
    private static final UID mySpace = new UID();
    private static final SecureRandom secureRandom = new SecureRandom();
    private final long objNum;
    private final UID space;

    public ObjID() {
        if (ObjID.useRandomIDs()) {
            this.space = new UID();
            this.objNum = secureRandom.nextLong();
        } else {
            this.space = mySpace;
            this.objNum = nextObjNum.getAndIncrement();
        }
    }

    public ObjID(int objNum) {
        this.space = new UID(0);
        this.objNum = objNum;
    }

    private ObjID(long objNum, UID space) {
        this.objNum = objNum;
        this.space = space;
    }

    public void write(ObjectOutput out) throws IOException {
        out.writeLong(this.objNum);
        this.space.write(out);
    }

    public static ObjID read(ObjectInput in) throws IOException {
        long num = in.readLong();
        UID space = UID.read(in);
        return new ObjID(num, space);
    }

    public int hashCode() {
        return (int)this.objNum;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjID) {
            ObjID id = (ObjID)obj;
            return this.objNum == id.objNum && this.space.equals(id.space);
        }
        return false;
    }

    public String toString() {
        return "[" + (this.space.equals(mySpace) ? "" : this.space + ", ") + this.objNum + "]";
    }

    private static boolean useRandomIDs() {
        String value = AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.randomIDs"));
        return value == null ? true : Boolean.parseBoolean(value);
    }
}

