/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sun.font.FontStrikeDesc;
import sun.font.FontUtilities;
import sun.font.NativeFont;
import sun.font.NativeStrikeDisposer;
import sun.font.PhysicalStrike;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;
import sun.font.SunFontManager;

class NativeStrike
extends PhysicalStrike {
    NativeFont nativeFont;
    int numGlyphs;
    AffineTransform invertDevTx;
    AffineTransform fontTx;

    private int getNativePointSize() {
        double[] mat = new double[4];
        this.desc.glyphTx.getMatrix(mat);
        this.fontTx = new AffineTransform(mat);
        if (!this.desc.devTx.isIdentity() && this.desc.devTx.getType() != 1) {
            try {
                this.invertDevTx = this.desc.devTx.createInverse();
                this.fontTx.concatenate(this.invertDevTx);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
        }
        Point2D.Float pt = new Point2D.Float(1.0f, 1.0f);
        this.fontTx.deltaTransform(pt, pt);
        double ptSize = Math.abs(pt.y);
        int ttype = this.fontTx.getType();
        if ((ttype & 0xFFFFFFFD) != 0 || this.fontTx.getScaleY() <= 0.0) {
            this.fontTx.scale(1.0 / ptSize, 1.0 / ptSize);
        } else {
            this.fontTx = null;
        }
        return (int)ptSize;
    }

    NativeStrike(NativeFont nativeFont, FontStrikeDesc desc) {
        super(nativeFont, desc);
        int ttype;
        this.nativeFont = nativeFont;
        if (nativeFont.isBitmapDelegate && (((ttype = desc.glyphTx.getType()) & 0xFFFFFFFD) != 0 || desc.glyphTx.getScaleX() <= 0.0)) {
            this.numGlyphs = 0;
            return;
        }
        int ptSize = this.getNativePointSize();
        byte[] nameBytes = nativeFont.getPlatformNameBytes(ptSize);
        double scale = Math.abs(desc.devTx.getScaleX());
        this.pScalerContext = this.createScalerContext(nameBytes, ptSize, scale);
        if (this.pScalerContext == 0L) {
            SunFontManager.getInstance().deRegisterBadFont(nativeFont);
            this.pScalerContext = this.createNullScalerContext();
            this.numGlyphs = 0;
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().severe("Could not create native strike " + new String(nameBytes));
            }
            return;
        }
        this.numGlyphs = nativeFont.getMapper().getNumGlyphs();
        this.disposer = new NativeStrikeDisposer(nativeFont, desc, this.pScalerContext);
    }

    private boolean usingIntGlyphImages() {
        if (this.intGlyphImages != null) {
            return true;
        }
        if (longAddresses) {
            return false;
        }
        int glyphLenArray = this.getMaxGlyph(this.pScalerContext);
        if (glyphLenArray < this.numGlyphs) {
            glyphLenArray = this.numGlyphs;
        }
        this.intGlyphImages = new int[glyphLenArray];
        this.disposer.intGlyphImages = this.intGlyphImages;
        return true;
    }

    private long[] getLongGlyphImages() {
        if (this.longGlyphImages == null && longAddresses) {
            int glyphLenArray = this.getMaxGlyph(this.pScalerContext);
            if (glyphLenArray < this.numGlyphs) {
                glyphLenArray = this.numGlyphs;
            }
            this.longGlyphImages = new long[glyphLenArray];
            this.disposer.longGlyphImages = this.longGlyphImages;
        }
        return this.longGlyphImages;
    }

    NativeStrike(NativeFont nativeFont, FontStrikeDesc desc, boolean nocache) {
        super(nativeFont, desc);
        this.nativeFont = nativeFont;
        int ptSize = (int)desc.glyphTx.getScaleY();
        double scale = desc.devTx.getScaleX();
        byte[] nameBytes = nativeFont.getPlatformNameBytes(ptSize);
        this.pScalerContext = this.createScalerContext(nameBytes, ptSize, scale);
        int numGlyphs = nativeFont.getMapper().getNumGlyphs();
    }

    @Override
    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            if (this.pScalerContext != 0L) {
                this.strikeMetrics = this.nativeFont.getFontMetrics(this.pScalerContext);
            }
            if (this.strikeMetrics != null && this.fontTx != null) {
                this.strikeMetrics.convertToUserSpace(this.fontTx);
            }
        }
        return this.strikeMetrics;
    }

    private native long createScalerContext(byte[] var1, int var2, double var3);

    private native int getMaxGlyph(long var1);

    private native long createNullScalerContext();

    @Override
    void getGlyphImagePtrs(int[] glyphCodes, long[] images, int len) {
        for (int i = 0; i < len; ++i) {
            images[i] = this.getGlyphImagePtr(glyphCodes[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getGlyphImagePtr(int glyphCode) {
        if (this.usingIntGlyphImages()) {
            long glyphPtr = (long)this.intGlyphImages[glyphCode] & 0xFFFFFFFFL;
            if (glyphPtr != 0L) {
                return glyphPtr;
            }
            glyphPtr = this.nativeFont.getGlyphImage(this.pScalerContext, glyphCode);
            NativeStrike nativeStrike = this;
            synchronized (nativeStrike) {
                if (this.intGlyphImages[glyphCode] == 0) {
                    this.intGlyphImages[glyphCode] = (int)glyphPtr;
                    return glyphPtr;
                }
                StrikeCache.freeIntPointer((int)glyphPtr);
                return (long)this.intGlyphImages[glyphCode] & 0xFFFFFFFFL;
            }
        }
        long glyphPtr = this.getLongGlyphImages()[glyphCode];
        if (glyphPtr != 0L) {
            return glyphPtr;
        }
        glyphPtr = this.nativeFont.getGlyphImage(this.pScalerContext, glyphCode);
        NativeStrike nativeStrike = this;
        synchronized (nativeStrike) {
            if (this.longGlyphImages[glyphCode] == 0L) {
                this.longGlyphImages[glyphCode] = glyphPtr;
                return glyphPtr;
            }
            StrikeCache.freeLongPointer(glyphPtr);
            return this.longGlyphImages[glyphCode];
        }
    }

    long getGlyphImagePtrNoCache(int glyphCode) {
        return this.nativeFont.getGlyphImageNoDefault(this.pScalerContext, glyphCode);
    }

    @Override
    void getGlyphImageBounds(int glyphcode, Point2D.Float pt, Rectangle result) {
    }

    @Override
    Point2D.Float getGlyphMetrics(int glyphCode) {
        Point2D.Float pt = new Point2D.Float(this.getGlyphAdvance(glyphCode), 0.0f);
        return pt;
    }

    @Override
    float getGlyphAdvance(int glyphCode) {
        return this.nativeFont.getGlyphAdvance(this.pScalerContext, glyphCode);
    }

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(int glyphCode) {
        return this.nativeFont.getGlyphOutlineBounds(this.pScalerContext, glyphCode);
    }

    @Override
    GeneralPath getGlyphOutline(int glyphCode, float x, float y) {
        return new GeneralPath();
    }

    @Override
    GeneralPath getGlyphVectorOutline(int[] glyphs, float x, float y) {
        return new GeneralPath();
    }
}

