/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;

class LCMSImageLayout {
    public static final int SWAPFIRST = 16384;
    public static final int DOSWAP = 1024;
    public static final int PT_RGB_8 = LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_8 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_16 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(2);
    public static final int PT_RGBA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ARGB_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x4000;
    public static final int PT_BGR_8 = 0x400 | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ABGR_8 = 0x400 | LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_BGRA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x400 | 0x4000;
    public static final int DT_BYTE = 0;
    public static final int DT_SHORT = 1;
    public static final int DT_INT = 2;
    public static final int DT_DOUBLE = 3;
    boolean isIntPacked = false;
    int pixelType;
    int dataType;
    int width;
    int height;
    int nextRowOffset;
    private int nextPixelOffset;
    int offset;
    private boolean imageAtOnce = false;
    Object dataArray;
    private int dataArrayLength;

    public static int BYTES_SH(int x) {
        return x;
    }

    public static int EXTRA_SH(int x) {
        return x << 7;
    }

    public static int CHANNELS_SH(int x) {
        return x << 3;
    }

    private LCMSImageLayout(int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this.pixelType = pixelType;
        this.width = np;
        this.height = 1;
        this.nextPixelOffset = pixelSize;
        this.nextRowOffset = LCMSImageLayout.safeMult(pixelSize, np);
        this.offset = 0;
    }

    private LCMSImageLayout(int width, int height, int pixelType, int pixelSize) throws ImageLayoutException {
        this.pixelType = pixelType;
        this.width = width;
        this.height = height;
        this.nextPixelOffset = pixelSize;
        this.nextRowOffset = LCMSImageLayout.safeMult(pixelSize, width);
        this.offset = 0;
    }

    public LCMSImageLayout(byte[] data, int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this(np, pixelType, pixelSize);
        this.dataType = 0;
        this.dataArray = data;
        this.dataArrayLength = data.length;
        this.verify();
    }

    public LCMSImageLayout(short[] data, int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this(np, pixelType, pixelSize);
        this.dataType = 1;
        this.dataArray = data;
        this.dataArrayLength = 2 * data.length;
        this.verify();
    }

    public LCMSImageLayout(int[] data, int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this(np, pixelType, pixelSize);
        this.dataType = 2;
        this.dataArray = data;
        this.dataArrayLength = 4 * data.length;
        this.verify();
    }

    public LCMSImageLayout(double[] data, int np, int pixelType, int pixelSize) throws ImageLayoutException {
        this(np, pixelType, pixelSize);
        this.dataType = 3;
        this.dataArray = data;
        this.dataArrayLength = 8 * data.length;
        this.verify();
    }

    private LCMSImageLayout() {
    }

    public static LCMSImageLayout createImageLayout(BufferedImage image) throws ImageLayoutException {
        LCMSImageLayout l = new LCMSImageLayout();
        switch (image.getType()) {
            case 1: {
                l.pixelType = PT_ARGB_8;
                l.isIntPacked = true;
                break;
            }
            case 2: {
                l.pixelType = PT_ARGB_8;
                l.isIntPacked = true;
                break;
            }
            case 4: {
                l.pixelType = PT_ABGR_8;
                l.isIntPacked = true;
                break;
            }
            case 5: {
                l.pixelType = PT_BGR_8;
                break;
            }
            case 6: {
                l.pixelType = PT_ABGR_8;
                break;
            }
            case 10: {
                l.pixelType = PT_GRAY_8;
                break;
            }
            case 11: {
                l.pixelType = PT_GRAY_16;
                break;
            }
            default: {
                ColorModel cm = image.getColorModel();
                if (cm instanceof ComponentColorModel) {
                    int[] cs;
                    ComponentColorModel ccm = (ComponentColorModel)cm;
                    for (int s : cs = ccm.getComponentSize()) {
                        if (s == 8) continue;
                        return null;
                    }
                    return LCMSImageLayout.createImageLayout(image.getRaster());
                }
                return null;
            }
        }
        l.width = image.getWidth();
        l.height = image.getHeight();
        switch (image.getType()) {
            case 1: 
            case 2: 
            case 4: {
                IntegerComponentRaster intRaster = (IntegerComponentRaster)image.getRaster();
                l.nextRowOffset = LCMSImageLayout.safeMult(4, intRaster.getScanlineStride());
                l.nextPixelOffset = LCMSImageLayout.safeMult(4, intRaster.getPixelStride());
                l.offset = LCMSImageLayout.safeMult(4, intRaster.getDataOffset(0));
                l.dataArray = intRaster.getDataStorage();
                l.dataArrayLength = 4 * intRaster.getDataStorage().length;
                l.dataType = 2;
                if (l.nextRowOffset != LCMSImageLayout.safeMult(l.width, l.nextPixelOffset)) break;
                l.imageAtOnce = true;
                break;
            }
            case 5: 
            case 6: {
                ByteComponentRaster byteRaster = (ByteComponentRaster)image.getRaster();
                l.nextRowOffset = byteRaster.getScanlineStride();
                l.nextPixelOffset = byteRaster.getPixelStride();
                int firstBand = image.getSampleModel().getNumBands() - 1;
                l.offset = byteRaster.getDataOffset(firstBand);
                l.dataArray = byteRaster.getDataStorage();
                l.dataArrayLength = byteRaster.getDataStorage().length;
                l.dataType = 0;
                if (l.nextRowOffset != l.width * byteRaster.getPixelStride()) break;
                l.imageAtOnce = true;
                break;
            }
            case 10: {
                ByteComponentRaster byteRaster = (ByteComponentRaster)image.getRaster();
                l.nextRowOffset = byteRaster.getScanlineStride();
                l.nextPixelOffset = byteRaster.getPixelStride();
                l.dataArrayLength = byteRaster.getDataStorage().length;
                l.offset = byteRaster.getDataOffset(0);
                l.dataArray = byteRaster.getDataStorage();
                l.dataType = 0;
                if (l.nextRowOffset != l.width * byteRaster.getPixelStride()) break;
                l.imageAtOnce = true;
                break;
            }
            case 11: {
                ShortComponentRaster shortRaster = (ShortComponentRaster)image.getRaster();
                l.nextRowOffset = LCMSImageLayout.safeMult(2, shortRaster.getScanlineStride());
                l.nextPixelOffset = LCMSImageLayout.safeMult(2, shortRaster.getPixelStride());
                l.offset = LCMSImageLayout.safeMult(2, shortRaster.getDataOffset(0));
                l.dataArray = shortRaster.getDataStorage();
                l.dataArrayLength = 2 * shortRaster.getDataStorage().length;
                l.dataType = 1;
                if (l.nextRowOffset != l.width * 2 * shortRaster.getPixelStride()) break;
                l.imageAtOnce = true;
                break;
            }
            default: {
                return null;
            }
        }
        l.verify();
        return l;
    }

    private void verify() throws ImageLayoutException {
        if (this.offset < 0 || this.offset >= this.dataArrayLength) {
            throw new ImageLayoutException("Invalid image layout");
        }
        if (this.nextPixelOffset != LCMSImageLayout.getBytesPerPixel(this.pixelType)) {
            throw new ImageLayoutException("Invalid image layout");
        }
        int lastScanOffset = LCMSImageLayout.safeMult(this.nextRowOffset, this.height - 1);
        int lastPixelOffset = LCMSImageLayout.safeMult(this.nextPixelOffset, this.width - 1);
        int off = LCMSImageLayout.safeAdd(this.offset, lastPixelOffset = LCMSImageLayout.safeAdd(lastPixelOffset, lastScanOffset));
        if (off < 0 || off >= this.dataArrayLength) {
            throw new ImageLayoutException("Invalid image layout");
        }
    }

    static int safeAdd(int a, int b) throws ImageLayoutException {
        long res = a;
        if ((res += (long)b) < Integer.MIN_VALUE || res > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)res;
    }

    static int safeMult(int a, int b) throws ImageLayoutException {
        long res = a;
        if ((res *= (long)b) < Integer.MIN_VALUE || res > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)res;
    }

    public static LCMSImageLayout createImageLayout(Raster r) {
        LCMSImageLayout l = new LCMSImageLayout();
        if (r instanceof ByteComponentRaster && r.getSampleModel() instanceof ComponentSampleModel) {
            ByteComponentRaster br = (ByteComponentRaster)r;
            ComponentSampleModel csm = (ComponentSampleModel)r.getSampleModel();
            l.pixelType = LCMSImageLayout.CHANNELS_SH(br.getNumBands()) | LCMSImageLayout.BYTES_SH(1);
            int[] bandOffsets = csm.getBandOffsets();
            BandOrder order = BandOrder.getBandOrder(bandOffsets);
            int firstBand = 0;
            switch (order) {
                case INVERTED: {
                    l.pixelType |= 0x400;
                    firstBand = csm.getNumBands() - 1;
                    break;
                }
                case DIRECT: {
                    break;
                }
                default: {
                    return null;
                }
            }
            l.nextRowOffset = br.getScanlineStride();
            l.nextPixelOffset = br.getPixelStride();
            l.offset = br.getDataOffset(firstBand);
            l.dataArray = br.getDataStorage();
            l.dataType = 0;
            l.width = br.getWidth();
            l.height = br.getHeight();
            if (l.nextRowOffset == l.width * br.getPixelStride()) {
                l.imageAtOnce = true;
            }
            return l;
        }
        return null;
    }

    private static int getBytesPerPixel(int pixelType) {
        int bytesPerSample = 7 & pixelType;
        int colorSamplesPerPixel = 0xF & pixelType >> 3;
        int extraSamplesPerPixel = 7 & pixelType >> 7;
        return bytesPerSample * (colorSamplesPerPixel + extraSamplesPerPixel);
    }

    public static class ImageLayoutException
    extends Exception {
        public ImageLayoutException(String message) {
            super(message);
        }
    }

    private static enum BandOrder {
        DIRECT,
        INVERTED,
        ARBITRARY,
        UNKNOWN;


        public static BandOrder getBandOrder(int[] bandOffsets) {
            BandOrder order = UNKNOWN;
            int numBands = bandOffsets.length;
            block5: for (int i = 0; order != ARBITRARY && i < bandOffsets.length; ++i) {
                switch (order) {
                    case UNKNOWN: {
                        if (bandOffsets[i] == i) {
                            order = DIRECT;
                            continue block5;
                        }
                        if (bandOffsets[i] == numBands - 1 - i) {
                            order = INVERTED;
                            continue block5;
                        }
                        order = ARBITRARY;
                        continue block5;
                    }
                    case DIRECT: {
                        if (bandOffsets[i] == i) continue block5;
                        order = ARBITRARY;
                        continue block5;
                    }
                    case INVERTED: {
                        if (bandOffsets[i] == numBands - 1 - i) continue block5;
                        order = ARBITRARY;
                    }
                }
            }
            return order;
        }
    }
}

