/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Iterator;
import sun.java2d.pisces.Helpers;

final class Curve {
    float ax;
    float ay;
    float bx;
    float by;
    float cx;
    float cy;
    float dx;
    float dy;
    float dax;
    float day;
    float dbx;
    float dby;

    Curve() {
    }

    void set(float[] points, int type) {
        switch (type) {
            case 8: {
                this.set(points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7]);
                break;
            }
            case 6: {
                this.set(points[0], points[1], points[2], points[3], points[4], points[5]);
                break;
            }
            default: {
                throw new InternalError("Curves can only be cubic or quadratic");
            }
        }
    }

    void set(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.ax = 3.0f * (x2 - x3) + x4 - x1;
        this.ay = 3.0f * (y2 - y3) + y4 - y1;
        this.bx = 3.0f * (x1 - 2.0f * x2 + x3);
        this.by = 3.0f * (y1 - 2.0f * y2 + y3);
        this.cx = 3.0f * (x2 - x1);
        this.cy = 3.0f * (y2 - y1);
        this.dx = x1;
        this.dy = y1;
        this.dax = 3.0f * this.ax;
        this.day = 3.0f * this.ay;
        this.dbx = 2.0f * this.bx;
        this.dby = 2.0f * this.by;
    }

    void set(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.ay = 0.0f;
        this.ax = 0.0f;
        this.bx = x1 - 2.0f * x2 + x3;
        this.by = y1 - 2.0f * y2 + y3;
        this.cx = 2.0f * (x2 - x1);
        this.cy = 2.0f * (y2 - y1);
        this.dx = x1;
        this.dy = y1;
        this.dax = 0.0f;
        this.day = 0.0f;
        this.dbx = 2.0f * this.bx;
        this.dby = 2.0f * this.by;
    }

    float xat(float t) {
        return t * (t * (t * this.ax + this.bx) + this.cx) + this.dx;
    }

    float yat(float t) {
        return t * (t * (t * this.ay + this.by) + this.cy) + this.dy;
    }

    float dxat(float t) {
        return t * (t * this.dax + this.dbx) + this.cx;
    }

    float dyat(float t) {
        return t * (t * this.day + this.dby) + this.cy;
    }

    int dxRoots(float[] roots, int off) {
        return Helpers.quadraticRoots(this.dax, this.dbx, this.cx, roots, off);
    }

    int dyRoots(float[] roots, int off) {
        return Helpers.quadraticRoots(this.day, this.dby, this.cy, roots, off);
    }

    int infPoints(float[] pts, int off) {
        float a = this.dax * this.dby - this.dbx * this.day;
        float b = 2.0f * (this.cy * this.dax - this.day * this.cx);
        float c = this.cy * this.dbx - this.cx * this.dby;
        return Helpers.quadraticRoots(a, b, c, pts, off);
    }

    private int perpendiculardfddf(float[] pts, int off) {
        assert (pts.length >= off + 4);
        float a = 2.0f * (this.dax * this.dax + this.day * this.day);
        float b = 3.0f * (this.dax * this.dbx + this.day * this.dby);
        float c = 2.0f * (this.dax * this.cx + this.day * this.cy) + this.dbx * this.dbx + this.dby * this.dby;
        float d = this.dbx * this.cx + this.dby * this.cy;
        return Helpers.cubicRootsInAB(a, b, c, d, pts, off, 0.0f, 1.0f);
    }

    int rootsOfROCMinusW(float[] roots, int off, float w, float err) {
        assert (off <= 6 && roots.length >= 10);
        int ret = off;
        int numPerpdfddf = this.perpendiculardfddf(roots, off);
        float t0 = 0.0f;
        float ft0 = this.ROCsq(t0) - w * w;
        roots[off + numPerpdfddf] = 1.0f;
        ++numPerpdfddf;
        for (int i = off; i < off + numPerpdfddf; ++i) {
            float t1 = roots[i];
            float ft1 = this.ROCsq(t1) - w * w;
            if (ft0 == 0.0f) {
                roots[ret++] = t0;
            } else if (ft1 * ft0 < 0.0f) {
                roots[ret++] = this.falsePositionROCsqMinusX(t0, t1, w * w, err);
            }
            t0 = t1;
            ft0 = ft1;
        }
        return ret - off;
    }

    private static float eliminateInf(float x) {
        return x == Float.POSITIVE_INFINITY ? Float.MAX_VALUE : (x == Float.NEGATIVE_INFINITY ? Float.MIN_VALUE : x);
    }

    private float falsePositionROCsqMinusX(float x0, float x1, float x, float err) {
        int iterLimit = 100;
        int side = 0;
        float t = x1;
        float ft = Curve.eliminateInf(this.ROCsq(t) - x);
        float s = x0;
        float fs = Curve.eliminateInf(this.ROCsq(s) - x);
        float r = s;
        for (int i = 0; i < 100 && Math.abs(t - s) > err * Math.abs(t + s); ++i) {
            r = (fs * t - ft * s) / (fs - ft);
            float fr = this.ROCsq(r) - x;
            if (Curve.sameSign(fr, ft)) {
                ft = fr;
                t = r;
                if (side < 0) {
                    fs /= (float)(1 << -side);
                    --side;
                    continue;
                }
                side = -1;
                continue;
            }
            if (!(fr * fs > 0.0f)) break;
            fs = fr;
            s = r;
            if (side > 0) {
                ft /= (float)(1 << side);
                ++side;
                continue;
            }
            side = 1;
        }
        return r;
    }

    private static boolean sameSign(double x, double y) {
        return x < 0.0 && y < 0.0 || x > 0.0 && y > 0.0;
    }

    private float ROCsq(float t) {
        float dx = t * (t * this.dax + this.dbx) + this.cx;
        float dy = t * (t * this.day + this.dby) + this.cy;
        float ddx = 2.0f * this.dax * t + this.dbx;
        float ddy = 2.0f * this.day * t + this.dby;
        float dx2dy2 = dx * dx + dy * dy;
        float ddx2ddy2 = ddx * ddx + ddy * ddy;
        float ddxdxddydy = ddx * dx + ddy * dy;
        return dx2dy2 * (dx2dy2 * dx2dy2 / (dx2dy2 * ddx2ddy2 - ddxdxddydy * ddxdxddydy));
    }

    static Iterator<Integer> breakPtsAtTs(final float[] pts, final int type, final float[] Ts, final int numTs) {
        assert (pts.length >= 2 * type && numTs <= Ts.length);
        return new Iterator<Integer>(){
            final Integer i0 = 0;
            final Integer itype = type;
            int nextCurveIdx = 0;
            Integer curCurveOff = this.i0;
            float prevT = 0.0f;

            @Override
            public boolean hasNext() {
                return this.nextCurveIdx < numTs + 1;
            }

            @Override
            public Integer next() {
                Integer ret;
                if (this.nextCurveIdx < numTs) {
                    float curT = Ts[this.nextCurveIdx];
                    float splitT = (curT - this.prevT) / (1.0f - this.prevT);
                    Helpers.subdivideAt(splitT, pts, this.curCurveOff, pts, 0, pts, type, type);
                    this.prevT = curT;
                    ret = this.i0;
                    this.curCurveOff = this.itype;
                } else {
                    ret = this.curCurveOff;
                }
                ++this.nextCurveIdx;
                return ret;
            }

            @Override
            public void remove() {
            }
        };
    }
}

