/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class PortConfig {
    private static int defaultUpper;
    private static int defaultLower;
    private static final int upper;
    private static final int lower;

    private PortConfig() {
    }

    static native int getLower0();

    static native int getUpper0();

    public static int getLower() {
        return lower;
    }

    public static int getUpper() {
        return upper;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                String os = System.getProperty("os.name");
                if (os.startsWith("Linux")) {
                    defaultLower = 32768;
                    defaultUpper = 61000;
                } else if (os.startsWith("SunOS")) {
                    defaultLower = 32768;
                    defaultUpper = 65535;
                } else if (os.startsWith("AIX")) {
                    defaultLower = 32768;
                    defaultUpper = 65535;
                } else if (os.contains("OS X")) {
                    defaultLower = 49152;
                    defaultUpper = 65535;
                } else {
                    throw new InternalError("sun.net.PortConfig: unknown OS");
                }
                return null;
            }
        });
        int v = PortConfig.getLower0();
        if (v == -1) {
            v = defaultLower;
        }
        lower = v;
        v = PortConfig.getUpper0();
        if (v == -1) {
            v = defaultUpper;
        }
        upper = v;
    }
}

