/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.security.AccessController;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.security.action.GetIntegerAction;

class EPollArrayWrapper {
    private static final int EPOLLIN = 1;
    private static final int EPOLL_CTL_ADD = 1;
    private static final int EPOLL_CTL_DEL = 2;
    private static final int EPOLL_CTL_MOD = 3;
    private static final int SIZE_EPOLLEVENT = EPollArrayWrapper.sizeofEPollEvent();
    private static final int EVENT_OFFSET = 0;
    private static final int DATA_OFFSET;
    private static final int FD_OFFSET;
    private static final int OPEN_MAX;
    private static final int NUM_EPOLLEVENTS;
    private static final byte KILLED = -1;
    private static final int INITIAL_PENDING_UPDATE_SIZE = 64;
    private static final int MAX_UPDATE_ARRAY_SIZE;
    private final int epfd;
    private final AllocatedNativeObject pollArray;
    private final long pollArrayAddress;
    private int outgoingInterruptFD;
    private int incomingInterruptFD;
    private int interruptedIndex;
    int updated;
    private final Object updateLock = new Object();
    private int updateCount;
    private int[] updateDescriptors = new int[64];
    private final byte[] eventsLow = new byte[MAX_UPDATE_ARRAY_SIZE];
    private Map<Integer, Byte> eventsHigh;
    private final BitSet registered = new BitSet();
    private boolean interrupted = false;

    EPollArrayWrapper() throws IOException {
        this.epfd = this.epollCreate();
        int allocationSize = NUM_EPOLLEVENTS * SIZE_EPOLLEVENT;
        this.pollArray = new AllocatedNativeObject(allocationSize, true);
        this.pollArrayAddress = this.pollArray.address();
        if (OPEN_MAX > MAX_UPDATE_ARRAY_SIZE) {
            this.eventsHigh = new HashMap<Integer, Byte>();
        }
    }

    void initInterrupt(int fd0, int fd1) {
        this.outgoingInterruptFD = fd1;
        this.incomingInterruptFD = fd0;
        this.epollCtl(this.epfd, 1, fd0, 1);
    }

    void putEventOps(int i, int event) {
        int offset = SIZE_EPOLLEVENT * i + 0;
        this.pollArray.putInt(offset, event);
    }

    void putDescriptor(int i, int fd) {
        int offset = SIZE_EPOLLEVENT * i + FD_OFFSET;
        this.pollArray.putInt(offset, fd);
    }

    int getEventOps(int i) {
        int offset = SIZE_EPOLLEVENT * i + 0;
        return this.pollArray.getInt(offset);
    }

    int getDescriptor(int i) {
        int offset = SIZE_EPOLLEVENT * i + FD_OFFSET;
        return this.pollArray.getInt(offset);
    }

    private boolean isEventsHighKilled(Integer key) {
        assert (key >= MAX_UPDATE_ARRAY_SIZE);
        Byte value = this.eventsHigh.get(key);
        return value != null && value == -1;
    }

    private void setUpdateEvents(int fd, byte events, boolean force) {
        if (fd < MAX_UPDATE_ARRAY_SIZE) {
            if (this.eventsLow[fd] != -1 || force) {
                this.eventsLow[fd] = events;
            }
        } else {
            Integer key = fd;
            if (!this.isEventsHighKilled(key) || force) {
                this.eventsHigh.put(key, events);
            }
        }
    }

    private byte getUpdateEvents(int fd) {
        if (fd < MAX_UPDATE_ARRAY_SIZE) {
            return this.eventsLow[fd];
        }
        Byte result = this.eventsHigh.get(fd);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int fd, int mask) {
        Object object = this.updateLock;
        synchronized (object) {
            int oldCapacity = this.updateDescriptors.length;
            if (this.updateCount == oldCapacity) {
                int newCapacity = oldCapacity + 64;
                int[] newDescriptors = new int[newCapacity];
                System.arraycopy(this.updateDescriptors, 0, newDescriptors, 0, oldCapacity);
                this.updateDescriptors = newDescriptors;
            }
            this.updateDescriptors[this.updateCount++] = fd;
            byte b = (byte)mask;
            assert (b == mask && b != -1);
            this.setUpdateEvents(fd, b, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(int fd) {
        Object object = this.updateLock;
        synchronized (object) {
            assert (!this.registered.get(fd));
            this.setUpdateEvents(fd, (byte)0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(int fd) {
        Object object = this.updateLock;
        synchronized (object) {
            this.setUpdateEvents(fd, (byte)-1, false);
            if (this.registered.get(fd)) {
                this.epollCtl(this.epfd, 2, fd, 0);
                this.registered.clear(fd);
            }
        }
    }

    void closeEPollFD() throws IOException {
        FileDispatcherImpl.closeIntFD(this.epfd);
        this.pollArray.free();
    }

    int poll(long timeout) throws IOException {
        this.updateRegistrations();
        this.updated = this.epollWait(this.pollArrayAddress, NUM_EPOLLEVENTS, timeout, this.epfd);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRegistrations() {
        Object object = this.updateLock;
        synchronized (object) {
            for (int j = 0; j < this.updateCount; ++j) {
                int fd = this.updateDescriptors[j];
                short events = this.getUpdateEvents(fd);
                boolean isRegistered = this.registered.get(fd);
                int opcode = 0;
                if (events == -1) continue;
                if (isRegistered) {
                    opcode = events != 0 ? 3 : 2;
                } else {
                    int n = opcode = events != 0 ? 1 : 0;
                }
                if (opcode == 0) continue;
                this.epollCtl(this.epfd, opcode, fd, events);
                if (opcode == 1) {
                    this.registered.set(fd);
                    continue;
                }
                if (opcode != 2) continue;
                this.registered.clear(fd);
            }
            this.updateCount = 0;
        }
    }

    public void interrupt() {
        EPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int epollCreate();

    private native void epollCtl(int var1, int var2, int var3, int var4);

    private native int epollWait(long var1, int var3, long var4, int var6) throws IOException;

    private static native int sizeofEPollEvent();

    private static native int offsetofData();

    private static native void interrupt(int var0);

    private static native void init();

    static {
        FD_OFFSET = DATA_OFFSET = EPollArrayWrapper.offsetofData();
        OPEN_MAX = IOUtil.fdLimit();
        NUM_EPOLLEVENTS = Math.min(OPEN_MAX, 8192);
        MAX_UPDATE_ARRAY_SIZE = AccessController.doPrivileged(new GetIntegerAction("sun.nio.ch.maxUpdateArraySize", Math.min(OPEN_MAX, 65536)));
        IOUtil.load();
        EPollArrayWrapper.init();
    }
}

