/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.font.TextLayout;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;

public class PeekMetrics {
    private boolean mHasNonSolidColors;
    private boolean mHasCompositing;
    private boolean mHasText;
    private boolean mHasImages;

    public boolean hasNonSolidColors() {
        return this.mHasNonSolidColors;
    }

    public boolean hasCompositing() {
        return this.mHasCompositing;
    }

    public boolean hasText() {
        return this.mHasText;
    }

    public boolean hasImages() {
        return this.mHasImages;
    }

    public void fill(Graphics2D g) {
        this.checkDrawingMode(g);
    }

    public void draw(Graphics2D g) {
        this.checkDrawingMode(g);
    }

    public void clear(Graphics2D g) {
        this.checkPaint(g.getBackground());
    }

    public void drawText(Graphics2D g) {
        this.mHasText = true;
        this.checkDrawingMode(g);
    }

    public void drawText(Graphics2D g, TextLayout textLayout) {
        this.mHasText = true;
        this.checkDrawingMode(g);
    }

    public void drawImage(Graphics2D g, Image image) {
        this.mHasImages = true;
    }

    public void drawImage(Graphics2D g, RenderedImage image) {
        this.mHasImages = true;
    }

    public void drawImage(Graphics2D g, RenderableImage image) {
        this.mHasImages = true;
    }

    private void checkDrawingMode(Graphics2D g) {
        this.checkPaint(g.getPaint());
        this.checkAlpha(g.getComposite());
    }

    private void checkPaint(Paint paint) {
        if (paint instanceof Color) {
            if (((Color)paint).getAlpha() < 255) {
                this.mHasNonSolidColors = true;
            }
        } else {
            this.mHasNonSolidColors = true;
        }
    }

    private void checkAlpha(Composite composite) {
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            float alpha = alphaComposite.getAlpha();
            int rule = alphaComposite.getRule();
            if ((double)alpha != 1.0 || rule != 2 && rule != 3) {
                this.mHasCompositing = true;
            }
        } else {
            this.mHasCompositing = true;
        }
    }
}

