/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class AuthenticationTLSCertificateInterface
 * \headerfile TelepathyQt/tls-certificate.h <TelepathyQt/TLSCertificate>
 * \ingroup clienttls
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Authentication.TLSCertificate".
 */
class TP_QT_EXPORT AuthenticationTLSCertificateInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Authentication.TLSCertificate", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Authentication.TLSCertificate");
    }

    /**
     * Creates a AuthenticationTLSCertificateInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AuthenticationTLSCertificateInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AuthenticationTLSCertificateInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    AuthenticationTLSCertificateInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a AuthenticationTLSCertificateInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    AuthenticationTLSCertificateInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a AuthenticationTLSCertificateInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit AuthenticationTLSCertificateInterface(const Tp::AbstractInterface& mainInterface);

    /**
     * Creates a AuthenticationTLSCertificateInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    AuthenticationTLSCertificateInterface(const Tp::AbstractInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c State of type \c uint.
     *
     * 
     * The current state of this certificate. State change notifications 
     * happen by means of the Accepted and Rejected signals.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyState() const
    {
        return internalRequestProperty(QLatin1String("State"));
    }

    /**
     * Asynchronous getter for the remote object property \c Rejections of type \c Tp::TLSCertificateRejectionList.
     *
     * 
     * \htmlonly
     * <p>If the  \endhtmlonly \link requestPropertyState() State \endlink \htmlonly  is Rejected,
     * an array of <tp:type>TLS_Certificate_Rejection</tp:type>
     * structures containing the reason why the certificate is rejected.</p>
     * <p>If the  \endhtmlonly \link requestPropertyState() State \endlink \htmlonly  is not Rejected,
     * this property is not meaningful, and SHOULD be set to an empty
     * array.</p>
     * <p>The first rejection in the list MAY be assumed to be
     * the most important; if the array contains more than one
     * element, the CM MAY either use the values after the first,
     * or ignore them.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRejections() const
    {
        return internalRequestProperty(QLatin1String("Rejections"));
    }

    /**
     * Asynchronous getter for the remote object property \c CertificateType of type \c QString.
     *
     * 
     * The type of this TLS certificate (e.g. &apos;x509&apos; or 
     * &apos;pgp&apos;). This property is immutable
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCertificateType() const
    {
        return internalRequestProperty(QLatin1String("CertificateType"));
    }

    /**
     * Asynchronous getter for the remote object property \c CertificateChainData of type \c Tp::ByteArrayList.
     *
     * 
     * \htmlonly
     * <p>One or more TLS certificates forming a trust chain, each encoded as
     * specified by <tp:type>Certificate_Data</tp:type>.</p>
     * <p>The first certificate in the chain MUST be the server certificate,
     * followed by the issuer's certificate, followed by the issuer's issuer
     * and so on.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCertificateChainData() const
    {
        return internalRequestProperty(QLatin1String("CertificateChainData"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Accept on the remote object.
     * 
     * Accepts this certificate, i.e. marks it as verified.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Accept(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Accept"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Reject on the remote object.
     * 
     * Rejects this certificate.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param rejections
     *     
     *     \htmlonly
     *     <p>The new value of the  \endhtmlonly \link requestPropertyRejections() Rejections \endlink \htmlonly  property.</p>
     *     <p>This MUST NOT be an empty array.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Reject(const Tp::TLSCertificateRejectionList& rejections, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Reject"));
        callMessage << QVariant::fromValue(rejections);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c Accepted on the remote object.
     * 
     * The State of this certificate has changed to Accepted.
     */
    void Accepted();

    /**
     * Represents the signal \c Rejected on the remote object.
     * 
     * The State of this certificate has changed to Rejected.
     *
     * \param rejections
     *     
     *     The new value of the Rejections property.
     */
    void Rejected(const Tp::TLSCertificateRejectionList& rejections);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::AuthenticationTLSCertificateInterface*)
