/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

public class Bib2GlsDualAbbrev
extends Bib2GlsDualEntry {
    public Bib2GlsDualAbbrev(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualabbreviation");
    }

    public Bib2GlsDualAbbrev(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualAbbrevMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualAbbrevMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualAbbrevMap();
    }

    @Override
    protected Bib2GlsEntry createDualEntry() {
        return new Bib2GlsDualAbbrev(this.bib2gls, this.getEntryType());
    }

    @Override
    public void checkRequiredFields(TeXParser teXParser) {
        if (this.getField("short") == null) {
            this.missingFieldWarning(teXParser, "short");
        }
        if (this.getField("long") == null) {
            this.missingFieldWarning(teXParser, "long");
        }
        if (this.getField("dualshort") == null) {
            this.missingFieldWarning(teXParser, "dualshort");
        }
        if (this.getField("duallong") == null) {
            this.missingFieldWarning(teXParser, "duallong");
        }
    }

    @Override
    public String getFallbackValue(String string) {
        String string2;
        if (string.equals("name") && (string2 = this.getFieldValue("short")) != null) {
            return string2;
        }
        string2 = super.getFallbackValue(string);
        if (string2 != null) {
            return string2;
        }
        if (string.equals("sort")) {
            return this.getFieldValue("short");
        }
        return null;
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        BibValueList bibValueList;
        if (string.equals("sort")) {
            BibValueList bibValueList2 = this.getField("name");
            return bibValueList2 == null ? this.getFallbackContents("name") : bibValueList2;
        }
        if (string.equals("name") && (bibValueList = this.getField("short")) != null) {
            return bibValueList;
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = "";
        String string3 = "";
        Set<String> set = this.getFieldSet();
        for (String string4 : set) {
            if (string4.equals("short")) {
                string2 = this.getFieldValue(string4);
                continue;
            }
            if (string4.equals("long")) {
                string3 = this.getFieldValue(string4);
                continue;
            }
            printWriter.format("%s", string);
            string = String.format(",%n", new Object[0]);
            printWriter.format("%s={%s}", string4, this.getFieldValue(string4));
        }
        printWriter.println(String.format("}%%%n{%s}%%%n{%s}", string2, string3));
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.println("\\glsxtrprovidestoragekey{dualshort}{}{}");
        printWriter.println("\\glsxtrprovidestoragekey{dualshortplural}{}{}");
        printWriter.println("\\glsxtrprovidestoragekey{duallong}{}{}");
        printWriter.println("\\glsxtrprovidestoragekey{duallongplural}{}{}");
        printWriter.format("\\providecommand{\\%s}[4]{%%%n", this.getCsName());
        String string = this.getEntryType();
        if (string.startsWith("dual")) {
            string = string.substring(4);
        }
        printWriter.format("  \\new%s[#2]{#1}{#3}{#4}%%%n", string);
        printWriter.println("}");
    }
}

