/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.bib2gls.NumberGroupTitle;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Vector;

public class Bib2GlsEntryNumericComparator
implements Comparator<Bib2GlsEntry> {
    private String sortField;
    private String sort;
    private Bib2Gls bib2gls;
    private Vector<Bib2GlsEntry> entries;
    private boolean reverse;

    public Bib2GlsEntryNumericComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, String string, String string2) {
        this.sortField = string2;
        this.bib2gls = bib2Gls;
        this.entries = vector;
        this.reverse = string.endsWith("-reverse");
        this.sort = string;
    }

    private String updateSortValue(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        Serializable serializable;
        String string;
        String string2;
        block18: {
            string2 = bib2GlsEntry.getId();
            string = null;
            if (this.sortField.equals("id")) {
                string = string2;
            } else {
                string = bib2GlsEntry.getFieldValue(this.sortField);
                serializable = bib2GlsEntry.getField(this.sortField);
                if (string == null) {
                    string = bib2GlsEntry.getFallbackValue(this.sortField);
                    serializable = bib2GlsEntry.getFallbackContents(this.sortField);
                }
                if (string == null) {
                    string = string2;
                    this.bib2gls.debug(this.bib2gls.getMessage("warning.no.default.sort", string2));
                } else if (this.bib2gls.useInterpreter() && serializable != null && string.matches(".*[\\\\\\$\\{\\}].*")) {
                    string = this.bib2gls.interpret(string, (BibValueList)serializable);
                }
            }
            serializable = null;
            try {
                if (this.sort.equals("integer") || this.sort.equals("integer-reverse")) {
                    serializable = new Integer(string);
                    break block18;
                }
                if (this.sort.equals("float") || this.sort.equals("float-reverse")) {
                    serializable = new Float(string);
                    break block18;
                }
                if (this.sort.equals("double") || this.sort.equals("double-reverse")) {
                    serializable = new Double(string);
                    break block18;
                }
                if (this.sort.equals("hex") || this.sort.equals("hex-reverse")) {
                    serializable = new Integer(Integer.parseInt(string, 16));
                    break block18;
                }
                if (this.sort.equals("octal") || this.sort.equals("octal-reverse")) {
                    serializable = new Integer(Integer.parseInt(string, 8));
                    break block18;
                }
                if (this.sort.equals("binary") || this.sort.equals("binary-reverse")) {
                    serializable = new Integer(Integer.parseInt(string, 2));
                    break block18;
                }
                throw new IllegalArgumentException("Unrecognised numeric sort option: " + this.sort);
            }
            catch (NumberFormatException numberFormatException) {
                string = "0";
                serializable = new Integer(0);
            }
        }
        bib2GlsEntry.setNumericSort((Number)serializable);
        bib2GlsEntry.putField("sort", string);
        if (this.bib2gls.useGroupField() && bib2GlsEntry.getFieldValue("group") == null) {
            String string3;
            GlsResource glsResource = this.bib2gls.getCurrentResource();
            GroupTitle groupTitle = glsResource.getGroupTitle(bib2GlsEntry, ((Number)serializable).intValue());
            if (groupTitle == null) {
                String string4 = glsResource.getType(bib2GlsEntry);
                groupTitle = new NumberGroupTitle((Number)serializable, string4);
                glsResource.putGroupTitle(groupTitle);
                string3 = groupTitle.toString();
            } else {
                string3 = groupTitle.format(string);
            }
            bib2GlsEntry.putField("group", String.format("\\%s%s", groupTitle.getCsLabelName(), string3));
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            this.bib2gls.verbose(String.format("%s -> '%s'", string2, string));
        }
        return string;
    }

    @Override
    protected int compare(Number number, Number number2) {
        double d;
        double d2;
        if (number instanceof Integer && number2 instanceof Integer) {
            return this.reverse ? ((Integer)number2).compareTo((Integer)number) : ((Integer)number).compareTo((Integer)number2);
        }
        if (number instanceof Float && number2 instanceof Float) {
            return this.reverse ? ((Float)number2).compareTo((Float)number) : ((Float)number).compareTo((Float)number2);
        }
        if (number instanceof Double && number2 instanceof Double) {
            return this.reverse ? ((Double)number2).compareTo((Double)number) : ((Double)number).compareTo((Double)number2);
        }
        if (this.reverse) {
            d2 = number.doubleValue();
            d = number2.doubleValue();
        } else {
            d = number.doubleValue();
            d2 = number2.doubleValue();
        }
        if (d == d2) {
            return 0;
        }
        return d < d2 ? -1 : 1;
    }

    @Override
    public int compare(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        if (this.bib2gls.getCurrentResource().flattenSort()) {
            return this.compare(bib2GlsEntry.getNumericSort(), bib2GlsEntry2.getNumericSort());
        }
        int n = bib2GlsEntry.getHierarchyCount();
        int n2 = bib2GlsEntry2.getHierarchyCount();
        int n3 = Integer.min(n, n2);
        if (n == n2 && bib2GlsEntry.getId().equals(bib2GlsEntry2.getId())) {
            return 0;
        }
        for (int i = 0; i < n3; ++i) {
            Bib2GlsEntry bib2GlsEntry3 = bib2GlsEntry.getHierarchyElement(i);
            Bib2GlsEntry bib2GlsEntry4 = bib2GlsEntry2.getHierarchyElement(i);
            int n4 = this.compare(bib2GlsEntry3.getNumericSort(), bib2GlsEntry4.getNumericSort());
            if (n4 == 0) continue;
            return n4;
        }
        return n == n2 ? 0 : (n < n2 ? -1 : 1);
    }

    public void sortEntries() throws Bib2GlsException {
        for (Bib2GlsEntry bib2GlsEntry : this.entries) {
            bib2GlsEntry.updateHierarchy(this.entries);
            this.updateSortValue(bib2GlsEntry, this.entries);
        }
        this.entries.sort(this);
    }
}

