/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.FontShapeDeclaration;
import java.io.IOException;

public class L2HFontShapeDeclaration
extends FontShapeDeclaration {
    public L2HFontShapeDeclaration(String string, int n) {
        super(string, n);
    }

    @Override
    public Object clone() {
        return new L2HFontShapeDeclaration(this.getName(), this.getShape());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        super.process(teXParser);
        String string = "";
        switch (this.getShape()) {
            case 0: {
                string = "font-style: normal; font-variant: normal; ";
                break;
            }
            case 1: {
                string = "font-style: italic; font-variant: normal; ";
                break;
            }
            case 2: {
                string = "font-style: oblique; font-variant: normal; ";
                break;
            }
            case 3: {
                int n;
                TeXSettings teXSettings = teXParser.getSettings();
                TeXSettings teXSettings2 = teXSettings.getParent();
                string = teXSettings2 != null ? ((n = teXSettings2.getFontShape()) == 0 || n == -1 ? (teXSettings.getFontFamily() == 1 ? string + "font-style: oblique; " : string + "font-style: italic; ") : string + "font-style: normal; ") : (teXSettings.getFontFamily() == 1 ? string + "font-style: oblique; " : string + "font-style: italic; ");
                string = string + "font-variant: normal; ";
                break;
            }
            case 4: {
                string = string + "font-style: normal; font-variant: small-caps; ";
            }
        }
        teXParser.getListener().getWriteable().write("<span style=\"" + string + "\">");
    }

    @Override
    public void end(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().write("</span>");
        super.end(teXParser);
    }
}

