/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.inputenc;

import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.inputenc.InputEncoding;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;

public class InputEncSty
extends LaTeXSty {
    public static final String[] KNOWN_ENCODINGS = new String[]{"ascii", "latin1", "latin2", "latin3", "latin4", "latin5", "latin9", "latin10", "decmulti", "cp850", "cp852", "cp858", "cp437", "cp437de", "cp865", "applemac", "macce", "next", "cp1250", "cp1252", "cp1257", "ansinew", "utf8"};

    public InputEncSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener) throws IOException {
        super(keyValList, "inputenc", laTeXParserListener);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new InputEncoding());
    }

    @Override
    public void processOption(String string) throws IOException {
        if (this.isKnownEncoding(string)) {
            this.getListener().setInputEncoding(string);
        }
    }

    @Override
    protected void preOptions() throws IOException {
    }

    public static Charset getCharSet(String string) throws IllegalCharsetNameException {
        if (string.equals("ascii")) {
            return Charset.forName("US-ASCII");
        }
        if (string.equals("utf8")) {
            return Charset.forName("UTF-8");
        }
        if (string.equals("latin1")) {
            return Charset.forName("ISO-8859-1");
        }
        return Charset.forName(string);
    }

    public boolean isKnownEncoding(String string) {
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            if (!KNOWN_ENCODINGS[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

