/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.image;

import java.lang.reflect.Array;
import java.util.List;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.InstanceBuilder;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.InstanceBuilderRegistry;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public class FieldAccessor {
    private final Heap heap;
    private final InstanceBuilderRegistry registry;

    public FieldAccessor(Heap heap) {
        this(heap, new InstanceBuilderRegistry());
    }

    public FieldAccessor(Heap heap, InstanceBuilderRegistry instanceBuilderRegistry) {
        this.heap = heap;
        this.registry = instanceBuilderRegistry;
    }

    public Heap getHeap() {
        return this.heap;
    }

    public static String getClassMask(Class<?> clazz, boolean bl) {
        if (bl) {
            return clazz.getName() + "+";
        }
        return clazz.getName();
    }

    public static boolean matchClassMask(Instance instance, String string) {
        if (string.endsWith("+")) {
            return DetailsUtils.isSubclassOf(instance, string.substring(0, string.length() - 1));
        }
        return DetailsUtils.isInstanceOf(instance, string);
    }

    public static boolean isInstanceOf(Instance instance, Class<?> clazz) {
        if (instance == null) {
            return false;
        }
        return instance.getJavaClass().getName().equals(clazz.getName());
    }

    public static <T> T notNull(T t) throws InvalidFieldException {
        return FieldAccessor.notNullCheck(t, false);
    }

    public static <T> T notNullCheck(T t, boolean bl) throws InvalidFieldException {
        if (!bl && t == null) {
            throw new InvalidFieldException("Unexpected null value");
        }
        return t;
    }

    public static <T> T castValue(Object object, Class<T> clazz) throws InvalidFieldException {
        if (object == null) {
            return null;
        }
        if (!clazz.isInstance(object)) {
            throw new InvalidFieldException("Value is %s but %s is expected", object.getClass().getName(), clazz.getName());
        }
        return clazz.cast(object);
    }

    public <T> T get(Instance instance, String string, Class<T> clazz, boolean bl) throws InvalidFieldException {
        Object object = instance.getValueOfField(string);
        if (object == null) {
            if (bl) {
                return null;
            }
            throw new InvalidFieldException(instance, string, "Empty or missing field");
        }
        try {
            return FieldAccessor.castValue(object, clazz);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new InvalidFieldException(instance, string, invalidFieldException.getMessage()).initCause(invalidFieldException);
        }
    }

    public Instance getInstance(Instance instance, String string, boolean bl) throws InvalidFieldException {
        return this.get(instance, string, Instance.class, bl);
    }

    public Instance getInstance(Instance instance, String string, Class<?> clazz, boolean bl) throws InvalidFieldException {
        return this.getInstance(instance, string, FieldAccessor.getClassMask(clazz, bl));
    }

    public Instance getInstance(Instance instance, String string, String string2) throws InvalidFieldException {
        Instance instance2 = this.getInstance(instance, string, false);
        if (string2.endsWith("+")) {
            if (!DetailsUtils.isSubclassOf(instance2, string2 = string2.substring(0, string2.length() - 1))) {
                throw new InvalidFieldException(instance, string, "Instance is %s but subclass of %s is expected", instance2.getJavaClass().getName(), string2);
            }
        } else if (!DetailsUtils.isInstanceOf(instance2, string2)) {
            throw new InvalidFieldException(instance, string, "Instance is %s but %s is expected", instance2.getJavaClass().getName(), string2);
        }
        return instance2;
    }

    public <T> T build(Instance instance, String string, InstanceBuilder<T> instanceBuilder, boolean bl) throws InvalidFieldException {
        return instanceBuilder.convert(this, this.get(instance, string, Instance.class, bl));
    }

    public <T> T build(Instance instance, String string, Class<T> clazz, boolean bl) throws InvalidFieldException {
        Instance instance2 = this.get(instance, string, Instance.class, bl);
        if (instance2 == null) {
            return null;
        }
        InstanceBuilder<T> instanceBuilder = this.registry.getBuilder(instance2, clazz);
        if (instanceBuilder == null) {
            if (bl) {
                return null;
            }
            throw new InvalidFieldException(instance, string, "No builder for %s returning %s registered", instance2.getJavaClass().getName(), clazz.getName());
        }
        return instanceBuilder.convert(this, instance2);
    }

    public <T> T[] buildArray(Instance instance, String string, Class<T> clazz, boolean bl, boolean bl2) throws InvalidFieldException {
        return this.buildArray(instance, string, clazz, null, bl, bl2);
    }

    public <T> T[] buildArray(Instance instance, String string, InstanceBuilder<T> instanceBuilder, boolean bl, boolean bl2) throws InvalidFieldException {
        return this.buildArray(instance, string, instanceBuilder.getType(), instanceBuilder, bl, bl2);
    }

    private <T> T[] buildArray(Instance instance, String string, Class<T> clazz, InstanceBuilder<? extends T> instanceBuilder, boolean bl, boolean bl2) throws InvalidFieldException {
        ObjectArrayInstance objectArrayInstance = this.get(instance, string, ObjectArrayInstance.class, bl);
        if (objectArrayInstance == null) {
            return null;
        }
        List list = objectArrayInstance.getValues();
        Object[] objectArray = (Object[])Array.newInstance(instanceBuilder.getType(), list.size());
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                InstanceBuilder<T> instanceBuilder2 = instanceBuilder == null ? this.registry.getBuilder(instance, clazz) : instanceBuilder;
                objectArray[i] = instanceBuilder2.convert(this, FieldAccessor.castValue(FieldAccessor.notNullCheck(list.get(i), bl2), Instance.class));
                continue;
            }
            catch (InvalidFieldException invalidFieldException) {
                throw new InvalidFieldException(instance, string, "Invalid value at index %d: %s", i, invalidFieldException.getMessage()).initCause(invalidFieldException);
            }
        }
        return objectArray;
    }

    public String toString(Instance instance) {
        if (instance == null) {
            return null;
        }
        return DetailsSupport.getDetailsString(instance, this.heap);
    }

    public int getInt(Instance instance, String string) throws InvalidFieldException {
        return this.get(instance, string, Number.class, false).intValue();
    }

    public boolean getBoolean(Instance instance, String string) throws InvalidFieldException {
        return this.get(instance, string, Boolean.class, false);
    }

    public String getString(Instance instance, String string, boolean bl) throws InvalidFieldException {
        return this.build(instance, string, InstanceBuilder.STRING_BUILDER, bl);
    }

    public int[] getIntArray(Instance instance, String string, boolean bl) throws InvalidFieldException {
        return this.build(instance, string, InstanceBuilder.INT_ARRAY_BUILDER, bl);
    }

    public byte[] getByteArray(Instance instance, String string, boolean bl) throws InvalidFieldException {
        return this.build(instance, string, InstanceBuilder.BYTE_ARRAY_BUILDER, bl);
    }

    public int[][] getIntArray2(Instance instance, String string, boolean bl) throws InvalidFieldException {
        return this.buildArray(instance, string, InstanceBuilder.INT_ARRAY_BUILDER, bl, false);
    }

    public byte[][] getByteArray2(Instance instance, String string, boolean bl) throws InvalidFieldException {
        return this.buildArray(instance, string, InstanceBuilder.BYTE_ARRAY_BUILDER, bl, false);
    }

    public short[][] getShortArray2(Instance instance, String string, boolean bl) throws InvalidFieldException {
        return this.buildArray(instance, string, InstanceBuilder.SHORT_ARRAY_BUILDER, bl, false);
    }

    public static class InvalidFieldException
    extends Exception {
        public InvalidFieldException() {
        }

        public InvalidFieldException(String string, Object ... objectArray) {
            super(String.format(string, objectArray));
        }

        public InvalidFieldException(Instance instance, String string, String string2) {
            this(instance, string, "%s", string2);
        }

        public InvalidFieldException(Instance instance, String string, String string2, Object ... objectArray) {
            this("%s#%d->%s: %s", instance == null ? "null" : instance.getJavaClass().getName(), instance == null ? -1 : instance.getInstanceNumber(), string, String.format(string2, objectArray));
        }

        public InvalidFieldException(String string) {
            super(string);
        }

        @Override
        public synchronized InvalidFieldException initCause(Throwable throwable) {
            super.initCause(throwable);
            return this;
        }
    }
}

