/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.impl.swing.EnhancedLabelRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderLabel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderPanel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LegendFont;
import org.netbeans.modules.profiler.snaptracer.impl.swing.TimelineMarksPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;

final class TimelineAxis
extends JPanel {
    private final HeaderRenderer painter = new HeaderRenderer();
    private final AxisComponent axis;
    private final MarksComponent marks;
    private int preferredHeight;
    private int pointerX;

    TimelineAxis(final TimelineChart timelineChart, TimelineSupport timelineSupport) {
        super(null);
        Timeline timeline = ((SynchronousXYItemsModel)timelineChart.getItemsModel()).getTimeline();
        this.axis = new Axis(timelineChart, new MarksComputer(timeline, timelineChart.getChartContext()));
        this.marks = new MarksComponent(timelineSupport);
        this.preferredHeight = HeaderLabel.DEFAULT_HEIGHT;
        this.add(this.marks);
        this.add((Component)this.axis);
        this.add(this.painter);
        timelineChart.addConfigurationListener((ChartConfigurationListener)new ChartConfigurationListener.Adapter(){
            private final Runnable updater = new Runnable(){

                @Override
                public void run() {
                    if (!TimelineAxis.this.axis.isVisible()) {
                        TimelineAxis.this.marks.setupTicks();
                        TimelineAxis.this.marks.refreshHoverMark(TimelineAxis.this.pointerX);
                        TimelineAxis.this.marks.repaint();
                    }
                }
            };

            public void contentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
                if (l3 != l || d3 != d) {
                    TimelineAxis.this.marks.refreshMarks();
                }
                SwingUtilities.invokeLater(this.updater);
            }
        });
        timelineSupport.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
                TimelineAxis.this.marks.refreshMarks();
                TimelineAxis.this.marks.repaint();
            }

            @Override
            public void indexSelectionChanged() {
            }

            @Override
            public void timeSelectionChanged(boolean bl, boolean bl2) {
                TimelineAxis.this.marks.refreshMarks();
                TimelineAxis.this.marks.repaint();
            }
        });
        this.marks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TimelineAxis.this.pointerX = mouseEvent.getX();
                TimelineAxis.this.marks.setupTicks();
                TimelineAxis.this.marks.refreshHoverMark(TimelineAxis.this.pointerX);
                TimelineAxis.this.axis.setVisible(false);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                TimelineAxis.this.axis.setVisible(true);
                TimelineAxis.this.marks.clearTicks();
                TimelineAxis.this.marks.refreshHoverMark(-10);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TimelineAxis.this.marks.handleAction();
                TimelineAxis.this.marks.repaint();
            }
        });
        this.marks.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                TimelineAxis.this.pointerX = mouseEvent.getX();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                TimelineAxis.this.pointerX = mouseEvent.getX();
                if (!TimelineAxis.this.axis.isVisible()) {
                    TimelineAxis.this.marks.refreshHoverMark(TimelineAxis.this.pointerX);
                }
            }
        });
        this.marks.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                mouseWheelEvent.setSource((Object)timelineChart);
                timelineChart.processMouseWheelEvent(mouseWheelEvent);
            }
        });
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = this.preferredHeight;
        return dimension;
    }

    @Override
    public void validate() {
    }

    @Override
    public void doLayout() {
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.painter.reshape(0, 0, n3, n4);
        this.axis.reshape(1, 1, n3 - 2, n4 - 2);
        this.marks.reshape(0, 0, n3, n4);
    }

    private static class Axis
    extends AxisComponent {
        private static final int LAF_OFFSET = Axis.resolveOffset();
        private final Paint meshPaint = Utils.checkedColor((Color)new Color(180, 180, 180, 50));
        private final Stroke meshStroke = new BasicStroke(1.0f);
        private final TimelineChart chart;
        private final MarksComputer marksComputer;
        private final TimelineMarksPainter marksPainter;
        private boolean hadTicks = false;
        private final Runnable repainter;

        Axis(TimelineChart timelineChart, MarksComputer marksComputer) {
            super((ChartComponent)timelineChart, (AxisMarksComputer)marksComputer, null, 1, 2);
            this.chart = timelineChart;
            this.marksComputer = marksComputer;
            this.marksPainter = new TimelineMarksPainter();
            this.repainter = new Runnable(){

                @Override
                public void run() {
                    Axis.this.chart.invalidateRepaint();
                }
            };
        }

        public void validate() {
        }

        public void doLayout() {
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            }
            this.marksComputer.refresh();
            this.paintHorizontalAxis(graphics, rectangle);
        }

        protected void paintHorizontalMesh(Graphics2D graphics2D, Rectangle rectangle, Rectangle rectangle2) {
            Iterator iterator = this.marksComputer.marksIterator(rectangle2.x, rectangle2.x + rectangle2.width);
            boolean bl = false;
            while (iterator.hasNext()) {
                bl = true;
                AxisMark axisMark = (AxisMark)iterator.next();
                int n = axisMark.getPosition();
                graphics2D.setPaint(this.meshPaint);
                graphics2D.setStroke(this.meshStroke);
                graphics2D.drawLine(n, rectangle2.y, n, rectangle2.y + rectangle2.height);
            }
            if (!this.hadTicks && bl) {
                SwingUtilities.invokeLater(this.repainter);
            }
            this.hadTicks = bl;
        }

        protected void paintHorizontalAxis(Graphics graphics, Rectangle rectangle) {
            int n;
            int n2 = -1;
            int n3 = n2 + this.chart.getWidth() + 2;
            Iterator iterator = this.marksComputer.marksIterator(n2, n3);
            int n4 = this.chart.isRightBased() ? 0 : 1;
            int n5 = n = this.chart.isRightBased() ? 1 : 0;
            while (iterator.hasNext()) {
                AxisMark axisMark = (AxisMark)iterator.next();
                int n6 = axisMark.getPosition() - 1;
                if (n6 < -1 - n4 || n6 >= -1 + this.chart.getWidth() + n) continue;
                TimelineMarksPainter timelineMarksPainter = (TimelineMarksPainter)this.marksPainter.getPainter(axisMark);
                Dimension dimension = timelineMarksPainter.getPreferredSize();
                int n7 = dimension.width / 2;
                if (n6 + n7 < rectangle.x || n6 - n7 >= rectangle.x + rectangle.width) continue;
                graphics.setColor(this.getForeground());
                graphics.drawLine(n6, 1, n6, 3);
                int n8 = (this.getHeight() - dimension.height) / 2 + LAF_OFFSET;
                timelineMarksPainter.setLocation(n6 - n7, n8);
                timelineMarksPainter.paint(graphics);
            }
        }

        private static int resolveOffset() {
            if (UIUtils.isWindowsLookAndFeel() || UIUtils.isMetalLookAndFeel() || UIUtils.isGTKLookAndFeel()) {
                return 1;
            }
            return 0;
        }
    }

    private static class MarksComputer
    extends TimelineMarksComputer {
        MarksComputer(Timeline timeline, ChartContext chartContext) {
            super(timeline, chartContext, 0);
        }

        void refresh() {
            this.refreshConfiguration();
        }
    }

    private static class MarksComponent
    extends JComponent {
        private static final Image MARK = Icons.getImage((String)"TracerIcons.Mark");
        private static final Image MARK_HIGHL = Icons.getImage((String)"TracerIcons.MarkHiglight");
        private static final int MARK_EXTENT = MARK.getWidth(null) / 2;
        private static final int MARK_HEIGHT = MARK.getHeight(null);
        private final TimelineSupport support;
        private final Timeline timeline;
        private final SynchronousXYChartContext context;
        private final EnhancedLabelRenderer timeRenderer;
        private final Format timeFormat;
        private int[] ticks;
        private int hoverIndex = -1;
        private int hoverX = -10;
        private boolean wasSelected;
        private long hoverTime;
        private final List<Integer> selections = new ArrayList<Integer>();
        private final List<Integer> intervals = new ArrayList<Integer>();
        private final int markExtent = 2;
        private final Color systemSelection = Utils.getSystemSelection();
        private final Color selection = new Color(this.systemSelection.getRed(), this.systemSelection.getGreen(), this.systemSelection.getBlue(), 150);

        MarksComponent(TimelineSupport timelineSupport) {
            this.support = timelineSupport;
            TimelineChart timelineChart = timelineSupport.getChart();
            SynchronousXYItemsModel synchronousXYItemsModel = (SynchronousXYItemsModel)timelineChart.getItemsModel();
            this.context = (SynchronousXYChartContext)timelineChart.getChartContext();
            this.timeline = synchronousXYItemsModel.getTimeline();
            this.timeRenderer = new EnhancedLabelRenderer();
            if (UIUtils.isAquaLookAndFeel()) {
                LegendFont legendFont = new LegendFont();
                this.timeRenderer.setFont(legendFont.deriveFont(legendFont.getSize2D() - 1.0f));
                this.timeRenderer.setMargin(new Insets(0, 2, 0, 2));
            } else {
                this.timeRenderer.setFont(new LegendFont());
                this.timeRenderer.setMargin(new Insets(1, 2, 1, 2));
            }
            this.timeRenderer.setBackground(Color.WHITE);
            this.timeRenderer.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.timeFormat = new SimpleDateFormat(TimeAxisUtils.getFormatString((long)1L, (long)1L, (long)1L));
            this.setOpaque(false);
        }

        @Override
        public void validate() {
        }

        @Override
        public void doLayout() {
        }

        void refreshMarks() {
            Object object;
            Set<Integer> set = this.support.getSelectedTimestamps();
            if (!set.isEmpty() || !this.selections.isEmpty()) {
                this.selections.clear();
                object = set.iterator();
                while (object.hasNext()) {
                    int n = (Integer)object.next();
                    long l = this.timeline.getTimestamp(n);
                    int n2 = Utils.checkedInt((double)this.context.getViewX((double)l));
                    if (n2 <= -2 || n2 >= this.getWidth() + 2) continue;
                    this.selections.add(n2 + 1);
                }
            }
            if (!(object = this.support.getSelectedIntervals()).isEmpty() || !this.intervals.isEmpty()) {
                this.intervals.clear();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    long l = this.timeline.getTimestamp(n);
                    int n3 = Utils.checkedInt((double)this.context.getViewX((double)l)) + 1;
                    int n4 = iterator.hasNext() ? ((Integer)iterator.next()).intValue() : this.getWidth();
                    l = this.timeline.getTimestamp(n4);
                    int n5 = Utils.checkedInt((double)this.context.getViewX((double)l)) + 1;
                    if (n3 >= this.getWidth() || n5 <= 0) continue;
                    this.intervals.add(n3);
                    this.intervals.add(n5);
                }
            }
        }

        void setupTicks() {
            int[][] nArray = this.support.getPointsComputer().getVisible(this.getBounds(), this.timeline.getTimestampsCount(), this.context, 1, 0);
            int[] nArray2 = this.ticks = nArray == null ? null : nArray[0];
            if (this.ticks != null) {
                for (int i = 0; i < nArray[1][0]; ++i) {
                    this.ticks[i] = Utils.checkedInt((double)this.context.getViewX((double)this.timeline.getTimestamp(this.ticks[i]))) + 1;
                }
            }
        }

        void refreshHoverMark(int n) {
            int n2 = this.hoverIndex;
            this.hoverIndex = this.context.getNearestTimestampIndex(n - 1, 0);
            int n3 = this.hoverX = this.hoverIndex == -1 ? -10 : Utils.checkedInt((double)this.context.getViewX((double)this.timeline.getTimestamp(this.hoverIndex))) + 1;
            if (Math.abs(this.hoverX - n + 1) > MARK_EXTENT) {
                this.hoverIndex = -1;
                this.hoverX = -10;
            }
            if (n2 != this.hoverIndex) {
                if (!this.wasSelected) {
                    this.support.unselectTimestamp(n2);
                }
                this.wasSelected = this.hoverIndex != -1 && this.support.isTimestampSelected(this.hoverIndex);
                this.support.setTimestampHovering(this.hoverIndex != -1, this.wasSelected);
                if (this.hoverIndex != -1) {
                    this.support.selectTimestamp(this.hoverIndex, false);
                    this.hoverTime = this.timeline.getTimestamp(this.hoverIndex);
                    if (this.wasSelected) {
                        this.repaint();
                    }
                } else if (!this.wasSelected) {
                    this.repaint();
                }
                if (this.hoverIndex == -1) {
                    this.setCursor(Cursor.getDefaultCursor());
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }

        void clearTicks() {
            this.ticks = null;
        }

        void handleAction() {
            this.wasSelected = !this.wasSelected;
            this.support.setTimestampHovering(this.hoverIndex != -1, this.wasSelected);
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2 = this.getHeight();
            int n3 = this.getWidth();
            int n4 = n2 / 2 - 1;
            int n5 = n4 + 2;
            graphics.setColor(this.selection);
            if (this.intervals != null && !this.intervals.isEmpty()) {
                Iterator<Integer> iterator = this.intervals.iterator();
                while (iterator.hasNext()) {
                    int n6 = iterator.next();
                    n = iterator.next() - n6 + 1;
                    graphics.fillRect(n6, n2 - 6, Math.min(n, n3 - n6 - 3), 3);
                }
            }
            graphics.setColor(this.getForeground());
            if (this.ticks != null) {
                for (int i = 0; i < this.ticks.length; ++i) {
                    graphics.drawLine(this.ticks[i], n4, this.ticks[i], n5);
                }
            }
            if (this.selections != null && !this.selections.isEmpty()) {
                int n7 = n2 - 5 - MARK_HEIGHT;
                Object object = this.selections.iterator();
                while (object.hasNext()) {
                    n = object.next();
                    graphics.drawImage(n == this.hoverX && this.wasSelected ? MARK_HIGHL : MARK, n - MARK_EXTENT + 1, n7, null);
                }
                if (this.hoverIndex != -1) {
                    this.timeRenderer.setText(this.timeFormat.format(this.hoverTime));
                    object = this.timeRenderer.getPreferredSize();
                    n = ((Dimension)object).width;
                    int n8 = MARK_EXTENT + 15;
                    int n9 = this.hoverX + n8;
                    if (n9 > n3 - n - 10) {
                        n9 = this.hoverX - n - n8;
                    }
                    this.timeRenderer.setLocation(n9, n4 - ((Dimension)object).height / 2);
                    this.timeRenderer.paint(graphics);
                }
            }
        }
    }

    private static class HeaderRenderer
    extends HeaderPanel {
        private Image offscreen;
        long total = 0L;
        int count = 0;

        private HeaderRenderer() {
        }

        @Override
        public void reshape(int n, int n2, int n3, int n4) {
            if (this.getWidth() != n3 || this.getHeight() != n4) {
                this.offscreen = null;
            }
            super.reshape(n, n2, n3, n4);
        }

        @Override
        public void validate() {
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.offscreen == null) {
                this.offscreen = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                super.paint(this.offscreen.getGraphics());
            }
            graphics.drawImage(this.offscreen, 0, 0, null);
        }
    }
}

