/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderFactory;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderType;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.RootSelectorTree;
import org.netbeans.modules.profiler.selector.ui.TreePathSearch;
import org.netbeans.modules.profiler.ui.ProfilerProgressDisplayer;
import org.netbeans.modules.profiler.ui.panels.Bundle;
import org.netbeans.modules.profiler.ui.panels.ProjectSelectorPanel;
import org.netbeans.modules.profiler.ui.panels.RootMethodsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class ProjectSelectRootMethodsPanel
extends JPanel
implements HelpCtx.Provider {
    private static final Logger LOG = Logger.getLogger(ProjectSelectRootMethodsPanel.class.getName());
    private static ProjectSelectRootMethodsPanel instance = null;
    protected static final Dimension PREFERRED_TOPTREE_DIMENSION = new Dimension(500, 250);
    private HTMLTextArea hintArea;
    private JButton okButton;
    private JComboBox treeBuilderList;
    private Lookup.Provider currentProject;
    private List<Lookup.Provider> additionalProjects = new ArrayList<Lookup.Provider>();
    private RequestProcessor rp = new RequestProcessor("SRM-UI Processor", 1);
    private RootSelectorTree pkgTreeView;
    private JButton additionalProjectsSelector;
    private volatile boolean changingBuilderList = false;
    private static final String HELP_CTX_KEY = "ProjectSelectRootMethodsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProjectSelectRootMethodsPanel.HelpCtx");
    private static final String PROP_PROJECTLIST = "projectList";
    private static final String PROPS_FILE_NAME = "root_selector.properties";

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static synchronized ProjectSelectRootMethodsPanel getDefault() {
        if (instance == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    instance = new ProjectSelectRootMethodsPanel();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    runnable.run();
                }
            }
        }
        return instance;
    }

    private ProjectSelectRootMethodsPanel() {
        this.initComponents(this);
    }

    public static boolean canBeShown(Lookup lookup) {
        return RootSelectorTree.canBeShown((Lookup)lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getRootMethods(Lookup.Provider provider, final ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        if (provider == null) {
            return RootMethodsPanel.getSelectedRootMethods(sourceCodeSelectionArray, provider);
        }
        this.currentProject = provider;
        this.unpersist();
        this.pkgTreeView.reset();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProjectSelectRootMethodsPanel.this.refreshBuilderList();
            }
        };
        try {
            this.pkgTreeView.addPropertyChangeListener("SELECTION_TREE_VIEW_LIST", propertyChangeListener);
            this.updateSelector(new Runnable(){

                @Override
                public void run() {
                    ProjectSelectRootMethodsPanel.this.pkgTreeView.setSelection(sourceCodeSelectionArray, ProjectSelectRootMethodsPanel.this.getContext());
                }
            });
            if (this.pkgTreeView.getBuilderTypes().isEmpty()) {
                LOG.fine(Bundle.SelectRootMethodsPanel_NoSelectionProviders_MSG());
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray2 = RootMethodsPanel.getSelectedRootMethods(sourceCodeSelectionArray, provider);
                return sourceCodeSelectionArray2;
            }
            final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, Bundle.SelectRootMethodsPanel_Title(), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
            Object[] objectArray = this.getAdditionalOptions();
            if (objectArray != null && objectArray.length > 0) {
                dialogDescriptor.setAdditionalOptions(objectArray);
            }
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            Cancellable cancellable = new Cancellable(){

                public boolean cancel() {
                    dialogDescriptor.setValue(DialogDescriptor.CANCEL_OPTION);
                    dialog.setVisible(false);
                    ProjectSelectRootMethodsPanel.this.pkgTreeView.setCancelHandler(null);
                    return true;
                }
            };
            this.pkgTreeView.setCancelHandler(cancellable);
            dialog.pack();
            dialog.setVisible(true);
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray3 = this.pkgTreeView.getSelection();
            if (dialogDescriptor.getValue().equals(this.okButton)) {
                this.persist();
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray4 = sourceCodeSelectionArray3;
                return sourceCodeSelectionArray4;
            }
            this.currentProject = null;
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray5 = null;
            return sourceCodeSelectionArray5;
        }
        finally {
            this.pkgTreeView.removePropertyChangeListener("SELECTION_TREE_VIEW_LIST", propertyChangeListener);
        }
    }

    protected void initComponents(Container container) {
        this.additionalProjectsSelector = new JButton(Bundle.LBL_EditProjects());
        Mnemonics.setLocalizedText((AbstractButton)this.additionalProjectsSelector, (String)Bundle.LBL_EditProjects());
        this.okButton = new JButton(Bundle.SelectRootMethodsPanel_OkButtonText());
        ProfilerProgressDisplayer profilerProgressDisplayer = ProfilerProgressDisplayer.getDefault();
        this.pkgTreeView = new RootSelectorTree((ProgressDisplayer)profilerProgressDisplayer, new TreePathSearch.ClassIndex(){

            public List<SourceClassInfo> getClasses(String string, Lookup lookup) {
                Lookup.Provider provider = (Lookup.Provider)lookup.lookup(Lookup.Provider.class);
                if (provider != null) {
                    ArrayList<SourceClassInfo> arrayList = new ArrayList<SourceClassInfo>(ProfilerTypeUtils.findClasses((String)string, EnumSet.of(SourcePackageInfo.Scope.SOURCE), (Lookup.Provider)provider));
                    Collections.sort(arrayList, SourceClassInfo.COMPARATOR);
                    if (!Boolean.getBoolean("profiler.roots.hide.libraries")) {
                        ArrayList arrayList2 = new ArrayList(ProfilerTypeUtils.findClasses((String)string, EnumSet.of(SourcePackageInfo.Scope.DEPENDENCIES), (Lookup.Provider)provider));
                        Collections.sort(arrayList2, SourceClassInfo.COMPARATOR);
                        arrayList.addAll(arrayList2);
                    }
                    return arrayList;
                }
                return Collections.EMPTY_LIST;
            }
        });
        this.additionalProjectsSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectSelectorPanel projectSelectorPanel = new ProjectSelectorPanel(){

                    @Override
                    protected Lookup.Provider getCurrentProject() {
                        return ProjectSelectRootMethodsPanel.this.currentProject;
                    }
                };
                projectSelectorPanel.setSelection(ProjectSelectRootMethodsPanel.this.additionalProjects);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)projectSelectorPanel, Bundle.TIT_EditProjects());
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    ProjectSelectRootMethodsPanel.this.additionalProjects = projectSelectorPanel.getSelection();
                    ProjectSelectRootMethodsPanel.this.updateSelectorProjects();
                }
            }
        });
        this.treeBuilderList = new JComboBox();
        this.treeBuilderList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(final ItemEvent itemEvent) {
                if (ProjectSelectRootMethodsPanel.this.changingBuilderList) {
                    return;
                }
                if (itemEvent.getStateChange() == 1) {
                    ProjectSelectRootMethodsPanel.this.rp.post(new Runnable(){

                        @Override
                        public void run() {
                            ProjectSelectRootMethodsPanel.this.pkgTreeView.setBuilderType((SelectionTreeBuilderType)itemEvent.getItem());
                        }
                    });
                }
            }
        });
        container.setLayout(new GridBagLayout());
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.pkgTreeView.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.pkgTreeView.setPreferredSize(PREFERRED_TOPTREE_DIMENSION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 10, 0, 10);
        container.add((Component)this.pkgTreeView, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.SelectRootMethodsPanel_SelectViewLabel());
        jLabel.setLabelFor(this.treeBuilderList);
        jPanel.add(jLabel);
        jPanel.add(this.treeBuilderList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        container.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        container.add((Component)this.additionalProjectsSelector, gridBagConstraints);
        String string = this.getHintString();
        if (string != null && string.length() > 0) {
            Color color = UIManager.getColor("Panel.background");
            Color color2 = UIUtils.getSafeColor((int)(color.getRed() - 10), (int)(color.getGreen() - 10), (int)(color.getBlue() - 10));
            this.hintArea.setText(string);
            this.hintArea.setEnabled(false);
            this.hintArea.setDisabledTextColor(Color.darkGray);
            this.hintArea.setBackground(color2);
            this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, color2));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            container.add((Component)this.hintArea, gridBagConstraints);
        }
    }

    private Object[] getAdditionalOptions() {
        JButton jButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        final ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = RootMethodsPanel.getSelectedRootMethods(ProjectSelectRootMethodsPanel.this.pkgTreeView.getSelection(), ProjectSelectRootMethodsPanel.this.currentProject);
                        if (sourceCodeSelectionArray != null) {
                            ProjectSelectRootMethodsPanel.this.updateSelector(new Runnable(){

                                @Override
                                public void run() {
                                    ProjectSelectRootMethodsPanel.this.pkgTreeView.setSelection(sourceCodeSelectionArray, ProjectSelectRootMethodsPanel.this.getContext());
                                }
                            });
                        }
                    }
                });
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Bundle.SelectRootMethodsPanel_AdvancedButtonText());
        return new Object[]{jButton};
    }

    private String getHintString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBuilderList() {
        List list = this.pkgTreeView.getBuilderTypes();
        if (list == null || list.isEmpty()) {
            return;
        }
        try {
            this.changingBuilderList = true;
            this.treeBuilderList.setModel(new DefaultComboBoxModel<SelectionTreeBuilderType>(list.toArray(new SelectionTreeBuilderType[list.size()])));
            this.treeBuilderList.setSelectedIndex(0);
            this.pkgTreeView.setBuilderType((SelectionTreeBuilderType)this.treeBuilderList.getItemAt(0));
        }
        finally {
            this.changingBuilderList = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector(Runnable runnable) {
        try {
            this.setUIEnabled(false);
            runnable.run();
        }
        finally {
            this.setUIEnabled(true);
        }
    }

    private void setUIEnabled(final boolean bl) {
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectSelectRootMethodsPanel.this.treeBuilderList.setEnabled(bl);
                ProjectSelectRootMethodsPanel.this.pkgTreeView.setEnabled(bl);
                ProjectSelectRootMethodsPanel.this.okButton.setEnabled(bl);
            }
        });
    }

    private void updateSelectorProjects() {
        this.updateSelector(new Runnable(){

            @Override
            public void run() {
                ProjectSelectRootMethodsPanel.this.pkgTreeView.setContext(ProjectSelectRootMethodsPanel.this.getContext());
            }
        });
    }

    private Lookup getContext() {
        ArrayList arrayList = new ArrayList();
        if (this.currentProject != null) {
            arrayList.addAll(SelectionTreeBuilderFactory.buildersFor((Lookup.Provider)this.currentProject));
        }
        for (Lookup.Provider provider : this.additionalProjects) {
            arrayList.addAll(SelectionTreeBuilderFactory.buildersFor((Lookup.Provider)provider));
        }
        return Lookups.fixed((Object[])arrayList.toArray(new SelectionTreeBuilder[arrayList.size()]));
    }

    private void persist() {
        Properties properties = this.loadProjectProperties();
        if (properties != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Lookup.Provider provider : this.additionalProjects) {
                stringBuilder.append(ProjectUtilities.getProjectDirectory((Lookup.Provider)provider).getPath()).append(File.pathSeparator);
            }
            properties.setProperty(PROP_PROJECTLIST, stringBuilder.toString());
            this.saveProjectProperties(properties);
            this.additionalProjects.clear();
        }
    }

    private void unpersist() {
        Properties properties = this.loadProjectProperties();
        if (properties != null) {
            this.additionalProjects.clear();
            String string = properties.getProperty(PROP_PROJECTLIST, "");
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                FileObject fileObject = FileUtil.toFileObject((File)new File(string2));
                Lookup.Provider provider = ProjectUtilities.getProject((FileObject)fileObject);
                this.additionalProjects.add(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProjectProperties() {
        InputStream inputStream = null;
        try {
            Properties properties = new Properties();
            inputStream = this.getProjectPropertiesFile().getInputStream();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProjectProperties(Properties properties) {
        OutputStream outputStream = null;
        try {
            outputStream = this.getProjectPropertiesFile().getOutputStream();
            properties.store(outputStream, "");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private FileObject getProjectPropertiesFile() throws IOException {
        FileObject fileObject = ProjectStorage.getSettingsFolder((Lookup.Provider)this.currentProject, (boolean)true);
        FileObject fileObject2 = fileObject.getFileObject(PROPS_FILE_NAME);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createData(PROPS_FILE_NAME);
        }
        return fileObject2;
    }
}

