/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.nativeaccess;

import com.sun.jna.platform.WindowUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;
import org.openide.util.Utilities;

public class NativeWindowSystemImpl
extends NativeWindowSystem {
    private static final Logger LOG = Logger.getLogger(NativeWindowSystemImpl.class.getName());

    public boolean isWindowAlphaSupported() {
        String string;
        if (Utilities.isMac() && null != (string = System.getProperty("java.version")) && string.startsWith("1.7")) {
            return false;
        }
        boolean bl = false;
        try {
            bl = WindowUtils.isWindowAlphaSupported();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            LOG.log(Level.FINE, null, unsatisfiedLinkError);
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, null, throwable);
        }
        return bl;
    }

    public void setWindowAlpha(Window window, float f) {
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        if (graphicsConfiguration.getDevice().getFullScreenWindow() != window && NativeWindowSystemImpl.isUndecorated(window) && graphicsDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            try {
                window.setOpacity(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            WindowUtils.setWindowAlpha((Window)window, (float)f);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, null, throwable);
        }
    }

    private static boolean isUndecorated(Window window) {
        if (window instanceof Dialog) {
            return ((Dialog)window).isUndecorated();
        }
        if (window instanceof Frame) {
            return ((Frame)window).isUndecorated();
        }
        return true;
    }

    public void setWindowMask(Window window, Shape shape) {
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        if (graphicsConfiguration.getDevice().getFullScreenWindow() != window && graphicsDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            try {
                window.setShape(shape);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setWindowMask(Window window, Icon icon) {
        try {
            WindowUtils.setWindowMask((Window)window, (Icon)icon);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, null, throwable);
        }
    }

    public boolean isUndecoratedWindowAlphaSupported() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return graphicsConfiguration.getDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
    }
}

