/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u001a\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a(\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0001\u001a-\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00032\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017H\u0082\b\u001a\\\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u001a\b\u0002\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0\u00172\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE", "", "MAX_PORT_NUMBER", "", "getMAX_PORT_NUMBER", "()I", "ORPHANED_RUN_FILE_AGE_THRESHOLD_MS", "", "validFlagFileKeywordChars", "makeAutodeletingFlagFile", "Ljava/io/File;", "keyword", "baseDir", "makePortFromRunFilenameExtractor", "Lkotlin/Function1;", "digest", "makeRunFilenameString", "timestamp", "port", "escapeSequence", "tryConnectToDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "", "walkDaemons", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/daemon/common/DaemonWithMetadata;", "registryDir", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "fileToCompareTimestamp", "filter", "", "daemon-common"})
public final class ClientUtilsKt {
    private static final int MAX_PORT_NUMBER = 65535;
    @NotNull
    public static final String LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE = "Assuming other daemons have";

    public static final int getMAX_PORT_NUMBER() {
        return MAX_PORT_NUMBER;
    }

    @NotNull
    public static final String makeRunFilenameString(@NotNull String timestamp, @NotNull String digest, @NotNull String port, @NotNull String escapeSequence) {
        Intrinsics.checkParameterIsNotNull(timestamp, "timestamp");
        Intrinsics.checkParameterIsNotNull(digest, "digest");
        Intrinsics.checkParameterIsNotNull(port, "port");
        Intrinsics.checkParameterIsNotNull(escapeSequence, "escapeSequence");
        return "" + DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + "" + escapeSequence + '.' + timestamp + "" + escapeSequence + '.' + digest + "" + escapeSequence + '.' + port + "" + escapeSequence + ".run";
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String makeRunFilenameString$default(String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "";
        }
        return ClientUtilsKt.makeRunFilenameString(string, string2, string3, string4);
    }

    @NotNull
    public static final Function1<String, Integer> makePortFromRunFilenameExtractor(@NotNull String digest) {
        Intrinsics.checkParameterIsNotNull(digest, "digest");
        String string = ClientUtilsKt.makeRunFilenameString("[0-9TZ:\\.\\+-]+", digest, "(\\d+)", "\\");
        Regex regex = new Regex(string);
        return new Function1<String, Integer>(regex){
            final /* synthetic */ Regex $regex;

            @Nullable
            public final Integer invoke(@NotNull String it) {
                Integer n;
                Intrinsics.checkParameterIsNotNull(it, "it");
                Object object = Regex.find$default(this.$regex, it, 0, 2, null);
                if (object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = ((MatchGroup)object).getValue()) != null) {
                    Object object2 = object;
                    n = Integer.parseInt((String)object2);
                } else {
                    n = null;
                }
                return n;
            }
            {
                this.$regex = regex;
                super(1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<DaemonWithMetadata> walkDaemons(@NotNull File registryDir, @NotNull CompilerId compilerId, @NotNull File fileToCompareTimestamp, @NotNull Function2<? super File, ? super Integer, Boolean> filter2, @NotNull Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(registryDir, "registryDir");
        Intrinsics.checkParameterIsNotNull(compilerId, "compilerId");
        Intrinsics.checkParameterIsNotNull(fileToCompareTimestamp, "fileToCompareTimestamp");
        Intrinsics.checkParameterIsNotNull(filter2, "filter");
        Intrinsics.checkParameterIsNotNull(report2, "report");
        Iterable iterable = $receiver$iv = (Iterable)compilerId.getCompilerClasspath();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = new File((String)it).getAbsolutePath();
            collection.add(string2);
        }
        String classPathDigest = DaemonParamsKt.toHexString(DaemonParamsKt.distinctStringsDigest((List)destination$iv$iv));
        Function1<String, Integer> portExtractor = ClientUtilsKt.makePortFromRunFilenameExtractor(classPathDigest);
        return SequencesKt.mapNotNull(SequencesKt.filter(SequencesKt.map(FilesKt.walk$default(registryDir, null, 1, null), (Function1)new Function1<File, Pair<? extends File, ? extends Integer>>(portExtractor){
            final /* synthetic */ Function1 $portExtractor;

            @NotNull
            public final Pair<File, Integer> invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                String string = it.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.name");
                return new Pair<File, Integer>(it, (Integer)this.$portExtractor.invoke(string));
            }
            {
                this.$portExtractor = function1;
                super(1);
            }
        }), (Function1)new Function1<Pair<? extends File, ? extends Integer>, Boolean>(filter2){
            final /* synthetic */ Function2 $filter;

            public final boolean invoke(@NotNull Pair<? extends File, Integer> $file_port) {
                Intrinsics.checkParameterIsNotNull($file_port, "<name for destructuring parameter 0>");
                File file2 = $file_port.component1();
                Integer port = $file_port.component2();
                return port != null && (Boolean)this.$filter.invoke(file2, port) != false;
            }
            {
                this.$filter = function2;
                super(1);
            }
        }), (Function1)new Function1<Pair<? extends File, ? extends Integer>, DaemonWithMetadata>(fileToCompareTimestamp, report2){
            final /* synthetic */ File $fileToCompareTimestamp;
            final /* synthetic */ Function2 $report;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final DaemonWithMetadata invoke(@NotNull Pair<? extends File, Integer> $file_port) {
                CompileService compileService;
                CompileService daemon;
                long relativeAge;
                File file2;
                block17: {
                    CompileService compileService2;
                    block16: {
                        int n;
                        Intrinsics.checkParameterIsNotNull($file_port, "<name for destructuring parameter 0>");
                        file2 = $file_port.component1();
                        Integer port = $file_port.component2();
                        int n2 = ClientUtilsKt.getMAX_PORT_NUMBER() - 1;
                        Integer n3 = port;
                        if (n3 == null) {
                            Intrinsics.throwNpe();
                        }
                        int n4 = n = 1 <= (n = n3.intValue()) && n2 >= n ? 1 : 0;
                        if (_Assertions.ENABLED && n == 0) {
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        relativeAge = this.$fileToCompareTimestamp.lastModified() - file2.lastModified();
                        this.$report.invoke(DaemonReportCategory.DEBUG, "found daemon on port " + port + " (" + relativeAge + " ms old), trying to connect");
                        int n5 = port;
                        Function2 report$iv = this.$report;
                        try {
                            Remote daemon$iv;
                            void port$iv;
                            Registry registry = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), (int)port$iv, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
                            Remote remote = daemon$iv = registry != null ? registry.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
                            if (remote == null) {
                                report$iv.invoke(DaemonReportCategory.INFO, "daemon not found");
                                break block16;
                            }
                            if (remote instanceof CompileService) {
                                compileService2 = (CompileService)daemon$iv;
                                break block17;
                            }
                            report$iv.invoke(DaemonReportCategory.INFO, "Unable to cast compiler service, actual class received: " + daemon$iv.getClass().getName());
                        }
                        catch (Throwable e$iv) {
                            Object object;
                            StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
                            Object object2 = e$iv.getCause();
                            if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                                object2 = object = e$iv.getMessage();
                            }
                            if (object2 == null) {
                                object = "unknown error";
                            }
                            report$iv.invoke(DaemonReportCategory.INFO, stringBuilder.append(object).toString());
                        }
                    }
                    compileService2 = daemon = null;
                }
                if (daemon == null) {
                    if (relativeAge - 1000000L <= 0L) {
                        this.$report.invoke(DaemonReportCategory.DEBUG, "found fresh run file '" + file2.getAbsolutePath() + "' (" + relativeAge + " ms old), but no daemon, ignoring it");
                    } else {
                        this.$report.invoke(DaemonReportCategory.DEBUG, "found seemingly orphaned run file '" + file2.getAbsolutePath() + "' (" + relativeAge + " ms old), deleting it");
                        if (!file2.delete()) {
                            this.$report.invoke(DaemonReportCategory.INFO, "WARNING: unable to delete seemingly orphaned file '" + file2.getAbsolutePath() + "', cleanup recommended");
                        }
                    }
                }
                try {
                    DaemonWithMetadata daemonWithMetadata;
                    CompileService compileService3 = daemon;
                    if (compileService3 != null) {
                        CompileService it = compileService = compileService3;
                        daemonWithMetadata = new DaemonWithMetadata(it, file2, it.getDaemonJVMOptions().get());
                    } else {
                        daemonWithMetadata = null;
                    }
                    compileService = daemonWithMetadata;
                }
                catch (Exception e) {
                    this.$report.invoke(DaemonReportCategory.INFO, "ERROR: unable to retrieve daemon JVM options, assuming daemon is dead: " + e.getMessage());
                    compileService = null;
                }
                return compileService;
            }
            {
                this.$fileToCompareTimestamp = file2;
                this.$report = function2;
                super(1);
            }
        });
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Sequence walkDaemons$default(File file2, CompilerId compilerId, File file3, Function2 function2, Function2 function22, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = walkDaemons.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function22 = walkDaemons.2.INSTANCE;
        }
        return ClientUtilsKt.walkDaemons(file2, compilerId, file3, function2, function22);
    }

    private static final CompileService tryConnectToDaemon(int port, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        try {
            Remote daemon;
            Registry registry = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
            Remote remote = daemon = registry != null ? registry.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
            if (remote == null) {
                report2.invoke(DaemonReportCategory.INFO, "daemon not found");
            } else {
                if (remote instanceof CompileService) {
                    return (CompileService)daemon;
                }
                report2.invoke(DaemonReportCategory.INFO, "Unable to cast compiler service, actual class received: " + daemon.getClass().getName());
            }
        }
        catch (Throwable e) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
            Object object2 = e.getCause();
            if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                object2 = object = e.getMessage();
            }
            if (object2 == null) {
                object = "unknown error";
            }
            report2.invoke(DaemonReportCategory.INFO, stringBuilder.append(object).toString());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File makeAutodeletingFlagFile(@NotNull String keyword, @Nullable File baseDir) {
        Object object;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(keyword, "keyword");
        Object object2 = keyword;
        CharSequence charSequence = new StringBuilder().append("kotlin-");
        CharSequence charSequence2 = (CharSequence)$receiver$iv;
        Appendable destination$iv$iv = new StringBuilder();
        int n = 0;
        int n2 = $receiver$iv$iv.length() - 1;
        if (n <= n2) {
            while (true) {
                void index$iv$iv;
                char element$iv$iv;
                char it;
                char c;
                char c2;
                CharSequence charSequence3;
                if (StringsKt.contains$default(charSequence3 = (CharSequence)"abcdefghijklmnopqrstuvwxyz0123456789-_", c2 = Character.toLowerCase(c = (it = (element$iv$iv = $receiver$iv$iv.charAt((int)index$iv$iv)))), false, 2, null)) {
                    destination$iv$iv.append(element$iv$iv);
                }
                if (index$iv$iv == n2) break;
                ++index$iv$iv;
            }
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "filterTo(StringBuilder(), predicate).toString()");
        String string2 = string;
        CharSequence charSequence4 = charSequence.append(string2).append('-').toString();
        String string3 = "-is-running";
        File file2 = baseDir;
        if (file2 != null) {
            object2 = file2;
            string2 = string3;
            charSequence = charSequence4;
            Object it = object2;
            Object object3 = ((File)it).isDirectory() && ((File)it).exists() ? object2 : null;
            charSequence4 = charSequence;
            string3 = string2;
            object = object3;
        } else {
            object = null;
        }
        File flagFile = File.createTempFile(charSequence4, string3, object);
        flagFile.deleteOnExit();
        File file3 = flagFile;
        Intrinsics.checkExpressionValueIsNotNull(file3, "flagFile");
        return file3;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ File makeAutodeletingFlagFile$default(String string, File file2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "compiler-client";
        }
        if ((n & 2) != 0) {
            file2 = null;
        }
        return ClientUtilsKt.makeAutodeletingFlagFile(string, file2);
    }

    static {
        MAX_PORT_NUMBER = 65535;
    }

    @Nullable
    public static final /* synthetic */ CompileService access$tryConnectToDaemon(int port, @NotNull Function2 report2) {
        return ClientUtilsKt.tryConnectToDaemon(port, report2);
    }
}

