/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeprecationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J(\u0010\u0014\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001bH\u0002J(\u0010\u001c\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001bH\u0002J4\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001b\"\b\b\u0000\u0010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J@\u0010&\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u00172\u000e\u0010'\u001a\n\u0012\u0004\u0012\u0002H\u0016\u0018\u00010(2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0002J6\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010.2\b\u00100\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u00020\"2\u0006\u00102\u001a\u0002032\u0006\u0010+\u001a\u00020,H\u0002J,\u00104\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u0017*\b\u0012\u0004\u0012\u0002H\u00160(2\u0006\u00105\u001a\u00020.2\u0006\u0010+\u001a\u00020,H\u0002J,\u00106\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u0017*\b\u0012\u0004\u0012\u0002H\u00160(2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u00107\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030(2\u0006\u00108\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "candidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "callCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/DeprecationResolver;", "effectSystem", "Lorg/jetbrains/kotlin/contracts/EffectSystem;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/DeprecationResolver;Lorg/jetbrains/kotlin/contracts/EffectSystem;)V", "completeAllCandidates", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "completeArguments", "completeCall", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "completeCallForArgument", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "completeOneArgument", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "completeResolvedCallAndArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "hasNecessarySafeCall", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "updateRecordedTypeForArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "updatedType", "recordedType", "argumentExpression", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "completeConstraintSystem", "expectedType", "updateResolutionStatusFromConstraintSystem", "updateResultDataFlowInfoUsingEffects", "bindingTrace", "frontend"})
public final class CallCompleter {
    private final ArgumentTypeResolver argumentTypeResolver;
    private final CandidateResolver candidateResolver;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final Iterable<CallChecker> callCheckers;
    private final KotlinBuiltIns builtIns;
    private final LanguageVersionSettings languageVersionSettings;
    private final DeprecationResolver deprecationResolver;
    private final EffectSystem effectSystem;

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(results, "results");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        ResolvedCall resolvedCall2 = results.isSingleResult() ? results.getResultingCall() : null;
        Call call2 = context.call;
        Intrinsics.checkExpressionValueIsNotNull(call2, "context.call");
        if (!CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall2, results, context, tracing);
            this.completeAllCandidates(context, results);
        }
        if (resolvedCall2 != null && context.trace.wantsDiagnostics()) {
            KtElement ktElement;
            KtExpression calleeExpression;
            KtExpression ktExpression;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                Call call3 = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCall();
                Intrinsics.checkExpressionValueIsNotNull(call3, "resolvedCall.variableCall.call");
                ktExpression = call3.getCalleeExpression();
            } else {
                Call call4 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull(call4, "resolvedCall.call");
                ktExpression = calleeExpression = call4.getCalleeExpression();
            }
            if (calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression)) {
                ktElement = calleeExpression;
            } else {
                Call call5 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull(call5, "resolvedCall.call");
                ktElement = call5.getCallElement();
            }
            KtElement reportOn = ktElement;
            CallCheckerContext callCheckerContext = new CallCheckerContext(context, this.languageVersionSettings, this.deprecationResolver);
            for (CallChecker callChecker : this.callCheckers) {
                KtElement ktElement2 = reportOn;
                Intrinsics.checkExpressionValueIsNotNull(ktElement2, "reportOn");
                callChecker.check(resolvedCall2, ktElement2, callCheckerContext);
                if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall)) continue;
                callChecker.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), reportOn, callCheckerContext);
            }
        }
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall3 = results.getResultingCall();
            Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "results.resultingCall");
            ResolutionStatus resolutionStatus = resolvedCall3.getStatus();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "results.resultingCall.status");
            if (resolutionStatus.isSuccess()) {
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
                Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResultsImpl, "results.changeStatusToSuccess()");
                return overloadResolutionResultsImpl;
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeAllCandidates(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        void $receiver$iv$iv;
        Collection<ResolvedCall<D>> collection;
        if (context.collectAllCandidates) {
            Collection<ResolvedCall<D>> collection2 = results.getAllCandidates();
            if (collection2 == null) {
                Intrinsics.throwNpe();
            }
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "results.allCandidates!!");
        } else {
            Collection<MutableResolvedCall<D>> collection3 = results.getResultingCalls();
            collection = collection3;
            Intrinsics.checkExpressionValueIsNotNull(collection3, "results.resultingCalls");
        }
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall<D>>");
        }
        Collection<ResolvedCall<D>> candidates2 = collection;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "Trace to complete a candidate that is not a resulting call");
        Iterable $receiver$iv = candidates2;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            MutableResolvedCall resolvedCall2 = (MutableResolvedCall)element$iv$iv;
            if (resolvedCall2.isCompleted()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            MutableResolvedCall resolvedCall3 = (MutableResolvedCall)element$iv;
            Object Context2 = context.replaceBindingTrace(temporaryBindingTrace);
            Intrinsics.checkExpressionValueIsNotNull(Context2, "context.replaceBindingTrace(temporaryBindingTrace)");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)Context2;
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull(tracingStrategy, "TracingStrategy.EMPTY");
            this.completeResolvedCallAndArguments(resolvedCall3, results, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(MutableResolvedCall<D> resolvedCall2, OverloadResolutionResultsImpl<D> results, BasicCallResolutionContext context, TracingStrategy tracing) {
        if (resolvedCall2 == null || resolvedCall2.isCompleted() || resolvedCall2.getConstraintSystem() == null) {
            this.completeArguments(context, results);
            MutableResolvedCall<D> mutableResolvedCall = resolvedCall2;
            if (mutableResolvedCall != null) {
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                this.updateResultDataFlowInfoUsingEffects(mutableResolvedCall, bindingTrace);
            }
            MutableResolvedCall<D> mutableResolvedCall2 = resolvedCall2;
            if (mutableResolvedCall2 != null) {
                mutableResolvedCall2.markCallAsCompleted();
            }
            return;
        }
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        this.completeConstraintSystem(resolvedCall2, kotlinType, bindingTrace);
        this.completeArguments(context, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall2, context, tracing);
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        this.updateResultDataFlowInfoUsingEffects(resolvedCall2, bindingTrace2);
        resolvedCall2.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(@NotNull MutableResolvedCall<D> $receiver, KotlinType expectedType2, BindingTrace trace) {
        KotlinType kotlinType;
        Object d = $receiver.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "candidateDescriptor");
        KotlinType returnType = d.getReturnType();
        Call call2 = $receiver.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "call");
        if (CallUtilKt.isCallableReference(call2)) {
            if (!TypeUtils.noExpectedType(expectedType2) && FunctionTypesKt.isFunctionType(expectedType2)) {
                kotlinType = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType2);
            } else {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "TypeUtils.NO_EXPECTED_TYPE");
                kotlinType = simpleType2;
            }
        } else {
            kotlinType = expectedType2;
        }
        KotlinType expectedReturnType = kotlinType;
        Function2<ConstraintSystem.Builder, KotlinType, KotlinType> typeInSystem$ = new Function2<ConstraintSystem.Builder, KotlinType, KotlinType>($receiver){
            final /* synthetic */ MutableResolvedCall receiver$0;

            @Nullable
            public final KotlinType invoke(@NotNull ConstraintSystem.Builder $receiver, @Nullable KotlinType type2) {
                KotlinType kotlinType;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                KotlinType kotlinType2 = type2;
                if (kotlinType2 != null) {
                    KotlinType kotlinType3;
                    KotlinType it = kotlinType3 = kotlinType2;
                    Map<CallHandle, TypeSubstitutor> map2 = $receiver.getTypeVariableSubstitutors();
                    Call call2 = this.receiver$0.getCall();
                    Intrinsics.checkExpressionValueIsNotNull(call2, "call");
                    TypeSubstitutor typeSubstitutor2 = map2.get(TypeVariableKt.toHandle(call2));
                    if (typeSubstitutor2 == null) {
                        String string = "No substitutor for call: " + this.receiver$0.getCall();
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    TypeSubstitutor substitutor2 = typeSubstitutor2;
                    kotlinType = substitutor2.substitute(it, Variance.INVARIANT);
                } else {
                    kotlinType = null;
                }
                return kotlinType;
            }
            {
                this.receiver$0 = mutableResolvedCall;
                super(2);
            }
        };
        Function1<Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>, Unit> updateSystemIfNeeded$ = new Function1<Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>, Unit>($receiver){
            final /* synthetic */ MutableResolvedCall receiver$0;

            public final void invoke(@NotNull Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem> buildSystemWithAdditionalConstraints) {
                ConstraintSystem system;
                Intrinsics.checkParameterIsNotNull(buildSystemWithAdditionalConstraints, "buildSystemWithAdditionalConstraints");
                ConstraintSystem constraintSystem = this.receiver$0.getConstraintSystem();
                if (constraintSystem == null) {
                    Intrinsics.throwNpe();
                }
                if ((system = buildSystemWithAdditionalConstraints.invoke(ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem, null, 1, null))) != null) {
                    this.receiver$0.setConstraintSystem(system);
                }
            }
            {
                this.receiver$0 = mutableResolvedCall;
                super(1);
            }
        };
        if (returnType != null && !TypeUtils.noExpectedType(expectedReturnType)) {
            updateSystemIfNeeded$.invoke((Function1<ConstraintSystem.Builder, ConstraintSystem>)((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>(typeInSystem$, returnType, expectedReturnType){
                final /* synthetic */ completeConstraintSystem.1 $typeInSystem$1;
                final /* synthetic */ KotlinType $returnType;
                final /* synthetic */ KotlinType $expectedReturnType;

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkParameterIsNotNull(builder, "builder");
                    KotlinType returnTypeInSystem = this.$typeInSystem$1.invoke(builder, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder.addSubtypeConstraint(returnTypeInSystem, this.$expectedReturnType, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        constraintSystem = builder.build();
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
                {
                    this.$typeInSystem$1 = var1_1;
                    this.$returnType = kotlinType;
                    this.$expectedReturnType = kotlinType2;
                    super(1);
                }
            }));
        }
        ReadOnlySlice readOnlySlice = BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
        Call call3 = $receiver.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call3, "call");
        ConstraintSystemCompleter constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(readOnlySlice, call3.getCalleeExpression());
        if (constraintSystemCompleter != null) {
            updateSystemIfNeeded$.invoke((Function1<ConstraintSystem.Builder, ConstraintSystem>)((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>($receiver, constraintSystemCompleter){
                final /* synthetic */ MutableResolvedCall receiver$0;
                final /* synthetic */ ConstraintSystemCompleter $constraintSystemCompleter;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    void var2_2;
                    Intrinsics.checkParameterIsNotNull(builder, "builder");
                    this.$constraintSystemCompleter.completeConstraintSystem(builder, this.receiver$0);
                    ConstraintSystem system = builder.build();
                    ConstraintSystemStatus status2 = ConstraintSystemUtilsKt.filterConstraintsOut(system, ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus();
                    return status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.FROM_COMPLETER) ? null : var2_2;
                }
                {
                    this.receiver$0 = mutableResolvedCall;
                    this.$constraintSystemCompleter = constraintSystemCompleter;
                    super(1);
                }
            }));
        }
        if (returnType != null && expectedReturnType == TypeUtils.UNIT_EXPECTED_TYPE) {
            updateSystemIfNeeded$.invoke((Function1<ConstraintSystem.Builder, ConstraintSystem>)((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>(this, typeInSystem$, returnType){
                final /* synthetic */ CallCompleter this$0;
                final /* synthetic */ completeConstraintSystem.1 $typeInSystem$1;
                final /* synthetic */ KotlinType $returnType;

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkParameterIsNotNull(builder, "builder");
                    KotlinType returnTypeInSystem = this.$typeInSystem$1.invoke(builder, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder.addSubtypeConstraint(returnTypeInSystem, CallCompleter.access$getBuiltIns$p(this.this$0).getUnitType(), ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        ConstraintSystem system = builder.build();
                        constraintSystem = system.getStatus().isSuccessful() ? system : null;
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
                {
                    this.this$0 = callCompleter;
                    this.$typeInSystem$1 = var2_2;
                    this.$returnType = kotlinType;
                    super(1);
                }
            }));
        }
        Call call4 = $receiver.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call4, "call");
        if (CallUtilKt.isCallableReference(call4) && !TypeUtils.noExpectedType(expectedType2) && FunctionTypesKt.isFunctionType(expectedType2)) {
            updateSystemIfNeeded$.invoke((Function1<ConstraintSystem.Builder, ConstraintSystem>)((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>($receiver, expectedType2, typeInSystem$){
                final /* synthetic */ MutableResolvedCall receiver$0;
                final /* synthetic */ KotlinType $expectedType;
                final /* synthetic */ completeConstraintSystem.1 $typeInSystem$1;

                @NotNull
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    Intrinsics.checkParameterIsNotNull(builder, "builder");
                    D d = this.receiver$0.getCandidateDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull(d, "candidateDescriptor");
                    List<ValueParameterDescriptor> list2 = d.getValueParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "candidateDescriptor.valueParameters");
                    Iterable $receiver$iv = CollectionsKt.zip((Iterable)list2, (Iterable)FunctionTypesKt.getValueParameterTypesFromFunctionType(this.$expectedType));
                    for (T element$iv : $receiver$iv) {
                        Pair $parameter_argument = (Pair)element$iv;
                        ValueParameterDescriptor parameter = (ValueParameterDescriptor)$parameter_argument.component1();
                        TypeProjection argument = (TypeProjection)$parameter_argument.component2();
                        ValueParameterDescriptor valueParameterDescriptor = parameter;
                        Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameter");
                        KotlinType valueParameterInSystem = this.$typeInSystem$1.invoke(builder, valueParameterDescriptor.getType());
                        builder.addSubtypeConstraint(valueParameterInSystem, argument.getType(), ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(parameter.getIndex()));
                    }
                    return builder.build();
                }
                {
                    this.receiver$0 = mutableResolvedCall;
                    this.$expectedType = kotlinType;
                    this.$typeInSystem$1 = var3_3;
                    super(1);
                }
            }));
        }
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        ConstraintSystem.Builder builder = ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem, null, 1, null);
        builder.fixVariables();
        ConstraintSystem system = builder.build();
        $receiver.setConstraintSystem(system);
        $receiver.setResultingSubstitutor(system.getResultingSubstitutor());
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(@NotNull MutableResolvedCall<D> $receiver, BasicCallResolutionContext context, TracingStrategy tracing) {
        CallCandidateResolutionContext<D> contextWithResolvedCall;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = contextWithResolvedCall = CallCandidateResolutionContext.createForCallBeingAnalyzed($receiver, context, tracing);
        Intrinsics.checkExpressionValueIsNotNull(callCandidateResolutionContext, "contextWithResolvedCall");
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(callCandidateResolutionContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus status2 = $receiver.getStatus();
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        if (constraintSystem.getStatus().isSuccessful()) {
            if (Intrinsics.areEqual((Object)status2, (Object)ResolutionStatus.UNKNOWN_STATUS) || Intrinsics.areEqual((Object)status2, (Object)ResolutionStatus.INCOMPLETE_TYPE_INFERENCE)) {
                $receiver.setStatusToSuccess();
            }
            return;
        }
        ReceiverValue receiverValue = $receiver.getExtensionReceiver();
        KotlinType receiverType = receiverValue != null ? receiverValue.getType() : null;
        Object d = $receiver.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        InferenceErrorData errorData = InferenceErrorData.create(d, constraintSystem2, valueArgumentsCheckingResult.getArgumentTypes(), receiverType, context.expectedType, context.call);
        tracing.typeInferenceFailed(context, errorData);
        $receiver.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeArguments(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        Function1 getDataFlowInfoForArgument;
        Function1 getArgumentMapping;
        if (Intrinsics.areEqual((Object)context.checkArguments, (Object)CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) ^ true) {
            return;
        }
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            getArgumentMapping = new Function1<ValueArgument, ArgumentMapping>((MutableResolvedCall)resolvedCall2){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final ArgumentMapping invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull(argument, "argument");
                    ArgumentMapping argumentMapping = this.$resolvedCall.getArgumentMapping(argument);
                    Intrinsics.checkExpressionValueIsNotNull(argumentMapping, "resolvedCall.getArgumentMapping(argument)");
                    return argumentMapping;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
            getDataFlowInfoForArgument = new Function1<ValueArgument, DataFlowInfo>((MutableResolvedCall)resolvedCall2){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull(argument, "argument");
                    MutableResolvedCall mutableResolvedCall = this.$resolvedCall;
                    Intrinsics.checkExpressionValueIsNotNull(mutableResolvedCall, "resolvedCall");
                    DataFlowInfo dataFlowInfo = mutableResolvedCall.getDataFlowInfoForArguments().getInfo(argument);
                    Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "resolvedCall.dataFlowInf\u2026guments.getInfo(argument)");
                    return dataFlowInfo;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
        } else {
            getArgumentMapping = completeArguments.3.INSTANCE;
            getDataFlowInfoForArgument = new Function1<ValueArgument, DataFlowInfo>(context){
                final /* synthetic */ BasicCallResolutionContext $context;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    DataFlowInfo dataFlowInfo = this.$context.dataFlowInfo;
                    Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
                    return dataFlowInfo;
                }
                {
                    this.$context = basicCallResolutionContext;
                    super(1);
                }
            };
        }
        Call call2 = context.call;
        Intrinsics.checkExpressionValueIsNotNull(call2, "context.call");
        Iterator<? extends ValueArgument> iterator2 = call2.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            void expectedType2;
            BasicCallResolutionContext newContext;
            Pair<KotlinType, CallPosition.ValueArgumentPosition> pair;
            ArgumentMapping argumentMapping;
            ArgumentMapping argumentMapping2;
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            if (valueArgument2 == null) {
                Intrinsics.throwNpe();
            }
            if ((argumentMapping2 = (argumentMapping = (ArgumentMapping)getArgumentMapping.invoke(valueArgument2))) instanceof ArgumentMatch) {
                KotlinType kotlinType = CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument, context);
                ResolvedCall resolvedCall3 = results.getResultingCall();
                Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "results.resultingCall");
                pair = new Pair<KotlinType, CallPosition.ValueArgumentPosition>(kotlinType, new CallPosition.ValueArgumentPosition(resolvedCall3, ((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument));
            } else {
                pair = new Pair<SimpleType, CallPosition.Unknown>(TypeUtils.NO_EXPECTED_TYPE, CallPosition.Unknown.INSTANCE);
            }
            Pair<KotlinType, CallPosition.ValueArgumentPosition> pair2 = pair;
            KotlinType kotlinType = (KotlinType)pair2.component1();
            CallPosition callPosition = (CallPosition)pair2.component2();
            BasicCallResolutionContext basicCallResolutionContext = newContext = (BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)context.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke(valueArgument))).replaceExpectedType((KotlinType)expectedType2)).replaceCallPosition(callPosition);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "newContext");
            this.completeOneArgument(valueArgument, basicCallResolutionContext);
        }
    }

    private final void completeOneArgument(ValueArgument valueArgument, BasicCallResolutionContext context) {
        KtExpression ktExpression;
        KotlinType recordedType;
        if (valueArgument.isExternal()) {
            return;
        }
        KtExpression ktExpression2 = valueArgument.getArgumentExpression();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression expression2 = ktExpression2;
        KtExpression ktExpression3 = KtPsiUtil.getLastElementDeparenthesized(expression2, context.statementFilter);
        if (ktExpression3 == null) {
            return;
        }
        KtExpression deparenthesized = ktExpression3;
        KotlinType updatedType = recordedType = context.trace.getType(expression2);
        KtExpression ktExpression4 = deparenthesized;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression4, "deparenthesized");
        OverloadResolutionResultsImpl<?> results = this.completeCallForArgument(ktExpression4, context);
        if (results != null && results.isSingleResult()) {
            KotlinType kotlinType;
            ResolvedCall resolvedCall2 = results.getResultingCall();
            if (resolvedCall2.hasInferredReturnType()) {
                ResolvedCall resolvedCall3 = resolvedCall2;
                Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "resolvedCall");
                Object d = resolvedCall2.getResultingDescriptor();
                kotlinType = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver(resolvedCall3, d != null ? d.getReturnType() : null, context);
            } else {
                kotlinType = updatedType = null;
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable()) {
            KotlinType kotlinType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, expression2);
            if (kotlinType == null) {
                kotlinType = updatedType;
            }
            updatedType = kotlinType;
        }
        StatementFilter statementFilter = context.statementFilter;
        Intrinsics.checkExpressionValueIsNotNull(statementFilter, "context.statementFilter");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, expression2, statementFilter, bindingTrace);
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (ktFunction != null) {
            KtFunction functionLiteralArgument = ktExpression = ktFunction;
            this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context);
        if (ktCallableReferenceExpression != null) {
            KtExpression callableReferenceArgument = ktExpression = ktCallableReferenceExpression;
            this.argumentTypeResolver.getCallableReferenceTypeInfo(expression2, (KtCallableReferenceExpression)callableReferenceArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        this.dataFlowAnalyzer.checkType(updatedType, deparenthesized, (ResolutionContext)context);
    }

    /*
     * WARNING - void declaration
     */
    private final OverloadResolutionResultsImpl<?> completeCallForArgument(KtExpression expression2, BasicCallResolutionContext context) {
        void cachedResolutionResults;
        void cachedContext;
        BasicCallResolutionContext contextForArgument;
        ResolutionResultsCache.CachedData cachedData;
        ResolutionResultsCache.CachedData cachedData2 = GenericCandidateResolverKt.getResolutionResultsCachedData(expression2, context);
        if (cachedData2 == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData3 = cachedData = cachedData2;
        OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = cachedData3.component1();
        BasicCallResolutionContext basicCallResolutionContext = cachedData3.component2();
        TracingStrategy tracing = cachedData3.component3();
        BasicCallResolutionContext basicCallResolutionContext2 = contextForArgument = (BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(context.trace)).replaceExpectedType(context.expectedType)).replaceCollectAllCandidates(false)).replaceCallPosition(context.callPosition);
        Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext2, "contextForArgument");
        return this.completeCall(basicCallResolutionContext2, (OverloadResolutionResultsImpl)cachedResolutionResults, tracing);
    }

    private final KotlinType updateRecordedTypeForArgument(KotlinType updatedType, KotlinType recordedType, KtExpression argumentExpression, StatementFilter statementFilter, BindingTrace trace) {
        if (!ErrorUtils.containsErrorType(recordedType) && Intrinsics.areEqual(recordedType, updatedType) || updatedType == null) {
            return updatedType;
        }
        Function1<KtExpression, KtExpression> deparenthesizeOrGetSelector$ = new Function1<KtExpression, KtExpression>(statementFilter){
            final /* synthetic */ StatementFilter $statementFilter;

            @Nullable
            public final KtExpression invoke(@Nullable KtExpression expression2) {
                KtExpression deparenthesized = KtPsiUtil.deparenthesizeOnce(expression2);
                if (Intrinsics.areEqual(deparenthesized, expression2) ^ true) {
                    return deparenthesized;
                }
                if (expression2 instanceof KtBlockExpression) {
                    return StatementFilterKt.getLastStatementInABlock(this.$statementFilter, (KtBlockExpression)expression2);
                }
                KtExpression ktExpression = expression2;
                if (!(ktExpression instanceof KtQualifiedExpression)) {
                    ktExpression = null;
                }
                KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression;
                return ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
            }
            {
                this.$statementFilter = statementFilter;
                super(1);
            }
        };
        ArrayList<KtExpression> expressions = new ArrayList<KtExpression>();
        KtExpression expression2 = argumentExpression;
        while (expression2 != null) {
            expressions.add(expression2);
            expression2 = deparenthesizeOrGetSelector$.invoke(expression2);
        }
        boolean shouldBeMadeNullable = false;
        Iterable $receiver$iv = CollectionsKt.asReversedMutable((List)expressions);
        for (Object element$iv : $receiver$iv) {
            KtExpression expression3 = (KtExpression)element$iv;
            if (!(expression3 instanceof KtParenthesizedExpression || expression3 instanceof KtLabeledExpression || expression3 instanceof KtAnnotatedExpression)) {
                shouldBeMadeNullable = this.hasNecessarySafeCall(expression3, trace);
            }
            BindingContextUtils.updateRecordedType(updatedType, expression3, trace, shouldBeMadeNullable);
        }
        return trace.getType(argumentExpression);
    }

    private final boolean hasNecessarySafeCall(KtExpression expression2, BindingTrace trace) {
        if (!(expression2 instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        KotlinType expressionType = trace.getType(((KtSafeQualifiedExpression)expression2).getReceiverExpression());
        return expressionType != null && TypeUtils.isNullableType(expressionType);
    }

    private final void updateResultDataFlowInfoUsingEffects(@NotNull MutableResolvedCall<?> $receiver, BindingTrace bindingTrace) {
        if ($receiver.getDataFlowInfoForArguments() instanceof MutableDataFlowInfoForArguments.WithoutArgumentsCheck) {
            return;
        }
        Object d = $receiver.getResultingDescriptor();
        if (d == null || (d = d.getContainingDeclaration()) == null) {
            return;
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(d);
        ResolvedCall resolvedCall2 = $receiver;
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(moduleDescriptor2, "moduleDescriptor");
        DataFlowInfo resultDFIfromES = this.effectSystem.getDataFlowInfoForFinishedCall(resolvedCall2, bindingTrace, moduleDescriptor2);
        $receiver.getDataFlowInfoForArguments().updateResultInfo(resultDFIfromES);
        this.effectSystem.recordDefiniteInvocations((ResolvedCall)$receiver, bindingTrace, moduleDescriptor);
    }

    public CallCompleter(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CandidateResolver candidateResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull Iterable<? extends CallChecker> callCheckers, @NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DeprecationResolver deprecationResolver, @NotNull EffectSystem effectSystem) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(candidateResolver, "candidateResolver");
        Intrinsics.checkParameterIsNotNull(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(callCheckers, "callCheckers");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(deprecationResolver, "deprecationResolver");
        Intrinsics.checkParameterIsNotNull(effectSystem, "effectSystem");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.callCheckers = callCheckers;
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
        this.deprecationResolver = deprecationResolver;
        this.effectSystem = effectSystem;
    }

    @NotNull
    public static final /* synthetic */ KotlinBuiltIns access$getBuiltIns$p(CallCompleter $this) {
        return $this.builtIns;
    }
}

