#include <u.h>
#include <libc.h>
#include <draw.h>
#include <memdraw.h>
#include "a.h"

uchar pjw[] = {
  0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
  0x65, 0x64, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x6b, 0x32, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x34, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x34, 0x38, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x34, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x35, 0x34, 0x31, 0x20, 0x80,
  0xff, 0x20, 0x00, 0x08, 0x00, 0x82, 0xc0, 0x16,
  0x7f, 0x04, 0x06, 0x04, 0x00, 0x83, 0xfc, 0x01,
  0x04, 0x06, 0x04, 0x07, 0x04, 0x00, 0x83, 0xf1,
  0x00, 0x50, 0x11, 0x04, 0x18, 0x04, 0x00, 0x84,
  0xd4, 0x40, 0x48, 0x04, 0x05, 0x00, 0x07, 0x04,
  0x00, 0x87, 0xc1, 0x44, 0x11, 0x04, 0x51, 0xbf,
  0xff, 0xff, 0x04, 0x00, 0x87, 0x16, 0xfe, 0x81,
  0x01, 0x40, 0x5f, 0xff, 0xff, 0x04, 0x00, 0x87,
  0x5f, 0xff, 0xe4, 0x00, 0x40, 0x01, 0x1f, 0xff,
  0x00, 0x00, 0x88, 0xfd, 0x7f, 0xff, 0xfd, 0x11,
  0x11, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x80, 0xe5,
  0x00, 0x03, 0x84, 0x50, 0x04, 0x10, 0x42, 0xff,
  0x00, 0x00, 0x80, 0x97, 0x00, 0x03, 0x84, 0x51,
  0x00, 0x00, 0x07, 0xff, 0x00, 0x00, 0x80, 0x67,
  0x00, 0x03, 0x84, 0xc4, 0x40, 0x41, 0x11, 0x3f,
  0x00, 0x75, 0x80, 0x4f, 0x00, 0x0b, 0x84, 0xd0,
  0x40, 0x00, 0x11, 0x1b, 0x82, 0xff, 0xff, 0xf5,
  0x04, 0x40, 0x84, 0xf0, 0x00, 0x00, 0x04, 0x5f,
  0x82, 0xff, 0xff, 0xe1, 0x04, 0x40, 0x84, 0xf4,
  0x00, 0x00, 0x01, 0x5b, 0x00, 0x1e, 0x80, 0x2f,
  0x04, 0x9e, 0x83, 0x00, 0x00, 0x00, 0x17, 0x82,
  0xff, 0xff, 0x40, 0x04, 0x96, 0x84, 0xfe, 0x40,
  0x00, 0x00, 0x0f, 0x82, 0xff, 0xfd, 0x00, 0x08,
  0xa2, 0x00, 0x0b, 0x80, 0x5f, 0x8b, 0xff, 0xf9,
  0x00, 0xb5, 0x11, 0x5f, 0xff, 0xa5, 0x64, 0x00,
  0x00, 0x1f, 0x85, 0xff, 0xf4, 0x01, 0x0a, 0xf5,
  0x42, 0x04, 0x2e, 0x81, 0x00, 0x2b, 0x87, 0xff,
  0xf0, 0x01, 0x0f, 0xe4, 0x54, 0xf0, 0x3f, 0x00,
  0x23, 0x80, 0x1f, 0x88, 0xff, 0xe0, 0x00, 0x4e,
  0x00, 0x04, 0x00, 0x00, 0x14, 0x00, 0x0b, 0x85,
  0xff, 0xd0, 0x00, 0x4c, 0x50, 0x44, 0x04, 0x22,
  0x81, 0x00, 0x0b, 0x00, 0x0b, 0x82, 0x49, 0xa6,
  0x6c, 0x00, 0x76, 0x00, 0x17, 0x00, 0x7d, 0x88,
  0x5e, 0xd6, 0xf9, 0xf1, 0x51, 0x11, 0x00, 0x00,
  0x3f, 0x88, 0xff, 0xf1, 0x02, 0x2e, 0xff, 0xf3,
  0xf4, 0x6a, 0x98, 0x00, 0x0b, 0x8b, 0xff, 0xf3,
  0x06, 0x2f, 0xff, 0xeb, 0xf8, 0xba, 0xa5, 0x04,
  0x00, 0xbf, 0x8b, 0xff, 0xf5, 0x42, 0x9f, 0xff,
  0xcf, 0xf9, 0x2b, 0xa5, 0xc0, 0x08, 0xff, 0x8b,
  0xff, 0xfc, 0xc5, 0xfd, 0x40, 0x3f, 0xfe, 0x0b,
  0xfb, 0x00, 0x0e, 0xff, 0x00, 0xae, 0x88, 0xfa,
  0x96, 0xff, 0xfa, 0x81, 0x54, 0x40, 0x1b, 0xff,
  0x00, 0x0b, 0x88, 0xfe, 0xaa, 0x96, 0x50, 0x59,
  0x41, 0x00, 0x7b, 0xff, 0x88, 0xff, 0xff, 0x53,
  0xff, 0xab, 0xc0, 0x00, 0x16, 0x54, 0x00, 0xba,
  0x8b, 0xff, 0xff, 0x43, 0xfe, 0xaf, 0xe8, 0x00,
  0x5a, 0x61, 0x41, 0xbf, 0xff, 0x8b, 0xff, 0xff,
  0xc2, 0xfe, 0xbf, 0xfd, 0x01, 0x59, 0x94, 0x51,
  0x1b, 0xff, 0x00, 0xef, 0x88, 0xfe, 0xeb, 0xed,
  0x95, 0x56, 0x51, 0x40, 0x0f, 0xff, 0x8b, 0xff,
  0xff, 0xe0, 0xfa, 0x92, 0xa6, 0x91, 0x11, 0x54,
  0x54, 0x0f, 0xff, 0x00, 0x0b, 0x84, 0xff, 0xa9,
  0xa4, 0x00, 0x01, 0x04, 0x17, 0x00, 0x6c, 0x88,
  0xba, 0xaf, 0xff, 0xfd, 0x96, 0x45, 0x40, 0x3f,
  0xff, 0x00, 0x00, 0x88, 0x2a, 0xbf, 0x6a, 0xa4,
  0x15, 0x54, 0x60, 0xbf, 0xff, 0x00, 0x00, 0x88,
  0xfa, 0xeb, 0x90, 0x00, 0x95, 0x41, 0xae, 0xff,
  0xff, 0x04, 0x0b, 0x84, 0xaa, 0xa5, 0x11, 0x45,
  0x05, 0x01, 0x49, 0x05, 0x27, 0x87, 0xae, 0xff,
  0xf9, 0x54, 0x11, 0x6e, 0xff, 0xff, 0x0c, 0x0b,
  0x85, 0xfa, 0x54, 0x56, 0xbb, 0xff, 0xff, 0x04,
  0x0b, 0x87, 0xab, 0xbf, 0xf6, 0x54, 0x43, 0xaf,
  0xff, 0xff, 0x04, 0x00, 0x87, 0x5a, 0xaa, 0x95,
  0x11, 0x46, 0xfb, 0xff, 0xff, 0x04, 0x00, 0x84,
  0xaa, 0x55, 0x10, 0x45, 0x07, 0x00, 0x17, 0x04,
  0x00, 0x84, 0x95, 0x54, 0x45, 0x14, 0x06, 0x00,
  0x5e, 0x04, 0x00, 0x87, 0xa5, 0x55, 0x50, 0x40,
  0x12, 0xff, 0xbf, 0xff,
};

static Memimage* resample(int, int, Memimage*);

void
drawpjw(Memimage *m, Fontchar *fc, int x, int width, int height, int ascent)
{
	int w, p[2];
	Memimage *pm, *pm1, *pm2;
	Rectangle r;
	int margin;
	
	w = width;

	// assume margin below baseline is
	// approximately how much room we should preserve at top above peter too
	margin = height - ascent;
	if(w > ascent-margin)
		w = ascent-margin;

	if(w < 9)
		w = 9;
	fc->width = w;

	pipe(p);
	write(p[1], pjw, sizeof pjw);
	close(p[1]);
	pm = readmemimage(p[0]);
	close(p[0]);
	if(pm == nil)
		goto Error;
	
	pm1 = allocmemimage(pm->r, GREY8);
	memimagedraw(pm1, pm1->r, pm, pm->r.min, nil, ZP, S);
	pm2 = resample(w, w, pm1);
	memimagedraw(m, Rect(x, ascent-w, x+w, ascent), memwhite, ZP, nil, ZP, SoverD);
	memimagedraw(m, Rect(x, ascent-w, x+w, ascent), memblack, ZP, pm2, pm2->r.min, SoverD);
	freememimage(pm2);
	freememimage(pm1);
	freememimage(pm);
	return;

Error:
	// draw a box
	r = Rect(x, 0, x+width, height);
	memimagedraw(m, r, memwhite, ZP, nil, ZP, S);
	memimagedraw(m, insetrect(r, 3), memblack, ZP, nil, ZP, S);
	return;
}

#define K2 7	/* from -.7 to +.7 inclusive, meaning .2 into each adjacent pixel */
#define NK (2*K2+1)
static double K[NK];

static void
resamplex(uchar *in, int off, int d, int inx, uchar *out, int outx)
{
	int i, x, k;
	double X, xx, v, rat;


	rat = (double)inx/(double)outx;
	for(x=0; x<outx; x++){
		if(inx == outx){
			/* don't resample if size unchanged */
			out[off+x*d] = in[off+x*d];
			continue;
		}
		v = 0.0;
		X = x*rat;
		for(k=-K2; k<=K2; k++){
			xx = X + rat*k/10.;
			i = xx;
			if(i < 0)
				i = 0;
			if(i >= inx)
				i = inx-1;
			v += in[off+i*d] * K[K2+k];
		}
		out[off+x*d] = v;
	}
}

static void
resampley(uchar **in, int off, int iny, uchar **out, int outy)
{
	int y, i, k;
	double Y, yy, v, rat;

	rat = (double)iny/(double)outy;
	for(y=0; y<outy; y++){
		if(iny == outy){
			/* don't resample if size unchanged */
			out[y][off] = in[y][off];
			continue;
		}
		v = 0.0;
		Y = y*rat;
		for(k=-K2; k<=K2; k++){
			yy = Y + rat*k/10.;
			i = yy;
			if(i < 0)
				i = 0;
			if(i >= iny)
				i = iny-1;
			v += in[i][off] * K[K2+k];
		}
		out[y][off] = v;
	}

}

static int
max(int a, int b)
{
	if(a > b)
		return a;
	return b;
}

static double
fac(int L)
{
	int i, f;

	f = 1;
	for(i=L; i>1; --i)
		f *= i;
	return f;
}

/* 
 * i0(x) is the modified Bessel function, Σ (x/2)^2L / (L!)²
 * There are faster ways to calculate this, but we precompute
 * into a table so let's keep it simple.
 */
static double
i0(double x)
{
	double v;
	int L;

	v = 1.0;
	for(L=1; L<10; L++)
		v += pow(x/2., 2*L)/pow(fac(L), 2);
	return v;
}

static double
kaiser(double x, double tau, double alpha)
{
	if(fabs(x) > tau)
		return 0.;
	return i0(alpha*sqrt(1-(x*x/(tau*tau))))/i0(alpha);
}


static Memimage*
resample(int xsize, int ysize, Memimage *m)
{
	int i, j, bpl, nchan;
	Memimage *new;
	uchar **oscan, **nscan;
	double v;

	for(i=-K2; i<=K2; i++){
		K[K2+i] = kaiser(i/10., K2/10., 4.);
/*		print("%g %g\n", i/10., K[K2+i]); */
	}

	/* normalize */
	v = 0.0;
	for(i=0; i<NK; i++)
		v += K[i];
	for(i=0; i<NK; i++)
		K[i] /= v;

	new = allocmemimage(Rect(0, 0, xsize, ysize), m->chan);
	if(new == nil)
		sysfatal("can't allocate new image: %r");

	oscan = malloc(Dy(m->r)*sizeof(uchar*));
	nscan = malloc(max(ysize, Dy(m->r))*sizeof(uchar*));
	if(oscan == nil || nscan == nil)
		sysfatal("can't allocate: %r");

	/* unload original image into scan lines */
	bpl = bytesperline(m->r, m->depth);
	for(i=0; i<Dy(m->r); i++){
		oscan[i] = malloc(bpl);
		if(oscan[i] == nil)
			sysfatal("can't allocate: %r");
		j = unloadmemimage(m, Rect(m->r.min.x, m->r.min.y+i, m->r.max.x, m->r.min.y+i+1), oscan[i], bpl);
		if(j != bpl)
			sysfatal("unloadmemimage");
	}

	/* allocate scan lines for destination. we do y first, so need at least Dy(m->r) lines */
	bpl = bytesperline(Rect(0, 0, xsize, Dy(m->r)), m->depth);
	for(i=0; i<max(ysize, Dy(m->r)); i++){
		nscan[i] = malloc(bpl);
		if(nscan[i] == nil)
			sysfatal("can't allocate: %r");
	}

	/* resample in X */
	nchan = m->depth/8;
	for(i=0; i<Dy(m->r); i++){
		for(j=0; j<nchan; j++){
			if(j==0 && m->chan==XRGB32)
				continue;
			resamplex(oscan[i], j, nchan, Dx(m->r), nscan[i], xsize);
		}
		free(oscan[i]);
		oscan[i] = nscan[i];
		nscan[i] = malloc(bpl);
		if(nscan[i] == nil)
			sysfatal("can't allocate: %r");
	}

	/* resample in Y */
	for(i=0; i<xsize; i++)
		for(j=0; j<nchan; j++)
			resampley(oscan, nchan*i+j, Dy(m->r), nscan, ysize);

	/* pack data into destination */
	bpl = bytesperline(new->r, m->depth);
	for(i=0; i<ysize; i++){
		j = loadmemimage(new, Rect(0, i, xsize, i+1), nscan[i], bpl);
		if(j != bpl)
			sysfatal("loadmemimage: %r");
	}
	return new;
}
