# -*- coding: utf-8 -*-
# Autogenerated by Sphinx on Sat Jun 11 14:41:12 2016
topics = {'assert': '\n'
           'The "assert" statement\n'
           '**********************\n'
           '\n'
           'Assert statements are a convenient way to insert debugging '
           'assertions\n'
           'into a program:\n'
           '\n'
           '   assert_stmt ::= "assert" expression ["," expression]\n'
           '\n'
           'The simple form, "assert expression", is equivalent to\n'
           '\n'
           '   if __debug__:\n'
           '       if not expression: raise AssertionError\n'
           '\n'
           'The extended form, "assert expression1, expression2", is '
           'equivalent to\n'
           '\n'
           '   if __debug__:\n'
           '       if not expression1: raise AssertionError(expression2)\n'
           '\n'
           'These equivalences assume that "__debug__" and "AssertionError" '
           'refer\n'
           'to the built-in variables with those names.  In the current\n'
           'implementation, the built-in variable "__debug__" is "True" under\n'
           'normal circumstances, "False" when optimization is requested '
           '(command\n'
           'line option -O).  The current code generator emits no code for an\n'
           'assert statement when optimization is requested at compile time.  '
           'Note\n'
           'that it is unnecessary to include the source code for the '
           'expression\n'
           'that failed in the error message; it will be displayed as part of '
           'the\n'
           'stack trace.\n'
           '\n'
           'Assignments to "__debug__" are illegal.  The value for the '
           'built-in\n'
           'variable is determined when the interpreter starts.\n',
 'assignment': '\n'
               'Assignment statements\n'
               '*********************\n'
               '\n'
               'Assignment statements are used to (re)bind names to values and '
               'to\n'
               'modify attributes or items of mutable objects:\n'
               '\n'
               '   assignment_stmt ::= (target_list "=")+ (expression_list | '
               'yield_expression)\n'
               '   target_list     ::= target ("," target)* [","]\n'
               '   target          ::= identifier\n'
               '              | "(" target_list ")"\n'
               '              | "[" [target_list] "]"\n'
               '              | attributeref\n'
               '              | subscription\n'
               '              | slicing\n'
               '\n'
               '(See section Primaries for the syntax definitions for the last '
               'three\n'
               'symbols.)\n'
               '\n'
               'An assignment statement evaluates the expression list '
               '(remember that\n'
               'this can be a single expression or a comma-separated list, the '
               'latter\n'
               'yielding a tuple) and assigns the single resulting object to '
               'each of\n'
               'the target lists, from left to right.\n'
               '\n'
               'Assignment is defined recursively depending on the form of the '
               'target\n'
               '(list). When a target is part of a mutable object (an '
               'attribute\n'
               'reference, subscription or slicing), the mutable object must\n'
               'ultimately perform the assignment and decide about its '
               'validity, and\n'
               'may raise an exception if the assignment is unacceptable.  The '
               'rules\n'
               'observed by various types and the exceptions raised are given '
               'with the\n'
               'definition of the object types (see section The standard type\n'
               'hierarchy).\n'
               '\n'
               'Assignment of an object to a target list is recursively '
               'defined as\n'
               'follows.\n'
               '\n'
               '* If the target list is a single target: The object is '
               'assigned to\n'
               '  that target.\n'
               '\n'
               '* If the target list is a comma-separated list of targets: '
               'The\n'
               '  object must be an iterable with the same number of items as '
               'there\n'
               '  are targets in the target list, and the items are assigned, '
               'from\n'
               '  left to right, to the corresponding targets.\n'
               '\n'
               'Assignment of an object to a single target is recursively '
               'defined as\n'
               'follows.\n'
               '\n'
               '* If the target is an identifier (name):\n'
               '\n'
               '  * If the name does not occur in a "global" statement in the\n'
               '    current code block: the name is bound to the object in the '
               'current\n'
               '    local namespace.\n'
               '\n'
               '  * Otherwise: the name is bound to the object in the current '
               'global\n'
               '    namespace.\n'
               '\n'
               '  The name is rebound if it was already bound.  This may cause '
               'the\n'
               '  reference count for the object previously bound to the name '
               'to reach\n'
               '  zero, causing the object to be deallocated and its '
               'destructor (if it\n'
               '  has one) to be called.\n'
               '\n'
               '* If the target is a target list enclosed in parentheses or '
               'in\n'
               '  square brackets: The object must be an iterable with the '
               'same number\n'
               '  of items as there are targets in the target list, and its '
               'items are\n'
               '  assigned, from left to right, to the corresponding targets.\n'
               '\n'
               '* If the target is an attribute reference: The primary '
               'expression in\n'
               '  the reference is evaluated.  It should yield an object with\n'
               '  assignable attributes; if this is not the case, "TypeError" '
               'is\n'
               '  raised.  That object is then asked to assign the assigned '
               'object to\n'
               '  the given attribute; if it cannot perform the assignment, it '
               'raises\n'
               '  an exception (usually but not necessarily '
               '"AttributeError").\n'
               '\n'
               '  Note: If the object is a class instance and the attribute '
               'reference\n'
               '  occurs on both sides of the assignment operator, the RHS '
               'expression,\n'
               '  "a.x" can access either an instance attribute or (if no '
               'instance\n'
               '  attribute exists) a class attribute.  The LHS target "a.x" '
               'is always\n'
               '  set as an instance attribute, creating it if necessary.  '
               'Thus, the\n'
               '  two occurrences of "a.x" do not necessarily refer to the '
               'same\n'
               '  attribute: if the RHS expression refers to a class '
               'attribute, the\n'
               '  LHS creates a new instance attribute as the target of the\n'
               '  assignment:\n'
               '\n'
               '     class Cls:\n'
               '         x = 3             # class variable\n'
               '     inst = Cls()\n'
               '     inst.x = inst.x + 1   # writes inst.x as 4 leaving Cls.x '
               'as 3\n'
               '\n'
               '  This description does not necessarily apply to descriptor\n'
               '  attributes, such as properties created with "property()".\n'
               '\n'
               '* If the target is a subscription: The primary expression in '
               'the\n'
               '  reference is evaluated.  It should yield either a mutable '
               'sequence\n'
               '  object (such as a list) or a mapping object (such as a '
               'dictionary).\n'
               '  Next, the subscript expression is evaluated.\n'
               '\n'
               '  If the primary is a mutable sequence object (such as a '
               'list), the\n'
               '  subscript must yield a plain integer.  If it is negative, '
               'the\n'
               "  sequence's length is added to it. The resulting value must "
               'be a\n'
               "  nonnegative integer less than the sequence's length, and "
               'the\n'
               '  sequence is asked to assign the assigned object to its item '
               'with\n'
               '  that index.  If the index is out of range, "IndexError" is '
               'raised\n'
               '  (assignment to a subscripted sequence cannot add new items '
               'to a\n'
               '  list).\n'
               '\n'
               '  If the primary is a mapping object (such as a dictionary), '
               'the\n'
               "  subscript must have a type compatible with the mapping's key "
               'type,\n'
               '  and the mapping is then asked to create a key/datum pair '
               'which maps\n'
               '  the subscript to the assigned object.  This can either '
               'replace an\n'
               '  existing key/value pair with the same key value, or insert a '
               'new\n'
               '  key/value pair (if no key with the same value existed).\n'
               '\n'
               '* If the target is a slicing: The primary expression in the\n'
               '  reference is evaluated.  It should yield a mutable sequence '
               'object\n'
               '  (such as a list).  The assigned object should be a sequence '
               'object\n'
               '  of the same type.  Next, the lower and upper bound '
               'expressions are\n'
               '  evaluated, insofar they are present; defaults are zero and '
               'the\n'
               "  sequence's length.  The bounds should evaluate to (small) "
               'integers.\n'
               "  If either bound is negative, the sequence's length is added "
               'to it.\n'
               '  The resulting bounds are clipped to lie between zero and '
               'the\n'
               "  sequence's length, inclusive.  Finally, the sequence object "
               'is asked\n'
               '  to replace the slice with the items of the assigned '
               'sequence.  The\n'
               '  length of the slice may be different from the length of the '
               'assigned\n'
               '  sequence, thus changing the length of the target sequence, '
               'if the\n'
               '  object allows it.\n'
               '\n'
               '**CPython implementation detail:** In the current '
               'implementation, the\n'
               'syntax for targets is taken to be the same as for expressions, '
               'and\n'
               'invalid syntax is rejected during the code generation phase, '
               'causing\n'
               'less detailed error messages.\n'
               '\n'
               'WARNING: Although the definition of assignment implies that '
               'overlaps\n'
               "between the left-hand side and the right-hand side are 'safe' "
               '(for\n'
               'example "a, b = b, a" swaps two variables), overlaps *within* '
               'the\n'
               'collection of assigned-to variables are not safe!  For '
               'instance, the\n'
               'following program prints "[0, 2]":\n'
               '\n'
               '   x = [0, 1]\n'
               '   i = 0\n'
               '   i, x[i] = 1, 2\n'
               '   print x\n'
               '\n'
               '\n'
               'Augmented assignment statements\n'
               '===============================\n'
               '\n'
               'Augmented assignment is the combination, in a single '
               'statement, of a\n'
               'binary operation and an assignment statement:\n'
               '\n'
               '   augmented_assignment_stmt ::= augtarget augop '
               '(expression_list | yield_expression)\n'
               '   augtarget                 ::= identifier | attributeref | '
               'subscription | slicing\n'
               '   augop                     ::= "+=" | "-=" | "*=" | "/=" | '
               '"//=" | "%=" | "**="\n'
               '             | ">>=" | "<<=" | "&=" | "^=" | "|="\n'
               '\n'
               '(See section Primaries for the syntax definitions for the last '
               'three\n'
               'symbols.)\n'
               '\n'
               'An augmented assignment evaluates the target (which, unlike '
               'normal\n'
               'assignment statements, cannot be an unpacking) and the '
               'expression\n'
               'list, performs the binary operation specific to the type of '
               'assignment\n'
               'on the two operands, and assigns the result to the original '
               'target.\n'
               'The target is only evaluated once.\n'
               '\n'
               'An augmented assignment expression like "x += 1" can be '
               'rewritten as\n'
               '"x = x + 1" to achieve a similar, but not exactly equal '
               'effect. In the\n'
               'augmented version, "x" is only evaluated once. Also, when '
               'possible,\n'
               'the actual operation is performed *in-place*, meaning that '
               'rather than\n'
               'creating a new object and assigning that to the target, the '
               'old object\n'
               'is modified instead.\n'
               '\n'
               'With the exception of assigning to tuples and multiple targets '
               'in a\n'
               'single statement, the assignment done by augmented assignment\n'
               'statements is handled the same way as normal assignments. '
               'Similarly,\n'
               'with the exception of the possible *in-place* behavior, the '
               'binary\n'
               'operation performed by augmented assignment is the same as the '
               'normal\n'
               'binary operations.\n'
               '\n'
               'For targets which are attribute references, the same caveat '
               'about\n'
               'class and instance attributes applies as for regular '
               'assignments.\n',
 'atom-identifiers': '\n'
                     'Identifiers (Names)\n'
                     '*******************\n'
                     '\n'
                     'An identifier occurring as an atom is a name.  See '
                     'section Identifiers\n'
                     'and keywords for lexical definition and section Naming '
                     'and binding for\n'
                     'documentation of naming and binding.\n'
                     '\n'
                     'When the name is bound to an object, evaluation of the '
                     'atom yields\n'
                     'that object. When a name is not bound, an attempt to '
                     'evaluate it\n'
                     'raises a "NameError" exception.\n'
                     '\n'
                     '**Private name mangling:** When an identifier that '
                     'textually occurs in\n'
                     'a class definition begins with two or more underscore '
                     'characters and\n'
                     'does not end in two or more underscores, it is '
                     'considered a *private\n'
                     'name* of that class. Private names are transformed to a '
                     'longer form\n'
                     'before code is generated for them.  The transformation '
                     'inserts the\n'
                     'class name, with leading underscores removed and a '
                     'single underscore\n'
                     'inserted, in front of the name.  For example, the '
                     'identifier "__spam"\n'
                     'occurring in a class named "Ham" will be transformed to '
                     '"_Ham__spam".\n'
                     'This transformation is independent of the syntactical '
                     'context in which\n'
                     'the identifier is used.  If the transformed name is '
                     'extremely long\n'
                     '(longer than 255 characters), implementation defined '
                     'truncation may\n'
                     'happen. If the class name consists only of underscores, '
                     'no\n'
                     'transformation is done.\n',
 'atom-literals': '\n'
                  'Literals\n'
                  '********\n'
                  '\n'
                  'Python supports string literals and various numeric '
                  'literals:\n'
                  '\n'
                  '   literal ::= stringliteral | integer | longinteger\n'
                  '               | floatnumber | imagnumber\n'
                  '\n'
                  'Evaluation of a literal yields an object of the given type '
                  '(string,\n'
                  'integer, long integer, floating point number, complex '
                  'number) with the\n'
                  'given value.  The value may be approximated in the case of '
                  'floating\n'
                  'point and imaginary (complex) literals.  See section '
                  'Literals for\n'
                  'details.\n'
                  '\n'
                  'All literals correspond to immutable data types, and hence '
                  'the\n'
                  "object's identity is less important than its value.  "
                  'Multiple\n'
                  'evaluations of literals with the same value (either the '
                  'same\n'
                  'occurrence in the program text or a different occurrence) '
                  'may obtain\n'
                  'the same object or a different object with the same '
                  'value.\n',
 'attribute-access': '\n'
                     'Customizing attribute access\n'
                     '****************************\n'
                     '\n'
                     'The following methods can be defined to customize the '
                     'meaning of\n'
                     'attribute access (use of, assignment to, or deletion of '
                     '"x.name") for\n'
                     'class instances.\n'
                     '\n'
                     'object.__getattr__(self, name)\n'
                     '\n'
                     '   Called when an attribute lookup has not found the '
                     'attribute in the\n'
                     '   usual places (i.e. it is not an instance attribute '
                     'nor is it found\n'
                     '   in the class tree for "self").  "name" is the '
                     'attribute name. This\n'
                     '   method should return the (computed) attribute value '
                     'or raise an\n'
                     '   "AttributeError" exception.\n'
                     '\n'
                     '   Note that if the attribute is found through the '
                     'normal mechanism,\n'
                     '   "__getattr__()" is not called.  (This is an '
                     'intentional asymmetry\n'
                     '   between "__getattr__()" and "__setattr__()".) This is '
                     'done both for\n'
                     '   efficiency reasons and because otherwise '
                     '"__getattr__()" would have\n'
                     '   no way to access other attributes of the instance.  '
                     'Note that at\n'
                     '   least for instance variables, you can fake total '
                     'control by not\n'
                     '   inserting any values in the instance attribute '
                     'dictionary (but\n'
                     '   instead inserting them in another object).  See the\n'
                     '   "__getattribute__()" method below for a way to '
                     'actually get total\n'
                     '   control in new-style classes.\n'
                     '\n'
                     'object.__setattr__(self, name, value)\n'
                     '\n'
                     '   Called when an attribute assignment is attempted.  '
                     'This is called\n'
                     '   instead of the normal mechanism (i.e. store the value '
                     'in the\n'
                     '   instance dictionary).  *name* is the attribute name, '
                     '*value* is the\n'
                     '   value to be assigned to it.\n'
                     '\n'
                     '   If "__setattr__()" wants to assign to an instance '
                     'attribute, it\n'
                     '   should not simply execute "self.name = value" --- '
                     'this would cause\n'
                     '   a recursive call to itself.  Instead, it should '
                     'insert the value in\n'
                     '   the dictionary of instance attributes, e.g., '
                     '"self.__dict__[name] =\n'
                     '   value".  For new-style classes, rather than accessing '
                     'the instance\n'
                     '   dictionary, it should call the base class method with '
                     'the same\n'
                     '   name, for example, "object.__setattr__(self, name, '
                     'value)".\n'
                     '\n'
                     'object.__delattr__(self, name)\n'
                     '\n'
                     '   Like "__setattr__()" but for attribute deletion '
                     'instead of\n'
                     '   assignment.  This should only be implemented if "del '
                     'obj.name" is\n'
                     '   meaningful for the object.\n'
                     '\n'
                     '\n'
                     'More attribute access for new-style classes\n'
                     '===========================================\n'
                     '\n'
                     'The following methods only apply to new-style classes.\n'
                     '\n'
                     'object.__getattribute__(self, name)\n'
                     '\n'
                     '   Called unconditionally to implement attribute '
                     'accesses for\n'
                     '   instances of the class. If the class also defines '
                     '"__getattr__()",\n'
                     '   the latter will not be called unless '
                     '"__getattribute__()" either\n'
                     '   calls it explicitly or raises an "AttributeError". '
                     'This method\n'
                     '   should return the (computed) attribute value or raise '
                     'an\n'
                     '   "AttributeError" exception. In order to avoid '
                     'infinite recursion in\n'
                     '   this method, its implementation should always call '
                     'the base class\n'
                     '   method with the same name to access any attributes it '
                     'needs, for\n'
                     '   example, "object.__getattribute__(self, name)".\n'
                     '\n'
                     '   Note: This method may still be bypassed when looking '
                     'up special\n'
                     '     methods as the result of implicit invocation via '
                     'language syntax\n'
                     '     or built-in functions. See Special method lookup '
                     'for new-style\n'
                     '     classes.\n'
                     '\n'
                     '\n'
                     'Implementing Descriptors\n'
                     '========================\n'
                     '\n'
                     'The following methods only apply when an instance of the '
                     'class\n'
                     'containing the method (a so-called *descriptor* class) '
                     'appears in an\n'
                     '*owner* class (the descriptor must be in either the '
                     "owner's class\n"
                     'dictionary or in the class dictionary for one of its '
                     'parents).  In the\n'
                     'examples below, "the attribute" refers to the attribute '
                     'whose name is\n'
                     "the key of the property in the owner class' "
                     '"__dict__".\n'
                     '\n'
                     'object.__get__(self, instance, owner)\n'
                     '\n'
                     '   Called to get the attribute of the owner class (class '
                     'attribute\n'
                     '   access) or of an instance of that class (instance '
                     'attribute\n'
                     '   access). *owner* is always the owner class, while '
                     '*instance* is the\n'
                     '   instance that the attribute was accessed through, or '
                     '"None" when\n'
                     '   the attribute is accessed through the *owner*.  This '
                     'method should\n'
                     '   return the (computed) attribute value or raise an '
                     '"AttributeError"\n'
                     '   exception.\n'
                     '\n'
                     'object.__set__(self, instance, value)\n'
                     '\n'
                     '   Called to set the attribute on an instance *instance* '
                     'of the owner\n'
                     '   class to a new value, *value*.\n'
                     '\n'
                     'object.__delete__(self, instance)\n'
                     '\n'
                     '   Called to delete the attribute on an instance '
                     '*instance* of the\n'
                     '   owner class.\n'
                     '\n'
                     '\n'
                     'Invoking Descriptors\n'
                     '====================\n'
                     '\n'
                     'In general, a descriptor is an object attribute with '
                     '"binding\n'
                     'behavior", one whose attribute access has been '
                     'overridden by methods\n'
                     'in the descriptor protocol:  "__get__()", "__set__()", '
                     'and\n'
                     '"__delete__()". If any of those methods are defined for '
                     'an object, it\n'
                     'is said to be a descriptor.\n'
                     '\n'
                     'The default behavior for attribute access is to get, '
                     'set, or delete\n'
                     "the attribute from an object's dictionary. For instance, "
                     '"a.x" has a\n'
                     'lookup chain starting with "a.__dict__[\'x\']", then\n'
                     '"type(a).__dict__[\'x\']", and continuing through the '
                     'base classes of\n'
                     '"type(a)" excluding metaclasses.\n'
                     '\n'
                     'However, if the looked-up value is an object defining '
                     'one of the\n'
                     'descriptor methods, then Python may override the default '
                     'behavior and\n'
                     'invoke the descriptor method instead.  Where this occurs '
                     'in the\n'
                     'precedence chain depends on which descriptor methods '
                     'were defined and\n'
                     'how they were called.  Note that descriptors are only '
                     'invoked for new\n'
                     'style objects or classes (ones that subclass "object()" '
                     'or "type()").\n'
                     '\n'
                     'The starting point for descriptor invocation is a '
                     'binding, "a.x". How\n'
                     'the arguments are assembled depends on "a":\n'
                     '\n'
                     'Direct Call\n'
                     '   The simplest and least common call is when user code '
                     'directly\n'
                     '   invokes a descriptor method:    "x.__get__(a)".\n'
                     '\n'
                     'Instance Binding\n'
                     '   If binding to a new-style object instance, "a.x" is '
                     'transformed\n'
                     '   into the call: "type(a).__dict__[\'x\'].__get__(a, '
                     'type(a))".\n'
                     '\n'
                     'Class Binding\n'
                     '   If binding to a new-style class, "A.x" is transformed '
                     'into the\n'
                     '   call: "A.__dict__[\'x\'].__get__(None, A)".\n'
                     '\n'
                     'Super Binding\n'
                     '   If "a" is an instance of "super", then the binding '
                     '"super(B,\n'
                     '   obj).m()" searches "obj.__class__.__mro__" for the '
                     'base class "A"\n'
                     '   immediately preceding "B" and then invokes the '
                     'descriptor with the\n'
                     '   call: "A.__dict__[\'m\'].__get__(obj, '
                     'obj.__class__)".\n'
                     '\n'
                     'For instance bindings, the precedence of descriptor '
                     'invocation depends\n'
                     'on the which descriptor methods are defined.  A '
                     'descriptor can define\n'
                     'any combination of "__get__()", "__set__()" and '
                     '"__delete__()".  If it\n'
                     'does not define "__get__()", then accessing the '
                     'attribute will return\n'
                     'the descriptor object itself unless there is a value in '
                     "the object's\n"
                     'instance dictionary.  If the descriptor defines '
                     '"__set__()" and/or\n'
                     '"__delete__()", it is a data descriptor; if it defines '
                     'neither, it is\n'
                     'a non-data descriptor.  Normally, data descriptors '
                     'define both\n'
                     '"__get__()" and "__set__()", while non-data descriptors '
                     'have just the\n'
                     '"__get__()" method.  Data descriptors with "__set__()" '
                     'and "__get__()"\n'
                     'defined always override a redefinition in an instance '
                     'dictionary.  In\n'
                     'contrast, non-data descriptors can be overridden by '
                     'instances.\n'
                     '\n'
                     'Python methods (including "staticmethod()" and '
                     '"classmethod()") are\n'
                     'implemented as non-data descriptors.  Accordingly, '
                     'instances can\n'
                     'redefine and override methods.  This allows individual '
                     'instances to\n'
                     'acquire behaviors that differ from other instances of '
                     'the same class.\n'
                     '\n'
                     'The "property()" function is implemented as a data '
                     'descriptor.\n'
                     'Accordingly, instances cannot override the behavior of a '
                     'property.\n'
                     '\n'
                     '\n'
                     '__slots__\n'
                     '=========\n'
                     '\n'
                     'By default, instances of both old and new-style classes '
                     'have a\n'
                     'dictionary for attribute storage.  This wastes space for '
                     'objects\n'
                     'having very few instance variables.  The space '
                     'consumption can become\n'
                     'acute when creating large numbers of instances.\n'
                     '\n'
                     'The default can be overridden by defining *__slots__* in '
                     'a new-style\n'
                     'class definition.  The *__slots__* declaration takes a '
                     'sequence of\n'
                     'instance variables and reserves just enough space in '
                     'each instance to\n'
                     'hold a value for each variable.  Space is saved because '
                     '*__dict__* is\n'
                     'not created for each instance.\n'
                     '\n'
                     '__slots__\n'
                     '\n'
                     '   This class variable can be assigned a string, '
                     'iterable, or sequence\n'
                     '   of strings with variable names used by instances.  If '
                     'defined in a\n'
                     '   new-style class, *__slots__* reserves space for the '
                     'declared\n'
                     '   variables and prevents the automatic creation of '
                     '*__dict__* and\n'
                     '   *__weakref__* for each instance.\n'
                     '\n'
                     '   New in version 2.2.\n'
                     '\n'
                     'Notes on using *__slots__*\n'
                     '\n'
                     '* When inheriting from a class without *__slots__*, the '
                     '*__dict__*\n'
                     '  attribute of that class will always be accessible, so '
                     'a *__slots__*\n'
                     '  definition in the subclass is meaningless.\n'
                     '\n'
                     '* Without a *__dict__* variable, instances cannot be '
                     'assigned new\n'
                     '  variables not listed in the *__slots__* definition.  '
                     'Attempts to\n'
                     '  assign to an unlisted variable name raises '
                     '"AttributeError". If\n'
                     '  dynamic assignment of new variables is desired, then '
                     'add\n'
                     '  "\'__dict__\'" to the sequence of strings in the '
                     '*__slots__*\n'
                     '  declaration.\n'
                     '\n'
                     '  Changed in version 2.3: Previously, adding '
                     '"\'__dict__\'" to the\n'
                     '  *__slots__* declaration would not enable the '
                     'assignment of new\n'
                     '  attributes not specifically listed in the sequence of '
                     'instance\n'
                     '  variable names.\n'
                     '\n'
                     '* Without a *__weakref__* variable for each instance, '
                     'classes\n'
                     '  defining *__slots__* do not support weak references to '
                     'its\n'
                     '  instances. If weak reference support is needed, then '
                     'add\n'
                     '  "\'__weakref__\'" to the sequence of strings in the '
                     '*__slots__*\n'
                     '  declaration.\n'
                     '\n'
                     '  Changed in version 2.3: Previously, adding '
                     '"\'__weakref__\'" to the\n'
                     '  *__slots__* declaration would not enable support for '
                     'weak\n'
                     '  references.\n'
                     '\n'
                     '* *__slots__* are implemented at the class level by '
                     'creating\n'
                     '  descriptors (Implementing Descriptors) for each '
                     'variable name.  As a\n'
                     '  result, class attributes cannot be used to set default '
                     'values for\n'
                     '  instance variables defined by *__slots__*; otherwise, '
                     'the class\n'
                     '  attribute would overwrite the descriptor assignment.\n'
                     '\n'
                     '* The action of a *__slots__* declaration is limited to '
                     'the class\n'
                     '  where it is defined.  As a result, subclasses will '
                     'have a *__dict__*\n'
                     '  unless they also define *__slots__* (which must only '
                     'contain names\n'
                     '  of any *additional* slots).\n'
                     '\n'
                     '* If a class defines a slot also defined in a base '
                     'class, the\n'
                     '  instance variable defined by the base class slot is '
                     'inaccessible\n'
                     '  (except by retrieving its descriptor directly from the '
                     'base class).\n'
                     '  This renders the meaning of the program undefined.  In '
                     'the future, a\n'
                     '  check may be added to prevent this.\n'
                     '\n'
                     '* Nonempty *__slots__* does not work for classes derived '
                     'from\n'
                     '  "variable-length" built-in types such as "long", "str" '
                     'and "tuple".\n'
                     '\n'
                     '* Any non-string iterable may be assigned to '
                     '*__slots__*. Mappings\n'
                     '  may also be used; however, in the future, special '
                     'meaning may be\n'
                     '  assigned to the values corresponding to each key.\n'
                     '\n'
                     '* *__class__* assignment works only if both classes have '
                     'the same\n'
                     '  *__slots__*.\n'
                     '\n'
                     '  Changed in version 2.6: Previously, *__class__* '
                     'assignment raised an\n'
                     '  error if either new or old class had *__slots__*.\n',
 'attribute-references': '\n'
                         'Attribute references\n'
                         '********************\n'
                         '\n'
                         'An attribute reference is a primary followed by a '
                         'period and a name:\n'
                         '\n'
                         '   attributeref ::= primary "." identifier\n'
                         '\n'
                         'The primary must evaluate to an object of a type '
                         'that supports\n'
                         'attribute references, e.g., a module, list, or an '
                         'instance.  This\n'
                         'object is then asked to produce the attribute whose '
                         'name is the\n'
                         'identifier.  If this attribute is not available, the '
                         'exception\n'
                         '"AttributeError" is raised. Otherwise, the type and '
                         'value of the\n'
                         'object produced is determined by the object.  '
                         'Multiple evaluations of\n'
                         'the same attribute reference may yield different '
                         'objects.\n',
 'augassign': '\n'
              'Augmented assignment statements\n'
              '*******************************\n'
              '\n'
              'Augmented assignment is the combination, in a single statement, '
              'of a\n'
              'binary operation and an assignment statement:\n'
              '\n'
              '   augmented_assignment_stmt ::= augtarget augop '
              '(expression_list | yield_expression)\n'
              '   augtarget                 ::= identifier | attributeref | '
              'subscription | slicing\n'
              '   augop                     ::= "+=" | "-=" | "*=" | "/=" | '
              '"//=" | "%=" | "**="\n'
              '             | ">>=" | "<<=" | "&=" | "^=" | "|="\n'
              '\n'
              '(See section Primaries for the syntax definitions for the last '
              'three\n'
              'symbols.)\n'
              '\n'
              'An augmented assignment evaluates the target (which, unlike '
              'normal\n'
              'assignment statements, cannot be an unpacking) and the '
              'expression\n'
              'list, performs the binary operation specific to the type of '
              'assignment\n'
              'on the two operands, and assigns the result to the original '
              'target.\n'
              'The target is only evaluated once.\n'
              '\n'
              'An augmented assignment expression like "x += 1" can be '
              'rewritten as\n'
              '"x = x + 1" to achieve a similar, but not exactly equal effect. '
              'In the\n'
              'augmented version, "x" is only evaluated once. Also, when '
              'possible,\n'
              'the actual operation is performed *in-place*, meaning that '
              'rather than\n'
              'creating a new object and assigning that to the target, the old '
              'object\n'
              'is modified instead.\n'
              '\n'
              'With the exception of assigning to tuples and multiple targets '
              'in a\n'
              'single statement, the assignment done by augmented assignment\n'
              'statements is handled the same way as normal assignments. '
              'Similarly,\n'
              'with the exception of the possible *in-place* behavior, the '
              'binary\n'
              'operation performed by augmented assignment is the same as the '
              'normal\n'
              'binary operations.\n'
              '\n'
              'For targets which are attribute references, the same caveat '
              'about\n'
              'class and instance attributes applies as for regular '
              'assignments.\n',
 'binary': '\n'
           'Binary arithmetic operations\n'
           '****************************\n'
           '\n'
           'The binary arithmetic operations have the conventional priority\n'
           'levels.  Note that some of these operations also apply to certain '
           'non-\n'
           'numeric types.  Apart from the power operator, there are only two\n'
           'levels, one for multiplicative operators and one for additive\n'
           'operators:\n'
           '\n'
           '   m_expr ::= u_expr | m_expr "*" u_expr | m_expr "//" u_expr | '
           'm_expr "/" u_expr\n'
           '              | m_expr "%" u_expr\n'
           '   a_expr ::= m_expr | a_expr "+" m_expr | a_expr "-" m_expr\n'
           '\n'
           'The "*" (multiplication) operator yields the product of its '
           'arguments.\n'
           'The arguments must either both be numbers, or one argument must be '
           'an\n'
           'integer (plain or long) and the other must be a sequence. In the\n'
           'former case, the numbers are converted to a common type and then\n'
           'multiplied together.  In the latter case, sequence repetition is\n'
           'performed; a negative repetition factor yields an empty sequence.\n'
           '\n'
           'The "/" (division) and "//" (floor division) operators yield the\n'
           'quotient of their arguments.  The numeric arguments are first\n'
           'converted to a common type. Plain or long integer division yields '
           'an\n'
           'integer of the same type; the result is that of mathematical '
           'division\n'
           "with the 'floor' function applied to the result. Division by zero\n"
           'raises the "ZeroDivisionError" exception.\n'
           '\n'
           'The "%" (modulo) operator yields the remainder from the division '
           'of\n'
           'the first argument by the second.  The numeric arguments are '
           'first\n'
           'converted to a common type.  A zero right argument raises the\n'
           '"ZeroDivisionError" exception.  The arguments may be floating '
           'point\n'
           'numbers, e.g., "3.14%0.7" equals "0.34" (since "3.14" equals '
           '"4*0.7 +\n'
           '0.34".)  The modulo operator always yields a result with the same '
           'sign\n'
           'as its second operand (or zero); the absolute value of the result '
           'is\n'
           'strictly smaller than the absolute value of the second operand '
           '[2].\n'
           '\n'
           'The integer division and modulo operators are connected by the\n'
           'following identity: "x == (x/y)*y + (x%y)".  Integer division and\n'
           'modulo are also connected with the built-in function "divmod()":\n'
           '"divmod(x, y) == (x/y, x%y)".  These identities don\'t hold for\n'
           'floating point numbers; there similar identities hold '
           'approximately\n'
           'where "x/y" is replaced by "floor(x/y)" or "floor(x/y) - 1" [3].\n'
           '\n'
           'In addition to performing the modulo operation on numbers, the '
           '"%"\n'
           'operator is also overloaded by string and unicode objects to '
           'perform\n'
           'string formatting (also known as interpolation). The syntax for '
           'string\n'
           'formatting is described in the Python Library Reference, section\n'
           'String Formatting Operations.\n'
           '\n'
           'Deprecated since version 2.3: The floor division operator, the '
           'modulo\n'
           'operator, and the "divmod()" function are no longer defined for\n'
           'complex numbers.  Instead, convert to a floating point number '
           'using\n'
           'the "abs()" function if appropriate.\n'
           '\n'
           'The "+" (addition) operator yields the sum of its arguments. The\n'
           'arguments must either both be numbers or both sequences of the '
           'same\n'
           'type.  In the former case, the numbers are converted to a common '
           'type\n'
           'and then added together.  In the latter case, the sequences are\n'
           'concatenated.\n'
           '\n'
           'The "-" (subtraction) operator yields the difference of its '
           'arguments.\n'
           'The numeric arguments are first converted to a common type.\n',
 'bitwise': '\n'
            'Binary bitwise operations\n'
            '*************************\n'
            '\n'
            'Each of the three bitwise operations has a different priority '
            'level:\n'
            '\n'
            '   and_expr ::= shift_expr | and_expr "&" shift_expr\n'
            '   xor_expr ::= and_expr | xor_expr "^" and_expr\n'
            '   or_expr  ::= xor_expr | or_expr "|" xor_expr\n'
            '\n'
            'The "&" operator yields the bitwise AND of its arguments, which '
            'must\n'
            'be plain or long integers.  The arguments are converted to a '
            'common\n'
            'type.\n'
            '\n'
            'The "^" operator yields the bitwise XOR (exclusive OR) of its\n'
            'arguments, which must be plain or long integers.  The arguments '
            'are\n'
            'converted to a common type.\n'
            '\n'
            'The "|" operator yields the bitwise (inclusive) OR of its '
            'arguments,\n'
            'which must be plain or long integers.  The arguments are '
            'converted to\n'
            'a common type.\n',
 'bltin-code-objects': '\n'
                       'Code Objects\n'
                       '************\n'
                       '\n'
                       'Code objects are used by the implementation to '
                       'represent "pseudo-\n'
                       'compiled" executable Python code such as a function '
                       'body. They differ\n'
                       "from function objects because they don't contain a "
                       'reference to their\n'
                       'global execution environment.  Code objects are '
                       'returned by the built-\n'
                       'in "compile()" function and can be extracted from '
                       'function objects\n'
                       'through their "func_code" attribute. See also the '
                       '"code" module.\n'
                       '\n'
                       'A code object can be executed or evaluated by passing '
                       'it (instead of a\n'
                       'source string) to the "exec" statement or the built-in '
                       '"eval()"\n'
                       'function.\n'
                       '\n'
                       'See The standard type hierarchy for more '
                       'information.\n',
 'bltin-ellipsis-object': '\n'
                          'The Ellipsis Object\n'
                          '*******************\n'
                          '\n'
                          'This object is used by extended slice notation (see '
                          'Slicings).  It\n'
                          'supports no special operations.  There is exactly '
                          'one ellipsis object,\n'
                          'named "Ellipsis" (a built-in name).\n'
                          '\n'
                          'It is written as "Ellipsis".  When in a subscript, '
                          'it can also be\n'
                          'written as "...", for example "seq[...]".\n',
 'bltin-file-objects': '\n'
                       'File Objects\n'
                       '************\n'
                       '\n'
                       'File objects are implemented using C\'s "stdio" '
                       'package and can be\n'
                       'created with the built-in "open()" function.  File '
                       'objects are also\n'
                       'returned by some other built-in functions and methods, '
                       'such as\n'
                       '"os.popen()" and "os.fdopen()" and the "makefile()" '
                       'method of socket\n'
                       'objects. Temporary files can be created using the '
                       '"tempfile" module,\n'
                       'and high-level file operations such as copying, '
                       'moving, and deleting\n'
                       'files and directories can be achieved with the '
                       '"shutil" module.\n'
                       '\n'
                       'When a file operation fails for an I/O-related reason, '
                       'the exception\n'
                       '"IOError" is raised.  This includes situations where '
                       'the operation is\n'
                       'not defined for some reason, like "seek()" on a tty '
                       'device or writing\n'
                       'a file opened for reading.\n'
                       '\n'
                       'Files have the following methods:\n'
                       '\n'
                       'file.close()\n'
                       '\n'
                       '   Close the file.  A closed file cannot be read or '
                       'written any more.\n'
                       '   Any operation which requires that the file be open '
                       'will raise a\n'
                       '   "ValueError" after the file has been closed.  '
                       'Calling "close()"\n'
                       '   more than once is allowed.\n'
                       '\n'
                       '   As of Python 2.5, you can avoid having to call this '
                       'method\n'
                       '   explicitly if you use the "with" statement.  For '
                       'example, the\n'
                       '   following code will automatically close *f* when '
                       'the "with" block\n'
                       '   is exited:\n'
                       '\n'
                       '      from __future__ import with_statement # This '
                       "isn't required in Python 2.6\n"
                       '\n'
                       '      with open("hello.txt") as f:\n'
                       '          for line in f:\n'
                       '              print line,\n'
                       '\n'
                       '   In older versions of Python, you would have needed '
                       'to do this to\n'
                       '   get the same effect:\n'
                       '\n'
                       '      f = open("hello.txt")\n'
                       '      try:\n'
                       '          for line in f:\n'
                       '              print line,\n'
                       '      finally:\n'
                       '          f.close()\n'
                       '\n'
                       '   Note: Not all "file-like" types in Python support '
                       'use as a\n'
                       '     context manager for the "with" statement.  If '
                       'your code is\n'
                       '     intended to work with any file-like object, you '
                       'can use the\n'
                       '     function "contextlib.closing()" instead of using '
                       'the object\n'
                       '     directly.\n'
                       '\n'
                       'file.flush()\n'
                       '\n'
                       '   Flush the internal buffer, like "stdio"\'s '
                       '"fflush()".  This may be\n'
                       '   a no-op on some file-like objects.\n'
                       '\n'
                       '   Note: "flush()" does not necessarily write the '
                       "file's data to\n"
                       '     disk. Use "flush()" followed by "os.fsync()" to '
                       'ensure this\n'
                       '     behavior.\n'
                       '\n'
                       'file.fileno()\n'
                       '\n'
                       '   Return the integer "file descriptor" that is used '
                       'by the underlying\n'
                       '   implementation to request I/O operations from the '
                       'operating system.\n'
                       '   This can be useful for other, lower level '
                       'interfaces that use file\n'
                       '   descriptors, such as the "fcntl" module or '
                       '"os.read()" and friends.\n'
                       '\n'
                       '   Note: File-like objects which do not have a real '
                       'file descriptor\n'
                       '     should *not* provide this method!\n'
                       '\n'
                       'file.isatty()\n'
                       '\n'
                       '   Return "True" if the file is connected to a '
                       'tty(-like) device, else\n'
                       '   "False".\n'
                       '\n'
                       '   Note: If a file-like object is not associated with '
                       'a real file,\n'
                       '     this method should *not* be implemented.\n'
                       '\n'
                       'file.next()\n'
                       '\n'
                       '   A file object is its own iterator, for example '
                       '"iter(f)" returns\n'
                       '   *f* (unless *f* is closed).  When a file is used as '
                       'an iterator,\n'
                       '   typically in a "for" loop (for example, "for line '
                       'in f: print\n'
                       '   line.strip()"), the "next()" method is called '
                       'repeatedly.  This\n'
                       '   method returns the next input line, or raises '
                       '"StopIteration" when\n'
                       '   EOF is hit when the file is open for reading '
                       '(behavior is undefined\n'
                       '   when the file is open for writing).  In order to '
                       'make a "for" loop\n'
                       '   the most efficient way of looping over the lines of '
                       'a file (a very\n'
                       '   common operation), the "next()" method uses a '
                       'hidden read-ahead\n'
                       '   buffer.  As a consequence of using a read-ahead '
                       'buffer, combining\n'
                       '   "next()" with other file methods (like '
                       '"readline()") does not work\n'
                       '   right.  However, using "seek()" to reposition the '
                       'file to an\n'
                       '   absolute position will flush the read-ahead '
                       'buffer.\n'
                       '\n'
                       '   New in version 2.3.\n'
                       '\n'
                       'file.read([size])\n'
                       '\n'
                       '   Read at most *size* bytes from the file (less if '
                       'the read hits EOF\n'
                       '   before obtaining *size* bytes).  If the *size* '
                       'argument is negative\n'
                       '   or omitted, read all data until EOF is reached.  '
                       'The bytes are\n'
                       '   returned as a string object.  An empty string is '
                       'returned when EOF\n'
                       '   is encountered immediately.  (For certain files, '
                       'like ttys, it\n'
                       '   makes sense to continue reading after an EOF is '
                       'hit.)  Note that\n'
                       '   this method may call the underlying C function '
                       '"fread()" more than\n'
                       '   once in an effort to acquire as close to *size* '
                       'bytes as possible.\n'
                       '   Also note that when in non-blocking mode, less data '
                       'than was\n'
                       '   requested may be returned, even if no *size* '
                       'parameter was given.\n'
                       '\n'
                       '   Note: This function is simply a wrapper for the '
                       'underlying\n'
                       '     "fread()" C function, and will behave the same in '
                       'corner cases,\n'
                       '     such as whether the EOF value is cached.\n'
                       '\n'
                       'file.readline([size])\n'
                       '\n'
                       '   Read one entire line from the file.  A trailing '
                       'newline character\n'
                       '   is kept in the string (but may be absent when a '
                       'file ends with an\n'
                       '   incomplete line). [6] If the *size* argument is '
                       'present and non-\n'
                       '   negative, it is a maximum byte count (including the '
                       'trailing\n'
                       '   newline) and an incomplete line may be returned. '
                       'When *size* is not\n'
                       '   0, an empty string is returned *only* when EOF is '
                       'encountered\n'
                       '   immediately.\n'
                       '\n'
                       '   Note: Unlike "stdio"\'s "fgets()", the returned '
                       'string contains\n'
                       '     null characters ("\'\\0\'") if they occurred in '
                       'the input.\n'
                       '\n'
                       'file.readlines([sizehint])\n'
                       '\n'
                       '   Read until EOF using "readline()" and return a list '
                       'containing the\n'
                       '   lines thus read.  If the optional *sizehint* '
                       'argument is present,\n'
                       '   instead of reading up to EOF, whole lines totalling '
                       'approximately\n'
                       '   *sizehint* bytes (possibly after rounding up to an '
                       'internal buffer\n'
                       '   size) are read.  Objects implementing a file-like '
                       'interface may\n'
                       '   choose to ignore *sizehint* if it cannot be '
                       'implemented, or cannot\n'
                       '   be implemented efficiently.\n'
                       '\n'
                       'file.xreadlines()\n'
                       '\n'
                       '   This method returns the same thing as "iter(f)".\n'
                       '\n'
                       '   New in version 2.1.\n'
                       '\n'
                       '   Deprecated since version 2.3: Use "for line in '
                       'file" instead.\n'
                       '\n'
                       'file.seek(offset[, whence])\n'
                       '\n'
                       '   Set the file\'s current position, like "stdio"\'s '
                       '"fseek()". The\n'
                       '   *whence* argument is optional and defaults to  '
                       '"os.SEEK_SET" or "0"\n'
                       '   (absolute file positioning); other values are '
                       '"os.SEEK_CUR" or "1"\n'
                       '   (seek relative to the current position) and '
                       '"os.SEEK_END" or "2"\n'
                       "   (seek relative to the file's end).  There is no "
                       'return value.\n'
                       '\n'
                       '   For example, "f.seek(2, os.SEEK_CUR)" advances the '
                       'position by two\n'
                       '   and "f.seek(-3, os.SEEK_END)" sets the position to '
                       'the third to\n'
                       '   last.\n'
                       '\n'
                       '   Note that if the file is opened for appending (mode '
                       '"\'a\'" or\n'
                       '   "\'a+\'"), any "seek()" operations will be undone '
                       'at the next write.\n'
                       '   If the file is only opened for writing in append '
                       'mode (mode "\'a\'"),\n'
                       '   this method is essentially a no-op, but it remains '
                       'useful for files\n'
                       '   opened in append mode with reading enabled (mode '
                       '"\'a+\'").  If the\n'
                       '   file is opened in text mode (without "\'b\'"), only '
                       'offsets returned\n'
                       '   by "tell()" are legal.  Use of other offsets causes '
                       'undefined\n'
                       '   behavior.\n'
                       '\n'
                       '   Note that not all file objects are seekable.\n'
                       '\n'
                       '   Changed in version 2.6: Passing float values as '
                       'offset has been\n'
                       '   deprecated.\n'
                       '\n'
                       'file.tell()\n'
                       '\n'
                       "   Return the file's current position, like "
                       '"stdio"\'s "ftell()".\n'
                       '\n'
                       '   Note: On Windows, "tell()" can return illegal '
                       'values (after an\n'
                       '     "fgets()") when reading files with Unix-style '
                       'line-endings. Use\n'
                       '     binary mode ("\'rb\'") to circumvent this '
                       'problem.\n'
                       '\n'
                       'file.truncate([size])\n'
                       '\n'
                       "   Truncate the file's size.  If the optional *size* "
                       'argument is\n'
                       '   present, the file is truncated to (at most) that '
                       'size.  The size\n'
                       '   defaults to the current position. The current file '
                       'position is not\n'
                       '   changed.  Note that if a specified size exceeds the '
                       "file's current\n"
                       '   size, the result is platform-dependent:  '
                       'possibilities include that\n'
                       '   the file may remain unchanged, increase to the '
                       'specified size as if\n'
                       '   zero-filled, or increase to the specified size with '
                       'undefined new\n'
                       '   content. Availability:  Windows, many Unix '
                       'variants.\n'
                       '\n'
                       'file.write(str)\n'
                       '\n'
                       '   Write a string to the file.  There is no return '
                       'value.  Due to\n'
                       '   buffering, the string may not actually show up in '
                       'the file until\n'
                       '   the "flush()" or "close()" method is called.\n'
                       '\n'
                       'file.writelines(sequence)\n'
                       '\n'
                       '   Write a sequence of strings to the file.  The '
                       'sequence can be any\n'
                       '   iterable object producing strings, typically a list '
                       'of strings.\n'
                       '   There is no return value. (The name is intended to '
                       'match\n'
                       '   "readlines()"; "writelines()" does not add line '
                       'separators.)\n'
                       '\n'
                       'Files support the iterator protocol.  Each iteration '
                       'returns the same\n'
                       'result as "readline()", and iteration ends when the '
                       '"readline()"\n'
                       'method returns an empty string.\n'
                       '\n'
                       'File objects also offer a number of other interesting '
                       'attributes.\n'
                       'These are not required for file-like objects, but '
                       'should be\n'
                       'implemented if they make sense for the particular '
                       'object.\n'
                       '\n'
                       'file.closed\n'
                       '\n'
                       '   bool indicating the current state of the file '
                       'object.  This is a\n'
                       '   read-only attribute; the "close()" method changes '
                       'the value. It may\n'
                       '   not be available on all file-like objects.\n'
                       '\n'
                       'file.encoding\n'
                       '\n'
                       '   The encoding that this file uses. When Unicode '
                       'strings are written\n'
                       '   to a file, they will be converted to byte strings '
                       'using this\n'
                       '   encoding. In addition, when the file is connected '
                       'to a terminal,\n'
                       '   the attribute gives the encoding that the terminal '
                       'is likely to use\n'
                       '   (that  information might be incorrect if the user '
                       'has misconfigured\n'
                       '   the  terminal). The attribute is read-only and may '
                       'not be present\n'
                       '   on all file-like objects. It may also be "None", in '
                       'which case the\n'
                       '   file uses the system default encoding for '
                       'converting Unicode\n'
                       '   strings.\n'
                       '\n'
                       '   New in version 2.3.\n'
                       '\n'
                       'file.errors\n'
                       '\n'
                       '   The Unicode error handler used along with the '
                       'encoding.\n'
                       '\n'
                       '   New in version 2.6.\n'
                       '\n'
                       'file.mode\n'
                       '\n'
                       '   The I/O mode for the file.  If the file was created '
                       'using the\n'
                       '   "open()" built-in function, this will be the value '
                       'of the *mode*\n'
                       '   parameter.  This is a read-only attribute and may '
                       'not be present on\n'
                       '   all file-like objects.\n'
                       '\n'
                       'file.name\n'
                       '\n'
                       '   If the file object was created using "open()", the '
                       'name of the\n'
                       '   file. Otherwise, some string that indicates the '
                       'source of the file\n'
                       '   object, of the form "<...>".  This is a read-only '
                       'attribute and may\n'
                       '   not be present on all file-like objects.\n'
                       '\n'
                       'file.newlines\n'
                       '\n'
                       '   If Python was built with *universal newlines* '
                       'enabled (the default)\n'
                       '   this read-only attribute exists, and for files '
                       'opened in universal\n'
                       '   newline read mode it keeps track of the types of '
                       'newlines\n'
                       '   encountered while reading the file. The values it '
                       'can take are\n'
                       '   "\'\\r\'", "\'\\n\'", "\'\\r\\n\'", "None" '
                       '(unknown, no newlines read yet) or\n'
                       '   a tuple containing all the newline types seen, to '
                       'indicate that\n'
                       '   multiple newline conventions were encountered. For '
                       'files not opened\n'
                       '   in universal newlines read mode the value of this '
                       'attribute will be\n'
                       '   "None".\n'
                       '\n'
                       'file.softspace\n'
                       '\n'
                       '   Boolean that indicates whether a space character '
                       'needs to be\n'
                       '   printed before another value when using the "print" '
                       'statement.\n'
                       '   Classes that are trying to simulate a file object '
                       'should also have\n'
                       '   a writable "softspace" attribute, which should be '
                       'initialized to\n'
                       '   zero.  This will be automatic for most classes '
                       'implemented in\n'
                       '   Python (care may be needed for objects that '
                       'override attribute\n'
                       '   access); types implemented in C will have to '
                       'provide a writable\n'
                       '   "softspace" attribute.\n'
                       '\n'
                       '   Note: This attribute is not used to control the '
                       '"print"\n'
                       '     statement, but to allow the implementation of '
                       '"print" to keep\n'
                       '     track of its internal state.\n',
 'bltin-null-object': '\n'
                      'The Null Object\n'
                      '***************\n'
                      '\n'
                      "This object is returned by functions that don't "
                      'explicitly return a\n'
                      'value.  It supports no special operations.  There is '
                      'exactly one null\n'
                      'object, named "None" (a built-in name).\n'
                      '\n'
                      'It is written as "None".\n',
 'bltin-type-objects': '\n'
                       'Type Objects\n'
                       '************\n'
                       '\n'
                       'Type objects represent the various object types.  An '
                       "object's type is\n"
                       'accessed by the built-in function "type()".  There are '
                       'no special\n'
                       'operations on types.  The standard module "types" '
                       'defines names for\n'
                       'all standard built-in types.\n'
                       '\n'
                       'Types are written like this: "<type \'int\'>".\n',
 'booleans': '\n'
             'Boolean operations\n'
             '******************\n'
             '\n'
             '   or_test  ::= and_test | or_test "or" and_test\n'
             '   and_test ::= not_test | and_test "and" not_test\n'
             '   not_test ::= comparison | "not" not_test\n'
             '\n'
             'In the context of Boolean operations, and also when expressions '
             'are\n'
             'used by control flow statements, the following values are '
             'interpreted\n'
             'as false: "False", "None", numeric zero of all types, and empty\n'
             'strings and containers (including strings, tuples, lists,\n'
             'dictionaries, sets and frozensets).  All other values are '
             'interpreted\n'
             'as true.  (See the "__nonzero__()" special method for a way to '
             'change\n'
             'this.)\n'
             '\n'
             'The operator "not" yields "True" if its argument is false, '
             '"False"\n'
             'otherwise.\n'
             '\n'
             'The expression "x and y" first evaluates *x*; if *x* is false, '
             'its\n'
             'value is returned; otherwise, *y* is evaluated and the resulting '
             'value\n'
             'is returned.\n'
             '\n'
             'The expression "x or y" first evaluates *x*; if *x* is true, its '
             'value\n'
             'is returned; otherwise, *y* is evaluated and the resulting value '
             'is\n'
             'returned.\n'
             '\n'
             '(Note that neither "and" nor "or" restrict the value and type '
             'they\n'
             'return to "False" and "True", but rather return the last '
             'evaluated\n'
             'argument. This is sometimes useful, e.g., if "s" is a string '
             'that\n'
             'should be replaced by a default value if it is empty, the '
             'expression\n'
             '"s or \'foo\'" yields the desired value.  Because "not" has to '
             'invent a\n'
             'value anyway, it does not bother to return a value of the same '
             'type as\n'
             'its argument, so e.g., "not \'foo\'" yields "False", not '
             '"\'\'".)\n',
 'break': '\n'
          'The "break" statement\n'
          '*********************\n'
          '\n'
          '   break_stmt ::= "break"\n'
          '\n'
          '"break" may only occur syntactically nested in a "for" or "while"\n'
          'loop, but not nested in a function or class definition within that\n'
          'loop.\n'
          '\n'
          'It terminates the nearest enclosing loop, skipping the optional '
          '"else"\n'
          'clause if the loop has one.\n'
          '\n'
          'If a "for" loop is terminated by "break", the loop control target\n'
          'keeps its current value.\n'
          '\n'
          'When "break" passes control out of a "try" statement with a '
          '"finally"\n'
          'clause, that "finally" clause is executed before really leaving '
          'the\n'
          'loop.\n',
 'callable-types': '\n'
                   'Emulating callable objects\n'
                   '**************************\n'
                   '\n'
                   'object.__call__(self[, args...])\n'
                   '\n'
                   '   Called when the instance is "called" as a function; if '
                   'this method\n'
                   '   is defined, "x(arg1, arg2, ...)" is a shorthand for\n'
                   '   "x.__call__(arg1, arg2, ...)".\n',
 'calls': '\n'
          'Calls\n'
          '*****\n'
          '\n'
          'A call calls a callable object (e.g., a *function*) with a '
          'possibly\n'
          'empty series of *arguments*:\n'
          '\n'
          '   call                 ::= primary "(" [argument_list [","]\n'
          '            | expression genexpr_for] ")"\n'
          '   argument_list        ::= positional_arguments ["," '
          'keyword_arguments]\n'
          '                       ["," "*" expression] ["," '
          'keyword_arguments]\n'
          '                       ["," "**" expression]\n'
          '                     | keyword_arguments ["," "*" expression]\n'
          '                       ["," "**" expression]\n'
          '                     | "*" expression ["," keyword_arguments] ["," '
          '"**" expression]\n'
          '                     | "**" expression\n'
          '   positional_arguments ::= expression ("," expression)*\n'
          '   keyword_arguments    ::= keyword_item ("," keyword_item)*\n'
          '   keyword_item         ::= identifier "=" expression\n'
          '\n'
          'A trailing comma may be present after the positional and keyword\n'
          'arguments but does not affect the semantics.\n'
          '\n'
          'The primary must evaluate to a callable object (user-defined\n'
          'functions, built-in functions, methods of built-in objects, class\n'
          'objects, methods of class instances, and certain class instances\n'
          'themselves are callable; extensions may define additional callable\n'
          'object types).  All argument expressions are evaluated before the '
          'call\n'
          'is attempted.  Please refer to section Function definitions for '
          'the\n'
          'syntax of formal *parameter* lists.\n'
          '\n'
          'If keyword arguments are present, they are first converted to\n'
          'positional arguments, as follows.  First, a list of unfilled slots '
          'is\n'
          'created for the formal parameters.  If there are N positional\n'
          'arguments, they are placed in the first N slots.  Next, for each\n'
          'keyword argument, the identifier is used to determine the\n'
          'corresponding slot (if the identifier is the same as the first '
          'formal\n'
          'parameter name, the first slot is used, and so on).  If the slot '
          'is\n'
          'already filled, a "TypeError" exception is raised. Otherwise, the\n'
          'value of the argument is placed in the slot, filling it (even if '
          'the\n'
          'expression is "None", it fills the slot).  When all arguments have\n'
          'been processed, the slots that are still unfilled are filled with '
          'the\n'
          'corresponding default value from the function definition.  '
          '(Default\n'
          'values are calculated, once, when the function is defined; thus, a\n'
          'mutable object such as a list or dictionary used as default value '
          'will\n'
          "be shared by all calls that don't specify an argument value for "
          'the\n'
          'corresponding slot; this should usually be avoided.)  If there are '
          'any\n'
          'unfilled slots for which no default value is specified, a '
          '"TypeError"\n'
          'exception is raised.  Otherwise, the list of filled slots is used '
          'as\n'
          'the argument list for the call.\n'
          '\n'
          '**CPython implementation detail:** An implementation may provide\n'
          'built-in functions whose positional parameters do not have names, '
          'even\n'
          "if they are 'named' for the purpose of documentation, and which\n"
          'therefore cannot be supplied by keyword.  In CPython, this is the '
          'case\n'
          'for functions implemented in C that use "PyArg_ParseTuple()" to '
          'parse\n'
          'their arguments.\n'
          '\n'
          'If there are more positional arguments than there are formal '
          'parameter\n'
          'slots, a "TypeError" exception is raised, unless a formal '
          'parameter\n'
          'using the syntax "*identifier" is present; in this case, that '
          'formal\n'
          'parameter receives a tuple containing the excess positional '
          'arguments\n'
          '(or an empty tuple if there were no excess positional arguments).\n'
          '\n'
          'If any keyword argument does not correspond to a formal parameter\n'
          'name, a "TypeError" exception is raised, unless a formal parameter\n'
          'using the syntax "**identifier" is present; in this case, that '
          'formal\n'
          'parameter receives a dictionary containing the excess keyword\n'
          'arguments (using the keywords as keys and the argument values as\n'
          'corresponding values), or a (new) empty dictionary if there were '
          'no\n'
          'excess keyword arguments.\n'
          '\n'
          'If the syntax "*expression" appears in the function call, '
          '"expression"\n'
          'must evaluate to an iterable.  Elements from this iterable are '
          'treated\n'
          'as if they were additional positional arguments; if there are\n'
          'positional arguments *x1*, ..., *xN*, and "expression" evaluates to '
          'a\n'
          'sequence *y1*, ..., *yM*, this is equivalent to a call with M+N\n'
          'positional arguments *x1*, ..., *xN*, *y1*, ..., *yM*.\n'
          '\n'
          'A consequence of this is that although the "*expression" syntax '
          'may\n'
          'appear *after* some keyword arguments, it is processed *before* '
          'the\n'
          'keyword arguments (and the "**expression" argument, if any -- see\n'
          'below).  So:\n'
          '\n'
          '   >>> def f(a, b):\n'
          '   ...     print a, b\n'
          '   ...\n'
          '   >>> f(b=1, *(2,))\n'
          '   2 1\n'
          '   >>> f(a=1, *(2,))\n'
          '   Traceback (most recent call last):\n'
          '     File "<stdin>", line 1, in ?\n'
          "   TypeError: f() got multiple values for keyword argument 'a'\n"
          '   >>> f(1, *(2,))\n'
          '   1 2\n'
          '\n'
          'It is unusual for both keyword arguments and the "*expression" '
          'syntax\n'
          'to be used in the same call, so in practice this confusion does '
          'not\n'
          'arise.\n'
          '\n'
          'If the syntax "**expression" appears in the function call,\n'
          '"expression" must evaluate to a mapping, the contents of which are\n'
          'treated as additional keyword arguments.  In the case of a keyword\n'
          'appearing in both "expression" and as an explicit keyword argument, '
          'a\n'
          '"TypeError" exception is raised.\n'
          '\n'
          'Formal parameters using the syntax "*identifier" or "**identifier"\n'
          'cannot be used as positional argument slots or as keyword argument\n'
          'names.  Formal parameters using the syntax "(sublist)" cannot be '
          'used\n'
          'as keyword argument names; the outermost sublist corresponds to a\n'
          'single unnamed argument slot, and the argument value is assigned '
          'to\n'
          'the sublist using the usual tuple assignment rules after all other\n'
          'parameter processing is done.\n'
          '\n'
          'A call always returns some value, possibly "None", unless it raises '
          'an\n'
          'exception.  How this value is computed depends on the type of the\n'
          'callable object.\n'
          '\n'
          'If it is---\n'
          '\n'
          'a user-defined function:\n'
          '   The code block for the function is executed, passing it the\n'
          '   argument list.  The first thing the code block will do is bind '
          'the\n'
          '   formal parameters to the arguments; this is described in '
          'section\n'
          '   Function definitions.  When the code block executes a "return"\n'
          '   statement, this specifies the return value of the function '
          'call.\n'
          '\n'
          'a built-in function or method:\n'
          '   The result is up to the interpreter; see Built-in Functions for '
          'the\n'
          '   descriptions of built-in functions and methods.\n'
          '\n'
          'a class object:\n'
          '   A new instance of that class is returned.\n'
          '\n'
          'a class instance method:\n'
          '   The corresponding user-defined function is called, with an '
          'argument\n'
          '   list that is one longer than the argument list of the call: the\n'
          '   instance becomes the first argument.\n'
          '\n'
          'a class instance:\n'
          '   The class must define a "__call__()" method; the effect is then '
          'the\n'
          '   same as if that method was called.\n',
 'class': '\n'
          'Class definitions\n'
          '*****************\n'
          '\n'
          'A class definition defines a class object (see section The '
          'standard\n'
          'type hierarchy):\n'
          '\n'
          '   classdef    ::= "class" classname [inheritance] ":" suite\n'
          '   inheritance ::= "(" [expression_list] ")"\n'
          '   classname   ::= identifier\n'
          '\n'
          'A class definition is an executable statement.  It first evaluates '
          'the\n'
          'inheritance list, if present.  Each item in the inheritance list\n'
          'should evaluate to a class object or class type which allows\n'
          "subclassing.  The class's suite is then executed in a new "
          'execution\n'
          'frame (see section Naming and binding), using a newly created '
          'local\n'
          'namespace and the original global namespace. (Usually, the suite\n'
          "contains only function definitions.)  When the class's suite "
          'finishes\n'
          'execution, its execution frame is discarded but its local namespace '
          'is\n'
          'saved. [4] A class object is then created using the inheritance '
          'list\n'
          'for the base classes and the saved local namespace for the '
          'attribute\n'
          'dictionary.  The class name is bound to this class object in the\n'
          'original local namespace.\n'
          '\n'
          "**Programmer's note:** Variables defined in the class definition "
          'are\n'
          'class variables; they are shared by all instances.  To create '
          'instance\n'
          'variables, they can be set in a method with "self.name = value".  '
          'Both\n'
          'class and instance variables are accessible through the notation\n'
          '""self.name"", and an instance variable hides a class variable '
          'with\n'
          'the same name when accessed in this way. Class variables can be '
          'used\n'
          'as defaults for instance variables, but using mutable values there '
          'can\n'
          'lead to unexpected results.  For *new-style class*es, descriptors '
          'can\n'
          'be used to create instance variables with different implementation\n'
          'details.\n'
          '\n'
          'Class definitions, like function definitions, may be wrapped by one '
          'or\n'
          'more *decorator* expressions.  The evaluation rules for the '
          'decorator\n'
          'expressions are the same as for functions.  The result must be a '
          'class\n'
          'object, which is then bound to the class name.\n'
          '\n'
          '-[ Footnotes ]-\n'
          '\n'
          '[1] The exception is propagated to the invocation stack unless\n'
          '    there is a "finally" clause which happens to raise another\n'
          '    exception. That new exception causes the old one to be lost.\n'
          '\n'
          '[2] Currently, control "flows off the end" except in the case of\n'
          '    an exception or the execution of a "return", "continue", or\n'
          '    "break" statement.\n'
          '\n'
          '[3] A string literal appearing as the first statement in the\n'
          '    function body is transformed into the function\'s "__doc__"\n'
          "    attribute and therefore the function's *docstring*.\n"
          '\n'
          '[4] A string literal appearing as the first statement in the class\n'
          '    body is transformed into the namespace\'s "__doc__" item and\n'
          "    therefore the class's *docstring*.\n",
 'comparisons': '\n'
                'Comparisons\n'
                '***********\n'
                '\n'
                'Unlike C, all comparison operations in Python have the same '
                'priority,\n'
                'which is lower than that of any arithmetic, shifting or '
                'bitwise\n'
                'operation.  Also unlike C, expressions like "a < b < c" have '
                'the\n'
                'interpretation that is conventional in mathematics:\n'
                '\n'
                '   comparison    ::= or_expr ( comp_operator or_expr )*\n'
                '   comp_operator ::= "<" | ">" | "==" | ">=" | "<=" | "<>" | '
                '"!="\n'
                '                     | "is" ["not"] | ["not"] "in"\n'
                '\n'
                'Comparisons yield boolean values: "True" or "False".\n'
                '\n'
                'Comparisons can be chained arbitrarily, e.g., "x < y <= z" '
                'is\n'
                'equivalent to "x < y and y <= z", except that "y" is '
                'evaluated only\n'
                'once (but in both cases "z" is not evaluated at all when "x < '
                'y" is\n'
                'found to be false).\n'
                '\n'
                'Formally, if *a*, *b*, *c*, ..., *y*, *z* are expressions and '
                '*op1*,\n'
                '*op2*, ..., *opN* are comparison operators, then "a op1 b op2 '
                'c ... y\n'
                'opN z" is equivalent to "a op1 b and b op2 c and ... y opN '
                'z", except\n'
                'that each expression is evaluated at most once.\n'
                '\n'
                'Note that "a op1 b op2 c" doesn\'t imply any kind of '
                'comparison between\n'
                '*a* and *c*, so that, e.g., "x < y > z" is perfectly legal '
                '(though\n'
                'perhaps not pretty).\n'
                '\n'
                'The forms "<>" and "!=" are equivalent; for consistency with '
                'C, "!="\n'
                'is preferred; where "!=" is mentioned below "<>" is also '
                'accepted.\n'
                'The "<>" spelling is considered obsolescent.\n'
                '\n'
                'The operators "<", ">", "==", ">=", "<=", and "!=" compare '
                'the values\n'
                'of two objects.  The objects need not have the same type. If '
                'both are\n'
                'numbers, they are converted to a common type.  Otherwise, '
                'objects of\n'
                'different types *always* compare unequal, and are ordered '
                'consistently\n'
                'but arbitrarily. You can control comparison behavior of '
                'objects of\n'
                'non-built-in types by defining a "__cmp__" method or rich '
                'comparison\n'
                'methods like "__gt__", described in section Special method '
                'names.\n'
                '\n'
                '(This unusual definition of comparison was used to simplify '
                'the\n'
                'definition of operations like sorting and the "in" and "not '
                'in"\n'
                'operators. In the future, the comparison rules for objects '
                'of\n'
                'different types are likely to change.)\n'
                '\n'
                'Comparison of objects of the same type depends on the type:\n'
                '\n'
                '* Numbers are compared arithmetically.\n'
                '\n'
                '* Strings are compared lexicographically using the numeric\n'
                '  equivalents (the result of the built-in function "ord()") '
                'of their\n'
                '  characters. Unicode and 8-bit strings are fully '
                'interoperable in\n'
                '  this behavior. [4]\n'
                '\n'
                '* Tuples and lists are compared lexicographically using '
                'comparison\n'
                '  of corresponding elements.  This means that to compare '
                'equal, each\n'
                '  element must compare equal and the two sequences must be of '
                'the same\n'
                '  type and have the same length.\n'
                '\n'
                '  If not equal, the sequences are ordered the same as their '
                'first\n'
                '  differing elements.  For example, "cmp([1,2,x], [1,2,y])" '
                'returns\n'
                '  the same as "cmp(x,y)".  If the corresponding element does '
                'not\n'
                '  exist, the shorter sequence is ordered first (for example, '
                '"[1,2] <\n'
                '  [1,2,3]").\n'
                '\n'
                '* Mappings (dictionaries) compare equal if and only if their '
                'sorted\n'
                '  (key, value) lists compare equal. [5] Outcomes other than '
                'equality\n'
                '  are resolved consistently, but are not otherwise defined. '
                '[6]\n'
                '\n'
                '* Most other objects of built-in types compare unequal unless '
                'they\n'
                '  are the same object; the choice whether one object is '
                'considered\n'
                '  smaller or larger than another one is made arbitrarily but\n'
                '  consistently within one execution of a program.\n'
                '\n'
                'The operators "in" and "not in" test for collection '
                'membership.  "x in\n'
                's" evaluates to true if *x* is a member of the collection '
                '*s*, and\n'
                'false otherwise.  "x not in s" returns the negation of "x in '
                's". The\n'
                'collection membership test has traditionally been bound to '
                'sequences;\n'
                'an object is a member of a collection if the collection is a '
                'sequence\n'
                'and contains an element equal to that object.  However, it '
                'make sense\n'
                'for many other object types to support membership tests '
                'without being\n'
                'a sequence.  In particular, dictionaries (for keys) and sets '
                'support\n'
                'membership testing.\n'
                '\n'
                'For the list and tuple types, "x in y" is true if and only if '
                'there\n'
                'exists an index *i* such that either "x is y[i]" or "x == '
                'y[i]" is\n'
                'true.\n'
                '\n'
                'For the Unicode and string types, "x in y" is true if and '
                'only if *x*\n'
                'is a substring of *y*.  An equivalent test is "y.find(x) != '
                '-1".\n'
                'Note, *x* and *y* need not be the same type; consequently, '
                '"u\'ab\' in\n'
                '\'abc\'" will return "True". Empty strings are always '
                'considered to be a\n'
                'substring of any other string, so """ in "abc"" will return '
                '"True".\n'
                '\n'
                'Changed in version 2.3: Previously, *x* was required to be a '
                'string of\n'
                'length "1".\n'
                '\n'
                'For user-defined classes which define the "__contains__()" '
                'method, "x\n'
                'in y" is true if and only if "y.__contains__(x)" is true.\n'
                '\n'
                'For user-defined classes which do not define "__contains__()" '
                'but do\n'
                'define "__iter__()", "x in y" is true if some value "z" with '
                '"x == z"\n'
                'is produced while iterating over "y".  If an exception is '
                'raised\n'
                'during the iteration, it is as if "in" raised that '
                'exception.\n'
                '\n'
                'Lastly, the old-style iteration protocol is tried: if a class '
                'defines\n'
                '"__getitem__()", "x in y" is true if and only if there is a '
                'non-\n'
                'negative integer index *i* such that "x == y[i]", and all '
                'lower\n'
                'integer indices do not raise "IndexError" exception. (If any '
                'other\n'
                'exception is raised, it is as if "in" raised that '
                'exception).\n'
                '\n'
                'The operator "not in" is defined to have the inverse true '
                'value of\n'
                '"in".\n'
                '\n'
                'The operators "is" and "is not" test for object identity: "x '
                'is y" is\n'
                'true if and only if *x* and *y* are the same object.  "x is '
                'not y"\n'
                'yields the inverse truth value. [7]\n',
 'compound': '\n'
             'Compound statements\n'
             '*******************\n'
             '\n'
             'Compound statements contain (groups of) other statements; they '
             'affect\n'
             'or control the execution of those other statements in some way.  '
             'In\n'
             'general, compound statements span multiple lines, although in '
             'simple\n'
             'incarnations a whole compound statement may be contained in one '
             'line.\n'
             '\n'
             'The "if", "while" and "for" statements implement traditional '
             'control\n'
             'flow constructs.  "try" specifies exception handlers and/or '
             'cleanup\n'
             'code for a group of statements.  Function and class definitions '
             'are\n'
             'also syntactically compound statements.\n'
             '\n'
             "Compound statements consist of one or more 'clauses.'  A clause\n"
             "consists of a header and a 'suite.'  The clause headers of a\n"
             'particular compound statement are all at the same indentation '
             'level.\n'
             'Each clause header begins with a uniquely identifying keyword '
             'and ends\n'
             'with a colon.  A suite is a group of statements controlled by a\n'
             'clause.  A suite can be one or more semicolon-separated simple\n'
             'statements on the same line as the header, following the '
             "header's\n"
             'colon, or it can be one or more indented statements on '
             'subsequent\n'
             'lines.  Only the latter form of suite can contain nested '
             'compound\n'
             "statements; the following is illegal, mostly because it wouldn't "
             'be\n'
             'clear to which "if" clause a following "else" clause would '
             'belong:\n'
             '\n'
             '   if test1: if test2: print x\n'
             '\n'
             'Also note that the semicolon binds tighter than the colon in '
             'this\n'
             'context, so that in the following example, either all or none of '
             'the\n'
             '"print" statements are executed:\n'
             '\n'
             '   if x < y < z: print x; print y; print z\n'
             '\n'
             'Summarizing:\n'
             '\n'
             '   compound_stmt ::= if_stmt\n'
             '                     | while_stmt\n'
             '                     | for_stmt\n'
             '                     | try_stmt\n'
             '                     | with_stmt\n'
             '                     | funcdef\n'
             '                     | classdef\n'
             '                     | decorated\n'
             '   suite         ::= stmt_list NEWLINE | NEWLINE INDENT '
             'statement+ DEDENT\n'
             '   statement     ::= stmt_list NEWLINE | compound_stmt\n'
             '   stmt_list     ::= simple_stmt (";" simple_stmt)* [";"]\n'
             '\n'
             'Note that statements always end in a "NEWLINE" possibly followed '
             'by a\n'
             '"DEDENT". Also note that optional continuation clauses always '
             'begin\n'
             'with a keyword that cannot start a statement, thus there are no\n'
             'ambiguities (the \'dangling "else"\' problem is solved in Python '
             'by\n'
             'requiring nested "if" statements to be indented).\n'
             '\n'
             'The formatting of the grammar rules in the following sections '
             'places\n'
             'each clause on a separate line for clarity.\n'
             '\n'
             '\n'
             'The "if" statement\n'
             '==================\n'
             '\n'
             'The "if" statement is used for conditional execution:\n'
             '\n'
             '   if_stmt ::= "if" expression ":" suite\n'
             '               ( "elif" expression ":" suite )*\n'
             '               ["else" ":" suite]\n'
             '\n'
             'It selects exactly one of the suites by evaluating the '
             'expressions one\n'
             'by one until one is found to be true (see section Boolean '
             'operations\n'
             'for the definition of true and false); then that suite is '
             'executed\n'
             '(and no other part of the "if" statement is executed or '
             'evaluated).\n'
             'If all expressions are false, the suite of the "else" clause, '
             'if\n'
             'present, is executed.\n'
             '\n'
             '\n'
             'The "while" statement\n'
             '=====================\n'
             '\n'
             'The "while" statement is used for repeated execution as long as '
             'an\n'
             'expression is true:\n'
             '\n'
             '   while_stmt ::= "while" expression ":" suite\n'
             '                  ["else" ":" suite]\n'
             '\n'
             'This repeatedly tests the expression and, if it is true, '
             'executes the\n'
             'first suite; if the expression is false (which may be the first '
             'time\n'
             'it is tested) the suite of the "else" clause, if present, is '
             'executed\n'
             'and the loop terminates.\n'
             '\n'
             'A "break" statement executed in the first suite terminates the '
             'loop\n'
             'without executing the "else" clause\'s suite.  A "continue" '
             'statement\n'
             'executed in the first suite skips the rest of the suite and goes '
             'back\n'
             'to testing the expression.\n'
             '\n'
             '\n'
             'The "for" statement\n'
             '===================\n'
             '\n'
             'The "for" statement is used to iterate over the elements of a '
             'sequence\n'
             '(such as a string, tuple or list) or other iterable object:\n'
             '\n'
             '   for_stmt ::= "for" target_list "in" expression_list ":" '
             'suite\n'
             '                ["else" ":" suite]\n'
             '\n'
             'The expression list is evaluated once; it should yield an '
             'iterable\n'
             'object.  An iterator is created for the result of the\n'
             '"expression_list".  The suite is then executed once for each '
             'item\n'
             'provided by the iterator, in the order of ascending indices.  '
             'Each\n'
             'item in turn is assigned to the target list using the standard '
             'rules\n'
             'for assignments, and then the suite is executed.  When the items '
             'are\n'
             'exhausted (which is immediately when the sequence is empty), the '
             'suite\n'
             'in the "else" clause, if present, is executed, and the loop\n'
             'terminates.\n'
             '\n'
             'A "break" statement executed in the first suite terminates the '
             'loop\n'
             'without executing the "else" clause\'s suite.  A "continue" '
             'statement\n'
             'executed in the first suite skips the rest of the suite and '
             'continues\n'
             'with the next item, or with the "else" clause if there was no '
             'next\n'
             'item.\n'
             '\n'
             'The suite may assign to the variable(s) in the target list; this '
             'does\n'
             'not affect the next item assigned to it.\n'
             '\n'
             'The target list is not deleted when the loop is finished, but if '
             'the\n'
             'sequence is empty, it will not have been assigned to at all by '
             'the\n'
             'loop.  Hint: the built-in function "range()" returns a sequence '
             'of\n'
             'integers suitable to emulate the effect of Pascal\'s "for i := a '
             'to b\n'
             'do"; e.g., "range(3)" returns the list "[0, 1, 2]".\n'
             '\n'
             'Note: There is a subtlety when the sequence is being modified by '
             'the\n'
             '  loop (this can only occur for mutable sequences, i.e. lists). '
             'An\n'
             '  internal counter is used to keep track of which item is used '
             'next,\n'
             '  and this is incremented on each iteration.  When this counter '
             'has\n'
             '  reached the length of the sequence the loop terminates.  This '
             'means\n'
             '  that if the suite deletes the current (or a previous) item '
             'from the\n'
             '  sequence, the next item will be skipped (since it gets the '
             'index of\n'
             '  the current item which has already been treated).  Likewise, '
             'if the\n'
             '  suite inserts an item in the sequence before the current item, '
             'the\n'
             '  current item will be treated again the next time through the '
             'loop.\n'
             '  This can lead to nasty bugs that can be avoided by making a\n'
             '  temporary copy using a slice of the whole sequence, e.g.,\n'
             '\n'
             '     for x in a[:]:\n'
             '         if x < 0: a.remove(x)\n'
             '\n'
             '\n'
             'The "try" statement\n'
             '===================\n'
             '\n'
             'The "try" statement specifies exception handlers and/or cleanup '
             'code\n'
             'for a group of statements:\n'
             '\n'
             '   try_stmt  ::= try1_stmt | try2_stmt\n'
             '   try1_stmt ::= "try" ":" suite\n'
             '                 ("except" [expression [("as" | ",") '
             'identifier]] ":" suite)+\n'
             '                 ["else" ":" suite]\n'
             '                 ["finally" ":" suite]\n'
             '   try2_stmt ::= "try" ":" suite\n'
             '                 "finally" ":" suite\n'
             '\n'
             'Changed in version 2.5: In previous versions of Python,\n'
             '"try"..."except"..."finally" did not work. "try"..."except" had '
             'to be\n'
             'nested in "try"..."finally".\n'
             '\n'
             'The "except" clause(s) specify one or more exception handlers. '
             'When no\n'
             'exception occurs in the "try" clause, no exception handler is\n'
             'executed. When an exception occurs in the "try" suite, a search '
             'for an\n'
             'exception handler is started.  This search inspects the except '
             'clauses\n'
             'in turn until one is found that matches the exception.  An '
             'expression-\n'
             'less except clause, if present, must be last; it matches any\n'
             'exception.  For an except clause with an expression, that '
             'expression\n'
             'is evaluated, and the clause matches the exception if the '
             'resulting\n'
             'object is "compatible" with the exception.  An object is '
             'compatible\n'
             'with an exception if it is the class or a base class of the '
             'exception\n'
             'object, or a tuple containing an item compatible with the '
             'exception.\n'
             '\n'
             'If no except clause matches the exception, the search for an '
             'exception\n'
             'handler continues in the surrounding code and on the invocation '
             'stack.\n'
             '[1]\n'
             '\n'
             'If the evaluation of an expression in the header of an except '
             'clause\n'
             'raises an exception, the original search for a handler is '
             'canceled and\n'
             'a search starts for the new exception in the surrounding code '
             'and on\n'
             'the call stack (it is treated as if the entire "try" statement '
             'raised\n'
             'the exception).\n'
             '\n'
             'When a matching except clause is found, the exception is '
             'assigned to\n'
             'the target specified in that except clause, if present, and the '
             'except\n'
             "clause's suite is executed.  All except clauses must have an\n"
             'executable block.  When the end of this block is reached, '
             'execution\n'
             'continues normally after the entire try statement.  (This means '
             'that\n'
             'if two nested handlers exist for the same exception, and the '
             'exception\n'
             'occurs in the try clause of the inner handler, the outer handler '
             'will\n'
             'not handle the exception.)\n'
             '\n'
             "Before an except clause's suite is executed, details about the\n"
             'exception are assigned to three variables in the "sys" module:\n'
             '"sys.exc_type" receives the object identifying the exception;\n'
             '"sys.exc_value" receives the exception\'s parameter;\n'
             '"sys.exc_traceback" receives a traceback object (see section '
             'The\n'
             'standard type hierarchy) identifying the point in the program '
             'where\n'
             'the exception occurred. These details are also available through '
             'the\n'
             '"sys.exc_info()" function, which returns a tuple "(exc_type,\n'
             'exc_value, exc_traceback)".  Use of the corresponding variables '
             'is\n'
             'deprecated in favor of this function, since their use is unsafe '
             'in a\n'
             'threaded program.  As of Python 1.5, the variables are restored '
             'to\n'
             'their previous values (before the call) when returning from a '
             'function\n'
             'that handled an exception.\n'
             '\n'
             'The optional "else" clause is executed if and when control flows '
             'off\n'
             'the end of the "try" clause. [2] Exceptions in the "else" clause '
             'are\n'
             'not handled by the preceding "except" clauses.\n'
             '\n'
             'If "finally" is present, it specifies a \'cleanup\' handler.  '
             'The "try"\n'
             'clause is executed, including any "except" and "else" clauses.  '
             'If an\n'
             'exception occurs in any of the clauses and is not handled, the\n'
             'exception is temporarily saved. The "finally" clause is '
             'executed.  If\n'
             'there is a saved exception, it is re-raised at the end of the\n'
             '"finally" clause. If the "finally" clause raises another '
             'exception or\n'
             'executes a "return" or "break" statement, the saved exception '
             'is\n'
             'discarded:\n'
             '\n'
             '   >>> def f():\n'
             '   ...     try:\n'
             '   ...         1/0\n'
             '   ...     finally:\n'
             '   ...         return 42\n'
             '   ...\n'
             '   >>> f()\n'
             '   42\n'
             '\n'
             'The exception information is not available to the program '
             'during\n'
             'execution of the "finally" clause.\n'
             '\n'
             'When a "return", "break" or "continue" statement is executed in '
             'the\n'
             '"try" suite of a "try"..."finally" statement, the "finally" '
             'clause is\n'
             'also executed \'on the way out.\' A "continue" statement is '
             'illegal in\n'
             'the "finally" clause. (The reason is a problem with the current\n'
             'implementation --- this restriction may be lifted in the '
             'future).\n'
             '\n'
             'The return value of a function is determined by the last '
             '"return"\n'
             'statement executed.  Since the "finally" clause always executes, '
             'a\n'
             '"return" statement executed in the "finally" clause will always '
             'be the\n'
             'last one executed:\n'
             '\n'
             '   >>> def foo():\n'
             '   ...     try:\n'
             "   ...         return 'try'\n"
             '   ...     finally:\n'
             "   ...         return 'finally'\n"
             '   ...\n'
             '   >>> foo()\n'
             "   'finally'\n"
             '\n'
             'Additional information on exceptions can be found in section\n'
             'Exceptions, and information on using the "raise" statement to '
             'generate\n'
             'exceptions may be found in section The raise statement.\n'
             '\n'
             '\n'
             'The "with" statement\n'
             '====================\n'
             '\n'
             'New in version 2.5.\n'
             '\n'
             'The "with" statement is used to wrap the execution of a block '
             'with\n'
             'methods defined by a context manager (see section With '
             'Statement\n'
             'Context Managers). This allows common '
             '"try"..."except"..."finally"\n'
             'usage patterns to be encapsulated for convenient reuse.\n'
             '\n'
             '   with_stmt ::= "with" with_item ("," with_item)* ":" suite\n'
             '   with_item ::= expression ["as" target]\n'
             '\n'
             'The execution of the "with" statement with one "item" proceeds '
             'as\n'
             'follows:\n'
             '\n'
             '1. The context expression (the expression given in the '
             '"with_item")\n'
             '   is evaluated to obtain a context manager.\n'
             '\n'
             '2. The context manager\'s "__exit__()" is loaded for later use.\n'
             '\n'
             '3. The context manager\'s "__enter__()" method is invoked.\n'
             '\n'
             '4. If a target was included in the "with" statement, the return\n'
             '   value from "__enter__()" is assigned to it.\n'
             '\n'
             '   Note: The "with" statement guarantees that if the '
             '"__enter__()"\n'
             '     method returns without an error, then "__exit__()" will '
             'always be\n'
             '     called. Thus, if an error occurs during the assignment to '
             'the\n'
             '     target list, it will be treated the same as an error '
             'occurring\n'
             '     within the suite would be. See step 6 below.\n'
             '\n'
             '5. The suite is executed.\n'
             '\n'
             '6. The context manager\'s "__exit__()" method is invoked. If an\n'
             '   exception caused the suite to be exited, its type, value, '
             'and\n'
             '   traceback are passed as arguments to "__exit__()". Otherwise, '
             'three\n'
             '   "None" arguments are supplied.\n'
             '\n'
             '   If the suite was exited due to an exception, and the return '
             'value\n'
             '   from the "__exit__()" method was false, the exception is '
             'reraised.\n'
             '   If the return value was true, the exception is suppressed, '
             'and\n'
             '   execution continues with the statement following the "with"\n'
             '   statement.\n'
             '\n'
             '   If the suite was exited for any reason other than an '
             'exception, the\n'
             '   return value from "__exit__()" is ignored, and execution '
             'proceeds\n'
             '   at the normal location for the kind of exit that was taken.\n'
             '\n'
             'With more than one item, the context managers are processed as '
             'if\n'
             'multiple "with" statements were nested:\n'
             '\n'
             '   with A() as a, B() as b:\n'
             '       suite\n'
             '\n'
             'is equivalent to\n'
             '\n'
             '   with A() as a:\n'
             '       with B() as b:\n'
             '           suite\n'
             '\n'
             'Note: In Python 2.5, the "with" statement is only allowed when '
             'the\n'
             '  "with_statement" feature has been enabled.  It is always '
             'enabled in\n'
             '  Python 2.6.\n'
             '\n'
             'Changed in version 2.7: Support for multiple context '
             'expressions.\n'
             '\n'
             'See also:\n'
             '\n'
             '  **PEP 343** - The "with" statement\n'
             '     The specification, background, and examples for the Python '
             '"with"\n'
             '     statement.\n'
             '\n'
             '\n'
             'Function definitions\n'
             '====================\n'
             '\n'
             'A function definition defines a user-defined function object '
             '(see\n'
             'section The standard type hierarchy):\n'
             '\n'
             '   decorated      ::= decorators (classdef | funcdef)\n'
             '   decorators     ::= decorator+\n'
             '   decorator      ::= "@" dotted_name ["(" [argument_list [","]] '
             '")"] NEWLINE\n'
             '   funcdef        ::= "def" funcname "(" [parameter_list] ")" '
             '":" suite\n'
             '   dotted_name    ::= identifier ("." identifier)*\n'
             '   parameter_list ::= (defparameter ",")*\n'
             '                      (  "*" identifier ["," "**" identifier]\n'
             '                      | "**" identifier\n'
             '                      | defparameter [","] )\n'
             '   defparameter   ::= parameter ["=" expression]\n'
             '   sublist        ::= parameter ("," parameter)* [","]\n'
             '   parameter      ::= identifier | "(" sublist ")"\n'
             '   funcname       ::= identifier\n'
             '\n'
             'A function definition is an executable statement.  Its execution '
             'binds\n'
             'the function name in the current local namespace to a function '
             'object\n'
             '(a wrapper around the executable code for the function).  This\n'
             'function object contains a reference to the current global '
             'namespace\n'
             'as the global namespace to be used when the function is called.\n'
             '\n'
             'The function definition does not execute the function body; this '
             'gets\n'
             'executed only when the function is called. [3]\n'
             '\n'
             'A function definition may be wrapped by one or more *decorator*\n'
             'expressions. Decorator expressions are evaluated when the '
             'function is\n'
             'defined, in the scope that contains the function definition.  '
             'The\n'
             'result must be a callable, which is invoked with the function '
             'object\n'
             'as the only argument. The returned value is bound to the '
             'function name\n'
             'instead of the function object.  Multiple decorators are applied '
             'in\n'
             'nested fashion. For example, the following code:\n'
             '\n'
             '   @f1(arg)\n'
             '   @f2\n'
             '   def func(): pass\n'
             '\n'
             'is equivalent to:\n'
             '\n'
             '   def func(): pass\n'
             '   func = f1(arg)(f2(func))\n'
             '\n'
             'When one or more top-level *parameters* have the form '
             '*parameter* "="\n'
             '*expression*, the function is said to have "default parameter '
             'values."\n'
             'For a parameter with a default value, the corresponding '
             '*argument* may\n'
             "be omitted from a call, in which case the parameter's default "
             'value is\n'
             'substituted.  If a parameter has a default value, all following\n'
             'parameters must also have a default value --- this is a '
             'syntactic\n'
             'restriction that is not expressed by the grammar.\n'
             '\n'
             '**Default parameter values are evaluated when the function '
             'definition\n'
             'is executed.**  This means that the expression is evaluated '
             'once, when\n'
             'the function is defined, and that the same "pre-computed" value '
             'is\n'
             'used for each call.  This is especially important to understand '
             'when a\n'
             'default parameter is a mutable object, such as a list or a '
             'dictionary:\n'
             'if the function modifies the object (e.g. by appending an item '
             'to a\n'
             'list), the default value is in effect modified. This is '
             'generally not\n'
             'what was intended.  A way around this  is to use "None" as the\n'
             'default, and explicitly test for it in the body of the function, '
             'e.g.:\n'
             '\n'
             '   def whats_on_the_telly(penguin=None):\n'
             '       if penguin is None:\n'
             '           penguin = []\n'
             '       penguin.append("property of the zoo")\n'
             '       return penguin\n'
             '\n'
             'Function call semantics are described in more detail in section '
             'Calls.\n'
             'A function call always assigns values to all parameters '
             'mentioned in\n'
             'the parameter list, either from position arguments, from '
             'keyword\n'
             'arguments, or from default values.  If the form ""*identifier"" '
             'is\n'
             'present, it is initialized to a tuple receiving any excess '
             'positional\n'
             'parameters, defaulting to the empty tuple.  If the form\n'
             '""**identifier"" is present, it is initialized to a new '
             'dictionary\n'
             'receiving any excess keyword arguments, defaulting to a new '
             'empty\n'
             'dictionary.\n'
             '\n'
             'It is also possible to create anonymous functions (functions not '
             'bound\n'
             'to a name), for immediate use in expressions.  This uses lambda\n'
             'expressions, described in section Lambdas.  Note that the '
             'lambda\n'
             'expression is merely a shorthand for a simplified function '
             'definition;\n'
             'a function defined in a ""def"" statement can be passed around '
             'or\n'
             'assigned to another name just like a function defined by a '
             'lambda\n'
             'expression.  The ""def"" form is actually more powerful since '
             'it\n'
             'allows the execution of multiple statements.\n'
             '\n'
             "**Programmer's note:** Functions are first-class objects.  A "
             '""def""\n'
             'form executed inside a function definition defines a local '
             'function\n'
             'that can be returned or passed around.  Free variables used in '
             'the\n'
             'nested function can access the local variables of the function\n'
             'containing the def.  See section Naming and binding for '
             'details.\n'
             '\n'
             '\n'
             'Class definitions\n'
             '=================\n'
             '\n'
             'A class definition defines a class object (see section The '
             'standard\n'
             'type hierarchy):\n'
             '\n'
             '   classdef    ::= "class" classname [inheritance] ":" suite\n'
             '   inheritance ::= "(" [expression_list] ")"\n'
             '   classname   ::= identifier\n'
             '\n'
             'A class definition is an executable statement.  It first '
             'evaluates the\n'
             'inheritance list, if present.  Each item in the inheritance '
             'list\n'
             'should evaluate to a class object or class type which allows\n'
             "subclassing.  The class's suite is then executed in a new "
             'execution\n'
             'frame (see section Naming and binding), using a newly created '
             'local\n'
             'namespace and the original global namespace. (Usually, the '
             'suite\n'
             "contains only function definitions.)  When the class's suite "
             'finishes\n'
             'execution, its execution frame is discarded but its local '
             'namespace is\n'
             'saved. [4] A class object is then created using the inheritance '
             'list\n'
             'for the base classes and the saved local namespace for the '
             'attribute\n'
             'dictionary.  The class name is bound to this class object in '
             'the\n'
             'original local namespace.\n'
             '\n'
             "**Programmer's note:** Variables defined in the class definition "
             'are\n'
             'class variables; they are shared by all instances.  To create '
             'instance\n'
             'variables, they can be set in a method with "self.name = '
             'value".  Both\n'
             'class and instance variables are accessible through the '
             'notation\n'
             '""self.name"", and an instance variable hides a class variable '
             'with\n'
             'the same name when accessed in this way. Class variables can be '
             'used\n'
             'as defaults for instance variables, but using mutable values '
             'there can\n'
             'lead to unexpected results.  For *new-style class*es, '
             'descriptors can\n'
             'be used to create instance variables with different '
             'implementation\n'
             'details.\n'
             '\n'
             'Class definitions, like function definitions, may be wrapped by '
             'one or\n'
             'more *decorator* expressions.  The evaluation rules for the '
             'decorator\n'
             'expressions are the same as for functions.  The result must be a '
             'class\n'
             'object, which is then bound to the class name.\n'
             '\n'
             '-[ Footnotes ]-\n'
             '\n'
             '[1] The exception is propagated to the invocation stack unless\n'
             '    there is a "finally" clause which happens to raise another\n'
             '    exception. That new exception causes the old one to be '
             'lost.\n'
             '\n'
             '[2] Currently, control "flows off the end" except in the case '
             'of\n'
             '    an exception or the execution of a "return", "continue", or\n'
             '    "break" statement.\n'
             '\n'
             '[3] A string literal appearing as the first statement in the\n'
             '    function body is transformed into the function\'s "__doc__"\n'
             "    attribute and therefore the function's *docstring*.\n"
             '\n'
             '[4] A string literal appearing as the first statement in the '
             'class\n'
             '    body is transformed into the namespace\'s "__doc__" item '
             'and\n'
             "    therefore the class's *docstring*.\n",
 'context-managers': '\n'
                     'With Statement Context Managers\n'
                     '*******************************\n'
                     '\n'
                     'New in version 2.5.\n'
                     '\n'
                     'A *context manager* is an object that defines the '
                     'runtime context to\n'
                     'be established when executing a "with" statement. The '
                     'context manager\n'
                     'handles the entry into, and the exit from, the desired '
                     'runtime context\n'
                     'for the execution of the block of code.  Context '
                     'managers are normally\n'
                     'invoked using the "with" statement (described in section '
                     'The with\n'
                     'statement), but can also be used by directly invoking '
                     'their methods.\n'
                     '\n'
                     'Typical uses of context managers include saving and '
                     'restoring various\n'
                     'kinds of global state, locking and unlocking resources, '
                     'closing opened\n'
                     'files, etc.\n'
                     '\n'
                     'For more information on context managers, see Context '
                     'Manager Types.\n'
                     '\n'
                     'object.__enter__(self)\n'
                     '\n'
                     '   Enter the runtime context related to this object. The '
                     '"with"\n'
                     "   statement will bind this method's return value to the "
                     'target(s)\n'
                     '   specified in the "as" clause of the statement, if '
                     'any.\n'
                     '\n'
                     'object.__exit__(self, exc_type, exc_value, traceback)\n'
                     '\n'
                     '   Exit the runtime context related to this object. The '
                     'parameters\n'
                     '   describe the exception that caused the context to be '
                     'exited. If the\n'
                     '   context was exited without an exception, all three '
                     'arguments will\n'
                     '   be "None".\n'
                     '\n'
                     '   If an exception is supplied, and the method wishes to '
                     'suppress the\n'
                     '   exception (i.e., prevent it from being propagated), '
                     'it should\n'
                     '   return a true value. Otherwise, the exception will be '
                     'processed\n'
                     '   normally upon exit from this method.\n'
                     '\n'
                     '   Note that "__exit__()" methods should not reraise the '
                     'passed-in\n'
                     "   exception; this is the caller's responsibility.\n"
                     '\n'
                     'See also:\n'
                     '\n'
                     '  **PEP 343** - The "with" statement\n'
                     '     The specification, background, and examples for the '
                     'Python "with"\n'
                     '     statement.\n',
 'continue': '\n'
             'The "continue" statement\n'
             '************************\n'
             '\n'
             '   continue_stmt ::= "continue"\n'
             '\n'
             '"continue" may only occur syntactically nested in a "for" or '
             '"while"\n'
             'loop, but not nested in a function or class definition or '
             '"finally"\n'
             'clause within that loop.  It continues with the next cycle of '
             'the\n'
             'nearest enclosing loop.\n'
             '\n'
             'When "continue" passes control out of a "try" statement with a\n'
             '"finally" clause, that "finally" clause is executed before '
             'really\n'
             'starting the next loop cycle.\n',
 'conversions': '\n'
                'Arithmetic conversions\n'
                '**********************\n'
                '\n'
                'When a description of an arithmetic operator below uses the '
                'phrase\n'
                '"the numeric arguments are converted to a common type," the '
                'arguments\n'
                'are coerced using the coercion rules listed at  Coercion '
                'rules.  If\n'
                'both arguments are standard numeric types, the following '
                'coercions are\n'
                'applied:\n'
                '\n'
                '* If either argument is a complex number, the other is '
                'converted to\n'
                '  complex;\n'
                '\n'
                '* otherwise, if either argument is a floating point number, '
                'the\n'
                '  other is converted to floating point;\n'
                '\n'
                '* otherwise, if either argument is a long integer, the other '
                'is\n'
                '  converted to long integer;\n'
                '\n'
                '* otherwise, both must be plain integers and no conversion '
                'is\n'
                '  necessary.\n'
                '\n'
                'Some additional rules apply for certain operators (e.g., a '
                'string left\n'
                "argument to the '%' operator). Extensions can define their "
                'own\n'
                'coercions.\n',
 'customization': '\n'
                  'Basic customization\n'
                  '*******************\n'
                  '\n'
                  'object.__new__(cls[, ...])\n'
                  '\n'
                  '   Called to create a new instance of class *cls*.  '
                  '"__new__()" is a\n'
                  '   static method (special-cased so you need not declare it '
                  'as such)\n'
                  '   that takes the class of which an instance was requested '
                  'as its\n'
                  '   first argument.  The remaining arguments are those '
                  'passed to the\n'
                  '   object constructor expression (the call to the class).  '
                  'The return\n'
                  '   value of "__new__()" should be the new object instance '
                  '(usually an\n'
                  '   instance of *cls*).\n'
                  '\n'
                  '   Typical implementations create a new instance of the '
                  'class by\n'
                  '   invoking the superclass\'s "__new__()" method using\n'
                  '   "super(currentclass, cls).__new__(cls[, ...])" with '
                  'appropriate\n'
                  '   arguments and then modifying the newly-created instance '
                  'as\n'
                  '   necessary before returning it.\n'
                  '\n'
                  '   If "__new__()" returns an instance of *cls*, then the '
                  'new\n'
                  '   instance\'s "__init__()" method will be invoked like\n'
                  '   "__init__(self[, ...])", where *self* is the new '
                  'instance and the\n'
                  '   remaining arguments are the same as were passed to '
                  '"__new__()".\n'
                  '\n'
                  '   If "__new__()" does not return an instance of *cls*, '
                  'then the new\n'
                  '   instance\'s "__init__()" method will not be invoked.\n'
                  '\n'
                  '   "__new__()" is intended mainly to allow subclasses of '
                  'immutable\n'
                  '   types (like int, str, or tuple) to customize instance '
                  'creation.  It\n'
                  '   is also commonly overridden in custom metaclasses in '
                  'order to\n'
                  '   customize class creation.\n'
                  '\n'
                  'object.__init__(self[, ...])\n'
                  '\n'
                  '   Called after the instance has been created (by '
                  '"__new__()"), but\n'
                  '   before it is returned to the caller.  The arguments are '
                  'those\n'
                  '   passed to the class constructor expression.  If a base '
                  'class has an\n'
                  '   "__init__()" method, the derived class\'s "__init__()" '
                  'method, if\n'
                  '   any, must explicitly call it to ensure proper '
                  'initialization of the\n'
                  '   base class part of the instance; for example:\n'
                  '   "BaseClass.__init__(self, [args...])".\n'
                  '\n'
                  '   Because "__new__()" and "__init__()" work together in '
                  'constructing\n'
                  '   objects ("__new__()" to create it, and "__init__()" to '
                  'customise\n'
                  '   it), no non-"None" value may be returned by '
                  '"__init__()"; doing so\n'
                  '   will cause a "TypeError" to be raised at runtime.\n'
                  '\n'
                  'object.__del__(self)\n'
                  '\n'
                  '   Called when the instance is about to be destroyed.  This '
                  'is also\n'
                  '   called a destructor.  If a base class has a "__del__()" '
                  'method, the\n'
                  '   derived class\'s "__del__()" method, if any, must '
                  'explicitly call it\n'
                  '   to ensure proper deletion of the base class part of the '
                  'instance.\n'
                  '   Note that it is possible (though not recommended!) for '
                  'the\n'
                  '   "__del__()" method to postpone destruction of the '
                  'instance by\n'
                  '   creating a new reference to it.  It may then be called '
                  'at a later\n'
                  '   time when this new reference is deleted.  It is not '
                  'guaranteed that\n'
                  '   "__del__()" methods are called for objects that still '
                  'exist when\n'
                  '   the interpreter exits.\n'
                  '\n'
                  '   Note: "del x" doesn\'t directly call "x.__del__()" --- '
                  'the former\n'
                  '     decrements the reference count for "x" by one, and the '
                  'latter is\n'
                  '     only called when "x"\'s reference count reaches zero.  '
                  'Some common\n'
                  '     situations that may prevent the reference count of an '
                  'object from\n'
                  '     going to zero include: circular references between '
                  'objects (e.g.,\n'
                  '     a doubly-linked list or a tree data structure with '
                  'parent and\n'
                  '     child pointers); a reference to the object on the '
                  'stack frame of\n'
                  '     a function that caught an exception (the traceback '
                  'stored in\n'
                  '     "sys.exc_traceback" keeps the stack frame alive); or a '
                  'reference\n'
                  '     to the object on the stack frame that raised an '
                  'unhandled\n'
                  '     exception in interactive mode (the traceback stored '
                  'in\n'
                  '     "sys.last_traceback" keeps the stack frame alive).  '
                  'The first\n'
                  '     situation can only be remedied by explicitly breaking '
                  'the cycles;\n'
                  '     the latter two situations can be resolved by storing '
                  '"None" in\n'
                  '     "sys.exc_traceback" or "sys.last_traceback".  Circular '
                  'references\n'
                  '     which are garbage are detected when the option cycle '
                  'detector is\n'
                  "     enabled (it's on by default), but can only be cleaned "
                  'up if there\n'
                  '     are no Python-level "__del__()" methods involved. '
                  'Refer to the\n'
                  '     documentation for the "gc" module for more information '
                  'about how\n'
                  '     "__del__()" methods are handled by the cycle '
                  'detector,\n'
                  '     particularly the description of the "garbage" value.\n'
                  '\n'
                  '   Warning: Due to the precarious circumstances under '
                  'which\n'
                  '     "__del__()" methods are invoked, exceptions that occur '
                  'during\n'
                  '     their execution are ignored, and a warning is printed '
                  'to\n'
                  '     "sys.stderr" instead. Also, when "__del__()" is '
                  'invoked in\n'
                  '     response to a module being deleted (e.g., when '
                  'execution of the\n'
                  '     program is done), other globals referenced by the '
                  '"__del__()"\n'
                  '     method may already have been deleted or in the process '
                  'of being\n'
                  '     torn down (e.g. the import machinery shutting down).  '
                  'For this\n'
                  '     reason, "__del__()" methods should do the absolute '
                  'minimum needed\n'
                  '     to maintain external invariants.  Starting with '
                  'version 1.5,\n'
                  '     Python guarantees that globals whose name begins with '
                  'a single\n'
                  '     underscore are deleted from their module before other '
                  'globals are\n'
                  '     deleted; if no other references to such globals exist, '
                  'this may\n'
                  '     help in assuring that imported modules are still '
                  'available at the\n'
                  '     time when the "__del__()" method is called.\n'
                  '\n'
                  '   See also the "-R" command-line option.\n'
                  '\n'
                  'object.__repr__(self)\n'
                  '\n'
                  '   Called by the "repr()" built-in function and by string '
                  'conversions\n'
                  '   (reverse quotes) to compute the "official" string '
                  'representation of\n'
                  '   an object.  If at all possible, this should look like a '
                  'valid\n'
                  '   Python expression that could be used to recreate an '
                  'object with the\n'
                  '   same value (given an appropriate environment).  If this '
                  'is not\n'
                  '   possible, a string of the form "<...some useful '
                  'description...>"\n'
                  '   should be returned.  The return value must be a string '
                  'object. If a\n'
                  '   class defines "__repr__()" but not "__str__()", then '
                  '"__repr__()"\n'
                  '   is also used when an "informal" string representation of '
                  'instances\n'
                  '   of that class is required.\n'
                  '\n'
                  '   This is typically used for debugging, so it is important '
                  'that the\n'
                  '   representation is information-rich and unambiguous.\n'
                  '\n'
                  'object.__str__(self)\n'
                  '\n'
                  '   Called by the "str()" built-in function and by the '
                  '"print"\n'
                  '   statement to compute the "informal" string '
                  'representation of an\n'
                  '   object.  This differs from "__repr__()" in that it does '
                  'not have to\n'
                  '   be a valid Python expression: a more convenient or '
                  'concise\n'
                  '   representation may be used instead. The return value '
                  'must be a\n'
                  '   string object.\n'
                  '\n'
                  'object.__lt__(self, other)\n'
                  'object.__le__(self, other)\n'
                  'object.__eq__(self, other)\n'
                  'object.__ne__(self, other)\n'
                  'object.__gt__(self, other)\n'
                  'object.__ge__(self, other)\n'
                  '\n'
                  '   New in version 2.1.\n'
                  '\n'
                  '   These are the so-called "rich comparison" methods, and '
                  'are called\n'
                  '   for comparison operators in preference to "__cmp__()" '
                  'below. The\n'
                  '   correspondence between operator symbols and method names '
                  'is as\n'
                  '   follows: "x<y" calls "x.__lt__(y)", "x<=y" calls '
                  '"x.__le__(y)",\n'
                  '   "x==y" calls "x.__eq__(y)", "x!=y" and "x<>y" call '
                  '"x.__ne__(y)",\n'
                  '   "x>y" calls "x.__gt__(y)", and "x>=y" calls '
                  '"x.__ge__(y)".\n'
                  '\n'
                  '   A rich comparison method may return the singleton '
                  '"NotImplemented"\n'
                  '   if it does not implement the operation for a given pair '
                  'of\n'
                  '   arguments. By convention, "False" and "True" are '
                  'returned for a\n'
                  '   successful comparison. However, these methods can return '
                  'any value,\n'
                  '   so if the comparison operator is used in a Boolean '
                  'context (e.g.,\n'
                  '   in the condition of an "if" statement), Python will call '
                  '"bool()"\n'
                  '   on the value to determine if the result is true or '
                  'false.\n'
                  '\n'
                  '   There are no implied relationships among the comparison '
                  'operators.\n'
                  '   The truth of "x==y" does not imply that "x!=y" is '
                  'false.\n'
                  '   Accordingly, when defining "__eq__()", one should also '
                  'define\n'
                  '   "__ne__()" so that the operators will behave as '
                  'expected.  See the\n'
                  '   paragraph on "__hash__()" for some important notes on '
                  'creating\n'
                  '   *hashable* objects which support custom comparison '
                  'operations and\n'
                  '   are usable as dictionary keys.\n'
                  '\n'
                  '   There are no swapped-argument versions of these methods '
                  '(to be used\n'
                  '   when the left argument does not support the operation '
                  'but the right\n'
                  '   argument does); rather, "__lt__()" and "__gt__()" are '
                  "each other's\n"
                  '   reflection, "__le__()" and "__ge__()" are each other\'s '
                  'reflection,\n'
                  '   and "__eq__()" and "__ne__()" are their own reflection.\n'
                  '\n'
                  '   Arguments to rich comparison methods are never coerced.\n'
                  '\n'
                  '   To automatically generate ordering operations from a '
                  'single root\n'
                  '   operation, see "functools.total_ordering()".\n'
                  '\n'
                  'object.__cmp__(self, other)\n'
                  '\n'
                  '   Called by comparison operations if rich comparison (see '
                  'above) is\n'
                  '   not defined.  Should return a negative integer if "self '
                  '< other",\n'
                  '   zero if "self == other", a positive integer if "self > '
                  'other".  If\n'
                  '   no "__cmp__()", "__eq__()" or "__ne__()" operation is '
                  'defined,\n'
                  '   class instances are compared by object identity '
                  '("address").  See\n'
                  '   also the description of "__hash__()" for some important '
                  'notes on\n'
                  '   creating *hashable* objects which support custom '
                  'comparison\n'
                  '   operations and are usable as dictionary keys. (Note: '
                  'the\n'
                  '   restriction that exceptions are not propagated by '
                  '"__cmp__()" has\n'
                  '   been removed since Python 1.5.)\n'
                  '\n'
                  'object.__rcmp__(self, other)\n'
                  '\n'
                  '   Changed in version 2.1: No longer supported.\n'
                  '\n'
                  'object.__hash__(self)\n'
                  '\n'
                  '   Called by built-in function "hash()" and for operations '
                  'on members\n'
                  '   of hashed collections including "set", "frozenset", and '
                  '"dict".\n'
                  '   "__hash__()" should return an integer.  The only '
                  'required property\n'
                  '   is that objects which compare equal have the same hash '
                  'value; it is\n'
                  '   advised to somehow mix together (e.g. using exclusive '
                  'or) the hash\n'
                  '   values for the components of the object that also play a '
                  'part in\n'
                  '   comparison of objects.\n'
                  '\n'
                  '   If a class does not define a "__cmp__()" or "__eq__()" '
                  'method it\n'
                  '   should not define a "__hash__()" operation either; if it '
                  'defines\n'
                  '   "__cmp__()" or "__eq__()" but not "__hash__()", its '
                  'instances will\n'
                  '   not be usable in hashed collections.  If a class defines '
                  'mutable\n'
                  '   objects and implements a "__cmp__()" or "__eq__()" '
                  'method, it\n'
                  '   should not implement "__hash__()", since hashable '
                  'collection\n'
                  "   implementations require that a object's hash value is "
                  'immutable (if\n'
                  "   the object's hash value changes, it will be in the wrong "
                  'hash\n'
                  '   bucket).\n'
                  '\n'
                  '   User-defined classes have "__cmp__()" and "__hash__()" '
                  'methods by\n'
                  '   default; with them, all objects compare unequal (except '
                  'with\n'
                  '   themselves) and "x.__hash__()" returns a result derived '
                  'from\n'
                  '   "id(x)".\n'
                  '\n'
                  '   Classes which inherit a "__hash__()" method from a '
                  'parent class but\n'
                  '   change the meaning of "__cmp__()" or "__eq__()" such '
                  'that the hash\n'
                  '   value returned is no longer appropriate (e.g. by '
                  'switching to a\n'
                  '   value-based concept of equality instead of the default '
                  'identity\n'
                  '   based equality) can explicitly flag themselves as being '
                  'unhashable\n'
                  '   by setting "__hash__ = None" in the class definition. '
                  'Doing so\n'
                  '   means that not only will instances of the class raise '
                  'an\n'
                  '   appropriate "TypeError" when a program attempts to '
                  'retrieve their\n'
                  '   hash value, but they will also be correctly identified '
                  'as\n'
                  '   unhashable when checking "isinstance(obj, '
                  'collections.Hashable)"\n'
                  '   (unlike classes which define their own "__hash__()" to '
                  'explicitly\n'
                  '   raise "TypeError").\n'
                  '\n'
                  '   Changed in version 2.5: "__hash__()" may now also return '
                  'a long\n'
                  '   integer object; the 32-bit integer is then derived from '
                  'the hash of\n'
                  '   that object.\n'
                  '\n'
                  '   Changed in version 2.6: "__hash__" may now be set to '
                  '"None" to\n'
                  '   explicitly flag instances of a class as unhashable.\n'
                  '\n'
                  'object.__nonzero__(self)\n'
                  '\n'
                  '   Called to implement truth value testing and the built-in '
                  'operation\n'
                  '   "bool()"; should return "False" or "True", or their '
                  'integer\n'
                  '   equivalents "0" or "1".  When this method is not '
                  'defined,\n'
                  '   "__len__()" is called, if it is defined, and the object '
                  'is\n'
                  '   considered true if its result is nonzero. If a class '
                  'defines\n'
                  '   neither "__len__()" nor "__nonzero__()", all its '
                  'instances are\n'
                  '   considered true.\n'
                  '\n'
                  'object.__unicode__(self)\n'
                  '\n'
                  '   Called to implement "unicode()" built-in; should return '
                  'a Unicode\n'
                  '   object. When this method is not defined, string '
                  'conversion is\n'
                  '   attempted, and the result of string conversion is '
                  'converted to\n'
                  '   Unicode using the system default encoding.\n',
 'debugger': '\n'
             '"pdb" --- The Python Debugger\n'
             '*****************************\n'
             '\n'
             '**Source code:** Lib/pdb.py\n'
             '\n'
             '======================================================================\n'
             '\n'
             'The module "pdb" defines an interactive source code debugger '
             'for\n'
             'Python programs.  It supports setting (conditional) breakpoints '
             'and\n'
             'single stepping at the source line level, inspection of stack '
             'frames,\n'
             'source code listing, and evaluation of arbitrary Python code in '
             'the\n'
             'context of any stack frame.  It also supports post-mortem '
             'debugging\n'
             'and can be called under program control.\n'
             '\n'
             'The debugger is extensible --- it is actually defined as the '
             'class\n'
             '"Pdb". This is currently undocumented but easily understood by '
             'reading\n'
             'the source.  The extension interface uses the modules "bdb" and '
             '"cmd".\n'
             '\n'
             'The debugger\'s prompt is "(Pdb)". Typical usage to run a '
             'program under\n'
             'control of the debugger is:\n'
             '\n'
             '   >>> import pdb\n'
             '   >>> import mymodule\n'
             "   >>> pdb.run('mymodule.test()')\n"
             '   > <string>(0)?()\n'
             '   (Pdb) continue\n'
             '   > <string>(1)?()\n'
             '   (Pdb) continue\n'
             "   NameError: 'spam'\n"
             '   > <string>(1)?()\n'
             '   (Pdb)\n'
             '\n'
             '"pdb.py" can also be invoked as a script to debug other '
             'scripts.  For\n'
             'example:\n'
             '\n'
             '   python -m pdb myscript.py\n'
             '\n'
             'When invoked as a script, pdb will automatically enter '
             'post-mortem\n'
             'debugging if the program being debugged exits abnormally. After '
             'post-\n'
             'mortem debugging (or after normal exit of the program), pdb '
             'will\n'
             "restart the program. Automatic restarting preserves pdb's state "
             '(such\n'
             'as breakpoints) and in most cases is more useful than quitting '
             'the\n'
             "debugger upon program's exit.\n"
             '\n'
             'New in version 2.4: Restarting post-mortem behavior added.\n'
             '\n'
             'The typical usage to break into the debugger from a running '
             'program is\n'
             'to insert\n'
             '\n'
             '   import pdb; pdb.set_trace()\n'
             '\n'
             'at the location you want to break into the debugger.  You can '
             'then\n'
             'step through the code following this statement, and continue '
             'running\n'
             'without the debugger using the "c" command.\n'
             '\n'
             'The typical usage to inspect a crashed program is:\n'
             '\n'
             '   >>> import pdb\n'
             '   >>> import mymodule\n'
             '   >>> mymodule.test()\n'
             '   Traceback (most recent call last):\n'
             '     File "<stdin>", line 1, in ?\n'
             '     File "./mymodule.py", line 4, in test\n'
             '       test2()\n'
             '     File "./mymodule.py", line 3, in test2\n'
             '       print spam\n'
             '   NameError: spam\n'
             '   >>> pdb.pm()\n'
             '   > ./mymodule.py(3)test2()\n'
             '   -> print spam\n'
             '   (Pdb)\n'
             '\n'
             'The module defines the following functions; each enters the '
             'debugger\n'
             'in a slightly different way:\n'
             '\n'
             'pdb.run(statement[, globals[, locals]])\n'
             '\n'
             '   Execute the *statement* (given as a string) under debugger '
             'control.\n'
             '   The debugger prompt appears before any code is executed; you '
             'can\n'
             '   set breakpoints and type "continue", or you can step through '
             'the\n'
             '   statement using "step" or "next" (all these commands are '
             'explained\n'
             '   below).  The optional *globals* and *locals* arguments '
             'specify the\n'
             '   environment in which the code is executed; by default the\n'
             '   dictionary of the module "__main__" is used.  (See the '
             'explanation\n'
             '   of the "exec" statement or the "eval()" built-in function.)\n'
             '\n'
             'pdb.runeval(expression[, globals[, locals]])\n'
             '\n'
             '   Evaluate the *expression* (given as a string) under debugger\n'
             '   control.  When "runeval()" returns, it returns the value of '
             'the\n'
             '   expression.  Otherwise this function is similar to "run()".\n'
             '\n'
             'pdb.runcall(function[, argument, ...])\n'
             '\n'
             '   Call the *function* (a function or method object, not a '
             'string)\n'
             '   with the given arguments.  When "runcall()" returns, it '
             'returns\n'
             '   whatever the function call returned.  The debugger prompt '
             'appears\n'
             '   as soon as the function is entered.\n'
             '\n'
             'pdb.set_trace()\n'
             '\n'
             '   Enter the debugger at the calling stack frame.  This is '
             'useful to\n'
             '   hard-code a breakpoint at a given point in a program, even if '
             'the\n'
             '   code is not otherwise being debugged (e.g. when an assertion\n'
             '   fails).\n'
             '\n'
             'pdb.post_mortem([traceback])\n'
             '\n'
             '   Enter post-mortem debugging of the given *traceback* object.  '
             'If no\n'
             '   *traceback* is given, it uses the one of the exception that '
             'is\n'
             '   currently being handled (an exception must be being handled '
             'if the\n'
             '   default is to be used).\n'
             '\n'
             'pdb.pm()\n'
             '\n'
             '   Enter post-mortem debugging of the traceback found in\n'
             '   "sys.last_traceback".\n'
             '\n'
             'The "run*" functions and "set_trace()" are aliases for '
             'instantiating\n'
             'the "Pdb" class and calling the method of the same name.  If you '
             'want\n'
             'to access further features, you have to do this yourself:\n'
             '\n'
             "class pdb.Pdb(completekey='tab', stdin=None, stdout=None, "
             'skip=None)\n'
             '\n'
             '   "Pdb" is the debugger class.\n'
             '\n'
             '   The *completekey*, *stdin* and *stdout* arguments are passed '
             'to the\n'
             '   underlying "cmd.Cmd" class; see the description there.\n'
             '\n'
             '   The *skip* argument, if given, must be an iterable of '
             'glob-style\n'
             '   module name patterns.  The debugger will not step into frames '
             'that\n'
             '   originate in a module that matches one of these patterns. '
             '[1]\n'
             '\n'
             '   Example call to enable tracing with *skip*:\n'
             '\n'
             "      import pdb; pdb.Pdb(skip=['django.*']).set_trace()\n"
             '\n'
             '   New in version 2.7: The *skip* argument.\n'
             '\n'
             '   run(statement[, globals[, locals]])\n'
             '   runeval(expression[, globals[, locals]])\n'
             '   runcall(function[, argument, ...])\n'
             '   set_trace()\n'
             '\n'
             '      See the documentation for the functions explained above.\n',
 'del': '\n'
        'The "del" statement\n'
        '*******************\n'
        '\n'
        '   del_stmt ::= "del" target_list\n'
        '\n'
        'Deletion is recursively defined very similar to the way assignment '
        'is\n'
        'defined. Rather than spelling it out in full details, here are some\n'
        'hints.\n'
        '\n'
        'Deletion of a target list recursively deletes each target, from left\n'
        'to right.\n'
        '\n'
        'Deletion of a name removes the binding of that name  from the local '
        'or\n'
        'global namespace, depending on whether the name occurs in a "global"\n'
        'statement in the same code block.  If the name is unbound, a\n'
        '"NameError" exception will be raised.\n'
        '\n'
        'It is illegal to delete a name from the local namespace if it occurs\n'
        'as a free variable in a nested block.\n'
        '\n'
        'Deletion of attribute references, subscriptions and slicings is '
        'passed\n'
        'to the primary object involved; deletion of a slicing is in general\n'
        'equivalent to assignment of an empty slice of the right type (but '
        'even\n'
        'this is determined by the sliced object).\n',
 'dict': '\n'
         'Dictionary displays\n'
         '*******************\n'
         '\n'
         'A dictionary display is a possibly empty series of key/datum pairs\n'
         'enclosed in curly braces:\n'
         '\n'
         '   dict_display       ::= "{" [key_datum_list | dict_comprehension] '
         '"}"\n'
         '   key_datum_list     ::= key_datum ("," key_datum)* [","]\n'
         '   key_datum          ::= expression ":" expression\n'
         '   dict_comprehension ::= expression ":" expression comp_for\n'
         '\n'
         'A dictionary display yields a new dictionary object.\n'
         '\n'
         'If a comma-separated sequence of key/datum pairs is given, they are\n'
         'evaluated from left to right to define the entries of the '
         'dictionary:\n'
         'each key object is used as a key into the dictionary to store the\n'
         'corresponding datum.  This means that you can specify the same key\n'
         "multiple times in the key/datum list, and the final dictionary's "
         'value\n'
         'for that key will be the last one given.\n'
         '\n'
         'A dict comprehension, in contrast to list and set comprehensions,\n'
         'needs two expressions separated with a colon followed by the usual\n'
         '"for" and "if" clauses. When the comprehension is run, the '
         'resulting\n'
         'key and value elements are inserted in the new dictionary in the '
         'order\n'
         'they are produced.\n'
         '\n'
         'Restrictions on the types of the key values are listed earlier in\n'
         'section The standard type hierarchy.  (To summarize, the key type\n'
         'should be *hashable*, which excludes all mutable objects.)  Clashes\n'
         'between duplicate keys are not detected; the last datum (textually\n'
         'rightmost in the display) stored for a given key value prevails.\n',
 'dynamic-features': '\n'
                     'Interaction with dynamic features\n'
                     '*********************************\n'
                     '\n'
                     'There are several cases where Python statements are '
                     'illegal when used\n'
                     'in conjunction with nested scopes that contain free '
                     'variables.\n'
                     '\n'
                     'If a variable is referenced in an enclosing scope, it is '
                     'illegal to\n'
                     'delete the name.  An error will be reported at compile '
                     'time.\n'
                     '\n'
                     'If the wild card form of import --- "import *" --- is '
                     'used in a\n'
                     'function and the function contains or is a nested block '
                     'with free\n'
                     'variables, the compiler will raise a "SyntaxError".\n'
                     '\n'
                     'If "exec" is used in a function and the function '
                     'contains or is a\n'
                     'nested block with free variables, the compiler will '
                     'raise a\n'
                     '"SyntaxError" unless the exec explicitly specifies the '
                     'local namespace\n'
                     'for the "exec".  (In other words, "exec obj" would be '
                     'illegal, but\n'
                     '"exec obj in ns" would be legal.)\n'
                     '\n'
                     'The "eval()", "execfile()", and "input()" functions and '
                     'the "exec"\n'
                     'statement do not have access to the full environment for '
                     'resolving\n'
                     'names.  Names may be resolved in the local and global '
                     'namespaces of\n'
                     'the caller.  Free variables are not resolved in the '
                     'nearest enclosing\n'
                     'namespace, but in the global namespace. [1] The "exec" '
                     'statement and\n'
                     'the "eval()" and "execfile()" functions have optional '
                     'arguments to\n'
                     'override the global and local namespace.  If only one '
                     'namespace is\n'
                     'specified, it is used for both.\n',
 'else': '\n'
         'The "if" statement\n'
         '******************\n'
         '\n'
         'The "if" statement is used for conditional execution:\n'
         '\n'
         '   if_stmt ::= "if" expression ":" suite\n'
         '               ( "elif" expression ":" suite )*\n'
         '               ["else" ":" suite]\n'
         '\n'
         'It selects exactly one of the suites by evaluating the expressions '
         'one\n'
         'by one until one is found to be true (see section Boolean '
         'operations\n'
         'for the definition of true and false); then that suite is executed\n'
         '(and no other part of the "if" statement is executed or evaluated).\n'
         'If all expressions are false, the suite of the "else" clause, if\n'
         'present, is executed.\n',
 'exceptions': '\n'
               'Exceptions\n'
               '**********\n'
               '\n'
               'Exceptions are a means of breaking out of the normal flow of '
               'control\n'
               'of a code block in order to handle errors or other '
               'exceptional\n'
               'conditions.  An exception is *raised* at the point where the '
               'error is\n'
               'detected; it may be *handled* by the surrounding code block or '
               'by any\n'
               'code block that directly or indirectly invoked the code block '
               'where\n'
               'the error occurred.\n'
               '\n'
               'The Python interpreter raises an exception when it detects a '
               'run-time\n'
               'error (such as division by zero).  A Python program can also\n'
               'explicitly raise an exception with the "raise" statement. '
               'Exception\n'
               'handlers are specified with the "try" ... "except" statement.  '
               'The\n'
               '"finally" clause of such a statement can be used to specify '
               'cleanup\n'
               'code which does not handle the exception, but is executed '
               'whether an\n'
               'exception occurred or not in the preceding code.\n'
               '\n'
               'Python uses the "termination" model of error handling: an '
               'exception\n'
               'handler can find out what happened and continue execution at '
               'an outer\n'
               'level, but it cannot repair the cause of the error and retry '
               'the\n'
               'failing operation (except by re-entering the offending piece '
               'of code\n'
               'from the top).\n'
               '\n'
               'When an exception is not handled at all, the interpreter '
               'terminates\n'
               'execution of the program, or returns to its interactive main '
               'loop.  In\n'
               'either case, it prints a stack backtrace, except when the '
               'exception is\n'
               '"SystemExit".\n'
               '\n'
               'Exceptions are identified by class instances.  The "except" '
               'clause is\n'
               'selected depending on the class of the instance: it must '
               'reference the\n'
               'class of the instance or a base class thereof.  The instance '
               'can be\n'
               'received by the handler and can carry additional information '
               'about the\n'
               'exceptional condition.\n'
               '\n'
               'Exceptions can also be identified by strings, in which case '
               'the\n'
               '"except" clause is selected by object identity.  An arbitrary '
               'value\n'
               'can be raised along with the identifying string which can be '
               'passed to\n'
               'the handler.\n'
               '\n'
               'Note: Messages to exceptions are not part of the Python API.  '
               'Their\n'
               '  contents may change from one version of Python to the next '
               'without\n'
               '  warning and should not be relied on by code which will run '
               'under\n'
               '  multiple versions of the interpreter.\n'
               '\n'
               'See also the description of the "try" statement in section The '
               'try\n'
               'statement and "raise" statement in section The raise '
               'statement.\n'
               '\n'
               '-[ Footnotes ]-\n'
               '\n'
               '[1] This limitation occurs because the code that is executed '
               'by\n'
               '    these operations is not available at the time the module '
               'is\n'
               '    compiled.\n',
 'exec': '\n'
         'The "exec" statement\n'
         '********************\n'
         '\n'
         '   exec_stmt ::= "exec" or_expr ["in" expression ["," expression]]\n'
         '\n'
         'This statement supports dynamic execution of Python code.  The '
         'first\n'
         'expression should evaluate to either a Unicode string, a *Latin-1*\n'
         'encoded string, an open file object, a code object, or a tuple.  If '
         'it\n'
         'is a string, the string is parsed as a suite of Python statements\n'
         'which is then executed (unless a syntax error occurs). [1] If it is '
         'an\n'
         'open file, the file is parsed until EOF and executed. If it is a '
         'code\n'
         'object, it is simply executed.  For the interpretation of a tuple, '
         'see\n'
         "below.  In all cases, the code that's executed is expected to be "
         'valid\n'
         'as file input (see section File input).  Be aware that the "return"\n'
         'and "yield" statements may not be used outside of function '
         'definitions\n'
         'even within the context of code passed to the "exec" statement.\n'
         '\n'
         'In all cases, if the optional parts are omitted, the code is '
         'executed\n'
         'in the current scope.  If only the first expression after "in" is\n'
         'specified, it should be a dictionary, which will be used for both '
         'the\n'
         'global and the local variables.  If two expressions are given, they\n'
         'are used for the global and local variables, respectively. If\n'
         'provided, *locals* can be any mapping object. Remember that at '
         'module\n'
         'level, globals and locals are the same dictionary. If two separate\n'
         'objects are given as *globals* and *locals*, the code will be '
         'executed\n'
         'as if it were embedded in a class definition.\n'
         '\n'
         'The first expression may also be a tuple of length 2 or 3.  In this\n'
         'case, the optional parts must be omitted.  The form "exec(expr,\n'
         'globals)" is equivalent to "exec expr in globals", while the form\n'
         '"exec(expr, globals, locals)" is equivalent to "exec expr in '
         'globals,\n'
         'locals".  The tuple form of "exec" provides compatibility with '
         'Python\n'
         '3, where "exec" is a function rather than a statement.\n'
         '\n'
         'Changed in version 2.4: Formerly, *locals* was required to be a\n'
         'dictionary.\n'
         '\n'
         'As a side effect, an implementation may insert additional keys into\n'
         'the dictionaries given besides those corresponding to variable '
         'names\n'
         'set by the executed code.  For example, the current implementation '
         'may\n'
         'add a reference to the dictionary of the built-in module '
         '"__builtin__"\n'
         'under the key "__builtins__" (!).\n'
         '\n'
         "**Programmer's hints:** dynamic evaluation of expressions is "
         'supported\n'
         'by the built-in function "eval()".  The built-in functions '
         '"globals()"\n'
         'and "locals()" return the current global and local dictionary,\n'
         'respectively, which may be useful to pass around for use by "exec".\n'
         '\n'
         '-[ Footnotes ]-\n'
         '\n'
         '[1] Note that the parser only accepts the Unix-style end of line\n'
         '    convention. If you are reading the code from a file, make sure '
         'to\n'
         '    use *universal newlines* mode to convert Windows or Mac-style\n'
         '    newlines.\n',
 'execmodel': '\n'
              'Execution model\n'
              '***************\n'
              '\n'
              '\n'
              'Naming and binding\n'
              '==================\n'
              '\n'
              '*Names* refer to objects.  Names are introduced by name '
              'binding\n'
              'operations. Each occurrence of a name in the program text '
              'refers to\n'
              'the *binding* of that name established in the innermost '
              'function block\n'
              'containing the use.\n'
              '\n'
              'A *block* is a piece of Python program text that is executed as '
              'a\n'
              'unit. The following are blocks: a module, a function body, and '
              'a class\n'
              'definition. Each command typed interactively is a block.  A '
              'script\n'
              'file (a file given as standard input to the interpreter or '
              'specified\n'
              'on the interpreter command line the first argument) is a code '
              'block.\n'
              'A script command (a command specified on the interpreter '
              'command line\n'
              "with the '**-c**' option) is a code block.  The file read by "
              'the\n'
              'built-in function "execfile()" is a code block.  The string '
              'argument\n'
              'passed to the built-in function "eval()" and to the "exec" '
              'statement\n'
              'is a code block. The expression read and evaluated by the '
              'built-in\n'
              'function "input()" is a code block.\n'
              '\n'
              'A code block is executed in an *execution frame*.  A frame '
              'contains\n'
              'some administrative information (used for debugging) and '
              'determines\n'
              "where and how execution continues after the code block's "
              'execution has\n'
              'completed.\n'
              '\n'
              'A *scope* defines the visibility of a name within a block.  If '
              'a local\n'
              'variable is defined in a block, its scope includes that block.  '
              'If the\n'
              'definition occurs in a function block, the scope extends to any '
              'blocks\n'
              'contained within the defining one, unless a contained block '
              'introduces\n'
              'a different binding for the name.  The scope of names defined '
              'in a\n'
              'class block is limited to the class block; it does not extend '
              'to the\n'
              'code blocks of methods -- this includes generator expressions '
              'since\n'
              'they are implemented using a function scope.  This means that '
              'the\n'
              'following will fail:\n'
              '\n'
              '   class A:\n'
              '       a = 42\n'
              '       b = list(a + i for i in range(10))\n'
              '\n'
              'When a name is used in a code block, it is resolved using the '
              'nearest\n'
              'enclosing scope.  The set of all such scopes visible to a code '
              'block\n'
              "is called the block's *environment*.\n"
              '\n'
              'If a name is bound in a block, it is a local variable of that '
              'block.\n'
              'If a name is bound at the module level, it is a global '
              'variable.  (The\n'
              'variables of the module code block are local and global.)  If '
              'a\n'
              'variable is used in a code block but not defined there, it is a '
              '*free\n'
              'variable*.\n'
              '\n'
              'When a name is not found at all, a "NameError" exception is '
              'raised.\n'
              'If the name refers to a local variable that has not been bound, '
              'a\n'
              '"UnboundLocalError" exception is raised.  "UnboundLocalError" '
              'is a\n'
              'subclass of "NameError".\n'
              '\n'
              'The following constructs bind names: formal parameters to '
              'functions,\n'
              '"import" statements, class and function definitions (these bind '
              'the\n'
              'class or function name in the defining block), and targets that '
              'are\n'
              'identifiers if occurring in an assignment, "for" loop header, '
              'in the\n'
              'second position of an "except" clause header or after "as" in a '
              '"with"\n'
              'statement.  The "import" statement of the form "from ... import '
              '*"\n'
              'binds all names defined in the imported module, except those '
              'beginning\n'
              'with an underscore.  This form may only be used at the module '
              'level.\n'
              '\n'
              'A target occurring in a "del" statement is also considered '
              'bound for\n'
              'this purpose (though the actual semantics are to unbind the '
              'name).  It\n'
              'is illegal to unbind a name that is referenced by an enclosing '
              'scope;\n'
              'the compiler will report a "SyntaxError".\n'
              '\n'
              'Each assignment or import statement occurs within a block '
              'defined by a\n'
              'class or function definition or at the module level (the '
              'top-level\n'
              'code block).\n'
              '\n'
              'If a name binding operation occurs anywhere within a code '
              'block, all\n'
              'uses of the name within the block are treated as references to '
              'the\n'
              'current block.  This can lead to errors when a name is used '
              'within a\n'
              'block before it is bound. This rule is subtle.  Python lacks\n'
              'declarations and allows name binding operations to occur '
              'anywhere\n'
              'within a code block.  The local variables of a code block can '
              'be\n'
              'determined by scanning the entire text of the block for name '
              'binding\n'
              'operations.\n'
              '\n'
              'If the global statement occurs within a block, all uses of the '
              'name\n'
              'specified in the statement refer to the binding of that name in '
              'the\n'
              'top-level namespace. Names are resolved in the top-level '
              'namespace by\n'
              'searching the global namespace, i.e. the namespace of the '
              'module\n'
              'containing the code block, and the builtins namespace, the '
              'namespace\n'
              'of the module "__builtin__".  The global namespace is searched '
              'first.\n'
              'If the name is not found there, the builtins namespace is '
              'searched.\n'
              'The global statement must precede all uses of the name.\n'
              '\n'
              'The builtins namespace associated with the execution of a code '
              'block\n'
              'is actually found by looking up the name "__builtins__" in its '
              'global\n'
              'namespace; this should be a dictionary or a module (in the '
              'latter case\n'
              "the module's dictionary is used).  By default, when in the "
              '"__main__"\n'
              'module, "__builtins__" is the built-in module "__builtin__" '
              '(note: no\n'
              '\'s\'); when in any other module, "__builtins__" is an alias '
              'for the\n'
              'dictionary of the "__builtin__" module itself.  "__builtins__" '
              'can be\n'
              'set to a user-created dictionary to create a weak form of '
              'restricted\n'
              'execution.\n'
              '\n'
              '**CPython implementation detail:** Users should not touch\n'
              '"__builtins__"; it is strictly an implementation detail.  '
              'Users\n'
              'wanting to override values in the builtins namespace should '
              '"import"\n'
              'the "__builtin__" (no \'s\') module and modify its attributes\n'
              'appropriately.\n'
              '\n'
              'The namespace for a module is automatically created the first '
              'time a\n'
              'module is imported.  The main module for a script is always '
              'called\n'
              '"__main__".\n'
              '\n'
              'The "global" statement has the same scope as a name binding '
              'operation\n'
              'in the same block.  If the nearest enclosing scope for a free '
              'variable\n'
              'contains a global statement, the free variable is treated as a '
              'global.\n'
              '\n'
              'A class definition is an executable statement that may use and '
              'define\n'
              'names. These references follow the normal rules for name '
              'resolution.\n'
              'The namespace of the class definition becomes the attribute '
              'dictionary\n'
              'of the class.  Names defined at the class scope are not visible '
              'in\n'
              'methods.\n'
              '\n'
              '\n'
              'Interaction with dynamic features\n'
              '---------------------------------\n'
              '\n'
              'There are several cases where Python statements are illegal '
              'when used\n'
              'in conjunction with nested scopes that contain free variables.\n'
              '\n'
              'If a variable is referenced in an enclosing scope, it is '
              'illegal to\n'
              'delete the name.  An error will be reported at compile time.\n'
              '\n'
              'If the wild card form of import --- "import *" --- is used in '
              'a\n'
              'function and the function contains or is a nested block with '
              'free\n'
              'variables, the compiler will raise a "SyntaxError".\n'
              '\n'
              'If "exec" is used in a function and the function contains or is '
              'a\n'
              'nested block with free variables, the compiler will raise a\n'
              '"SyntaxError" unless the exec explicitly specifies the local '
              'namespace\n'
              'for the "exec".  (In other words, "exec obj" would be illegal, '
              'but\n'
              '"exec obj in ns" would be legal.)\n'
              '\n'
              'The "eval()", "execfile()", and "input()" functions and the '
              '"exec"\n'
              'statement do not have access to the full environment for '
              'resolving\n'
              'names.  Names may be resolved in the local and global '
              'namespaces of\n'
              'the caller.  Free variables are not resolved in the nearest '
              'enclosing\n'
              'namespace, but in the global namespace. [1] The "exec" '
              'statement and\n'
              'the "eval()" and "execfile()" functions have optional arguments '
              'to\n'
              'override the global and local namespace.  If only one namespace '
              'is\n'
              'specified, it is used for both.\n'
              '\n'
              '\n'
              'Exceptions\n'
              '==========\n'
              '\n'
              'Exceptions are a means of breaking out of the normal flow of '
              'control\n'
              'of a code block in order to handle errors or other exceptional\n'
              'conditions.  An exception is *raised* at the point where the '
              'error is\n'
              'detected; it may be *handled* by the surrounding code block or '
              'by any\n'
              'code block that directly or indirectly invoked the code block '
              'where\n'
              'the error occurred.\n'
              '\n'
              'The Python interpreter raises an exception when it detects a '
              'run-time\n'
              'error (such as division by zero).  A Python program can also\n'
              'explicitly raise an exception with the "raise" statement. '
              'Exception\n'
              'handlers are specified with the "try" ... "except" statement.  '
              'The\n'
              '"finally" clause of such a statement can be used to specify '
              'cleanup\n'
              'code which does not handle the exception, but is executed '
              'whether an\n'
              'exception occurred or not in the preceding code.\n'
              '\n'
              'Python uses the "termination" model of error handling: an '
              'exception\n'
              'handler can find out what happened and continue execution at an '
              'outer\n'
              'level, but it cannot repair the cause of the error and retry '
              'the\n'
              'failing operation (except by re-entering the offending piece of '
              'code\n'
              'from the top).\n'
              '\n'
              'When an exception is not handled at all, the interpreter '
              'terminates\n'
              'execution of the program, or returns to its interactive main '
              'loop.  In\n'
              'either case, it prints a stack backtrace, except when the '
              'exception is\n'
              '"SystemExit".\n'
              '\n'
              'Exceptions are identified by class instances.  The "except" '
              'clause is\n'
              'selected depending on the class of the instance: it must '
              'reference the\n'
              'class of the instance or a base class thereof.  The instance '
              'can be\n'
              'received by the handler and can carry additional information '
              'about the\n'
              'exceptional condition.\n'
              '\n'
              'Exceptions can also be identified by strings, in which case '
              'the\n'
              '"except" clause is selected by object identity.  An arbitrary '
              'value\n'
              'can be raised along with the identifying string which can be '
              'passed to\n'
              'the handler.\n'
              '\n'
              'Note: Messages to exceptions are not part of the Python API.  '
              'Their\n'
              '  contents may change from one version of Python to the next '
              'without\n'
              '  warning and should not be relied on by code which will run '
              'under\n'
              '  multiple versions of the interpreter.\n'
              '\n'
              'See also the description of the "try" statement in section The '
              'try\n'
              'statement and "raise" statement in section The raise '
              'statement.\n'
              '\n'
              '-[ Footnotes ]-\n'
              '\n'
              '[1] This limitation occurs because the code that is executed '
              'by\n'
              '    these operations is not available at the time the module '
              'is\n'
              '    compiled.\n',
 'exprlists': '\n'
              'Expression lists\n'
              '****************\n'
              '\n'
              '   expression_list ::= expression ( "," expression )* [","]\n'
              '\n'
              'An expression list containing at least one comma yields a '
              'tuple.  The\n'
              'length of the tuple is the number of expressions in the list.  '
              'The\n'
              'expressions are evaluated from left to right.\n'
              '\n'
              'The trailing comma is required only to create a single tuple '
              '(a.k.a. a\n'
              '*singleton*); it is optional in all other cases.  A single '
              'expression\n'
              "without a trailing comma doesn't create a tuple, but rather "
              'yields the\n'
              'value of that expression. (To create an empty tuple, use an '
              'empty pair\n'
              'of parentheses: "()".)\n',
 'floating': '\n'
             'Floating point literals\n'
             '***********************\n'
             '\n'
             'Floating point literals are described by the following lexical\n'
             'definitions:\n'
             '\n'
             '   floatnumber   ::= pointfloat | exponentfloat\n'
             '   pointfloat    ::= [intpart] fraction | intpart "."\n'
             '   exponentfloat ::= (intpart | pointfloat) exponent\n'
             '   intpart       ::= digit+\n'
             '   fraction      ::= "." digit+\n'
             '   exponent      ::= ("e" | "E") ["+" | "-"] digit+\n'
             '\n'
             'Note that the integer and exponent parts of floating point '
             'numbers can\n'
             'look like octal integers, but are interpreted using radix 10.  '
             'For\n'
             'example, "077e010" is legal, and denotes the same number as '
             '"77e10".\n'
             'The allowed range of floating point literals is implementation-\n'
             'dependent. Some examples of floating point literals:\n'
             '\n'
             '   3.14    10.    .001    1e100    3.14e-10    0e0\n'
             '\n'
             'Note that numeric literals do not include a sign; a phrase like '
             '"-1"\n'
             'is actually an expression composed of the unary operator "-" and '
             'the\n'
             'literal "1".\n',
 'for': '\n'
        'The "for" statement\n'
        '*******************\n'
        '\n'
        'The "for" statement is used to iterate over the elements of a '
        'sequence\n'
        '(such as a string, tuple or list) or other iterable object:\n'
        '\n'
        '   for_stmt ::= "for" target_list "in" expression_list ":" suite\n'
        '                ["else" ":" suite]\n'
        '\n'
        'The expression list is evaluated once; it should yield an iterable\n'
        'object.  An iterator is created for the result of the\n'
        '"expression_list".  The suite is then executed once for each item\n'
        'provided by the iterator, in the order of ascending indices.  Each\n'
        'item in turn is assigned to the target list using the standard rules\n'
        'for assignments, and then the suite is executed.  When the items are\n'
        'exhausted (which is immediately when the sequence is empty), the '
        'suite\n'
        'in the "else" clause, if present, is executed, and the loop\n'
        'terminates.\n'
        '\n'
        'A "break" statement executed in the first suite terminates the loop\n'
        'without executing the "else" clause\'s suite.  A "continue" '
        'statement\n'
        'executed in the first suite skips the rest of the suite and '
        'continues\n'
        'with the next item, or with the "else" clause if there was no next\n'
        'item.\n'
        '\n'
        'The suite may assign to the variable(s) in the target list; this '
        'does\n'
        'not affect the next item assigned to it.\n'
        '\n'
        'The target list is not deleted when the loop is finished, but if the\n'
        'sequence is empty, it will not have been assigned to at all by the\n'
        'loop.  Hint: the built-in function "range()" returns a sequence of\n'
        'integers suitable to emulate the effect of Pascal\'s "for i := a to '
        'b\n'
        'do"; e.g., "range(3)" returns the list "[0, 1, 2]".\n'
        '\n'
        'Note: There is a subtlety when the sequence is being modified by the\n'
        '  loop (this can only occur for mutable sequences, i.e. lists). An\n'
        '  internal counter is used to keep track of which item is used next,\n'
        '  and this is incremented on each iteration.  When this counter has\n'
        '  reached the length of the sequence the loop terminates.  This '
        'means\n'
        '  that if the suite deletes the current (or a previous) item from '
        'the\n'
        '  sequence, the next item will be skipped (since it gets the index '
        'of\n'
        '  the current item which has already been treated).  Likewise, if '
        'the\n'
        '  suite inserts an item in the sequence before the current item, the\n'
        '  current item will be treated again the next time through the loop.\n'
        '  This can lead to nasty bugs that can be avoided by making a\n'
        '  temporary copy using a slice of the whole sequence, e.g.,\n'
        '\n'
        '     for x in a[:]:\n'
        '         if x < 0: a.remove(x)\n',
 'formatstrings': '\n'
                  'Format String Syntax\n'
                  '********************\n'
                  '\n'
                  'The "str.format()" method and the "Formatter" class share '
                  'the same\n'
                  'syntax for format strings (although in the case of '
                  '"Formatter",\n'
                  'subclasses can define their own format string syntax).\n'
                  '\n'
                  'Format strings contain "replacement fields" surrounded by '
                  'curly braces\n'
                  '"{}". Anything that is not contained in braces is '
                  'considered literal\n'
                  'text, which is copied unchanged to the output.  If you need '
                  'to include\n'
                  'a brace character in the literal text, it can be escaped by '
                  'doubling:\n'
                  '"{{" and "}}".\n'
                  '\n'
                  'The grammar for a replacement field is as follows:\n'
                  '\n'
                  '      replacement_field ::= "{" [field_name] ["!" '
                  'conversion] [":" format_spec] "}"\n'
                  '      field_name        ::= arg_name ("." attribute_name | '
                  '"[" element_index "]")*\n'
                  '      arg_name          ::= [identifier | integer]\n'
                  '      attribute_name    ::= identifier\n'
                  '      element_index     ::= integer | index_string\n'
                  '      index_string      ::= <any source character except '
                  '"]"> +\n'
                  '      conversion        ::= "r" | "s"\n'
                  '      format_spec       ::= <described in the next '
                  'section>\n'
                  '\n'
                  'In less formal terms, the replacement field can start with '
                  'a\n'
                  '*field_name* that specifies the object whose value is to be '
                  'formatted\n'
                  'and inserted into the output instead of the replacement '
                  'field. The\n'
                  '*field_name* is optionally followed by a  *conversion* '
                  'field, which is\n'
                  'preceded by an exclamation point "\'!\'", and a '
                  '*format_spec*, which is\n'
                  'preceded by a colon "\':\'".  These specify a non-default '
                  'format for the\n'
                  'replacement value.\n'
                  '\n'
                  'See also the Format Specification Mini-Language section.\n'
                  '\n'
                  'The *field_name* itself begins with an *arg_name* that is '
                  'either a\n'
                  "number or a keyword.  If it's a number, it refers to a "
                  'positional\n'
                  "argument, and if it's a keyword, it refers to a named "
                  'keyword\n'
                  'argument.  If the numerical arg_names in a format string '
                  'are 0, 1, 2,\n'
                  '... in sequence, they can all be omitted (not just some) '
                  'and the\n'
                  'numbers 0, 1, 2, ... will be automatically inserted in that '
                  'order.\n'
                  'Because *arg_name* is not quote-delimited, it is not '
                  'possible to\n'
                  'specify arbitrary dictionary keys (e.g., the strings '
                  '"\'10\'" or\n'
                  '"\':-]\'") within a format string. The *arg_name* can be '
                  'followed by any\n'
                  'number of index or attribute expressions. An expression of '
                  'the form\n'
                  '"\'.name\'" selects the named attribute using "getattr()", '
                  'while an\n'
                  'expression of the form "\'[index]\'" does an index lookup '
                  'using\n'
                  '"__getitem__()".\n'
                  '\n'
                  'Changed in version 2.7: The positional argument specifiers '
                  'can be\n'
                  'omitted, so "\'{} {}\'" is equivalent to "\'{0} {1}\'".\n'
                  '\n'
                  'Some simple format string examples:\n'
                  '\n'
                  '   "First, thou shalt count to {0}"  # References first '
                  'positional argument\n'
                  '   "Bring me a {}"                   # Implicitly '
                  'references the first positional argument\n'
                  '   "From {} to {}"                   # Same as "From {0} to '
                  '{1}"\n'
                  '   "My quest is {name}"              # References keyword '
                  "argument 'name'\n"
                  '   "Weight in tons {0.weight}"       # \'weight\' attribute '
                  'of first positional arg\n'
                  '   "Units destroyed: {players[0]}"   # First element of '
                  "keyword argument 'players'.\n"
                  '\n'
                  'The *conversion* field causes a type coercion before '
                  'formatting.\n'
                  'Normally, the job of formatting a value is done by the '
                  '"__format__()"\n'
                  'method of the value itself.  However, in some cases it is '
                  'desirable to\n'
                  'force a type to be formatted as a string, overriding its '
                  'own\n'
                  'definition of formatting.  By converting the value to a '
                  'string before\n'
                  'calling "__format__()", the normal formatting logic is '
                  'bypassed.\n'
                  '\n'
                  'Two conversion flags are currently supported: "\'!s\'" '
                  'which calls\n'
                  '"str()" on the value, and "\'!r\'" which calls "repr()".\n'
                  '\n'
                  'Some examples:\n'
                  '\n'
                  '   "Harold\'s a clever {0!s}"        # Calls str() on the '
                  'argument first\n'
                  '   "Bring out the holy {name!r}"    # Calls repr() on the '
                  'argument first\n'
                  '\n'
                  'The *format_spec* field contains a specification of how the '
                  'value\n'
                  'should be presented, including such details as field width, '
                  'alignment,\n'
                  'padding, decimal precision and so on.  Each value type can '
                  'define its\n'
                  'own "formatting mini-language" or interpretation of the '
                  '*format_spec*.\n'
                  '\n'
                  'Most built-in types support a common formatting '
                  'mini-language, which\n'
                  'is described in the next section.\n'
                  '\n'
                  'A *format_spec* field can also include nested replacement '
                  'fields\n'
                  'within it. These nested replacement fields may contain a '
                  'field name,\n'
                  'conversion flag and format specification, but deeper '
                  'nesting is not\n'
                  'allowed.  The replacement fields within the format_spec '
                  'are\n'
                  'substituted before the *format_spec* string is interpreted. '
                  'This\n'
                  'allows the formatting of a value to be dynamically '
                  'specified.\n'
                  '\n'
                  'See the Format examples section for some examples.\n'
                  '\n'
                  '\n'
                  'Format Specification Mini-Language\n'
                  '==================================\n'
                  '\n'
                  '"Format specifications" are used within replacement fields '
                  'contained\n'
                  'within a format string to define how individual values are '
                  'presented\n'
                  '(see Format String Syntax).  They can also be passed '
                  'directly to the\n'
                  'built-in "format()" function.  Each formattable type may '
                  'define how\n'
                  'the format specification is to be interpreted.\n'
                  '\n'
                  'Most built-in types implement the following options for '
                  'format\n'
                  'specifications, although some of the formatting options are '
                  'only\n'
                  'supported by the numeric types.\n'
                  '\n'
                  'A general convention is that an empty format string ("""") '
                  'produces\n'
                  'the same result as if you had called "str()" on the value. '
                  'A non-empty\n'
                  'format string typically modifies the result.\n'
                  '\n'
                  'The general form of a *standard format specifier* is:\n'
                  '\n'
                  '   format_spec ::= '
                  '[[fill]align][sign][#][0][width][,][.precision][type]\n'
                  '   fill        ::= <any character>\n'
                  '   align       ::= "<" | ">" | "=" | "^"\n'
                  '   sign        ::= "+" | "-" | " "\n'
                  '   width       ::= integer\n'
                  '   precision   ::= integer\n'
                  '   type        ::= "b" | "c" | "d" | "e" | "E" | "f" | "F" '
                  '| "g" | "G" | "n" | "o" | "s" | "x" | "X" | "%"\n'
                  '\n'
                  'If a valid *align* value is specified, it can be preceded '
                  'by a *fill*\n'
                  'character that can be any character and defaults to a space '
                  'if\n'
                  'omitted. It is not possible to use a literal curly brace '
                  '(""{"" or\n'
                  '""}"") as the *fill* character when using the '
                  '"str.format()" method.\n'
                  'However, it is possible to insert a curly brace with a '
                  'nested\n'
                  "replacement field.  This limitation doesn't affect the "
                  '"format()"\n'
                  'function.\n'
                  '\n'
                  'The meaning of the various alignment options is as '
                  'follows:\n'
                  '\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | Option    | '
                  'Meaning                                                    '
                  '|\n'
                  '   '
                  '+===========+============================================================+\n'
                  '   | "\'<\'"     | Forces the field to be left-aligned '
                  'within the available   |\n'
                  '   |           | space (this is the default for most '
                  'objects).              |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'>\'"     | Forces the field to be right-aligned '
                  'within the available  |\n'
                  '   |           | space (this is the default for '
                  'numbers).                   |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'=\'"     | Forces the padding to be placed after '
                  'the sign (if any)    |\n'
                  '   |           | but before the digits.  This is used for '
                  'printing fields   |\n'
                  "   |           | in the form '+000000120'. This alignment "
                  'option is only    |\n'
                  '   |           | valid for numeric types.  It becomes the '
                  "default when '0'  |\n"
                  '   |           | immediately precedes the field '
                  'width.                      |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'^\'"     | Forces the field to be centered within '
                  'the available       |\n'
                  '   |           | '
                  'space.                                                     '
                  '|\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  'Note that unless a minimum field width is defined, the '
                  'field width\n'
                  'will always be the same size as the data to fill it, so '
                  'that the\n'
                  'alignment option has no meaning in this case.\n'
                  '\n'
                  'The *sign* option is only valid for number types, and can '
                  'be one of\n'
                  'the following:\n'
                  '\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | Option    | '
                  'Meaning                                                    '
                  '|\n'
                  '   '
                  '+===========+============================================================+\n'
                  '   | "\'+\'"     | indicates that a sign should be used for '
                  'both positive as  |\n'
                  '   |           | well as negative '
                  'numbers.                                  |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'-\'"     | indicates that a sign should be used '
                  'only for negative     |\n'
                  '   |           | numbers (this is the default '
                  'behavior).                    |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | space     | indicates that a leading space should be '
                  'used on positive  |\n'
                  '   |           | numbers, and a minus sign on negative '
                  'numbers.             |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  'The "\'#\'" option is only valid for integers, and only for '
                  'binary,\n'
                  'octal, or hexadecimal output.  If present, it specifies '
                  'that the\n'
                  'output will be prefixed by "\'0b\'", "\'0o\'", or "\'0x\'", '
                  'respectively.\n'
                  '\n'
                  'The "\',\'" option signals the use of a comma for a '
                  'thousands separator.\n'
                  'For a locale aware separator, use the "\'n\'" integer '
                  'presentation type\n'
                  'instead.\n'
                  '\n'
                  'Changed in version 2.7: Added the "\',\'" option (see also '
                  '**PEP 378**).\n'
                  '\n'
                  '*width* is a decimal integer defining the minimum field '
                  'width.  If not\n'
                  'specified, then the field width will be determined by the '
                  'content.\n'
                  '\n'
                  'When no explicit alignment is given, preceding the *width* '
                  'field by a\n'
                  'zero ("\'0\'") character enables sign-aware zero-padding '
                  'for numeric\n'
                  'types.  This is equivalent to a *fill* character of "\'0\'" '
                  'with an\n'
                  '*alignment* type of "\'=\'".\n'
                  '\n'
                  'The *precision* is a decimal number indicating how many '
                  'digits should\n'
                  'be displayed after the decimal point for a floating point '
                  'value\n'
                  'formatted with "\'f\'" and "\'F\'", or before and after the '
                  'decimal point\n'
                  'for a floating point value formatted with "\'g\'" or '
                  '"\'G\'".  For non-\n'
                  'number types the field indicates the maximum field size - '
                  'in other\n'
                  'words, how many characters will be used from the field '
                  'content. The\n'
                  '*precision* is not allowed for integer values.\n'
                  '\n'
                  'Finally, the *type* determines how the data should be '
                  'presented.\n'
                  '\n'
                  'The available string presentation types are:\n'
                  '\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | Type      | '
                  'Meaning                                                    '
                  '|\n'
                  '   '
                  '+===========+============================================================+\n'
                  '   | "\'s\'"     | String format. This is the default type '
                  'for strings and    |\n'
                  '   |           | may be '
                  'omitted.                                            |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | None      | The same as '
                  '"\'s\'".                                         |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  'The available integer presentation types are:\n'
                  '\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | Type      | '
                  'Meaning                                                    '
                  '|\n'
                  '   '
                  '+===========+============================================================+\n'
                  '   | "\'b\'"     | Binary format. Outputs the number in '
                  'base 2.               |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'c\'"     | Character. Converts the integer to the '
                  'corresponding       |\n'
                  '   |           | unicode character before '
                  'printing.                         |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'d\'"     | Decimal Integer. Outputs the number in '
                  'base 10.            |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'o\'"     | Octal format. Outputs the number in base '
                  '8.                |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'x\'"     | Hex format. Outputs the number in base '
                  '16, using lower-    |\n'
                  '   |           | case letters for the digits above '
                  '9.                       |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'X\'"     | Hex format. Outputs the number in base '
                  '16, using upper-    |\n'
                  '   |           | case letters for the digits above '
                  '9.                       |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'n\'"     | Number. This is the same as "\'d\'", '
                  'except that it uses the |\n'
                  '   |           | current locale setting to insert the '
                  'appropriate number    |\n'
                  '   |           | separator '
                  'characters.                                      |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | None      | The same as '
                  '"\'d\'".                                         |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  'In addition to the above presentation types, integers can '
                  'be formatted\n'
                  'with the floating point presentation types listed below '
                  '(except "\'n\'"\n'
                  'and None). When doing so, "float()" is used to convert the '
                  'integer to\n'
                  'a floating point number before formatting.\n'
                  '\n'
                  'The available presentation types for floating point and '
                  'decimal values\n'
                  'are:\n'
                  '\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | Type      | '
                  'Meaning                                                    '
                  '|\n'
                  '   '
                  '+===========+============================================================+\n'
                  '   | "\'e\'"     | Exponent notation. Prints the number in '
                  'scientific         |\n'
                  "   |           | notation using the letter 'e' to indicate "
                  'the exponent.    |\n'
                  '   |           | The default precision is '
                  '"6".                              |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'E\'"     | Exponent notation. Same as "\'e\'" '
                  'except it uses an upper   |\n'
                  "   |           | case 'E' as the separator "
                  'character.                       |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'f\'"     | Fixed point. Displays the number as a '
                  'fixed-point number.  |\n'
                  '   |           | The default precision is '
                  '"6".                              |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'F\'"     | Fixed point. Same as '
                  '"\'f\'".                                |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'g\'"     | General format.  For a given precision '
                  '"p >= 1", this      |\n'
                  '   |           | rounds the number to "p" significant '
                  'digits and then       |\n'
                  '   |           | formats the result in either fixed-point '
                  'format or in      |\n'
                  '   |           | scientific notation, depending on its '
                  'magnitude.  The      |\n'
                  '   |           | precise rules are as follows: suppose that '
                  'the result      |\n'
                  '   |           | formatted with presentation type "\'e\'" '
                  'and precision "p-1" |\n'
                  '   |           | would have exponent "exp".  Then if "-4 <= '
                  'exp < p", the   |\n'
                  '   |           | number is formatted with presentation type '
                  '"\'f\'" and       |\n'
                  '   |           | precision "p-1-exp".  Otherwise, the '
                  'number is formatted   |\n'
                  '   |           | with presentation type "\'e\'" and '
                  'precision "p-1". In both  |\n'
                  '   |           | cases insignificant trailing zeros are '
                  'removed from the    |\n'
                  '   |           | significand, and the decimal point is also '
                  'removed if      |\n'
                  '   |           | there are no remaining digits following '
                  'it.  Positive and  |\n'
                  '   |           | negative infinity, positive and negative '
                  'zero, and nans,   |\n'
                  '   |           | are formatted as "inf", "-inf", "0", "-0" '
                  'and "nan"        |\n'
                  '   |           | respectively, regardless of the '
                  'precision.  A precision of |\n'
                  '   |           | "0" is treated as equivalent to a '
                  'precision of "1". The    |\n'
                  '   |           | default precision is '
                  '"6".                                  |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'G\'"     | General format. Same as "\'g\'" except '
                  'switches to "\'E\'" if  |\n'
                  '   |           | the number gets too large. The '
                  'representations of infinity |\n'
                  '   |           | and NaN are uppercased, '
                  'too.                               |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'n\'"     | Number. This is the same as "\'g\'", '
                  'except that it uses the |\n'
                  '   |           | current locale setting to insert the '
                  'appropriate number    |\n'
                  '   |           | separator '
                  'characters.                                      |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'%\'"     | Percentage. Multiplies the number by 100 '
                  'and displays in   |\n'
                  '   |           | fixed ("\'f\'") format, followed by a '
                  'percent sign.          |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | None      | The same as '
                  '"\'g\'".                                         |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  '\n'
                  'Format examples\n'
                  '===============\n'
                  '\n'
                  'This section contains examples of the "str.format()" syntax '
                  'and\n'
                  'comparison with the old "%"-formatting.\n'
                  '\n'
                  'In most of the cases the syntax is similar to the old '
                  '"%"-formatting,\n'
                  'with the addition of the "{}" and with ":" used instead of '
                  '"%". For\n'
                  'example, "\'%03.2f\'" can be translated to "\'{:03.2f}\'".\n'
                  '\n'
                  'The new format syntax also supports new and different '
                  'options, shown\n'
                  'in the follow examples.\n'
                  '\n'
                  'Accessing arguments by position:\n'
                  '\n'
                  "   >>> '{0}, {1}, {2}'.format('a', 'b', 'c')\n"
                  "   'a, b, c'\n"
                  "   >>> '{}, {}, {}'.format('a', 'b', 'c')  # 2.7+ only\n"
                  "   'a, b, c'\n"
                  "   >>> '{2}, {1}, {0}'.format('a', 'b', 'c')\n"
                  "   'c, b, a'\n"
                  "   >>> '{2}, {1}, {0}'.format(*'abc')      # unpacking "
                  'argument sequence\n'
                  "   'c, b, a'\n"
                  "   >>> '{0}{1}{0}'.format('abra', 'cad')   # arguments' "
                  'indices can be repeated\n'
                  "   'abracadabra'\n"
                  '\n'
                  'Accessing arguments by name:\n'
                  '\n'
                  "   >>> 'Coordinates: {latitude}, "
                  "{longitude}'.format(latitude='37.24N', "
                  "longitude='-115.81W')\n"
                  "   'Coordinates: 37.24N, -115.81W'\n"
                  "   >>> coord = {'latitude': '37.24N', 'longitude': "
                  "'-115.81W'}\n"
                  "   >>> 'Coordinates: {latitude}, "
                  "{longitude}'.format(**coord)\n"
                  "   'Coordinates: 37.24N, -115.81W'\n"
                  '\n'
                  "Accessing arguments' attributes:\n"
                  '\n'
                  '   >>> c = 3-5j\n'
                  "   >>> ('The complex number {0} is formed from the real "
                  "part {0.real} '\n"
                  "   ...  'and the imaginary part {0.imag}.').format(c)\n"
                  "   'The complex number (3-5j) is formed from the real part "
                  "3.0 and the imaginary part -5.0.'\n"
                  '   >>> class Point(object):\n'
                  '   ...     def __init__(self, x, y):\n'
                  '   ...         self.x, self.y = x, y\n'
                  '   ...     def __str__(self):\n'
                  "   ...         return 'Point({self.x}, "
                  "{self.y})'.format(self=self)\n"
                  '   ...\n'
                  '   >>> str(Point(4, 2))\n'
                  "   'Point(4, 2)'\n"
                  '\n'
                  "Accessing arguments' items:\n"
                  '\n'
                  '   >>> coord = (3, 5)\n'
                  "   >>> 'X: {0[0]};  Y: {0[1]}'.format(coord)\n"
                  "   'X: 3;  Y: 5'\n"
                  '\n'
                  'Replacing "%s" and "%r":\n'
                  '\n'
                  '   >>> "repr() shows quotes: {!r}; str() doesn\'t: '
                  '{!s}".format(\'test1\', \'test2\')\n'
                  '   "repr() shows quotes: \'test1\'; str() doesn\'t: test2"\n'
                  '\n'
                  'Aligning the text and specifying a width:\n'
                  '\n'
                  "   >>> '{:<30}'.format('left aligned')\n"
                  "   'left aligned                  '\n"
                  "   >>> '{:>30}'.format('right aligned')\n"
                  "   '                 right aligned'\n"
                  "   >>> '{:^30}'.format('centered')\n"
                  "   '           centered           '\n"
                  "   >>> '{:*^30}'.format('centered')  # use '*' as a fill "
                  'char\n'
                  "   '***********centered***********'\n"
                  '\n'
                  'Replacing "%+f", "%-f", and "% f" and specifying a sign:\n'
                  '\n'
                  "   >>> '{:+f}; {:+f}'.format(3.14, -3.14)  # show it "
                  'always\n'
                  "   '+3.140000; -3.140000'\n"
                  "   >>> '{: f}; {: f}'.format(3.14, -3.14)  # show a space "
                  'for positive numbers\n'
                  "   ' 3.140000; -3.140000'\n"
                  "   >>> '{:-f}; {:-f}'.format(3.14, -3.14)  # show only the "
                  "minus -- same as '{:f}; {:f}'\n"
                  "   '3.140000; -3.140000'\n"
                  '\n'
                  'Replacing "%x" and "%o" and converting the value to '
                  'different bases:\n'
                  '\n'
                  '   >>> # format also supports binary numbers\n'
                  '   >>> "int: {0:d};  hex: {0:x};  oct: {0:o};  bin: '
                  '{0:b}".format(42)\n'
                  "   'int: 42;  hex: 2a;  oct: 52;  bin: 101010'\n"
                  '   >>> # with 0x, 0o, or 0b as prefix:\n'
                  '   >>> "int: {0:d};  hex: {0:#x};  oct: {0:#o};  bin: '
                  '{0:#b}".format(42)\n'
                  "   'int: 42;  hex: 0x2a;  oct: 0o52;  bin: 0b101010'\n"
                  '\n'
                  'Using the comma as a thousands separator:\n'
                  '\n'
                  "   >>> '{:,}'.format(1234567890)\n"
                  "   '1,234,567,890'\n"
                  '\n'
                  'Expressing a percentage:\n'
                  '\n'
                  '   >>> points = 19.5\n'
                  '   >>> total = 22\n'
                  "   >>> 'Correct answers: {:.2%}'.format(points/total)\n"
                  "   'Correct answers: 88.64%'\n"
                  '\n'
                  'Using type-specific formatting:\n'
                  '\n'
                  '   >>> import datetime\n'
                  '   >>> d = datetime.datetime(2010, 7, 4, 12, 15, 58)\n'
                  "   >>> '{:%Y-%m-%d %H:%M:%S}'.format(d)\n"
                  "   '2010-07-04 12:15:58'\n"
                  '\n'
                  'Nesting arguments and more complex examples:\n'
                  '\n'
                  "   >>> for align, text in zip('<^>', ['left', 'center', "
                  "'right']):\n"
                  "   ...     '{0:{fill}{align}16}'.format(text, fill=align, "
                  'align=align)\n'
                  '   ...\n'
                  "   'left<<<<<<<<<<<<'\n"
                  "   '^^^^^center^^^^^'\n"
                  "   '>>>>>>>>>>>right'\n"
                  '   >>>\n'
                  '   >>> octets = [192, 168, 0, 1]\n'
                  "   >>> '{:02X}{:02X}{:02X}{:02X}'.format(*octets)\n"
                  "   'C0A80001'\n"
                  '   >>> int(_, 16)\n'
                  '   3232235521\n'
                  '   >>>\n'
                  '   >>> width = 5\n'
                  '   >>> for num in range(5,12):\n'
                  "   ...     for base in 'dXob':\n"
                  "   ...         print '{0:{width}{base}}'.format(num, "
                  'base=base, width=width),\n'
                  '   ...     print\n'
                  '   ...\n'
                  '       5     5     5   101\n'
                  '       6     6     6   110\n'
                  '       7     7     7   111\n'
                  '       8     8    10  1000\n'
                  '       9     9    11  1001\n'
                  '      10     A    12  1010\n'
                  '      11     B    13  1011\n',
 'function': '\n'
             'Function definitions\n'
             '********************\n'
             '\n'
             'A function definition defines a user-defined function object '
             '(see\n'
             'section The standard type hierarchy):\n'
             '\n'
             '   decorated      ::= decorators (classdef | funcdef)\n'
             '   decorators     ::= decorator+\n'
             '   decorator      ::= "@" dotted_name ["(" [argument_list [","]] '
             '")"] NEWLINE\n'
             '   funcdef        ::= "def" funcname "(" [parameter_list] ")" '
             '":" suite\n'
             '   dotted_name    ::= identifier ("." identifier)*\n'
             '   parameter_list ::= (defparameter ",")*\n'
             '                      (  "*" identifier ["," "**" identifier]\n'
             '                      | "**" identifier\n'
             '                      | defparameter [","] )\n'
             '   defparameter   ::= parameter ["=" expression]\n'
             '   sublist        ::= parameter ("," parameter)* [","]\n'
             '   parameter      ::= identifier | "(" sublist ")"\n'
             '   funcname       ::= identifier\n'
             '\n'
             'A function definition is an executable statement.  Its execution '
             'binds\n'
             'the function name in the current local namespace to a function '
             'object\n'
             '(a wrapper around the executable code for the function).  This\n'
             'function object contains a reference to the current global '
             'namespace\n'
             'as the global namespace to be used when the function is called.\n'
             '\n'
             'The function definition does not execute the function body; this '
             'gets\n'
             'executed only when the function is called. [3]\n'
             '\n'
             'A function definition may be wrapped by one or more *decorator*\n'
             'expressions. Decorator expressions are evaluated when the '
             'function is\n'
             'defined, in the scope that contains the function definition.  '
             'The\n'
             'result must be a callable, which is invoked with the function '
             'object\n'
             'as the only argument. The returned value is bound to the '
             'function name\n'
             'instead of the function object.  Multiple decorators are applied '
             'in\n'
             'nested fashion. For example, the following code:\n'
             '\n'
             '   @f1(arg)\n'
             '   @f2\n'
             '   def func(): pass\n'
             '\n'
             'is equivalent to:\n'
             '\n'
             '   def func(): pass\n'
             '   func = f1(arg)(f2(func))\n'
             '\n'
             'When one or more top-level *parameters* have the form '
             '*parameter* "="\n'
             '*expression*, the function is said to have "default parameter '
             'values."\n'
             'For a parameter with a default value, the corresponding '
             '*argument* may\n'
             "be omitted from a call, in which case the parameter's default "
             'value is\n'
             'substituted.  If a parameter has a default value, all following\n'
             'parameters must also have a default value --- this is a '
             'syntactic\n'
             'restriction that is not expressed by the grammar.\n'
             '\n'
             '**Default parameter values are evaluated when the function '
             'definition\n'
             'is executed.**  This means that the expression is evaluated '
             'once, when\n'
             'the function is defined, and that the same "pre-computed" value '
             'is\n'
             'used for each call.  This is especially important to understand '
             'when a\n'
             'default parameter is a mutable object, such as a list or a '
             'dictionary:\n'
             'if the function modifies the object (e.g. by appending an item '
             'to a\n'
             'list), the default value is in effect modified. This is '
             'generally not\n'
             'what was intended.  A way around this  is to use "None" as the\n'
             'default, and explicitly test for it in the body of the function, '
             'e.g.:\n'
             '\n'
             '   def whats_on_the_telly(penguin=None):\n'
             '       if penguin is None:\n'
             '           penguin = []\n'
             '       penguin.append("property of the zoo")\n'
             '       return penguin\n'
             '\n'
             'Function call semantics are described in more detail in section '
             'Calls.\n'
             'A function call always assigns values to all parameters '
             'mentioned in\n'
             'the parameter list, either from position arguments, from '
             'keyword\n'
             'arguments, or from default values.  If the form ""*identifier"" '
             'is\n'
             'present, it is initialized to a tuple receiving any excess '
             'positional\n'
             'parameters, defaulting to the empty tuple.  If the form\n'
             '""**identifier"" is present, it is initialized to a new '
             'dictionary\n'
             'receiving any excess keyword arguments, defaulting to a new '
             'empty\n'
             'dictionary.\n'
             '\n'
             'It is also possible to create anonymous functions (functions not '
             'bound\n'
             'to a name), for immediate use in expressions.  This uses lambda\n'
             'expressions, described in section Lambdas.  Note that the '
             'lambda\n'
             'expression is merely a shorthand for a simplified function '
             'definition;\n'
             'a function defined in a ""def"" statement can be passed around '
             'or\n'
             'assigned to another name just like a function defined by a '
             'lambda\n'
             'expression.  The ""def"" form is actually more powerful since '
             'it\n'
             'allows the execution of multiple statements.\n'
             '\n'
             "**Programmer's note:** Functions are first-class objects.  A "
             '""def""\n'
             'form executed inside a function definition defines a local '
             'function\n'
             'that can be returned or passed around.  Free variables used in '
             'the\n'
             'nested function can access the local variables of the function\n'
             'containing the def.  See section Naming and binding for '
             'details.\n',
 'global': '\n'
           'The "global" statement\n'
           '**********************\n'
           '\n'
           '   global_stmt ::= "global" identifier ("," identifier)*\n'
           '\n'
           'The "global" statement is a declaration which holds for the '
           'entire\n'
           'current code block.  It means that the listed identifiers are to '
           'be\n'
           'interpreted as globals.  It would be impossible to assign to a '
           'global\n'
           'variable without "global", although free variables may refer to\n'
           'globals without being declared global.\n'
           '\n'
           'Names listed in a "global" statement must not be used in the same '
           'code\n'
           'block textually preceding that "global" statement.\n'
           '\n'
           'Names listed in a "global" statement must not be defined as '
           'formal\n'
           'parameters or in a "for" loop control target, "class" definition,\n'
           'function definition, or "import" statement.\n'
           '\n'
           '**CPython implementation detail:** The current implementation does '
           'not\n'
           'enforce the latter two restrictions, but programs should not '
           'abuse\n'
           'this freedom, as future implementations may enforce them or '
           'silently\n'
           'change the meaning of the program.\n'
           '\n'
           '**Programmer\'s note:** the "global" is a directive to the '
           'parser.  It\n'
           'applies only to code parsed at the same time as the "global"\n'
           'statement. In particular, a "global" statement contained in an '
           '"exec"\n'
           'statement does not affect the code block *containing* the "exec"\n'
           'statement, and code contained in an "exec" statement is unaffected '
           'by\n'
           '"global" statements in the code containing the "exec" statement.  '
           'The\n'
           'same applies to the "eval()", "execfile()" and "compile()" '
           'functions.\n',
 'id-classes': '\n'
               'Reserved classes of identifiers\n'
               '*******************************\n'
               '\n'
               'Certain classes of identifiers (besides keywords) have '
               'special\n'
               'meanings.  These classes are identified by the patterns of '
               'leading and\n'
               'trailing underscore characters:\n'
               '\n'
               '"_*"\n'
               '   Not imported by "from module import *".  The special '
               'identifier "_"\n'
               '   is used in the interactive interpreter to store the result '
               'of the\n'
               '   last evaluation; it is stored in the "__builtin__" module.  '
               'When\n'
               '   not in interactive mode, "_" has no special meaning and is '
               'not\n'
               '   defined. See section The import statement.\n'
               '\n'
               '   Note: The name "_" is often used in conjunction with\n'
               '     internationalization; refer to the documentation for the\n'
               '     "gettext" module for more information on this '
               'convention.\n'
               '\n'
               '"__*__"\n'
               '   System-defined names. These names are defined by the '
               'interpreter\n'
               '   and its implementation (including the standard library).  '
               'Current\n'
               '   system names are discussed in the Special method names '
               'section and\n'
               '   elsewhere.  More will likely be defined in future versions '
               'of\n'
               '   Python.  *Any* use of "__*__" names, in any context, that '
               'does not\n'
               '   follow explicitly documented use, is subject to breakage '
               'without\n'
               '   warning.\n'
               '\n'
               '"__*"\n'
               '   Class-private names.  Names in this category, when used '
               'within the\n'
               '   context of a class definition, are re-written to use a '
               'mangled form\n'
               '   to help avoid name clashes between "private" attributes of '
               'base and\n'
               '   derived classes. See section Identifiers (Names).\n',
 'identifiers': '\n'
                'Identifiers and keywords\n'
                '************************\n'
                '\n'
                'Identifiers (also referred to as *names*) are described by '
                'the\n'
                'following lexical definitions:\n'
                '\n'
                '   identifier ::= (letter|"_") (letter | digit | "_")*\n'
                '   letter     ::= lowercase | uppercase\n'
                '   lowercase  ::= "a"..."z"\n'
                '   uppercase  ::= "A"..."Z"\n'
                '   digit      ::= "0"..."9"\n'
                '\n'
                'Identifiers are unlimited in length.  Case is significant.\n'
                '\n'
                '\n'
                'Keywords\n'
                '========\n'
                '\n'
                'The following identifiers are used as reserved words, or '
                '*keywords* of\n'
                'the language, and cannot be used as ordinary identifiers.  '
                'They must\n'
                'be spelled exactly as written here:\n'
                '\n'
                '   and       del       from      not       while\n'
                '   as        elif      global    or        with\n'
                '   assert    else      if        pass      yield\n'
                '   break     except    import    print\n'
                '   class     exec      in        raise\n'
                '   continue  finally   is        return\n'
                '   def       for       lambda    try\n'
                '\n'
                'Changed in version 2.4: "None" became a constant and is now '
                'recognized\n'
                'by the compiler as a name for the built-in object "None".  '
                'Although it\n'
                'is not a keyword, you cannot assign a different object to '
                'it.\n'
                '\n'
                'Changed in version 2.5: Using "as" and "with" as identifiers '
                'triggers\n'
                'a warning.  To use them as keywords, enable the '
                '"with_statement"\n'
                'future feature .\n'
                '\n'
                'Changed in version 2.6: "as" and "with" are full keywords.\n'
                '\n'
                '\n'
                'Reserved classes of identifiers\n'
                '===============================\n'
                '\n'
                'Certain classes of identifiers (besides keywords) have '
                'special\n'
                'meanings.  These classes are identified by the patterns of '
                'leading and\n'
                'trailing underscore characters:\n'
                '\n'
                '"_*"\n'
                '   Not imported by "from module import *".  The special '
                'identifier "_"\n'
                '   is used in the interactive interpreter to store the result '
                'of the\n'
                '   last evaluation; it is stored in the "__builtin__" '
                'module.  When\n'
                '   not in interactive mode, "_" has no special meaning and is '
                'not\n'
                '   defined. See section The import statement.\n'
                '\n'
                '   Note: The name "_" is often used in conjunction with\n'
                '     internationalization; refer to the documentation for '
                'the\n'
                '     "gettext" module for more information on this '
                'convention.\n'
                '\n'
                '"__*__"\n'
                '   System-defined names. These names are defined by the '
                'interpreter\n'
                '   and its implementation (including the standard library).  '
                'Current\n'
                '   system names are discussed in the Special method names '
                'section and\n'
                '   elsewhere.  More will likely be defined in future versions '
                'of\n'
                '   Python.  *Any* use of "__*__" names, in any context, that '
                'does not\n'
                '   follow explicitly documented use, is subject to breakage '
                'without\n'
                '   warning.\n'
                '\n'
                '"__*"\n'
                '   Class-private names.  Names in this category, when used '
                'within the\n'
                '   context of a class definition, are re-written to use a '
                'mangled form\n'
                '   to help avoid name clashes between "private" attributes of '
                'base and\n'
                '   derived classes. See section Identifiers (Names).\n',
 'if': '\n'
       'The "if" statement\n'
       '******************\n'
       '\n'
       'The "if" statement is used for conditional execution:\n'
       '\n'
       '   if_stmt ::= "if" expression ":" suite\n'
       '               ( "elif" expression ":" suite )*\n'
       '               ["else" ":" suite]\n'
       '\n'
       'It selects exactly one of the suites by evaluating the expressions '
       'one\n'
       'by one until one is found to be true (see section Boolean operations\n'
       'for the definition of true and false); then that suite is executed\n'
       '(and no other part of the "if" statement is executed or evaluated).\n'
       'If all expressions are false, the suite of the "else" clause, if\n'
       'present, is executed.\n',
 'imaginary': '\n'
              'Imaginary literals\n'
              '******************\n'
              '\n'
              'Imaginary literals are described by the following lexical '
              'definitions:\n'
              '\n'
              '   imagnumber ::= (floatnumber | intpart) ("j" | "J")\n'
              '\n'
              'An imaginary literal yields a complex number with a real part '
              'of 0.0.\n'
              'Complex numbers are represented as a pair of floating point '
              'numbers\n'
              'and have the same restrictions on their range.  To create a '
              'complex\n'
              'number with a nonzero real part, add a floating point number to '
              'it,\n'
              'e.g., "(3+4j)".  Some examples of imaginary literals:\n'
              '\n'
              '   3.14j   10.j    10j     .001j   1e100j  3.14e-10j\n',
 'import': '\n'
           'The "import" statement\n'
           '**********************\n'
           '\n'
           '   import_stmt     ::= "import" module ["as" name] ( "," module '
           '["as" name] )*\n'
           '                   | "from" relative_module "import" identifier '
           '["as" name]\n'
           '                   ( "," identifier ["as" name] )*\n'
           '                   | "from" relative_module "import" "(" '
           'identifier ["as" name]\n'
           '                   ( "," identifier ["as" name] )* [","] ")"\n'
           '                   | "from" module "import" "*"\n'
           '   module          ::= (identifier ".")* identifier\n'
           '   relative_module ::= "."* module | "."+\n'
           '   name            ::= identifier\n'
           '\n'
           'Import statements are executed in two steps: (1) find a module, '
           'and\n'
           'initialize it if necessary; (2) define a name or names in the '
           'local\n'
           'namespace (of the scope where the "import" statement occurs). The\n'
           'statement comes in two forms differing on whether it uses the '
           '"from"\n'
           'keyword. The first form (without "from") repeats these steps for '
           'each\n'
           'identifier in the list. The form with "from" performs step (1) '
           'once,\n'
           'and then performs step (2) repeatedly.\n'
           '\n'
           'To understand how step (1) occurs, one must first understand how\n'
           'Python handles hierarchical naming of modules. To help organize\n'
           'modules and provide a hierarchy in naming, Python has a concept '
           'of\n'
           'packages. A package can contain other packages and modules while\n'
           'modules cannot contain other modules or packages. From a file '
           'system\n'
           'perspective, packages are directories and modules are files.\n'
           '\n'
           'Once the name of the module is known (unless otherwise specified, '
           'the\n'
           'term "module" will refer to both packages and modules), searching '
           'for\n'
           'the module or package can begin. The first place checked is\n'
           '"sys.modules", the cache of all modules that have been imported\n'
           'previously. If the module is found there then it is used in step '
           '(2)\n'
           'of import.\n'
           '\n'
           'If the module is not found in the cache, then "sys.meta_path" is\n'
           'searched (the specification for "sys.meta_path" can be found in '
           '**PEP\n'
           '302**). The object is a list of *finder* objects which are queried '
           'in\n'
           'order as to whether they know how to load the module by calling '
           'their\n'
           '"find_module()" method with the name of the module. If the module\n'
           'happens to be contained within a package (as denoted by the '
           'existence\n'
           'of a dot in the name), then a second argument to "find_module()" '
           'is\n'
           'given as the value of the "__path__" attribute from the parent '
           'package\n'
           '(everything up to the last dot in the name of the module being\n'
           'imported). If a finder can find the module it returns a *loader*\n'
           '(discussed later) or returns "None".\n'
           '\n'
           'If none of the finders on "sys.meta_path" are able to find the '
           'module\n'
           'then some implicitly defined finders are queried. Implementations '
           'of\n'
           'Python vary in what implicit meta path finders are defined. The '
           'one\n'
           'they all do define, though, is one that handles "sys.path_hooks",\n'
           '"sys.path_importer_cache", and "sys.path".\n'
           '\n'
           'The implicit finder searches for the requested module in the '
           '"paths"\n'
           'specified in one of two places ("paths" do not have to be file '
           'system\n'
           'paths). If the module being imported is supposed to be contained\n'
           'within a package then the second argument passed to '
           '"find_module()",\n'
           '"__path__" on the parent package, is used as the source of paths. '
           'If\n'
           'the module is not contained in a package then "sys.path" is used '
           'as\n'
           'the source of paths.\n'
           '\n'
           'Once the source of paths is chosen it is iterated over to find a\n'
           'finder that can handle that path. The dict at\n'
           '"sys.path_importer_cache" caches finders for paths and is checked '
           'for\n'
           'a finder. If the path does not have a finder cached then\n'
           '"sys.path_hooks" is searched by calling each object in the list '
           'with a\n'
           'single argument of the path, returning a finder or raises\n'
           '"ImportError". If a finder is returned then it is cached in\n'
           '"sys.path_importer_cache" and then used for that path entry. If '
           'no\n'
           'finder can be found but the path exists then a value of "None" is\n'
           'stored in "sys.path_importer_cache" to signify that an implicit, '
           'file-\n'
           'based finder that handles modules stored as individual files '
           'should be\n'
           'used for that path. If the path does not exist then a finder '
           'which\n'
           'always returns "None" is placed in the cache for the path.\n'
           '\n'
           'If no finder can find the module then "ImportError" is raised.\n'
           'Otherwise some finder returned a loader whose "load_module()" '
           'method\n'
           'is called with the name of the module to load (see **PEP 302** for '
           'the\n'
           'original definition of loaders). A loader has several '
           'responsibilities\n'
           'to perform on a module it loads. First, if the module already '
           'exists\n'
           'in "sys.modules" (a possibility if the loader is called outside of '
           'the\n'
           'import machinery) then it is to use that module for initialization '
           'and\n'
           'not a new module. But if the module does not exist in '
           '"sys.modules"\n'
           'then it is to be added to that dict before initialization begins. '
           'If\n'
           'an error occurs during loading of the module and it was added to\n'
           '"sys.modules" it is to be removed from the dict. If an error '
           'occurs\n'
           'but the module was already in "sys.modules" it is left in the '
           'dict.\n'
           '\n'
           'The loader must set several attributes on the module. "__name__" '
           'is to\n'
           'be set to the name of the module. "__file__" is to be the "path" '
           'to\n'
           'the file unless the module is built-in (and thus listed in\n'
           '"sys.builtin_module_names") in which case the attribute is not '
           'set. If\n'
           'what is being imported is a package then "__path__" is to be set '
           'to a\n'
           'list of paths to be searched when looking for modules and '
           'packages\n'
           'contained within the package being imported. "__package__" is '
           'optional\n'
           'but should be set to the name of package that contains the module '
           'or\n'
           'package (the empty string is used for module not contained in a\n'
           'package). "__loader__" is also optional but should be set to the\n'
           'loader object that is loading the module.\n'
           '\n'
           'If an error occurs during loading then the loader raises '
           '"ImportError"\n'
           'if some other exception is not already being propagated. Otherwise '
           'the\n'
           'loader returns the module that was loaded and initialized.\n'
           '\n'
           'When step (1) finishes without raising an exception, step (2) can\n'
           'begin.\n'
           '\n'
           'The first form of "import" statement binds the module name in the\n'
           'local namespace to the module object, and then goes on to import '
           'the\n'
           'next identifier, if any.  If the module name is followed by "as", '
           'the\n'
           'name following "as" is used as the local name for the module.\n'
           '\n'
           'The "from" form does not bind the module name: it goes through '
           'the\n'
           'list of identifiers, looks each one of them up in the module found '
           'in\n'
           'step (1), and binds the name in the local namespace to the object '
           'thus\n'
           'found.  As with the first form of "import", an alternate local '
           'name\n'
           'can be supplied by specifying ""as" localname".  If a name is not\n'
           'found, "ImportError" is raised.  If the list of identifiers is\n'
           'replaced by a star ("\'*\'"), all public names defined in the '
           'module are\n'
           'bound in the local namespace of the "import" statement..\n'
           '\n'
           'The *public names* defined by a module are determined by checking '
           'the\n'
           'module\'s namespace for a variable named "__all__"; if defined, it '
           'must\n'
           'be a sequence of strings which are names defined or imported by '
           'that\n'
           'module.  The names given in "__all__" are all considered public '
           'and\n'
           'are required to exist.  If "__all__" is not defined, the set of '
           'public\n'
           "names includes all names found in the module's namespace which do "
           'not\n'
           'begin with an underscore character ("\'_\'"). "__all__" should '
           'contain\n'
           'the entire public API. It is intended to avoid accidentally '
           'exporting\n'
           'items that are not part of the API (such as library modules which '
           'were\n'
           'imported and used within the module).\n'
           '\n'
           'The "from" form with "*" may only occur in a module scope.  If '
           'the\n'
           'wild card form of import --- "import *" --- is used in a function '
           'and\n'
           'the function contains or is a nested block with free variables, '
           'the\n'
           'compiler will raise a "SyntaxError".\n'
           '\n'
           'When specifying what module to import you do not have to specify '
           'the\n'
           'absolute name of the module. When a module or package is '
           'contained\n'
           'within another package it is possible to make a relative import '
           'within\n'
           'the same top package without having to mention the package name. '
           'By\n'
           'using leading dots in the specified module or package after "from" '
           'you\n'
           'can specify how high to traverse up the current package hierarchy\n'
           'without specifying exact names. One leading dot means the current\n'
           'package where the module making the import exists. Two dots means '
           'up\n'
           'one package level. Three dots is up two levels, etc. So if you '
           'execute\n'
           '"from . import mod" from a module in the "pkg" package then you '
           'will\n'
           'end up importing "pkg.mod". If you execute "from ..subpkg2 import '
           'mod"\n'
           'from within "pkg.subpkg1" you will import "pkg.subpkg2.mod". The\n'
           'specification for relative imports is contained within **PEP '
           '328**.\n'
           '\n'
           '"importlib.import_module()" is provided to support applications '
           'that\n'
           'determine which modules need to be loaded dynamically.\n'
           '\n'
           '\n'
           'Future statements\n'
           '=================\n'
           '\n'
           'A *future statement* is a directive to the compiler that a '
           'particular\n'
           'module should be compiled using syntax or semantics that will be\n'
           'available in a specified future release of Python.  The future\n'
           'statement is intended to ease migration to future versions of '
           'Python\n'
           'that introduce incompatible changes to the language.  It allows '
           'use of\n'
           'the new features on a per-module basis before the release in which '
           'the\n'
           'feature becomes standard.\n'
           '\n'
           '   future_statement ::= "from" "__future__" "import" feature ["as" '
           'name]\n'
           '                        ("," feature ["as" name])*\n'
           '                        | "from" "__future__" "import" "(" feature '
           '["as" name]\n'
           '                        ("," feature ["as" name])* [","] ")"\n'
           '   feature          ::= identifier\n'
           '   name             ::= identifier\n'
           '\n'
           'A future statement must appear near the top of the module.  The '
           'only\n'
           'lines that can appear before a future statement are:\n'
           '\n'
           '* the module docstring (if any),\n'
           '\n'
           '* comments,\n'
           '\n'
           '* blank lines, and\n'
           '\n'
           '* other future statements.\n'
           '\n'
           'The features recognized by Python 2.6 are "unicode_literals",\n'
           '"print_function", "absolute_import", "division", "generators",\n'
           '"nested_scopes" and "with_statement".  "generators", '
           '"with_statement",\n'
           '"nested_scopes" are redundant in Python version 2.6 and above '
           'because\n'
           'they are always enabled.\n'
           '\n'
           'A future statement is recognized and treated specially at compile\n'
           'time: Changes to the semantics of core constructs are often\n'
           'implemented by generating different code.  It may even be the '
           'case\n'
           'that a new feature introduces new incompatible syntax (such as a '
           'new\n'
           'reserved word), in which case the compiler may need to parse the\n'
           'module differently.  Such decisions cannot be pushed off until\n'
           'runtime.\n'
           '\n'
           'For any given release, the compiler knows which feature names '
           'have\n'
           'been defined, and raises a compile-time error if a future '
           'statement\n'
           'contains a feature not known to it.\n'
           '\n'
           'The direct runtime semantics are the same as for any import '
           'statement:\n'
           'there is a standard module "__future__", described later, and it '
           'will\n'
           'be imported in the usual way at the time the future statement is\n'
           'executed.\n'
           '\n'
           'The interesting runtime semantics depend on the specific feature\n'
           'enabled by the future statement.\n'
           '\n'
           'Note that there is nothing special about the statement:\n'
           '\n'
           '   import __future__ [as name]\n'
           '\n'
           "That is not a future statement; it's an ordinary import statement "
           'with\n'
           'no special semantics or syntax restrictions.\n'
           '\n'
           'Code compiled by an "exec" statement or calls to the built-in\n'
           'functions "compile()" and "execfile()" that occur in a module "M"\n'
           'containing a future statement will, by default, use the new  '
           'syntax or\n'
           'semantics associated with the future statement.  This can, '
           'starting\n'
           'with Python 2.2 be controlled by optional arguments to "compile()" '
           '---\n'
           'see the documentation of that function for details.\n'
           '\n'
           'A future statement typed at an interactive interpreter prompt '
           'will\n'
           'take effect for the rest of the interpreter session.  If an\n'
           'interpreter is started with the "-i" option, is passed a script '
           'name\n'
           'to execute, and the script includes a future statement, it will be '
           'in\n'
           'effect in the interactive session started after the script is\n'
           'executed.\n'
           '\n'
           'See also:\n'
           '\n'
           '  **PEP 236** - Back to the __future__\n'
           '     The original proposal for the __future__ mechanism.\n',
 'in': '\n'
       'Comparisons\n'
       '***********\n'
       '\n'
       'Unlike C, all comparison operations in Python have the same priority,\n'
       'which is lower than that of any arithmetic, shifting or bitwise\n'
       'operation.  Also unlike C, expressions like "a < b < c" have the\n'
       'interpretation that is conventional in mathematics:\n'
       '\n'
       '   comparison    ::= or_expr ( comp_operator or_expr )*\n'
       '   comp_operator ::= "<" | ">" | "==" | ">=" | "<=" | "<>" | "!="\n'
       '                     | "is" ["not"] | ["not"] "in"\n'
       '\n'
       'Comparisons yield boolean values: "True" or "False".\n'
       '\n'
       'Comparisons can be chained arbitrarily, e.g., "x < y <= z" is\n'
       'equivalent to "x < y and y <= z", except that "y" is evaluated only\n'
       'once (but in both cases "z" is not evaluated at all when "x < y" is\n'
       'found to be false).\n'
       '\n'
       'Formally, if *a*, *b*, *c*, ..., *y*, *z* are expressions and *op1*,\n'
       '*op2*, ..., *opN* are comparison operators, then "a op1 b op2 c ... y\n'
       'opN z" is equivalent to "a op1 b and b op2 c and ... y opN z", except\n'
       'that each expression is evaluated at most once.\n'
       '\n'
       'Note that "a op1 b op2 c" doesn\'t imply any kind of comparison '
       'between\n'
       '*a* and *c*, so that, e.g., "x < y > z" is perfectly legal (though\n'
       'perhaps not pretty).\n'
       '\n'
       'The forms "<>" and "!=" are equivalent; for consistency with C, "!="\n'
       'is preferred; where "!=" is mentioned below "<>" is also accepted.\n'
       'The "<>" spelling is considered obsolescent.\n'
       '\n'
       'The operators "<", ">", "==", ">=", "<=", and "!=" compare the values\n'
       'of two objects.  The objects need not have the same type. If both are\n'
       'numbers, they are converted to a common type.  Otherwise, objects of\n'
       'different types *always* compare unequal, and are ordered '
       'consistently\n'
       'but arbitrarily. You can control comparison behavior of objects of\n'
       'non-built-in types by defining a "__cmp__" method or rich comparison\n'
       'methods like "__gt__", described in section Special method names.\n'
       '\n'
       '(This unusual definition of comparison was used to simplify the\n'
       'definition of operations like sorting and the "in" and "not in"\n'
       'operators. In the future, the comparison rules for objects of\n'
       'different types are likely to change.)\n'
       '\n'
       'Comparison of objects of the same type depends on the type:\n'
       '\n'
       '* Numbers are compared arithmetically.\n'
       '\n'
       '* Strings are compared lexicographically using the numeric\n'
       '  equivalents (the result of the built-in function "ord()") of their\n'
       '  characters. Unicode and 8-bit strings are fully interoperable in\n'
       '  this behavior. [4]\n'
       '\n'
       '* Tuples and lists are compared lexicographically using comparison\n'
       '  of corresponding elements.  This means that to compare equal, each\n'
       '  element must compare equal and the two sequences must be of the '
       'same\n'
       '  type and have the same length.\n'
       '\n'
       '  If not equal, the sequences are ordered the same as their first\n'
       '  differing elements.  For example, "cmp([1,2,x], [1,2,y])" returns\n'
       '  the same as "cmp(x,y)".  If the corresponding element does not\n'
       '  exist, the shorter sequence is ordered first (for example, "[1,2] <\n'
       '  [1,2,3]").\n'
       '\n'
       '* Mappings (dictionaries) compare equal if and only if their sorted\n'
       '  (key, value) lists compare equal. [5] Outcomes other than equality\n'
       '  are resolved consistently, but are not otherwise defined. [6]\n'
       '\n'
       '* Most other objects of built-in types compare unequal unless they\n'
       '  are the same object; the choice whether one object is considered\n'
       '  smaller or larger than another one is made arbitrarily but\n'
       '  consistently within one execution of a program.\n'
       '\n'
       'The operators "in" and "not in" test for collection membership.  "x '
       'in\n'
       's" evaluates to true if *x* is a member of the collection *s*, and\n'
       'false otherwise.  "x not in s" returns the negation of "x in s". The\n'
       'collection membership test has traditionally been bound to sequences;\n'
       'an object is a member of a collection if the collection is a sequence\n'
       'and contains an element equal to that object.  However, it make sense\n'
       'for many other object types to support membership tests without being\n'
       'a sequence.  In particular, dictionaries (for keys) and sets support\n'
       'membership testing.\n'
       '\n'
       'For the list and tuple types, "x in y" is true if and only if there\n'
       'exists an index *i* such that either "x is y[i]" or "x == y[i]" is\n'
       'true.\n'
       '\n'
       'For the Unicode and string types, "x in y" is true if and only if *x*\n'
       'is a substring of *y*.  An equivalent test is "y.find(x) != -1".\n'
       'Note, *x* and *y* need not be the same type; consequently, "u\'ab\' '
       'in\n'
       '\'abc\'" will return "True". Empty strings are always considered to be '
       'a\n'
       'substring of any other string, so """ in "abc"" will return "True".\n'
       '\n'
       'Changed in version 2.3: Previously, *x* was required to be a string '
       'of\n'
       'length "1".\n'
       '\n'
       'For user-defined classes which define the "__contains__()" method, "x\n'
       'in y" is true if and only if "y.__contains__(x)" is true.\n'
       '\n'
       'For user-defined classes which do not define "__contains__()" but do\n'
       'define "__iter__()", "x in y" is true if some value "z" with "x == z"\n'
       'is produced while iterating over "y".  If an exception is raised\n'
       'during the iteration, it is as if "in" raised that exception.\n'
       '\n'
       'Lastly, the old-style iteration protocol is tried: if a class defines\n'
       '"__getitem__()", "x in y" is true if and only if there is a non-\n'
       'negative integer index *i* such that "x == y[i]", and all lower\n'
       'integer indices do not raise "IndexError" exception. (If any other\n'
       'exception is raised, it is as if "in" raised that exception).\n'
       '\n'
       'The operator "not in" is defined to have the inverse true value of\n'
       '"in".\n'
       '\n'
       'The operators "is" and "is not" test for object identity: "x is y" is\n'
       'true if and only if *x* and *y* are the same object.  "x is not y"\n'
       'yields the inverse truth value. [7]\n',
 'integers': '\n'
             'Integer and long integer literals\n'
             '*********************************\n'
             '\n'
             'Integer and long integer literals are described by the '
             'following\n'
             'lexical definitions:\n'
             '\n'
             '   longinteger    ::= integer ("l" | "L")\n'
             '   integer        ::= decimalinteger | octinteger | hexinteger | '
             'bininteger\n'
             '   decimalinteger ::= nonzerodigit digit* | "0"\n'
             '   octinteger     ::= "0" ("o" | "O") octdigit+ | "0" octdigit+\n'
             '   hexinteger     ::= "0" ("x" | "X") hexdigit+\n'
             '   bininteger     ::= "0" ("b" | "B") bindigit+\n'
             '   nonzerodigit   ::= "1"..."9"\n'
             '   octdigit       ::= "0"..."7"\n'
             '   bindigit       ::= "0" | "1"\n'
             '   hexdigit       ::= digit | "a"..."f" | "A"..."F"\n'
             '\n'
             'Although both lower case "\'l\'" and upper case "\'L\'" are '
             'allowed as\n'
             'suffix for long integers, it is strongly recommended to always '
             'use\n'
             '"\'L\'", since the letter "\'l\'" looks too much like the digit '
             '"\'1\'".\n'
             '\n'
             'Plain integer literals that are above the largest representable '
             'plain\n'
             'integer (e.g., 2147483647 when using 32-bit arithmetic) are '
             'accepted\n'
             'as if they were long integers instead. [1]  There is no limit '
             'for long\n'
             'integer literals apart from what can be stored in available '
             'memory.\n'
             '\n'
             'Some examples of plain integer literals (first row) and long '
             'integer\n'
             'literals (second and third rows):\n'
             '\n'
             '   7     2147483647                        0177\n'
             '   3L    79228162514264337593543950336L    0377L   0x100000000L\n'
             '         79228162514264337593543950336             0xdeadbeef\n',
 'lambda': '\n'
           'Lambdas\n'
           '*******\n'
           '\n'
           '   lambda_expr     ::= "lambda" [parameter_list]: expression\n'
           '   old_lambda_expr ::= "lambda" [parameter_list]: old_expression\n'
           '\n'
           'Lambda expressions (sometimes called lambda forms) have the same\n'
           'syntactic position as expressions.  They are a shorthand to '
           'create\n'
           'anonymous functions; the expression "lambda arguments: '
           'expression"\n'
           'yields a function object.  The unnamed object behaves like a '
           'function\n'
           'object defined with\n'
           '\n'
           '   def name(arguments):\n'
           '       return expression\n'
           '\n'
           'See section Function definitions for the syntax of parameter '
           'lists.\n'
           'Note that functions created with lambda expressions cannot '
           'contain\n'
           'statements.\n',
 'lists': '\n'
          'List displays\n'
          '*************\n'
          '\n'
          'A list display is a possibly empty series of expressions enclosed '
          'in\n'
          'square brackets:\n'
          '\n'
          '   list_display        ::= "[" [expression_list | '
          'list_comprehension] "]"\n'
          '   list_comprehension  ::= expression list_for\n'
          '   list_for            ::= "for" target_list "in" '
          'old_expression_list [list_iter]\n'
          '   old_expression_list ::= old_expression [("," old_expression)+ '
          '[","]]\n'
          '   old_expression      ::= or_test | old_lambda_expr\n'
          '   list_iter           ::= list_for | list_if\n'
          '   list_if             ::= "if" old_expression [list_iter]\n'
          '\n'
          'A list display yields a new list object.  Its contents are '
          'specified\n'
          'by providing either a list of expressions or a list comprehension.\n'
          'When a comma-separated list of expressions is supplied, its '
          'elements\n'
          'are evaluated from left to right and placed into the list object '
          'in\n'
          'that order.  When a list comprehension is supplied, it consists of '
          'a\n'
          'single expression followed by at least one "for" clause and zero '
          'or\n'
          'more "for" or "if" clauses.  In this case, the elements of the new\n'
          'list are those that would be produced by considering each of the '
          '"for"\n'
          'or "if" clauses a block, nesting from left to right, and '
          'evaluating\n'
          'the expression to produce a list element each time the innermost '
          'block\n'
          'is reached [1].\n',
 'naming': '\n'
           'Naming and binding\n'
           '******************\n'
           '\n'
           '*Names* refer to objects.  Names are introduced by name binding\n'
           'operations. Each occurrence of a name in the program text refers '
           'to\n'
           'the *binding* of that name established in the innermost function '
           'block\n'
           'containing the use.\n'
           '\n'
           'A *block* is a piece of Python program text that is executed as a\n'
           'unit. The following are blocks: a module, a function body, and a '
           'class\n'
           'definition. Each command typed interactively is a block.  A '
           'script\n'
           'file (a file given as standard input to the interpreter or '
           'specified\n'
           'on the interpreter command line the first argument) is a code '
           'block.\n'
           'A script command (a command specified on the interpreter command '
           'line\n'
           "with the '**-c**' option) is a code block.  The file read by the\n"
           'built-in function "execfile()" is a code block.  The string '
           'argument\n'
           'passed to the built-in function "eval()" and to the "exec" '
           'statement\n'
           'is a code block. The expression read and evaluated by the '
           'built-in\n'
           'function "input()" is a code block.\n'
           '\n'
           'A code block is executed in an *execution frame*.  A frame '
           'contains\n'
           'some administrative information (used for debugging) and '
           'determines\n'
           "where and how execution continues after the code block's execution "
           'has\n'
           'completed.\n'
           '\n'
           'A *scope* defines the visibility of a name within a block.  If a '
           'local\n'
           'variable is defined in a block, its scope includes that block.  If '
           'the\n'
           'definition occurs in a function block, the scope extends to any '
           'blocks\n'
           'contained within the defining one, unless a contained block '
           'introduces\n'
           'a different binding for the name.  The scope of names defined in '
           'a\n'
           'class block is limited to the class block; it does not extend to '
           'the\n'
           'code blocks of methods -- this includes generator expressions '
           'since\n'
           'they are implemented using a function scope.  This means that the\n'
           'following will fail:\n'
           '\n'
           '   class A:\n'
           '       a = 42\n'
           '       b = list(a + i for i in range(10))\n'
           '\n'
           'When a name is used in a code block, it is resolved using the '
           'nearest\n'
           'enclosing scope.  The set of all such scopes visible to a code '
           'block\n'
           "is called the block's *environment*.\n"
           '\n'
           'If a name is bound in a block, it is a local variable of that '
           'block.\n'
           'If a name is bound at the module level, it is a global variable.  '
           '(The\n'
           'variables of the module code block are local and global.)  If a\n'
           'variable is used in a code block but not defined there, it is a '
           '*free\n'
           'variable*.\n'
           '\n'
           'When a name is not found at all, a "NameError" exception is '
           'raised.\n'
           'If the name refers to a local variable that has not been bound, a\n'
           '"UnboundLocalError" exception is raised.  "UnboundLocalError" is '
           'a\n'
           'subclass of "NameError".\n'
           '\n'
           'The following constructs bind names: formal parameters to '
           'functions,\n'
           '"import" statements, class and function definitions (these bind '
           'the\n'
           'class or function name in the defining block), and targets that '
           'are\n'
           'identifiers if occurring in an assignment, "for" loop header, in '
           'the\n'
           'second position of an "except" clause header or after "as" in a '
           '"with"\n'
           'statement.  The "import" statement of the form "from ... import '
           '*"\n'
           'binds all names defined in the imported module, except those '
           'beginning\n'
           'with an underscore.  This form may only be used at the module '
           'level.\n'
           '\n'
           'A target occurring in a "del" statement is also considered bound '
           'for\n'
           'this purpose (though the actual semantics are to unbind the '
           'name).  It\n'
           'is illegal to unbind a name that is referenced by an enclosing '
           'scope;\n'
           'the compiler will report a "SyntaxError".\n'
           '\n'
           'Each assignment or import statement occurs within a block defined '
           'by a\n'
           'class or function definition or at the module level (the '
           'top-level\n'
           'code block).\n'
           '\n'
           'If a name binding operation occurs anywhere within a code block, '
           'all\n'
           'uses of the name within the block are treated as references to '
           'the\n'
           'current block.  This can lead to errors when a name is used within '
           'a\n'
           'block before it is bound. This rule is subtle.  Python lacks\n'
           'declarations and allows name binding operations to occur anywhere\n'
           'within a code block.  The local variables of a code block can be\n'
           'determined by scanning the entire text of the block for name '
           'binding\n'
           'operations.\n'
           '\n'
           'If the global statement occurs within a block, all uses of the '
           'name\n'
           'specified in the statement refer to the binding of that name in '
           'the\n'
           'top-level namespace. Names are resolved in the top-level namespace '
           'by\n'
           'searching the global namespace, i.e. the namespace of the module\n'
           'containing the code block, and the builtins namespace, the '
           'namespace\n'
           'of the module "__builtin__".  The global namespace is searched '
           'first.\n'
           'If the name is not found there, the builtins namespace is '
           'searched.\n'
           'The global statement must precede all uses of the name.\n'
           '\n'
           'The builtins namespace associated with the execution of a code '
           'block\n'
           'is actually found by looking up the name "__builtins__" in its '
           'global\n'
           'namespace; this should be a dictionary or a module (in the latter '
           'case\n'
           "the module's dictionary is used).  By default, when in the "
           '"__main__"\n'
           'module, "__builtins__" is the built-in module "__builtin__" (note: '
           'no\n'
           '\'s\'); when in any other module, "__builtins__" is an alias for '
           'the\n'
           'dictionary of the "__builtin__" module itself.  "__builtins__" can '
           'be\n'
           'set to a user-created dictionary to create a weak form of '
           'restricted\n'
           'execution.\n'
           '\n'
           '**CPython implementation detail:** Users should not touch\n'
           '"__builtins__"; it is strictly an implementation detail.  Users\n'
           'wanting to override values in the builtins namespace should '
           '"import"\n'
           'the "__builtin__" (no \'s\') module and modify its attributes\n'
           'appropriately.\n'
           '\n'
           'The namespace for a module is automatically created the first time '
           'a\n'
           'module is imported.  The main module for a script is always '
           'called\n'
           '"__main__".\n'
           '\n'
           'The "global" statement has the same scope as a name binding '
           'operation\n'
           'in the same block.  If the nearest enclosing scope for a free '
           'variable\n'
           'contains a global statement, the free variable is treated as a '
           'global.\n'
           '\n'
           'A class definition is an executable statement that may use and '
           'define\n'
           'names. These references follow the normal rules for name '
           'resolution.\n'
           'The namespace of the class definition becomes the attribute '
           'dictionary\n'
           'of the class.  Names defined at the class scope are not visible '
           'in\n'
           'methods.\n'
           '\n'
           '\n'
           'Interaction with dynamic features\n'
           '=================================\n'
           '\n'
           'There are several cases where Python statements are illegal when '
           'used\n'
           'in conjunction with nested scopes that contain free variables.\n'
           '\n'
           'If a variable is referenced in an enclosing scope, it is illegal '
           'to\n'
           'delete the name.  An error will be reported at compile time.\n'
           '\n'
           'If the wild card form of import --- "import *" --- is used in a\n'
           'function and the function contains or is a nested block with free\n'
           'variables, the compiler will raise a "SyntaxError".\n'
           '\n'
           'If "exec" is used in a function and the function contains or is a\n'
           'nested block with free variables, the compiler will raise a\n'
           '"SyntaxError" unless the exec explicitly specifies the local '
           'namespace\n'
           'for the "exec".  (In other words, "exec obj" would be illegal, '
           'but\n'
           '"exec obj in ns" would be legal.)\n'
           '\n'
           'The "eval()", "execfile()", and "input()" functions and the '
           '"exec"\n'
           'statement do not have access to the full environment for '
           'resolving\n'
           'names.  Names may be resolved in the local and global namespaces '
           'of\n'
           'the caller.  Free variables are not resolved in the nearest '
           'enclosing\n'
           'namespace, but in the global namespace. [1] The "exec" statement '
           'and\n'
           'the "eval()" and "execfile()" functions have optional arguments '
           'to\n'
           'override the global and local namespace.  If only one namespace '
           'is\n'
           'specified, it is used for both.\n',
 'numbers': '\n'
            'Numeric literals\n'
            '****************\n'
            '\n'
            'There are four types of numeric literals: plain integers, long\n'
            'integers, floating point numbers, and imaginary numbers.  There '
            'are no\n'
            'complex literals (complex numbers can be formed by adding a real\n'
            'number and an imaginary number).\n'
            '\n'
            'Note that numeric literals do not include a sign; a phrase like '
            '"-1"\n'
            'is actually an expression composed of the unary operator \'"-"\' '
            'and the\n'
            'literal "1".\n',
 'numeric-types': '\n'
                  'Emulating numeric types\n'
                  '***********************\n'
                  '\n'
                  'The following methods can be defined to emulate numeric '
                  'objects.\n'
                  'Methods corresponding to operations that are not supported '
                  'by the\n'
                  'particular kind of number implemented (e.g., bitwise '
                  'operations for\n'
                  'non-integral numbers) should be left undefined.\n'
                  '\n'
                  'object.__add__(self, other)\n'
                  'object.__sub__(self, other)\n'
                  'object.__mul__(self, other)\n'
                  'object.__floordiv__(self, other)\n'
                  'object.__mod__(self, other)\n'
                  'object.__divmod__(self, other)\n'
                  'object.__pow__(self, other[, modulo])\n'
                  'object.__lshift__(self, other)\n'
                  'object.__rshift__(self, other)\n'
                  'object.__and__(self, other)\n'
                  'object.__xor__(self, other)\n'
                  'object.__or__(self, other)\n'
                  '\n'
                  '   These methods are called to implement the binary '
                  'arithmetic\n'
                  '   operations ("+", "-", "*", "//", "%", "divmod()", '
                  '"pow()", "**",\n'
                  '   "<<", ">>", "&", "^", "|").  For instance, to evaluate '
                  'the\n'
                  '   expression "x + y", where *x* is an instance of a class '
                  'that has an\n'
                  '   "__add__()" method, "x.__add__(y)" is called.  The '
                  '"__divmod__()"\n'
                  '   method should be the equivalent to using '
                  '"__floordiv__()" and\n'
                  '   "__mod__()"; it should not be related to "__truediv__()" '
                  '(described\n'
                  '   below).  Note that "__pow__()" should be defined to '
                  'accept an\n'
                  '   optional third argument if the ternary version of the '
                  'built-in\n'
                  '   "pow()" function is to be supported.\n'
                  '\n'
                  '   If one of those methods does not support the operation '
                  'with the\n'
                  '   supplied arguments, it should return "NotImplemented".\n'
                  '\n'
                  'object.__div__(self, other)\n'
                  'object.__truediv__(self, other)\n'
                  '\n'
                  '   The division operator ("/") is implemented by these '
                  'methods.  The\n'
                  '   "__truediv__()" method is used when '
                  '"__future__.division" is in\n'
                  '   effect, otherwise "__div__()" is used.  If only one of '
                  'these two\n'
                  '   methods is defined, the object will not support division '
                  'in the\n'
                  '   alternate context; "TypeError" will be raised instead.\n'
                  '\n'
                  'object.__radd__(self, other)\n'
                  'object.__rsub__(self, other)\n'
                  'object.__rmul__(self, other)\n'
                  'object.__rdiv__(self, other)\n'
                  'object.__rtruediv__(self, other)\n'
                  'object.__rfloordiv__(self, other)\n'
                  'object.__rmod__(self, other)\n'
                  'object.__rdivmod__(self, other)\n'
                  'object.__rpow__(self, other)\n'
                  'object.__rlshift__(self, other)\n'
                  'object.__rrshift__(self, other)\n'
                  'object.__rand__(self, other)\n'
                  'object.__rxor__(self, other)\n'
                  'object.__ror__(self, other)\n'
                  '\n'
                  '   These methods are called to implement the binary '
                  'arithmetic\n'
                  '   operations ("+", "-", "*", "/", "%", "divmod()", '
                  '"pow()", "**",\n'
                  '   "<<", ">>", "&", "^", "|") with reflected (swapped) '
                  'operands.\n'
                  '   These functions are only called if the left operand does '
                  'not\n'
                  '   support the corresponding operation and the operands are '
                  'of\n'
                  '   different types. [2] For instance, to evaluate the '
                  'expression "x -\n'
                  '   y", where *y* is an instance of a class that has an '
                  '"__rsub__()"\n'
                  '   method, "y.__rsub__(x)" is called if "x.__sub__(y)" '
                  'returns\n'
                  '   *NotImplemented*.\n'
                  '\n'
                  '   Note that ternary "pow()" will not try calling '
                  '"__rpow__()" (the\n'
                  '   coercion rules would become too complicated).\n'
                  '\n'
                  "   Note: If the right operand's type is a subclass of the "
                  'left\n'
                  "     operand's type and that subclass provides the "
                  'reflected method\n'
                  '     for the operation, this method will be called before '
                  'the left\n'
                  "     operand's non-reflected method.  This behavior allows "
                  'subclasses\n'
                  "     to override their ancestors' operations.\n"
                  '\n'
                  'object.__iadd__(self, other)\n'
                  'object.__isub__(self, other)\n'
                  'object.__imul__(self, other)\n'
                  'object.__idiv__(self, other)\n'
                  'object.__itruediv__(self, other)\n'
                  'object.__ifloordiv__(self, other)\n'
                  'object.__imod__(self, other)\n'
                  'object.__ipow__(self, other[, modulo])\n'
                  'object.__ilshift__(self, other)\n'
                  'object.__irshift__(self, other)\n'
                  'object.__iand__(self, other)\n'
                  'object.__ixor__(self, other)\n'
                  'object.__ior__(self, other)\n'
                  '\n'
                  '   These methods are called to implement the augmented '
                  'arithmetic\n'
                  '   assignments ("+=", "-=", "*=", "/=", "//=", "%=", "**=", '
                  '"<<=",\n'
                  '   ">>=", "&=", "^=", "|=").  These methods should attempt '
                  'to do the\n'
                  '   operation in-place (modifying *self*) and return the '
                  'result (which\n'
                  '   could be, but does not have to be, *self*).  If a '
                  'specific method\n'
                  '   is not defined, the augmented assignment falls back to '
                  'the normal\n'
                  '   methods.  For instance, to execute the statement "x += '
                  'y", where\n'
                  '   *x* is an instance of a class that has an "__iadd__()" '
                  'method,\n'
                  '   "x.__iadd__(y)" is called.  If *x* is an instance of a '
                  'class that\n'
                  '   does not define a "__iadd__()" method, "x.__add__(y)" '
                  'and\n'
                  '   "y.__radd__(x)" are considered, as with the evaluation '
                  'of "x + y".\n'
                  '\n'
                  'object.__neg__(self)\n'
                  'object.__pos__(self)\n'
                  'object.__abs__(self)\n'
                  'object.__invert__(self)\n'
                  '\n'
                  '   Called to implement the unary arithmetic operations '
                  '("-", "+",\n'
                  '   "abs()" and "~").\n'
                  '\n'
                  'object.__complex__(self)\n'
                  'object.__int__(self)\n'
                  'object.__long__(self)\n'
                  'object.__float__(self)\n'
                  '\n'
                  '   Called to implement the built-in functions "complex()", '
                  '"int()",\n'
                  '   "long()", and "float()".  Should return a value of the '
                  'appropriate\n'
                  '   type.\n'
                  '\n'
                  'object.__oct__(self)\n'
                  'object.__hex__(self)\n'
                  '\n'
                  '   Called to implement the built-in functions "oct()" and '
                  '"hex()".\n'
                  '   Should return a string value.\n'
                  '\n'
                  'object.__index__(self)\n'
                  '\n'
                  '   Called to implement "operator.index()".  Also called '
                  'whenever\n'
                  '   Python needs an integer object (such as in slicing).  '
                  'Must return\n'
                  '   an integer (int or long).\n'
                  '\n'
                  '   New in version 2.5.\n'
                  '\n'
                  'object.__coerce__(self, other)\n'
                  '\n'
                  '   Called to implement "mixed-mode" numeric arithmetic.  '
                  'Should either\n'
                  '   return a 2-tuple containing *self* and *other* converted '
                  'to a\n'
                  '   common numeric type, or "None" if conversion is '
                  'impossible.  When\n'
                  '   the common type would be the type of "other", it is '
                  'sufficient to\n'
                  '   return "None", since the interpreter will also ask the '
                  'other object\n'
                  '   to attempt a coercion (but sometimes, if the '
                  'implementation of the\n'
                  '   other type cannot be changed, it is useful to do the '
                  'conversion to\n'
                  '   the other type here).  A return value of '
                  '"NotImplemented" is\n'
                  '   equivalent to returning "None".\n',
 'objects': '\n'
            'Objects, values and types\n'
            '*************************\n'
            '\n'
            "*Objects* are Python's abstraction for data.  All data in a "
            'Python\n'
            'program is represented by objects or by relations between '
            'objects. (In\n'
            'a sense, and in conformance to Von Neumann\'s model of a "stored\n'
            'program computer," code is also represented by objects.)\n'
            '\n'
            "Every object has an identity, a type and a value.  An object's\n"
            '*identity* never changes once it has been created; you may think '
            'of it\n'
            'as the object\'s address in memory.  The \'"is"\' operator '
            'compares the\n'
            'identity of two objects; the "id()" function returns an integer\n'
            'representing its identity (currently implemented as its address). '
            'An\n'
            "object's *type* is also unchangeable. [1] An object's type "
            'determines\n'
            'the operations that the object supports (e.g., "does it have a\n'
            'length?") and also defines the possible values for objects of '
            'that\n'
            'type.  The "type()" function returns an object\'s type (which is '
            'an\n'
            'object itself).  The *value* of some objects can change.  '
            'Objects\n'
            'whose value can change are said to be *mutable*; objects whose '
            'value\n'
            'is unchangeable once they are created are called *immutable*. '
            '(The\n'
            'value of an immutable container object that contains a reference '
            'to a\n'
            "mutable object can change when the latter's value is changed; "
            'however\n'
            'the container is still considered immutable, because the '
            'collection of\n'
            'objects it contains cannot be changed.  So, immutability is not\n'
            'strictly the same as having an unchangeable value, it is more '
            'subtle.)\n'
            "An object's mutability is determined by its type; for instance,\n"
            'numbers, strings and tuples are immutable, while dictionaries '
            'and\n'
            'lists are mutable.\n'
            '\n'
            'Objects are never explicitly destroyed; however, when they '
            'become\n'
            'unreachable they may be garbage-collected.  An implementation is\n'
            'allowed to postpone garbage collection or omit it altogether --- '
            'it is\n'
            'a matter of implementation quality how garbage collection is\n'
            'implemented, as long as no objects are collected that are still\n'
            'reachable.\n'
            '\n'
            '**CPython implementation detail:** CPython currently uses a '
            'reference-\n'
            'counting scheme with (optional) delayed detection of cyclically '
            'linked\n'
            'garbage, which collects most objects as soon as they become\n'
            'unreachable, but is not guaranteed to collect garbage containing\n'
            'circular references.  See the documentation of the "gc" module '
            'for\n'
            'information on controlling the collection of cyclic garbage. '
            'Other\n'
            'implementations act differently and CPython may change. Do not '
            'depend\n'
            'on immediate finalization of objects when they become unreachable '
            '(ex:\n'
            'always close files).\n'
            '\n'
            "Note that the use of the implementation's tracing or debugging\n"
            'facilities may keep objects alive that would normally be '
            'collectable.\n'
            'Also note that catching an exception with a \'"try"..."except"\'\n'
            'statement may keep objects alive.\n'
            '\n'
            'Some objects contain references to "external" resources such as '
            'open\n'
            'files or windows.  It is understood that these resources are '
            'freed\n'
            'when the object is garbage-collected, but since garbage '
            'collection is\n'
            'not guaranteed to happen, such objects also provide an explicit '
            'way to\n'
            'release the external resource, usually a "close()" method. '
            'Programs\n'
            'are strongly recommended to explicitly close such objects.  The\n'
            '\'"try"..."finally"\' statement provides a convenient way to do '
            'this.\n'
            '\n'
            'Some objects contain references to other objects; these are '
            'called\n'
            '*containers*. Examples of containers are tuples, lists and\n'
            "dictionaries.  The references are part of a container's value.  "
            'In\n'
            'most cases, when we talk about the value of a container, we imply '
            'the\n'
            'values, not the identities of the contained objects; however, '
            'when we\n'
            'talk about the mutability of a container, only the identities of '
            'the\n'
            'immediately contained objects are implied.  So, if an immutable\n'
            'container (like a tuple) contains a reference to a mutable '
            'object, its\n'
            'value changes if that mutable object is changed.\n'
            '\n'
            'Types affect almost all aspects of object behavior.  Even the\n'
            'importance of object identity is affected in some sense: for '
            'immutable\n'
            'types, operations that compute new values may actually return a\n'
            'reference to any existing object with the same type and value, '
            'while\n'
            'for mutable objects this is not allowed.  E.g., after "a = 1; b = '
            '1",\n'
            '"a" and "b" may or may not refer to the same object with the '
            'value\n'
            'one, depending on the implementation, but after "c = []; d = []", '
            '"c"\n'
            'and "d" are guaranteed to refer to two different, unique, newly\n'
            'created empty lists. (Note that "c = d = []" assigns the same '
            'object\n'
            'to both "c" and "d".)\n',
 'operator-summary': '\n'
                     'Operator precedence\n'
                     '*******************\n'
                     '\n'
                     'The following table summarizes the operator precedences '
                     'in Python,\n'
                     'from lowest precedence (least binding) to highest '
                     'precedence (most\n'
                     'binding). Operators in the same box have the same '
                     'precedence.  Unless\n'
                     'the syntax is explicitly given, operators are binary.  '
                     'Operators in\n'
                     'the same box group left to right (except for '
                     'comparisons, including\n'
                     'tests, which all have the same precedence and chain from '
                     'left to right\n'
                     '--- see section Comparisons --- and exponentiation, '
                     'which groups from\n'
                     'right to left).\n'
                     '\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| Operator                                        | '
                     'Description                           |\n'
                     '+=================================================+=======================================+\n'
                     '| "lambda"                                        | '
                     'Lambda expression                     |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "if" -- "else"                                  | '
                     'Conditional expression                |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "or"                                            | '
                     'Boolean OR                            |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "and"                                           | '
                     'Boolean AND                           |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "not" "x"                                       | '
                     'Boolean NOT                           |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "in", "not in", "is", "is not", "<", "<=", ">", | '
                     'Comparisons, including membership     |\n'
                     '| ">=", "<>", "!=", "=="                          | '
                     'tests and identity tests              |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "|"                                             | '
                     'Bitwise OR                            |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "^"                                             | '
                     'Bitwise XOR                           |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "&"                                             | '
                     'Bitwise AND                           |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "<<", ">>"                                      | '
                     'Shifts                                |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "+", "-"                                        | '
                     'Addition and subtraction              |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "*", "/", "//", "%"                             | '
                     'Multiplication, division, remainder   |\n'
                     '|                                                 | '
                     '[8]                                   |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "+x", "-x", "~x"                                | '
                     'Positive, negative, bitwise NOT       |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "**"                                            | '
                     'Exponentiation [9]                    |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "x[index]", "x[index:index]",                   | '
                     'Subscription, slicing, call,          |\n'
                     '| "x(arguments...)", "x.attribute"                | '
                     'attribute reference                   |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "(expressions...)", "[expressions...]", "{key:  | '
                     'Binding or tuple display, list        |\n'
                     '| value...}", "`expressions...`"                  | '
                     'display, dictionary display, string   |\n'
                     '|                                                 | '
                     'conversion                            |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '\n'
                     '-[ Footnotes ]-\n'
                     '\n'
                     '[1] In Python 2.3 and later releases, a list '
                     'comprehension "leaks"\n'
                     '    the control variables of each "for" it contains into '
                     'the\n'
                     '    containing scope.  However, this behavior is '
                     'deprecated, and\n'
                     '    relying on it will not work in Python 3.\n'
                     '\n'
                     '[2] While "abs(x%y) < abs(y)" is true mathematically, '
                     'for floats\n'
                     '    it may not be true numerically due to roundoff.  For '
                     'example, and\n'
                     '    assuming a platform on which a Python float is an '
                     'IEEE 754 double-\n'
                     '    precision number, in order that "-1e-100 % 1e100" '
                     'have the same\n'
                     '    sign as "1e100", the computed result is "-1e-100 + '
                     '1e100", which\n'
                     '    is numerically exactly equal to "1e100".  The '
                     'function\n'
                     '    "math.fmod()" returns a result whose sign matches '
                     'the sign of the\n'
                     '    first argument instead, and so returns "-1e-100" in '
                     'this case.\n'
                     '    Which approach is more appropriate depends on the '
                     'application.\n'
                     '\n'
                     '[3] If x is very close to an exact integer multiple of '
                     "y, it's\n"
                     '    possible for "floor(x/y)" to be one larger than '
                     '"(x-x%y)/y" due to\n'
                     '    rounding.  In such cases, Python returns the latter '
                     'result, in\n'
                     '    order to preserve that "divmod(x,y)[0] * y + x % y" '
                     'be very close\n'
                     '    to "x".\n'
                     '\n'
                     '[4] While comparisons between unicode strings make sense '
                     'at the\n'
                     '    byte level, they may be counter-intuitive to users. '
                     'For example,\n'
                     '    the strings "u"\\u00C7"" and "u"\\u0043\\u0327"" '
                     'compare differently,\n'
                     '    even though they both represent the same unicode '
                     'character (LATIN\n'
                     '    CAPITAL LETTER C WITH CEDILLA). To compare strings '
                     'in a human\n'
                     '    recognizable way, compare using '
                     '"unicodedata.normalize()".\n'
                     '\n'
                     '[5] The implementation computes this efficiently, '
                     'without\n'
                     '    constructing lists or sorting.\n'
                     '\n'
                     '[6] Earlier versions of Python used lexicographic '
                     'comparison of\n'
                     '    the sorted (key, value) lists, but this was very '
                     'expensive for the\n'
                     '    common case of comparing for equality.  An even '
                     'earlier version of\n'
                     '    Python compared dictionaries by identity only, but '
                     'this caused\n'
                     '    surprises because people expected to be able to test '
                     'a dictionary\n'
                     '    for emptiness by comparing it to "{}".\n'
                     '\n'
                     '[7] Due to automatic garbage-collection, free lists, and '
                     'the\n'
                     '    dynamic nature of descriptors, you may notice '
                     'seemingly unusual\n'
                     '    behaviour in certain uses of the "is" operator, like '
                     'those\n'
                     '    involving comparisons between instance methods, or '
                     'constants.\n'
                     '    Check their documentation for more info.\n'
                     '\n'
                     '[8] The "%" operator is also used for string formatting; '
                     'the same\n'
                     '    precedence applies.\n'
                     '\n'
                     '[9] The power operator "**" binds less tightly than an '
                     'arithmetic\n'
                     '    or bitwise unary operator on its right, that is, '
                     '"2**-1" is "0.5".\n',
 'pass': '\n'
         'The "pass" statement\n'
         '********************\n'
         '\n'
         '   pass_stmt ::= "pass"\n'
         '\n'
         '"pass" is a null operation --- when it is executed, nothing '
         'happens.\n'
         'It is useful as a placeholder when a statement is required\n'
         'syntactically, but no code needs to be executed, for example:\n'
         '\n'
         '   def f(arg): pass    # a function that does nothing (yet)\n'
         '\n'
         '   class C: pass       # a class with no methods (yet)\n',
 'power': '\n'
          'The power operator\n'
          '******************\n'
          '\n'
          'The power operator binds more tightly than unary operators on its\n'
          'left; it binds less tightly than unary operators on its right.  '
          'The\n'
          'syntax is:\n'
          '\n'
          '   power ::= primary ["**" u_expr]\n'
          '\n'
          'Thus, in an unparenthesized sequence of power and unary operators, '
          'the\n'
          'operators are evaluated from right to left (this does not '
          'constrain\n'
          'the evaluation order for the operands): "-1**2" results in "-1".\n'
          '\n'
          'The power operator has the same semantics as the built-in "pow()"\n'
          'function, when called with two arguments: it yields its left '
          'argument\n'
          'raised to the power of its right argument.  The numeric arguments '
          'are\n'
          'first converted to a common type.  The result type is that of the\n'
          'arguments after coercion.\n'
          '\n'
          'With mixed operand types, the coercion rules for binary arithmetic\n'
          'operators apply. For int and long int operands, the result has the\n'
          'same type as the operands (after coercion) unless the second '
          'argument\n'
          'is negative; in that case, all arguments are converted to float and '
          'a\n'
          'float result is delivered. For example, "10**2" returns "100", but\n'
          '"10**-2" returns "0.01". (This last feature was added in Python '
          '2.2.\n'
          'In Python 2.1 and before, if both arguments were of integer types '
          'and\n'
          'the second argument was negative, an exception was raised).\n'
          '\n'
          'Raising "0.0" to a negative power results in a '
          '"ZeroDivisionError".\n'
          'Raising a negative number to a fractional power results in a\n'
          '"ValueError".\n',
 'print': '\n'
          'The "print" statement\n'
          '*********************\n'
          '\n'
          '   print_stmt ::= "print" ([expression ("," expression)* [","]]\n'
          '                  | ">>" expression [("," expression)+ [","]])\n'
          '\n'
          '"print" evaluates each expression in turn and writes the resulting\n'
          'object to standard output (see below).  If an object is not a '
          'string,\n'
          'it is first converted to a string using the rules for string\n'
          'conversions.  The (resulting or original) string is then written.  '
          'A\n'
          'space is written before each object is (converted and) written, '
          'unless\n'
          'the output system believes it is positioned at the beginning of a\n'
          'line.  This is the case (1) when no characters have yet been '
          'written\n'
          'to standard output, (2) when the last character written to '
          'standard\n'
          'output is a whitespace character except "\' \'", or (3) when the '
          'last\n'
          'write operation on standard output was not a "print" statement. '
          '(In\n'
          'some cases it may be functional to write an empty string to '
          'standard\n'
          'output for this reason.)\n'
          '\n'
          'Note: Objects which act like file objects but which are not the\n'
          '  built-in file objects often do not properly emulate this aspect '
          'of\n'
          "  the file object's behavior, so it is best not to rely on this.\n"
          '\n'
          'A "\'\\n\'" character is written at the end, unless the "print" '
          'statement\n'
          'ends with a comma.  This is the only action if the statement '
          'contains\n'
          'just the keyword "print".\n'
          '\n'
          'Standard output is defined as the file object named "stdout" in '
          'the\n'
          'built-in module "sys".  If no such object exists, or if it does '
          'not\n'
          'have a "write()" method, a "RuntimeError" exception is raised.\n'
          '\n'
          '"print" also has an extended form, defined by the second portion '
          'of\n'
          'the syntax described above. This form is sometimes referred to as\n'
          '""print" chevron." In this form, the first expression after the '
          '">>"\n'
          'must evaluate to a "file-like" object, specifically an object that '
          'has\n'
          'a "write()" method as described above.  With this extended form, '
          'the\n'
          'subsequent expressions are printed to this file object.  If the '
          'first\n'
          'expression evaluates to "None", then "sys.stdout" is used as the '
          'file\n'
          'for output.\n',
 'raise': '\n'
          'The "raise" statement\n'
          '*********************\n'
          '\n'
          '   raise_stmt ::= "raise" [expression ["," expression ["," '
          'expression]]]\n'
          '\n'
          'If no expressions are present, "raise" re-raises the last '
          'exception\n'
          'that was active in the current scope.  If no exception is active '
          'in\n'
          'the current scope, a "TypeError" exception is raised indicating '
          'that\n'
          'this is an error (if running under IDLE, a "Queue.Empty" exception '
          'is\n'
          'raised instead).\n'
          '\n'
          'Otherwise, "raise" evaluates the expressions to get three objects,\n'
          'using "None" as the value of omitted expressions.  The first two\n'
          'objects are used to determine the *type* and *value* of the '
          'exception.\n'
          '\n'
          'If the first object is an instance, the type of the exception is '
          'the\n'
          'class of the instance, the instance itself is the value, and the\n'
          'second object must be "None".\n'
          '\n'
          'If the first object is a class, it becomes the type of the '
          'exception.\n'
          'The second object is used to determine the exception value: If it '
          'is\n'
          'an instance of the class, the instance becomes the exception value. '
          'If\n'
          'the second object is a tuple, it is used as the argument list for '
          'the\n'
          'class constructor; if it is "None", an empty argument list is '
          'used,\n'
          'and any other object is treated as a single argument to the\n'
          'constructor.  The instance so created by calling the constructor '
          'is\n'
          'used as the exception value.\n'
          '\n'
          'If a third object is present and not "None", it must be a '
          'traceback\n'
          'object (see section The standard type hierarchy), and it is\n'
          'substituted instead of the current location as the place where the\n'
          'exception occurred.  If the third object is present and not a\n'
          'traceback object or "None", a "TypeError" exception is raised.  '
          'The\n'
          'three-expression form of "raise" is useful to re-raise an '
          'exception\n'
          'transparently in an except clause, but "raise" with no expressions\n'
          'should be preferred if the exception to be re-raised was the most\n'
          'recently active exception in the current scope.\n'
          '\n'
          'Additional information on exceptions can be found in section\n'
          'Exceptions, and information about handling exceptions is in '
          'section\n'
          'The try statement.\n',
 'return': '\n'
           'The "return" statement\n'
           '**********************\n'
           '\n'
           '   return_stmt ::= "return" [expression_list]\n'
           '\n'
           '"return" may only occur syntactically nested in a function '
           'definition,\n'
           'not within a nested class definition.\n'
           '\n'
           'If an expression list is present, it is evaluated, else "None" is\n'
           'substituted.\n'
           '\n'
           '"return" leaves the current function call with the expression list '
           '(or\n'
           '"None") as return value.\n'
           '\n'
           'When "return" passes control out of a "try" statement with a '
           '"finally"\n'
           'clause, that "finally" clause is executed before really leaving '
           'the\n'
           'function.\n'
           '\n'
           'In a generator function, the "return" statement is not allowed to\n'
           'include an "expression_list".  In that context, a bare "return"\n'
           'indicates that the generator is done and will cause '
           '"StopIteration" to\n'
           'be raised.\n',
 'sequence-types': '\n'
                   'Emulating container types\n'
                   '*************************\n'
                   '\n'
                   'The following methods can be defined to implement '
                   'container objects.\n'
                   'Containers usually are sequences (such as lists or tuples) '
                   'or mappings\n'
                   '(like dictionaries), but can represent other containers as '
                   'well.  The\n'
                   'first set of methods is used either to emulate a sequence '
                   'or to\n'
                   'emulate a mapping; the difference is that for a sequence, '
                   'the\n'
                   'allowable keys should be the integers *k* for which "0 <= '
                   'k < N" where\n'
                   '*N* is the length of the sequence, or slice objects, which '
                   'define a\n'
                   'range of items. (For backwards compatibility, the method\n'
                   '"__getslice__()" (see below) can also be defined to handle '
                   'simple, but\n'
                   'not extended slices.) It is also recommended that mappings '
                   'provide the\n'
                   'methods "keys()", "values()", "items()", "has_key()", '
                   '"get()",\n'
                   '"clear()", "setdefault()", "iterkeys()", "itervalues()",\n'
                   '"iteritems()", "pop()", "popitem()", "copy()", and '
                   '"update()" behaving\n'
                   "similar to those for Python's standard dictionary "
                   'objects.  The\n'
                   '"UserDict" module provides a "DictMixin" class to help '
                   'create those\n'
                   'methods from a base set of "__getitem__()", '
                   '"__setitem__()",\n'
                   '"__delitem__()", and "keys()". Mutable sequences should '
                   'provide\n'
                   'methods "append()", "count()", "index()", "extend()", '
                   '"insert()",\n'
                   '"pop()", "remove()", "reverse()" and "sort()", like Python '
                   'standard\n'
                   'list objects.  Finally, sequence types should implement '
                   'addition\n'
                   '(meaning concatenation) and multiplication (meaning '
                   'repetition) by\n'
                   'defining the methods "__add__()", "__radd__()", '
                   '"__iadd__()",\n'
                   '"__mul__()", "__rmul__()" and "__imul__()" described '
                   'below; they\n'
                   'should not define "__coerce__()" or other numerical '
                   'operators.  It is\n'
                   'recommended that both mappings and sequences implement '
                   'the\n'
                   '"__contains__()" method to allow efficient use of the "in" '
                   'operator;\n'
                   'for mappings, "in" should be equivalent of "has_key()"; '
                   'for sequences,\n'
                   'it should search through the values.  It is further '
                   'recommended that\n'
                   'both mappings and sequences implement the "__iter__()" '
                   'method to allow\n'
                   'efficient iteration through the container; for mappings, '
                   '"__iter__()"\n'
                   'should be the same as "iterkeys()"; for sequences, it '
                   'should iterate\n'
                   'through the values.\n'
                   '\n'
                   'object.__len__(self)\n'
                   '\n'
                   '   Called to implement the built-in function "len()".  '
                   'Should return\n'
                   '   the length of the object, an integer ">=" 0.  Also, an '
                   'object that\n'
                   '   doesn\'t define a "__nonzero__()" method and whose '
                   '"__len__()"\n'
                   '   method returns zero is considered to be false in a '
                   'Boolean context.\n'
                   '\n'
                   'object.__getitem__(self, key)\n'
                   '\n'
                   '   Called to implement evaluation of "self[key]". For '
                   'sequence types,\n'
                   '   the accepted keys should be integers and slice '
                   'objects.  Note that\n'
                   '   the special interpretation of negative indexes (if the '
                   'class wishes\n'
                   '   to emulate a sequence type) is up to the '
                   '"__getitem__()" method. If\n'
                   '   *key* is of an inappropriate type, "TypeError" may be '
                   'raised; if of\n'
                   '   a value outside the set of indexes for the sequence '
                   '(after any\n'
                   '   special interpretation of negative values), '
                   '"IndexError" should be\n'
                   '   raised. For mapping types, if *key* is missing (not in '
                   'the\n'
                   '   container), "KeyError" should be raised.\n'
                   '\n'
                   '   Note: "for" loops expect that an "IndexError" will be '
                   'raised for\n'
                   '     illegal indexes to allow proper detection of the end '
                   'of the\n'
                   '     sequence.\n'
                   '\n'
                   'object.__missing__(self, key)\n'
                   '\n'
                   '   Called by "dict"."__getitem__()" to implement '
                   '"self[key]" for dict\n'
                   '   subclasses when key is not in the dictionary.\n'
                   '\n'
                   'object.__setitem__(self, key, value)\n'
                   '\n'
                   '   Called to implement assignment to "self[key]".  Same '
                   'note as for\n'
                   '   "__getitem__()".  This should only be implemented for '
                   'mappings if\n'
                   '   the objects support changes to the values for keys, or '
                   'if new keys\n'
                   '   can be added, or for sequences if elements can be '
                   'replaced.  The\n'
                   '   same exceptions should be raised for improper *key* '
                   'values as for\n'
                   '   the "__getitem__()" method.\n'
                   '\n'
                   'object.__delitem__(self, key)\n'
                   '\n'
                   '   Called to implement deletion of "self[key]".  Same note '
                   'as for\n'
                   '   "__getitem__()".  This should only be implemented for '
                   'mappings if\n'
                   '   the objects support removal of keys, or for sequences '
                   'if elements\n'
                   '   can be removed from the sequence.  The same exceptions '
                   'should be\n'
                   '   raised for improper *key* values as for the '
                   '"__getitem__()" method.\n'
                   '\n'
                   'object.__iter__(self)\n'
                   '\n'
                   '   This method is called when an iterator is required for '
                   'a container.\n'
                   '   This method should return a new iterator object that '
                   'can iterate\n'
                   '   over all the objects in the container.  For mappings, '
                   'it should\n'
                   '   iterate over the keys of the container, and should also '
                   'be made\n'
                   '   available as the method "iterkeys()".\n'
                   '\n'
                   '   Iterator objects also need to implement this method; '
                   'they are\n'
                   '   required to return themselves.  For more information on '
                   'iterator\n'
                   '   objects, see Iterator Types.\n'
                   '\n'
                   'object.__reversed__(self)\n'
                   '\n'
                   '   Called (if present) by the "reversed()" built-in to '
                   'implement\n'
                   '   reverse iteration.  It should return a new iterator '
                   'object that\n'
                   '   iterates over all the objects in the container in '
                   'reverse order.\n'
                   '\n'
                   '   If the "__reversed__()" method is not provided, the '
                   '"reversed()"\n'
                   '   built-in will fall back to using the sequence protocol '
                   '("__len__()"\n'
                   '   and "__getitem__()").  Objects that support the '
                   'sequence protocol\n'
                   '   should only provide "__reversed__()" if they can '
                   'provide an\n'
                   '   implementation that is more efficient than the one '
                   'provided by\n'
                   '   "reversed()".\n'
                   '\n'
                   '   New in version 2.6.\n'
                   '\n'
                   'The membership test operators ("in" and "not in") are '
                   'normally\n'
                   'implemented as an iteration through a sequence.  However, '
                   'container\n'
                   'objects can supply the following special method with a '
                   'more efficient\n'
                   'implementation, which also does not require the object be '
                   'a sequence.\n'
                   '\n'
                   'object.__contains__(self, item)\n'
                   '\n'
                   '   Called to implement membership test operators.  Should '
                   'return true\n'
                   '   if *item* is in *self*, false otherwise.  For mapping '
                   'objects, this\n'
                   '   should consider the keys of the mapping rather than the '
                   'values or\n'
                   '   the key-item pairs.\n'
                   '\n'
                   '   For objects that don\'t define "__contains__()", the '
                   'membership test\n'
                   '   first tries iteration via "__iter__()", then the old '
                   'sequence\n'
                   '   iteration protocol via "__getitem__()", see this '
                   'section in the\n'
                   '   language reference.\n',
 'shifting': '\n'
             'Shifting operations\n'
             '*******************\n'
             '\n'
             'The shifting operations have lower priority than the arithmetic\n'
             'operations:\n'
             '\n'
             '   shift_expr ::= a_expr | shift_expr ( "<<" | ">>" ) a_expr\n'
             '\n'
             'These operators accept plain or long integers as arguments.  '
             'The\n'
             'arguments are converted to a common type.  They shift the first\n'
             'argument to the left or right by the number of bits given by '
             'the\n'
             'second argument.\n'
             '\n'
             'A right shift by *n* bits is defined as division by "pow(2, '
             'n)".  A\n'
             'left shift by *n* bits is defined as multiplication with "pow(2, '
             'n)".\n'
             'Negative shift counts raise a "ValueError" exception.\n'
             '\n'
             'Note: In the current implementation, the right-hand operand is\n'
             '  required to be at most "sys.maxsize".  If the right-hand '
             'operand is\n'
             '  larger than "sys.maxsize" an "OverflowError" exception is '
             'raised.\n',
 'slicings': '\n'
             'Slicings\n'
             '********\n'
             '\n'
             'A slicing selects a range of items in a sequence object (e.g., '
             'a\n'
             'string, tuple or list).  Slicings may be used as expressions or '
             'as\n'
             'targets in assignment or "del" statements.  The syntax for a '
             'slicing:\n'
             '\n'
             '   slicing          ::= simple_slicing | extended_slicing\n'
             '   simple_slicing   ::= primary "[" short_slice "]"\n'
             '   extended_slicing ::= primary "[" slice_list "]"\n'
             '   slice_list       ::= slice_item ("," slice_item)* [","]\n'
             '   slice_item       ::= expression | proper_slice | ellipsis\n'
             '   proper_slice     ::= short_slice | long_slice\n'
             '   short_slice      ::= [lower_bound] ":" [upper_bound]\n'
             '   long_slice       ::= short_slice ":" [stride]\n'
             '   lower_bound      ::= expression\n'
             '   upper_bound      ::= expression\n'
             '   stride           ::= expression\n'
             '   ellipsis         ::= "..."\n'
             '\n'
             'There is ambiguity in the formal syntax here: anything that '
             'looks like\n'
             'an expression list also looks like a slice list, so any '
             'subscription\n'
             'can be interpreted as a slicing.  Rather than further '
             'complicating the\n'
             'syntax, this is disambiguated by defining that in this case the\n'
             'interpretation as a subscription takes priority over the\n'
             'interpretation as a slicing (this is the case if the slice list\n'
             'contains no proper slice nor ellipses).  Similarly, when the '
             'slice\n'
             'list has exactly one short slice and no trailing comma, the\n'
             'interpretation as a simple slicing takes priority over that as '
             'an\n'
             'extended slicing.\n'
             '\n'
             'The semantics for a simple slicing are as follows.  The primary '
             'must\n'
             'evaluate to a sequence object.  The lower and upper bound '
             'expressions,\n'
             'if present, must evaluate to plain integers; defaults are zero '
             'and the\n'
             '"sys.maxint", respectively.  If either bound is negative, the\n'
             "sequence's length is added to it.  The slicing now selects all "
             'items\n'
             'with index *k* such that "i <= k < j" where *i* and *j* are the\n'
             'specified lower and upper bounds.  This may be an empty '
             'sequence.  It\n'
             'is not an error if *i* or *j* lie outside the range of valid '
             'indexes\n'
             "(such items don't exist so they aren't selected).\n"
             '\n'
             'The semantics for an extended slicing are as follows.  The '
             'primary\n'
             'must evaluate to a mapping object, and it is indexed with a key '
             'that\n'
             'is constructed from the slice list, as follows.  If the slice '
             'list\n'
             'contains at least one comma, the key is a tuple containing the\n'
             'conversion of the slice items; otherwise, the conversion of the '
             'lone\n'
             'slice item is the key.  The conversion of a slice item that is '
             'an\n'
             'expression is that expression.  The conversion of an ellipsis '
             'slice\n'
             'item is the built-in "Ellipsis" object.  The conversion of a '
             'proper\n'
             'slice is a slice object (see section The standard type '
             'hierarchy)\n'
             'whose "start", "stop" and "step" attributes are the values of '
             'the\n'
             'expressions given as lower bound, upper bound and stride,\n'
             'respectively, substituting "None" for missing expressions.\n',
 'specialattrs': '\n'
                 'Special Attributes\n'
                 '******************\n'
                 '\n'
                 'The implementation adds a few special read-only attributes '
                 'to several\n'
                 'object types, where they are relevant.  Some of these are '
                 'not reported\n'
                 'by the "dir()" built-in function.\n'
                 '\n'
                 'object.__dict__\n'
                 '\n'
                 '   A dictionary or other mapping object used to store an '
                 "object's\n"
                 '   (writable) attributes.\n'
                 '\n'
                 'object.__methods__\n'
                 '\n'
                 '   Deprecated since version 2.2: Use the built-in function '
                 '"dir()" to\n'
                 "   get a list of an object's attributes. This attribute is "
                 'no longer\n'
                 '   available.\n'
                 '\n'
                 'object.__members__\n'
                 '\n'
                 '   Deprecated since version 2.2: Use the built-in function '
                 '"dir()" to\n'
                 "   get a list of an object's attributes. This attribute is "
                 'no longer\n'
                 '   available.\n'
                 '\n'
                 'instance.__class__\n'
                 '\n'
                 '   The class to which a class instance belongs.\n'
                 '\n'
                 'class.__bases__\n'
                 '\n'
                 '   The tuple of base classes of a class object.\n'
                 '\n'
                 'class.__name__\n'
                 '\n'
                 '   The name of the class or type.\n'
                 '\n'
                 'The following attributes are only supported by *new-style '
                 'class*es.\n'
                 '\n'
                 'class.__mro__\n'
                 '\n'
                 '   This attribute is a tuple of classes that are considered '
                 'when\n'
                 '   looking for base classes during method resolution.\n'
                 '\n'
                 'class.mro()\n'
                 '\n'
                 '   This method can be overridden by a metaclass to customize '
                 'the\n'
                 '   method resolution order for its instances.  It is called '
                 'at class\n'
                 '   instantiation, and its result is stored in "__mro__".\n'
                 '\n'
                 'class.__subclasses__()\n'
                 '\n'
                 '   Each new-style class keeps a list of weak references to '
                 'its\n'
                 '   immediate subclasses.  This method returns a list of all '
                 'those\n'
                 '   references still alive. Example:\n'
                 '\n'
                 '      >>> int.__subclasses__()\n'
                 "      [<type 'bool'>]\n"
                 '\n'
                 '-[ Footnotes ]-\n'
                 '\n'
                 '[1] Additional information on these special methods may be '
                 'found\n'
                 '    in the Python Reference Manual (Basic customization).\n'
                 '\n'
                 '[2] As a consequence, the list "[1, 2]" is considered equal '
                 'to\n'
                 '    "[1.0, 2.0]", and similarly for tuples.\n'
                 '\n'
                 "[3] They must have since the parser can't tell the type of "
                 'the\n'
                 '    operands.\n'
                 '\n'
                 '[4] Cased characters are those with general category '
                 'property\n'
                 '    being one of "Lu" (Letter, uppercase), "Ll" (Letter, '
                 'lowercase),\n'
                 '    or "Lt" (Letter, titlecase).\n'
                 '\n'
                 '[5] To format only a tuple you should therefore provide a\n'
                 '    singleton tuple whose only element is the tuple to be '
                 'formatted.\n'
                 '\n'
                 '[6] The advantage of leaving the newline on is that '
                 'returning an\n'
                 '    empty string is then an unambiguous EOF indication.  It '
                 'is also\n'
                 '    possible (in cases where it might matter, for example, '
                 'if you want\n'
                 '    to make an exact copy of a file while scanning its '
                 'lines) to tell\n'
                 '    whether the last line of a file ended in a newline or '
                 'not (yes\n'
                 '    this happens!).\n',
 'specialnames': '\n'
                 'Special method names\n'
                 '********************\n'
                 '\n'
                 'A class can implement certain operations that are invoked by '
                 'special\n'
                 'syntax (such as arithmetic operations or subscripting and '
                 'slicing) by\n'
                 "defining methods with special names. This is Python's "
                 'approach to\n'
                 '*operator overloading*, allowing classes to define their own '
                 'behavior\n'
                 'with respect to language operators.  For instance, if a '
                 'class defines\n'
                 'a method named "__getitem__()", and "x" is an instance of '
                 'this class,\n'
                 'then "x[i]" is roughly equivalent to "x.__getitem__(i)" for '
                 'old-style\n'
                 'classes and "type(x).__getitem__(x, i)" for new-style '
                 'classes.  Except\n'
                 'where mentioned, attempts to execute an operation raise an '
                 'exception\n'
                 'when no appropriate method is defined (typically '
                 '"AttributeError" or\n'
                 '"TypeError").\n'
                 '\n'
                 'When implementing a class that emulates any built-in type, '
                 'it is\n'
                 'important that the emulation only be implemented to the '
                 'degree that it\n'
                 'makes sense for the object being modelled.  For example, '
                 'some\n'
                 'sequences may work well with retrieval of individual '
                 'elements, but\n'
                 'extracting a slice may not make sense.  (One example of this '
                 'is the\n'
                 '"NodeList" interface in the W3C\'s Document Object Model.)\n'
                 '\n'
                 '\n'
                 'Basic customization\n'
                 '===================\n'
                 '\n'
                 'object.__new__(cls[, ...])\n'
                 '\n'
                 '   Called to create a new instance of class *cls*.  '
                 '"__new__()" is a\n'
                 '   static method (special-cased so you need not declare it '
                 'as such)\n'
                 '   that takes the class of which an instance was requested '
                 'as its\n'
                 '   first argument.  The remaining arguments are those passed '
                 'to the\n'
                 '   object constructor expression (the call to the class).  '
                 'The return\n'
                 '   value of "__new__()" should be the new object instance '
                 '(usually an\n'
                 '   instance of *cls*).\n'
                 '\n'
                 '   Typical implementations create a new instance of the '
                 'class by\n'
                 '   invoking the superclass\'s "__new__()" method using\n'
                 '   "super(currentclass, cls).__new__(cls[, ...])" with '
                 'appropriate\n'
                 '   arguments and then modifying the newly-created instance '
                 'as\n'
                 '   necessary before returning it.\n'
                 '\n'
                 '   If "__new__()" returns an instance of *cls*, then the '
                 'new\n'
                 '   instance\'s "__init__()" method will be invoked like\n'
                 '   "__init__(self[, ...])", where *self* is the new instance '
                 'and the\n'
                 '   remaining arguments are the same as were passed to '
                 '"__new__()".\n'
                 '\n'
                 '   If "__new__()" does not return an instance of *cls*, then '
                 'the new\n'
                 '   instance\'s "__init__()" method will not be invoked.\n'
                 '\n'
                 '   "__new__()" is intended mainly to allow subclasses of '
                 'immutable\n'
                 '   types (like int, str, or tuple) to customize instance '
                 'creation.  It\n'
                 '   is also commonly overridden in custom metaclasses in '
                 'order to\n'
                 '   customize class creation.\n'
                 '\n'
                 'object.__init__(self[, ...])\n'
                 '\n'
                 '   Called after the instance has been created (by '
                 '"__new__()"), but\n'
                 '   before it is returned to the caller.  The arguments are '
                 'those\n'
                 '   passed to the class constructor expression.  If a base '
                 'class has an\n'
                 '   "__init__()" method, the derived class\'s "__init__()" '
                 'method, if\n'
                 '   any, must explicitly call it to ensure proper '
                 'initialization of the\n'
                 '   base class part of the instance; for example:\n'
                 '   "BaseClass.__init__(self, [args...])".\n'
                 '\n'
                 '   Because "__new__()" and "__init__()" work together in '
                 'constructing\n'
                 '   objects ("__new__()" to create it, and "__init__()" to '
                 'customise\n'
                 '   it), no non-"None" value may be returned by "__init__()"; '
                 'doing so\n'
                 '   will cause a "TypeError" to be raised at runtime.\n'
                 '\n'
                 'object.__del__(self)\n'
                 '\n'
                 '   Called when the instance is about to be destroyed.  This '
                 'is also\n'
                 '   called a destructor.  If a base class has a "__del__()" '
                 'method, the\n'
                 '   derived class\'s "__del__()" method, if any, must '
                 'explicitly call it\n'
                 '   to ensure proper deletion of the base class part of the '
                 'instance.\n'
                 '   Note that it is possible (though not recommended!) for '
                 'the\n'
                 '   "__del__()" method to postpone destruction of the '
                 'instance by\n'
                 '   creating a new reference to it.  It may then be called at '
                 'a later\n'
                 '   time when this new reference is deleted.  It is not '
                 'guaranteed that\n'
                 '   "__del__()" methods are called for objects that still '
                 'exist when\n'
                 '   the interpreter exits.\n'
                 '\n'
                 '   Note: "del x" doesn\'t directly call "x.__del__()" --- '
                 'the former\n'
                 '     decrements the reference count for "x" by one, and the '
                 'latter is\n'
                 '     only called when "x"\'s reference count reaches zero.  '
                 'Some common\n'
                 '     situations that may prevent the reference count of an '
                 'object from\n'
                 '     going to zero include: circular references between '
                 'objects (e.g.,\n'
                 '     a doubly-linked list or a tree data structure with '
                 'parent and\n'
                 '     child pointers); a reference to the object on the stack '
                 'frame of\n'
                 '     a function that caught an exception (the traceback '
                 'stored in\n'
                 '     "sys.exc_traceback" keeps the stack frame alive); or a '
                 'reference\n'
                 '     to the object on the stack frame that raised an '
                 'unhandled\n'
                 '     exception in interactive mode (the traceback stored in\n'
                 '     "sys.last_traceback" keeps the stack frame alive).  The '
                 'first\n'
                 '     situation can only be remedied by explicitly breaking '
                 'the cycles;\n'
                 '     the latter two situations can be resolved by storing '
                 '"None" in\n'
                 '     "sys.exc_traceback" or "sys.last_traceback".  Circular '
                 'references\n'
                 '     which are garbage are detected when the option cycle '
                 'detector is\n'
                 "     enabled (it's on by default), but can only be cleaned "
                 'up if there\n'
                 '     are no Python-level "__del__()" methods involved. Refer '
                 'to the\n'
                 '     documentation for the "gc" module for more information '
                 'about how\n'
                 '     "__del__()" methods are handled by the cycle detector,\n'
                 '     particularly the description of the "garbage" value.\n'
                 '\n'
                 '   Warning: Due to the precarious circumstances under which\n'
                 '     "__del__()" methods are invoked, exceptions that occur '
                 'during\n'
                 '     their execution are ignored, and a warning is printed '
                 'to\n'
                 '     "sys.stderr" instead. Also, when "__del__()" is invoked '
                 'in\n'
                 '     response to a module being deleted (e.g., when '
                 'execution of the\n'
                 '     program is done), other globals referenced by the '
                 '"__del__()"\n'
                 '     method may already have been deleted or in the process '
                 'of being\n'
                 '     torn down (e.g. the import machinery shutting down).  '
                 'For this\n'
                 '     reason, "__del__()" methods should do the absolute '
                 'minimum needed\n'
                 '     to maintain external invariants.  Starting with version '
                 '1.5,\n'
                 '     Python guarantees that globals whose name begins with a '
                 'single\n'
                 '     underscore are deleted from their module before other '
                 'globals are\n'
                 '     deleted; if no other references to such globals exist, '
                 'this may\n'
                 '     help in assuring that imported modules are still '
                 'available at the\n'
                 '     time when the "__del__()" method is called.\n'
                 '\n'
                 '   See also the "-R" command-line option.\n'
                 '\n'
                 'object.__repr__(self)\n'
                 '\n'
                 '   Called by the "repr()" built-in function and by string '
                 'conversions\n'
                 '   (reverse quotes) to compute the "official" string '
                 'representation of\n'
                 '   an object.  If at all possible, this should look like a '
                 'valid\n'
                 '   Python expression that could be used to recreate an '
                 'object with the\n'
                 '   same value (given an appropriate environment).  If this '
                 'is not\n'
                 '   possible, a string of the form "<...some useful '
                 'description...>"\n'
                 '   should be returned.  The return value must be a string '
                 'object. If a\n'
                 '   class defines "__repr__()" but not "__str__()", then '
                 '"__repr__()"\n'
                 '   is also used when an "informal" string representation of '
                 'instances\n'
                 '   of that class is required.\n'
                 '\n'
                 '   This is typically used for debugging, so it is important '
                 'that the\n'
                 '   representation is information-rich and unambiguous.\n'
                 '\n'
                 'object.__str__(self)\n'
                 '\n'
                 '   Called by the "str()" built-in function and by the '
                 '"print"\n'
                 '   statement to compute the "informal" string representation '
                 'of an\n'
                 '   object.  This differs from "__repr__()" in that it does '
                 'not have to\n'
                 '   be a valid Python expression: a more convenient or '
                 'concise\n'
                 '   representation may be used instead. The return value must '
                 'be a\n'
                 '   string object.\n'
                 '\n'
                 'object.__lt__(self, other)\n'
                 'object.__le__(self, other)\n'
                 'object.__eq__(self, other)\n'
                 'object.__ne__(self, other)\n'
                 'object.__gt__(self, other)\n'
                 'object.__ge__(self, other)\n'
                 '\n'
                 '   New in version 2.1.\n'
                 '\n'
                 '   These are the so-called "rich comparison" methods, and '
                 'are called\n'
                 '   for comparison operators in preference to "__cmp__()" '
                 'below. The\n'
                 '   correspondence between operator symbols and method names '
                 'is as\n'
                 '   follows: "x<y" calls "x.__lt__(y)", "x<=y" calls '
                 '"x.__le__(y)",\n'
                 '   "x==y" calls "x.__eq__(y)", "x!=y" and "x<>y" call '
                 '"x.__ne__(y)",\n'
                 '   "x>y" calls "x.__gt__(y)", and "x>=y" calls '
                 '"x.__ge__(y)".\n'
                 '\n'
                 '   A rich comparison method may return the singleton '
                 '"NotImplemented"\n'
                 '   if it does not implement the operation for a given pair '
                 'of\n'
                 '   arguments. By convention, "False" and "True" are returned '
                 'for a\n'
                 '   successful comparison. However, these methods can return '
                 'any value,\n'
                 '   so if the comparison operator is used in a Boolean '
                 'context (e.g.,\n'
                 '   in the condition of an "if" statement), Python will call '
                 '"bool()"\n'
                 '   on the value to determine if the result is true or '
                 'false.\n'
                 '\n'
                 '   There are no implied relationships among the comparison '
                 'operators.\n'
                 '   The truth of "x==y" does not imply that "x!=y" is false.\n'
                 '   Accordingly, when defining "__eq__()", one should also '
                 'define\n'
                 '   "__ne__()" so that the operators will behave as '
                 'expected.  See the\n'
                 '   paragraph on "__hash__()" for some important notes on '
                 'creating\n'
                 '   *hashable* objects which support custom comparison '
                 'operations and\n'
                 '   are usable as dictionary keys.\n'
                 '\n'
                 '   There are no swapped-argument versions of these methods '
                 '(to be used\n'
                 '   when the left argument does not support the operation but '
                 'the right\n'
                 '   argument does); rather, "__lt__()" and "__gt__()" are '
                 "each other's\n"
                 '   reflection, "__le__()" and "__ge__()" are each other\'s '
                 'reflection,\n'
                 '   and "__eq__()" and "__ne__()" are their own reflection.\n'
                 '\n'
                 '   Arguments to rich comparison methods are never coerced.\n'
                 '\n'
                 '   To automatically generate ordering operations from a '
                 'single root\n'
                 '   operation, see "functools.total_ordering()".\n'
                 '\n'
                 'object.__cmp__(self, other)\n'
                 '\n'
                 '   Called by comparison operations if rich comparison (see '
                 'above) is\n'
                 '   not defined.  Should return a negative integer if "self < '
                 'other",\n'
                 '   zero if "self == other", a positive integer if "self > '
                 'other".  If\n'
                 '   no "__cmp__()", "__eq__()" or "__ne__()" operation is '
                 'defined,\n'
                 '   class instances are compared by object identity '
                 '("address").  See\n'
                 '   also the description of "__hash__()" for some important '
                 'notes on\n'
                 '   creating *hashable* objects which support custom '
                 'comparison\n'
                 '   operations and are usable as dictionary keys. (Note: the\n'
                 '   restriction that exceptions are not propagated by '
                 '"__cmp__()" has\n'
                 '   been removed since Python 1.5.)\n'
                 '\n'
                 'object.__rcmp__(self, other)\n'
                 '\n'
                 '   Changed in version 2.1: No longer supported.\n'
                 '\n'
                 'object.__hash__(self)\n'
                 '\n'
                 '   Called by built-in function "hash()" and for operations '
                 'on members\n'
                 '   of hashed collections including "set", "frozenset", and '
                 '"dict".\n'
                 '   "__hash__()" should return an integer.  The only required '
                 'property\n'
                 '   is that objects which compare equal have the same hash '
                 'value; it is\n'
                 '   advised to somehow mix together (e.g. using exclusive or) '
                 'the hash\n'
                 '   values for the components of the object that also play a '
                 'part in\n'
                 '   comparison of objects.\n'
                 '\n'
                 '   If a class does not define a "__cmp__()" or "__eq__()" '
                 'method it\n'
                 '   should not define a "__hash__()" operation either; if it '
                 'defines\n'
                 '   "__cmp__()" or "__eq__()" but not "__hash__()", its '
                 'instances will\n'
                 '   not be usable in hashed collections.  If a class defines '
                 'mutable\n'
                 '   objects and implements a "__cmp__()" or "__eq__()" '
                 'method, it\n'
                 '   should not implement "__hash__()", since hashable '
                 'collection\n'
                 "   implementations require that a object's hash value is "
                 'immutable (if\n'
                 "   the object's hash value changes, it will be in the wrong "
                 'hash\n'
                 '   bucket).\n'
                 '\n'
                 '   User-defined classes have "__cmp__()" and "__hash__()" '
                 'methods by\n'
                 '   default; with them, all objects compare unequal (except '
                 'with\n'
                 '   themselves) and "x.__hash__()" returns a result derived '
                 'from\n'
                 '   "id(x)".\n'
                 '\n'
                 '   Classes which inherit a "__hash__()" method from a parent '
                 'class but\n'
                 '   change the meaning of "__cmp__()" or "__eq__()" such that '
                 'the hash\n'
                 '   value returned is no longer appropriate (e.g. by '
                 'switching to a\n'
                 '   value-based concept of equality instead of the default '
                 'identity\n'
                 '   based equality) can explicitly flag themselves as being '
                 'unhashable\n'
                 '   by setting "__hash__ = None" in the class definition. '
                 'Doing so\n'
                 '   means that not only will instances of the class raise an\n'
                 '   appropriate "TypeError" when a program attempts to '
                 'retrieve their\n'
                 '   hash value, but they will also be correctly identified '
                 'as\n'
                 '   unhashable when checking "isinstance(obj, '
                 'collections.Hashable)"\n'
                 '   (unlike classes which define their own "__hash__()" to '
                 'explicitly\n'
                 '   raise "TypeError").\n'
                 '\n'
                 '   Changed in version 2.5: "__hash__()" may now also return '
                 'a long\n'
                 '   integer object; the 32-bit integer is then derived from '
                 'the hash of\n'
                 '   that object.\n'
                 '\n'
                 '   Changed in version 2.6: "__hash__" may now be set to '
                 '"None" to\n'
                 '   explicitly flag instances of a class as unhashable.\n'
                 '\n'
                 'object.__nonzero__(self)\n'
                 '\n'
                 '   Called to implement truth value testing and the built-in '
                 'operation\n'
                 '   "bool()"; should return "False" or "True", or their '
                 'integer\n'
                 '   equivalents "0" or "1".  When this method is not '
                 'defined,\n'
                 '   "__len__()" is called, if it is defined, and the object '
                 'is\n'
                 '   considered true if its result is nonzero. If a class '
                 'defines\n'
                 '   neither "__len__()" nor "__nonzero__()", all its '
                 'instances are\n'
                 '   considered true.\n'
                 '\n'
                 'object.__unicode__(self)\n'
                 '\n'
                 '   Called to implement "unicode()" built-in; should return a '
                 'Unicode\n'
                 '   object. When this method is not defined, string '
                 'conversion is\n'
                 '   attempted, and the result of string conversion is '
                 'converted to\n'
                 '   Unicode using the system default encoding.\n'
                 '\n'
                 '\n'
                 'Customizing attribute access\n'
                 '============================\n'
                 '\n'
                 'The following methods can be defined to customize the '
                 'meaning of\n'
                 'attribute access (use of, assignment to, or deletion of '
                 '"x.name") for\n'
                 'class instances.\n'
                 '\n'
                 'object.__getattr__(self, name)\n'
                 '\n'
                 '   Called when an attribute lookup has not found the '
                 'attribute in the\n'
                 '   usual places (i.e. it is not an instance attribute nor is '
                 'it found\n'
                 '   in the class tree for "self").  "name" is the attribute '
                 'name. This\n'
                 '   method should return the (computed) attribute value or '
                 'raise an\n'
                 '   "AttributeError" exception.\n'
                 '\n'
                 '   Note that if the attribute is found through the normal '
                 'mechanism,\n'
                 '   "__getattr__()" is not called.  (This is an intentional '
                 'asymmetry\n'
                 '   between "__getattr__()" and "__setattr__()".) This is '
                 'done both for\n'
                 '   efficiency reasons and because otherwise "__getattr__()" '
                 'would have\n'
                 '   no way to access other attributes of the instance.  Note '
                 'that at\n'
                 '   least for instance variables, you can fake total control '
                 'by not\n'
                 '   inserting any values in the instance attribute dictionary '
                 '(but\n'
                 '   instead inserting them in another object).  See the\n'
                 '   "__getattribute__()" method below for a way to actually '
                 'get total\n'
                 '   control in new-style classes.\n'
                 '\n'
                 'object.__setattr__(self, name, value)\n'
                 '\n'
                 '   Called when an attribute assignment is attempted.  This '
                 'is called\n'
                 '   instead of the normal mechanism (i.e. store the value in '
                 'the\n'
                 '   instance dictionary).  *name* is the attribute name, '
                 '*value* is the\n'
                 '   value to be assigned to it.\n'
                 '\n'
                 '   If "__setattr__()" wants to assign to an instance '
                 'attribute, it\n'
                 '   should not simply execute "self.name = value" --- this '
                 'would cause\n'
                 '   a recursive call to itself.  Instead, it should insert '
                 'the value in\n'
                 '   the dictionary of instance attributes, e.g., '
                 '"self.__dict__[name] =\n'
                 '   value".  For new-style classes, rather than accessing the '
                 'instance\n'
                 '   dictionary, it should call the base class method with the '
                 'same\n'
                 '   name, for example, "object.__setattr__(self, name, '
                 'value)".\n'
                 '\n'
                 'object.__delattr__(self, name)\n'
                 '\n'
                 '   Like "__setattr__()" but for attribute deletion instead '
                 'of\n'
                 '   assignment.  This should only be implemented if "del '
                 'obj.name" is\n'
                 '   meaningful for the object.\n'
                 '\n'
                 '\n'
                 'More attribute access for new-style classes\n'
                 '-------------------------------------------\n'
                 '\n'
                 'The following methods only apply to new-style classes.\n'
                 '\n'
                 'object.__getattribute__(self, name)\n'
                 '\n'
                 '   Called unconditionally to implement attribute accesses '
                 'for\n'
                 '   instances of the class. If the class also defines '
                 '"__getattr__()",\n'
                 '   the latter will not be called unless "__getattribute__()" '
                 'either\n'
                 '   calls it explicitly or raises an "AttributeError". This '
                 'method\n'
                 '   should return the (computed) attribute value or raise an\n'
                 '   "AttributeError" exception. In order to avoid infinite '
                 'recursion in\n'
                 '   this method, its implementation should always call the '
                 'base class\n'
                 '   method with the same name to access any attributes it '
                 'needs, for\n'
                 '   example, "object.__getattribute__(self, name)".\n'
                 '\n'
                 '   Note: This method may still be bypassed when looking up '
                 'special\n'
                 '     methods as the result of implicit invocation via '
                 'language syntax\n'
                 '     or built-in functions. See Special method lookup for '
                 'new-style\n'
                 '     classes.\n'
                 '\n'
                 '\n'
                 'Implementing Descriptors\n'
                 '------------------------\n'
                 '\n'
                 'The following methods only apply when an instance of the '
                 'class\n'
                 'containing the method (a so-called *descriptor* class) '
                 'appears in an\n'
                 "*owner* class (the descriptor must be in either the owner's "
                 'class\n'
                 'dictionary or in the class dictionary for one of its '
                 'parents).  In the\n'
                 'examples below, "the attribute" refers to the attribute '
                 'whose name is\n'
                 'the key of the property in the owner class\' "__dict__".\n'
                 '\n'
                 'object.__get__(self, instance, owner)\n'
                 '\n'
                 '   Called to get the attribute of the owner class (class '
                 'attribute\n'
                 '   access) or of an instance of that class (instance '
                 'attribute\n'
                 '   access). *owner* is always the owner class, while '
                 '*instance* is the\n'
                 '   instance that the attribute was accessed through, or '
                 '"None" when\n'
                 '   the attribute is accessed through the *owner*.  This '
                 'method should\n'
                 '   return the (computed) attribute value or raise an '
                 '"AttributeError"\n'
                 '   exception.\n'
                 '\n'
                 'object.__set__(self, instance, value)\n'
                 '\n'
                 '   Called to set the attribute on an instance *instance* of '
                 'the owner\n'
                 '   class to a new value, *value*.\n'
                 '\n'
                 'object.__delete__(self, instance)\n'
                 '\n'
                 '   Called to delete the attribute on an instance *instance* '
                 'of the\n'
                 '   owner class.\n'
                 '\n'
                 '\n'
                 'Invoking Descriptors\n'
                 '--------------------\n'
                 '\n'
                 'In general, a descriptor is an object attribute with '
                 '"binding\n'
                 'behavior", one whose attribute access has been overridden by '
                 'methods\n'
                 'in the descriptor protocol:  "__get__()", "__set__()", and\n'
                 '"__delete__()". If any of those methods are defined for an '
                 'object, it\n'
                 'is said to be a descriptor.\n'
                 '\n'
                 'The default behavior for attribute access is to get, set, or '
                 'delete\n'
                 "the attribute from an object's dictionary. For instance, "
                 '"a.x" has a\n'
                 'lookup chain starting with "a.__dict__[\'x\']", then\n'
                 '"type(a).__dict__[\'x\']", and continuing through the base '
                 'classes of\n'
                 '"type(a)" excluding metaclasses.\n'
                 '\n'
                 'However, if the looked-up value is an object defining one of '
                 'the\n'
                 'descriptor methods, then Python may override the default '
                 'behavior and\n'
                 'invoke the descriptor method instead.  Where this occurs in '
                 'the\n'
                 'precedence chain depends on which descriptor methods were '
                 'defined and\n'
                 'how they were called.  Note that descriptors are only '
                 'invoked for new\n'
                 'style objects or classes (ones that subclass "object()" or '
                 '"type()").\n'
                 '\n'
                 'The starting point for descriptor invocation is a binding, '
                 '"a.x". How\n'
                 'the arguments are assembled depends on "a":\n'
                 '\n'
                 'Direct Call\n'
                 '   The simplest and least common call is when user code '
                 'directly\n'
                 '   invokes a descriptor method:    "x.__get__(a)".\n'
                 '\n'
                 'Instance Binding\n'
                 '   If binding to a new-style object instance, "a.x" is '
                 'transformed\n'
                 '   into the call: "type(a).__dict__[\'x\'].__get__(a, '
                 'type(a))".\n'
                 '\n'
                 'Class Binding\n'
                 '   If binding to a new-style class, "A.x" is transformed '
                 'into the\n'
                 '   call: "A.__dict__[\'x\'].__get__(None, A)".\n'
                 '\n'
                 'Super Binding\n'
                 '   If "a" is an instance of "super", then the binding '
                 '"super(B,\n'
                 '   obj).m()" searches "obj.__class__.__mro__" for the base '
                 'class "A"\n'
                 '   immediately preceding "B" and then invokes the descriptor '
                 'with the\n'
                 '   call: "A.__dict__[\'m\'].__get__(obj, obj.__class__)".\n'
                 '\n'
                 'For instance bindings, the precedence of descriptor '
                 'invocation depends\n'
                 'on the which descriptor methods are defined.  A descriptor '
                 'can define\n'
                 'any combination of "__get__()", "__set__()" and '
                 '"__delete__()".  If it\n'
                 'does not define "__get__()", then accessing the attribute '
                 'will return\n'
                 'the descriptor object itself unless there is a value in the '
                 "object's\n"
                 'instance dictionary.  If the descriptor defines "__set__()" '
                 'and/or\n'
                 '"__delete__()", it is a data descriptor; if it defines '
                 'neither, it is\n'
                 'a non-data descriptor.  Normally, data descriptors define '
                 'both\n'
                 '"__get__()" and "__set__()", while non-data descriptors have '
                 'just the\n'
                 '"__get__()" method.  Data descriptors with "__set__()" and '
                 '"__get__()"\n'
                 'defined always override a redefinition in an instance '
                 'dictionary.  In\n'
                 'contrast, non-data descriptors can be overridden by '
                 'instances.\n'
                 '\n'
                 'Python methods (including "staticmethod()" and '
                 '"classmethod()") are\n'
                 'implemented as non-data descriptors.  Accordingly, instances '
                 'can\n'
                 'redefine and override methods.  This allows individual '
                 'instances to\n'
                 'acquire behaviors that differ from other instances of the '
                 'same class.\n'
                 '\n'
                 'The "property()" function is implemented as a data '
                 'descriptor.\n'
                 'Accordingly, instances cannot override the behavior of a '
                 'property.\n'
                 '\n'
                 '\n'
                 '__slots__\n'
                 '---------\n'
                 '\n'
                 'By default, instances of both old and new-style classes have '
                 'a\n'
                 'dictionary for attribute storage.  This wastes space for '
                 'objects\n'
                 'having very few instance variables.  The space consumption '
                 'can become\n'
                 'acute when creating large numbers of instances.\n'
                 '\n'
                 'The default can be overridden by defining *__slots__* in a '
                 'new-style\n'
                 'class definition.  The *__slots__* declaration takes a '
                 'sequence of\n'
                 'instance variables and reserves just enough space in each '
                 'instance to\n'
                 'hold a value for each variable.  Space is saved because '
                 '*__dict__* is\n'
                 'not created for each instance.\n'
                 '\n'
                 '__slots__\n'
                 '\n'
                 '   This class variable can be assigned a string, iterable, '
                 'or sequence\n'
                 '   of strings with variable names used by instances.  If '
                 'defined in a\n'
                 '   new-style class, *__slots__* reserves space for the '
                 'declared\n'
                 '   variables and prevents the automatic creation of '
                 '*__dict__* and\n'
                 '   *__weakref__* for each instance.\n'
                 '\n'
                 '   New in version 2.2.\n'
                 '\n'
                 'Notes on using *__slots__*\n'
                 '\n'
                 '* When inheriting from a class without *__slots__*, the '
                 '*__dict__*\n'
                 '  attribute of that class will always be accessible, so a '
                 '*__slots__*\n'
                 '  definition in the subclass is meaningless.\n'
                 '\n'
                 '* Without a *__dict__* variable, instances cannot be '
                 'assigned new\n'
                 '  variables not listed in the *__slots__* definition.  '
                 'Attempts to\n'
                 '  assign to an unlisted variable name raises '
                 '"AttributeError". If\n'
                 '  dynamic assignment of new variables is desired, then add\n'
                 '  "\'__dict__\'" to the sequence of strings in the '
                 '*__slots__*\n'
                 '  declaration.\n'
                 '\n'
                 '  Changed in version 2.3: Previously, adding "\'__dict__\'" '
                 'to the\n'
                 '  *__slots__* declaration would not enable the assignment of '
                 'new\n'
                 '  attributes not specifically listed in the sequence of '
                 'instance\n'
                 '  variable names.\n'
                 '\n'
                 '* Without a *__weakref__* variable for each instance, '
                 'classes\n'
                 '  defining *__slots__* do not support weak references to '
                 'its\n'
                 '  instances. If weak reference support is needed, then add\n'
                 '  "\'__weakref__\'" to the sequence of strings in the '
                 '*__slots__*\n'
                 '  declaration.\n'
                 '\n'
                 '  Changed in version 2.3: Previously, adding '
                 '"\'__weakref__\'" to the\n'
                 '  *__slots__* declaration would not enable support for weak\n'
                 '  references.\n'
                 '\n'
                 '* *__slots__* are implemented at the class level by '
                 'creating\n'
                 '  descriptors (Implementing Descriptors) for each variable '
                 'name.  As a\n'
                 '  result, class attributes cannot be used to set default '
                 'values for\n'
                 '  instance variables defined by *__slots__*; otherwise, the '
                 'class\n'
                 '  attribute would overwrite the descriptor assignment.\n'
                 '\n'
                 '* The action of a *__slots__* declaration is limited to the '
                 'class\n'
                 '  where it is defined.  As a result, subclasses will have a '
                 '*__dict__*\n'
                 '  unless they also define *__slots__* (which must only '
                 'contain names\n'
                 '  of any *additional* slots).\n'
                 '\n'
                 '* If a class defines a slot also defined in a base class, '
                 'the\n'
                 '  instance variable defined by the base class slot is '
                 'inaccessible\n'
                 '  (except by retrieving its descriptor directly from the '
                 'base class).\n'
                 '  This renders the meaning of the program undefined.  In the '
                 'future, a\n'
                 '  check may be added to prevent this.\n'
                 '\n'
                 '* Nonempty *__slots__* does not work for classes derived '
                 'from\n'
                 '  "variable-length" built-in types such as "long", "str" and '
                 '"tuple".\n'
                 '\n'
                 '* Any non-string iterable may be assigned to *__slots__*. '
                 'Mappings\n'
                 '  may also be used; however, in the future, special meaning '
                 'may be\n'
                 '  assigned to the values corresponding to each key.\n'
                 '\n'
                 '* *__class__* assignment works only if both classes have the '
                 'same\n'
                 '  *__slots__*.\n'
                 '\n'
                 '  Changed in version 2.6: Previously, *__class__* assignment '
                 'raised an\n'
                 '  error if either new or old class had *__slots__*.\n'
                 '\n'
                 '\n'
                 'Customizing class creation\n'
                 '==========================\n'
                 '\n'
                 'By default, new-style classes are constructed using '
                 '"type()". A class\n'
                 'definition is read into a separate namespace and the value '
                 'of class\n'
                 'name is bound to the result of "type(name, bases, dict)".\n'
                 '\n'
                 'When the class definition is read, if *__metaclass__* is '
                 'defined then\n'
                 'the callable assigned to it will be called instead of '
                 '"type()". This\n'
                 'allows classes or functions to be written which monitor or '
                 'alter the\n'
                 'class creation process:\n'
                 '\n'
                 '* Modifying the class dictionary prior to the class being '
                 'created.\n'
                 '\n'
                 '* Returning an instance of another class -- essentially '
                 'performing\n'
                 '  the role of a factory function.\n'
                 '\n'
                 "These steps will have to be performed in the metaclass's "
                 '"__new__()"\n'
                 'method -- "type.__new__()" can then be called from this '
                 'method to\n'
                 'create a class with different properties.  This example adds '
                 'a new\n'
                 'element to the class dictionary before creating the class:\n'
                 '\n'
                 '   class metacls(type):\n'
                 '       def __new__(mcs, name, bases, dict):\n'
                 "           dict['foo'] = 'metacls was here'\n"
                 '           return type.__new__(mcs, name, bases, dict)\n'
                 '\n'
                 'You can of course also override other class methods (or add '
                 'new\n'
                 'methods); for example defining a custom "__call__()" method '
                 'in the\n'
                 'metaclass allows custom behavior when the class is called, '
                 'e.g. not\n'
                 'always creating a new instance.\n'
                 '\n'
                 '__metaclass__\n'
                 '\n'
                 '   This variable can be any callable accepting arguments for '
                 '"name",\n'
                 '   "bases", and "dict".  Upon class creation, the callable '
                 'is used\n'
                 '   instead of the built-in "type()".\n'
                 '\n'
                 '   New in version 2.2.\n'
                 '\n'
                 'The appropriate metaclass is determined by the following '
                 'precedence\n'
                 'rules:\n'
                 '\n'
                 '* If "dict[\'__metaclass__\']" exists, it is used.\n'
                 '\n'
                 '* Otherwise, if there is at least one base class, its '
                 'metaclass is\n'
                 '  used (this looks for a *__class__* attribute first and if '
                 'not found,\n'
                 '  uses its type).\n'
                 '\n'
                 '* Otherwise, if a global variable named __metaclass__ '
                 'exists, it is\n'
                 '  used.\n'
                 '\n'
                 '* Otherwise, the old-style, classic metaclass '
                 '(types.ClassType) is\n'
                 '  used.\n'
                 '\n'
                 'The potential uses for metaclasses are boundless. Some ideas '
                 'that have\n'
                 'been explored including logging, interface checking, '
                 'automatic\n'
                 'delegation, automatic property creation, proxies, '
                 'frameworks, and\n'
                 'automatic resource locking/synchronization.\n'
                 '\n'
                 '\n'
                 'Customizing instance and subclass checks\n'
                 '========================================\n'
                 '\n'
                 'New in version 2.6.\n'
                 '\n'
                 'The following methods are used to override the default '
                 'behavior of the\n'
                 '"isinstance()" and "issubclass()" built-in functions.\n'
                 '\n'
                 'In particular, the metaclass "abc.ABCMeta" implements these '
                 'methods in\n'
                 'order to allow the addition of Abstract Base Classes (ABCs) '
                 'as\n'
                 '"virtual base classes" to any class or type (including '
                 'built-in\n'
                 'types), including other ABCs.\n'
                 '\n'
                 'class.__instancecheck__(self, instance)\n'
                 '\n'
                 '   Return true if *instance* should be considered a (direct '
                 'or\n'
                 '   indirect) instance of *class*. If defined, called to '
                 'implement\n'
                 '   "isinstance(instance, class)".\n'
                 '\n'
                 'class.__subclasscheck__(self, subclass)\n'
                 '\n'
                 '   Return true if *subclass* should be considered a (direct '
                 'or\n'
                 '   indirect) subclass of *class*.  If defined, called to '
                 'implement\n'
                 '   "issubclass(subclass, class)".\n'
                 '\n'
                 'Note that these methods are looked up on the type '
                 '(metaclass) of a\n'
                 'class.  They cannot be defined as class methods in the '
                 'actual class.\n'
                 'This is consistent with the lookup of special methods that '
                 'are called\n'
                 'on instances, only in this case the instance is itself a '
                 'class.\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 3119** - Introducing Abstract Base Classes\n'
                 '     Includes the specification for customizing '
                 '"isinstance()" and\n'
                 '     "issubclass()" behavior through "__instancecheck__()" '
                 'and\n'
                 '     "__subclasscheck__()", with motivation for this '
                 'functionality in\n'
                 '     the context of adding Abstract Base Classes (see the '
                 '"abc"\n'
                 '     module) to the language.\n'
                 '\n'
                 '\n'
                 'Emulating callable objects\n'
                 '==========================\n'
                 '\n'
                 'object.__call__(self[, args...])\n'
                 '\n'
                 '   Called when the instance is "called" as a function; if '
                 'this method\n'
                 '   is defined, "x(arg1, arg2, ...)" is a shorthand for\n'
                 '   "x.__call__(arg1, arg2, ...)".\n'
                 '\n'
                 '\n'
                 'Emulating container types\n'
                 '=========================\n'
                 '\n'
                 'The following methods can be defined to implement container '
                 'objects.\n'
                 'Containers usually are sequences (such as lists or tuples) '
                 'or mappings\n'
                 '(like dictionaries), but can represent other containers as '
                 'well.  The\n'
                 'first set of methods is used either to emulate a sequence or '
                 'to\n'
                 'emulate a mapping; the difference is that for a sequence, '
                 'the\n'
                 'allowable keys should be the integers *k* for which "0 <= k '
                 '< N" where\n'
                 '*N* is the length of the sequence, or slice objects, which '
                 'define a\n'
                 'range of items. (For backwards compatibility, the method\n'
                 '"__getslice__()" (see below) can also be defined to handle '
                 'simple, but\n'
                 'not extended slices.) It is also recommended that mappings '
                 'provide the\n'
                 'methods "keys()", "values()", "items()", "has_key()", '
                 '"get()",\n'
                 '"clear()", "setdefault()", "iterkeys()", "itervalues()",\n'
                 '"iteritems()", "pop()", "popitem()", "copy()", and '
                 '"update()" behaving\n'
                 "similar to those for Python's standard dictionary objects.  "
                 'The\n'
                 '"UserDict" module provides a "DictMixin" class to help '
                 'create those\n'
                 'methods from a base set of "__getitem__()", '
                 '"__setitem__()",\n'
                 '"__delitem__()", and "keys()". Mutable sequences should '
                 'provide\n'
                 'methods "append()", "count()", "index()", "extend()", '
                 '"insert()",\n'
                 '"pop()", "remove()", "reverse()" and "sort()", like Python '
                 'standard\n'
                 'list objects.  Finally, sequence types should implement '
                 'addition\n'
                 '(meaning concatenation) and multiplication (meaning '
                 'repetition) by\n'
                 'defining the methods "__add__()", "__radd__()", '
                 '"__iadd__()",\n'
                 '"__mul__()", "__rmul__()" and "__imul__()" described below; '
                 'they\n'
                 'should not define "__coerce__()" or other numerical '
                 'operators.  It is\n'
                 'recommended that both mappings and sequences implement the\n'
                 '"__contains__()" method to allow efficient use of the "in" '
                 'operator;\n'
                 'for mappings, "in" should be equivalent of "has_key()"; for '
                 'sequences,\n'
                 'it should search through the values.  It is further '
                 'recommended that\n'
                 'both mappings and sequences implement the "__iter__()" '
                 'method to allow\n'
                 'efficient iteration through the container; for mappings, '
                 '"__iter__()"\n'
                 'should be the same as "iterkeys()"; for sequences, it should '
                 'iterate\n'
                 'through the values.\n'
                 '\n'
                 'object.__len__(self)\n'
                 '\n'
                 '   Called to implement the built-in function "len()".  '
                 'Should return\n'
                 '   the length of the object, an integer ">=" 0.  Also, an '
                 'object that\n'
                 '   doesn\'t define a "__nonzero__()" method and whose '
                 '"__len__()"\n'
                 '   method returns zero is considered to be false in a '
                 'Boolean context.\n'
                 '\n'
                 'object.__getitem__(self, key)\n'
                 '\n'
                 '   Called to implement evaluation of "self[key]". For '
                 'sequence types,\n'
                 '   the accepted keys should be integers and slice objects.  '
                 'Note that\n'
                 '   the special interpretation of negative indexes (if the '
                 'class wishes\n'
                 '   to emulate a sequence type) is up to the "__getitem__()" '
                 'method. If\n'
                 '   *key* is of an inappropriate type, "TypeError" may be '
                 'raised; if of\n'
                 '   a value outside the set of indexes for the sequence '
                 '(after any\n'
                 '   special interpretation of negative values), "IndexError" '
                 'should be\n'
                 '   raised. For mapping types, if *key* is missing (not in '
                 'the\n'
                 '   container), "KeyError" should be raised.\n'
                 '\n'
                 '   Note: "for" loops expect that an "IndexError" will be '
                 'raised for\n'
                 '     illegal indexes to allow proper detection of the end of '
                 'the\n'
                 '     sequence.\n'
                 '\n'
                 'object.__missing__(self, key)\n'
                 '\n'
                 '   Called by "dict"."__getitem__()" to implement "self[key]" '
                 'for dict\n'
                 '   subclasses when key is not in the dictionary.\n'
                 '\n'
                 'object.__setitem__(self, key, value)\n'
                 '\n'
                 '   Called to implement assignment to "self[key]".  Same note '
                 'as for\n'
                 '   "__getitem__()".  This should only be implemented for '
                 'mappings if\n'
                 '   the objects support changes to the values for keys, or if '
                 'new keys\n'
                 '   can be added, or for sequences if elements can be '
                 'replaced.  The\n'
                 '   same exceptions should be raised for improper *key* '
                 'values as for\n'
                 '   the "__getitem__()" method.\n'
                 '\n'
                 'object.__delitem__(self, key)\n'
                 '\n'
                 '   Called to implement deletion of "self[key]".  Same note '
                 'as for\n'
                 '   "__getitem__()".  This should only be implemented for '
                 'mappings if\n'
                 '   the objects support removal of keys, or for sequences if '
                 'elements\n'
                 '   can be removed from the sequence.  The same exceptions '
                 'should be\n'
                 '   raised for improper *key* values as for the '
                 '"__getitem__()" method.\n'
                 '\n'
                 'object.__iter__(self)\n'
                 '\n'
                 '   This method is called when an iterator is required for a '
                 'container.\n'
                 '   This method should return a new iterator object that can '
                 'iterate\n'
                 '   over all the objects in the container.  For mappings, it '
                 'should\n'
                 '   iterate over the keys of the container, and should also '
                 'be made\n'
                 '   available as the method "iterkeys()".\n'
                 '\n'
                 '   Iterator objects also need to implement this method; they '
                 'are\n'
                 '   required to return themselves.  For more information on '
                 'iterator\n'
                 '   objects, see Iterator Types.\n'
                 '\n'
                 'object.__reversed__(self)\n'
                 '\n'
                 '   Called (if present) by the "reversed()" built-in to '
                 'implement\n'
                 '   reverse iteration.  It should return a new iterator '
                 'object that\n'
                 '   iterates over all the objects in the container in reverse '
                 'order.\n'
                 '\n'
                 '   If the "__reversed__()" method is not provided, the '
                 '"reversed()"\n'
                 '   built-in will fall back to using the sequence protocol '
                 '("__len__()"\n'
                 '   and "__getitem__()").  Objects that support the sequence '
                 'protocol\n'
                 '   should only provide "__reversed__()" if they can provide '
                 'an\n'
                 '   implementation that is more efficient than the one '
                 'provided by\n'
                 '   "reversed()".\n'
                 '\n'
                 '   New in version 2.6.\n'
                 '\n'
                 'The membership test operators ("in" and "not in") are '
                 'normally\n'
                 'implemented as an iteration through a sequence.  However, '
                 'container\n'
                 'objects can supply the following special method with a more '
                 'efficient\n'
                 'implementation, which also does not require the object be a '
                 'sequence.\n'
                 '\n'
                 'object.__contains__(self, item)\n'
                 '\n'
                 '   Called to implement membership test operators.  Should '
                 'return true\n'
                 '   if *item* is in *self*, false otherwise.  For mapping '
                 'objects, this\n'
                 '   should consider the keys of the mapping rather than the '
                 'values or\n'
                 '   the key-item pairs.\n'
                 '\n'
                 '   For objects that don\'t define "__contains__()", the '
                 'membership test\n'
                 '   first tries iteration via "__iter__()", then the old '
                 'sequence\n'
                 '   iteration protocol via "__getitem__()", see this section '
                 'in the\n'
                 '   language reference.\n'
                 '\n'
                 '\n'
                 'Additional methods for emulation of sequence types\n'
                 '==================================================\n'
                 '\n'
                 'The following optional methods can be defined to further '
                 'emulate\n'
                 'sequence objects.  Immutable sequences methods should at '
                 'most only\n'
                 'define "__getslice__()"; mutable sequences might define all '
                 'three\n'
                 'methods.\n'
                 '\n'
                 'object.__getslice__(self, i, j)\n'
                 '\n'
                 '   Deprecated since version 2.0: Support slice objects as '
                 'parameters\n'
                 '   to the "__getitem__()" method. (However, built-in types '
                 'in CPython\n'
                 '   currently still implement "__getslice__()".  Therefore, '
                 'you have to\n'
                 '   override it in derived classes when implementing '
                 'slicing.)\n'
                 '\n'
                 '   Called to implement evaluation of "self[i:j]". The '
                 'returned object\n'
                 '   should be of the same type as *self*.  Note that missing '
                 '*i* or *j*\n'
                 '   in the slice expression are replaced by zero or '
                 '"sys.maxsize",\n'
                 '   respectively.  If negative indexes are used in the slice, '
                 'the\n'
                 '   length of the sequence is added to that index. If the '
                 'instance does\n'
                 '   not implement the "__len__()" method, an "AttributeError" '
                 'is\n'
                 '   raised. No guarantee is made that indexes adjusted this '
                 'way are not\n'
                 '   still negative.  Indexes which are greater than the '
                 'length of the\n'
                 '   sequence are not modified. If no "__getslice__()" is '
                 'found, a slice\n'
                 '   object is created instead, and passed to "__getitem__()" '
                 'instead.\n'
                 '\n'
                 'object.__setslice__(self, i, j, sequence)\n'
                 '\n'
                 '   Called to implement assignment to "self[i:j]". Same notes '
                 'for *i*\n'
                 '   and *j* as for "__getslice__()".\n'
                 '\n'
                 '   This method is deprecated. If no "__setslice__()" is '
                 'found, or for\n'
                 '   extended slicing of the form "self[i:j:k]", a slice '
                 'object is\n'
                 '   created, and passed to "__setitem__()", instead of '
                 '"__setslice__()"\n'
                 '   being called.\n'
                 '\n'
                 'object.__delslice__(self, i, j)\n'
                 '\n'
                 '   Called to implement deletion of "self[i:j]". Same notes '
                 'for *i* and\n'
                 '   *j* as for "__getslice__()". This method is deprecated. '
                 'If no\n'
                 '   "__delslice__()" is found, or for extended slicing of the '
                 'form\n'
                 '   "self[i:j:k]", a slice object is created, and passed to\n'
                 '   "__delitem__()", instead of "__delslice__()" being '
                 'called.\n'
                 '\n'
                 'Notice that these methods are only invoked when a single '
                 'slice with a\n'
                 'single colon is used, and the slice method is available.  '
                 'For slice\n'
                 'operations involving extended slice notation, or in absence '
                 'of the\n'
                 'slice methods, "__getitem__()", "__setitem__()" or '
                 '"__delitem__()" is\n'
                 'called with a slice object as argument.\n'
                 '\n'
                 'The following example demonstrate how to make your program '
                 'or module\n'
                 'compatible with earlier versions of Python (assuming that '
                 'methods\n'
                 '"__getitem__()", "__setitem__()" and "__delitem__()" support '
                 'slice\n'
                 'objects as arguments):\n'
                 '\n'
                 '   class MyClass:\n'
                 '       ...\n'
                 '       def __getitem__(self, index):\n'
                 '           ...\n'
                 '       def __setitem__(self, index, value):\n'
                 '           ...\n'
                 '       def __delitem__(self, index):\n'
                 '           ...\n'
                 '\n'
                 '       if sys.version_info < (2, 0):\n'
                 "           # They won't be defined if version is at least "
                 '2.0 final\n'
                 '\n'
                 '           def __getslice__(self, i, j):\n'
                 '               return self[max(0, i):max(0, j):]\n'
                 '           def __setslice__(self, i, j, seq):\n'
                 '               self[max(0, i):max(0, j):] = seq\n'
                 '           def __delslice__(self, i, j):\n'
                 '               del self[max(0, i):max(0, j):]\n'
                 '       ...\n'
                 '\n'
                 'Note the calls to "max()"; these are necessary because of '
                 'the handling\n'
                 'of negative indices before the "__*slice__()" methods are '
                 'called.\n'
                 'When negative indexes are used, the "__*item__()" methods '
                 'receive them\n'
                 'as provided, but the "__*slice__()" methods get a "cooked" '
                 'form of the\n'
                 'index values.  For each negative index value, the length of '
                 'the\n'
                 'sequence is added to the index before calling the method '
                 '(which may\n'
                 'still result in a negative index); this is the customary '
                 'handling of\n'
                 'negative indexes by the built-in sequence types, and the '
                 '"__*item__()"\n'
                 'methods are expected to do this as well.  However, since '
                 'they should\n'
                 'already be doing that, negative indexes cannot be passed in; '
                 'they must\n'
                 'be constrained to the bounds of the sequence before being '
                 'passed to\n'
                 'the "__*item__()" methods. Calling "max(0, i)" conveniently '
                 'returns\n'
                 'the proper value.\n'
                 '\n'
                 '\n'
                 'Emulating numeric types\n'
                 '=======================\n'
                 '\n'
                 'The following methods can be defined to emulate numeric '
                 'objects.\n'
                 'Methods corresponding to operations that are not supported '
                 'by the\n'
                 'particular kind of number implemented (e.g., bitwise '
                 'operations for\n'
                 'non-integral numbers) should be left undefined.\n'
                 '\n'
                 'object.__add__(self, other)\n'
                 'object.__sub__(self, other)\n'
                 'object.__mul__(self, other)\n'
                 'object.__floordiv__(self, other)\n'
                 'object.__mod__(self, other)\n'
                 'object.__divmod__(self, other)\n'
                 'object.__pow__(self, other[, modulo])\n'
                 'object.__lshift__(self, other)\n'
                 'object.__rshift__(self, other)\n'
                 'object.__and__(self, other)\n'
                 'object.__xor__(self, other)\n'
                 'object.__or__(self, other)\n'
                 '\n'
                 '   These methods are called to implement the binary '
                 'arithmetic\n'
                 '   operations ("+", "-", "*", "//", "%", "divmod()", '
                 '"pow()", "**",\n'
                 '   "<<", ">>", "&", "^", "|").  For instance, to evaluate '
                 'the\n'
                 '   expression "x + y", where *x* is an instance of a class '
                 'that has an\n'
                 '   "__add__()" method, "x.__add__(y)" is called.  The '
                 '"__divmod__()"\n'
                 '   method should be the equivalent to using "__floordiv__()" '
                 'and\n'
                 '   "__mod__()"; it should not be related to "__truediv__()" '
                 '(described\n'
                 '   below).  Note that "__pow__()" should be defined to '
                 'accept an\n'
                 '   optional third argument if the ternary version of the '
                 'built-in\n'
                 '   "pow()" function is to be supported.\n'
                 '\n'
                 '   If one of those methods does not support the operation '
                 'with the\n'
                 '   supplied arguments, it should return "NotImplemented".\n'
                 '\n'
                 'object.__div__(self, other)\n'
                 'object.__truediv__(self, other)\n'
                 '\n'
                 '   The division operator ("/") is implemented by these '
                 'methods.  The\n'
                 '   "__truediv__()" method is used when "__future__.division" '
                 'is in\n'
                 '   effect, otherwise "__div__()" is used.  If only one of '
                 'these two\n'
                 '   methods is defined, the object will not support division '
                 'in the\n'
                 '   alternate context; "TypeError" will be raised instead.\n'
                 '\n'
                 'object.__radd__(self, other)\n'
                 'object.__rsub__(self, other)\n'
                 'object.__rmul__(self, other)\n'
                 'object.__rdiv__(self, other)\n'
                 'object.__rtruediv__(self, other)\n'
                 'object.__rfloordiv__(self, other)\n'
                 'object.__rmod__(self, other)\n'
                 'object.__rdivmod__(self, other)\n'
                 'object.__rpow__(self, other)\n'
                 'object.__rlshift__(self, other)\n'
                 'object.__rrshift__(self, other)\n'
                 'object.__rand__(self, other)\n'
                 'object.__rxor__(self, other)\n'
                 'object.__ror__(self, other)\n'
                 '\n'
                 '   These methods are called to implement the binary '
                 'arithmetic\n'
                 '   operations ("+", "-", "*", "/", "%", "divmod()", "pow()", '
                 '"**",\n'
                 '   "<<", ">>", "&", "^", "|") with reflected (swapped) '
                 'operands.\n'
                 '   These functions are only called if the left operand does '
                 'not\n'
                 '   support the corresponding operation and the operands are '
                 'of\n'
                 '   different types. [2] For instance, to evaluate the '
                 'expression "x -\n'
                 '   y", where *y* is an instance of a class that has an '
                 '"__rsub__()"\n'
                 '   method, "y.__rsub__(x)" is called if "x.__sub__(y)" '
                 'returns\n'
                 '   *NotImplemented*.\n'
                 '\n'
                 '   Note that ternary "pow()" will not try calling '
                 '"__rpow__()" (the\n'
                 '   coercion rules would become too complicated).\n'
                 '\n'
                 "   Note: If the right operand's type is a subclass of the "
                 'left\n'
                 "     operand's type and that subclass provides the reflected "
                 'method\n'
                 '     for the operation, this method will be called before '
                 'the left\n'
                 "     operand's non-reflected method.  This behavior allows "
                 'subclasses\n'
                 "     to override their ancestors' operations.\n"
                 '\n'
                 'object.__iadd__(self, other)\n'
                 'object.__isub__(self, other)\n'
                 'object.__imul__(self, other)\n'
                 'object.__idiv__(self, other)\n'
                 'object.__itruediv__(self, other)\n'
                 'object.__ifloordiv__(self, other)\n'
                 'object.__imod__(self, other)\n'
                 'object.__ipow__(self, other[, modulo])\n'
                 'object.__ilshift__(self, other)\n'
                 'object.__irshift__(self, other)\n'
                 'object.__iand__(self, other)\n'
                 'object.__ixor__(self, other)\n'
                 'object.__ior__(self, other)\n'
                 '\n'
                 '   These methods are called to implement the augmented '
                 'arithmetic\n'
                 '   assignments ("+=", "-=", "*=", "/=", "//=", "%=", "**=", '
                 '"<<=",\n'
                 '   ">>=", "&=", "^=", "|=").  These methods should attempt '
                 'to do the\n'
                 '   operation in-place (modifying *self*) and return the '
                 'result (which\n'
                 '   could be, but does not have to be, *self*).  If a '
                 'specific method\n'
                 '   is not defined, the augmented assignment falls back to '
                 'the normal\n'
                 '   methods.  For instance, to execute the statement "x += '
                 'y", where\n'
                 '   *x* is an instance of a class that has an "__iadd__()" '
                 'method,\n'
                 '   "x.__iadd__(y)" is called.  If *x* is an instance of a '
                 'class that\n'
                 '   does not define a "__iadd__()" method, "x.__add__(y)" '
                 'and\n'
                 '   "y.__radd__(x)" are considered, as with the evaluation of '
                 '"x + y".\n'
                 '\n'
                 'object.__neg__(self)\n'
                 'object.__pos__(self)\n'
                 'object.__abs__(self)\n'
                 'object.__invert__(self)\n'
                 '\n'
                 '   Called to implement the unary arithmetic operations ("-", '
                 '"+",\n'
                 '   "abs()" and "~").\n'
                 '\n'
                 'object.__complex__(self)\n'
                 'object.__int__(self)\n'
                 'object.__long__(self)\n'
                 'object.__float__(self)\n'
                 '\n'
                 '   Called to implement the built-in functions "complex()", '
                 '"int()",\n'
                 '   "long()", and "float()".  Should return a value of the '
                 'appropriate\n'
                 '   type.\n'
                 '\n'
                 'object.__oct__(self)\n'
                 'object.__hex__(self)\n'
                 '\n'
                 '   Called to implement the built-in functions "oct()" and '
                 '"hex()".\n'
                 '   Should return a string value.\n'
                 '\n'
                 'object.__index__(self)\n'
                 '\n'
                 '   Called to implement "operator.index()".  Also called '
                 'whenever\n'
                 '   Python needs an integer object (such as in slicing).  '
                 'Must return\n'
                 '   an integer (int or long).\n'
                 '\n'
                 '   New in version 2.5.\n'
                 '\n'
                 'object.__coerce__(self, other)\n'
                 '\n'
                 '   Called to implement "mixed-mode" numeric arithmetic.  '
                 'Should either\n'
                 '   return a 2-tuple containing *self* and *other* converted '
                 'to a\n'
                 '   common numeric type, or "None" if conversion is '
                 'impossible.  When\n'
                 '   the common type would be the type of "other", it is '
                 'sufficient to\n'
                 '   return "None", since the interpreter will also ask the '
                 'other object\n'
                 '   to attempt a coercion (but sometimes, if the '
                 'implementation of the\n'
                 '   other type cannot be changed, it is useful to do the '
                 'conversion to\n'
                 '   the other type here).  A return value of "NotImplemented" '
                 'is\n'
                 '   equivalent to returning "None".\n'
                 '\n'
                 '\n'
                 'Coercion rules\n'
                 '==============\n'
                 '\n'
                 'This section used to document the rules for coercion.  As '
                 'the language\n'
                 'has evolved, the coercion rules have become hard to '
                 'document\n'
                 'precisely; documenting what one version of one particular\n'
                 'implementation does is undesirable.  Instead, here are some '
                 'informal\n'
                 'guidelines regarding coercion.  In Python 3, coercion will '
                 'not be\n'
                 'supported.\n'
                 '\n'
                 '* If the left operand of a % operator is a string or Unicode '
                 'object,\n'
                 '  no coercion takes place and the string formatting '
                 'operation is\n'
                 '  invoked instead.\n'
                 '\n'
                 '* It is no longer recommended to define a coercion '
                 'operation. Mixed-\n'
                 "  mode operations on types that don't define coercion pass "
                 'the\n'
                 '  original arguments to the operation.\n'
                 '\n'
                 '* New-style classes (those derived from "object") never '
                 'invoke the\n'
                 '  "__coerce__()" method in response to a binary operator; '
                 'the only\n'
                 '  time "__coerce__()" is invoked is when the built-in '
                 'function\n'
                 '  "coerce()" is called.\n'
                 '\n'
                 '* For most intents and purposes, an operator that returns\n'
                 '  "NotImplemented" is treated the same as one that is not '
                 'implemented\n'
                 '  at all.\n'
                 '\n'
                 '* Below, "__op__()" and "__rop__()" are used to signify the '
                 'generic\n'
                 '  method names corresponding to an operator; "__iop__()" is '
                 'used for\n'
                 '  the corresponding in-place operator.  For example, for the '
                 'operator\n'
                 '  \'"+"\', "__add__()" and "__radd__()" are used for the '
                 'left and right\n'
                 '  variant of the binary operator, and "__iadd__()" for the '
                 'in-place\n'
                 '  variant.\n'
                 '\n'
                 '* For objects *x* and *y*, first "x.__op__(y)" is tried.  If '
                 'this is\n'
                 '  not implemented or returns "NotImplemented", '
                 '"y.__rop__(x)" is\n'
                 '  tried.  If this is also not implemented or returns '
                 '"NotImplemented",\n'
                 '  a "TypeError" exception is raised.  But see the following '
                 'exception:\n'
                 '\n'
                 '* Exception to the previous item: if the left operand is an '
                 'instance\n'
                 '  of a built-in type or a new-style class, and the right '
                 'operand is an\n'
                 '  instance of a proper subclass of that type or class and '
                 'overrides\n'
                 '  the base\'s "__rop__()" method, the right operand\'s '
                 '"__rop__()"\n'
                 '  method is tried *before* the left operand\'s "__op__()" '
                 'method.\n'
                 '\n'
                 '  This is done so that a subclass can completely override '
                 'binary\n'
                 '  operators. Otherwise, the left operand\'s "__op__()" '
                 'method would\n'
                 '  always accept the right operand: when an instance of a '
                 'given class\n'
                 '  is expected, an instance of a subclass of that class is '
                 'always\n'
                 '  acceptable.\n'
                 '\n'
                 '* When either operand type defines a coercion, this coercion '
                 'is\n'
                 '  called before that type\'s "__op__()" or "__rop__()" '
                 'method is\n'
                 '  called, but no sooner.  If the coercion returns an object '
                 'of a\n'
                 '  different type for the operand whose coercion is invoked, '
                 'part of\n'
                 '  the process is redone using the new object.\n'
                 '\n'
                 '* When an in-place operator (like \'"+="\') is used, if the '
                 'left\n'
                 '  operand implements "__iop__()", it is invoked without any '
                 'coercion.\n'
                 '  When the operation falls back to "__op__()" and/or '
                 '"__rop__()", the\n'
                 '  normal coercion rules apply.\n'
                 '\n'
                 '* In "x + y", if *x* is a sequence that implements sequence\n'
                 '  concatenation, sequence concatenation is invoked.\n'
                 '\n'
                 '* In "x * y", if one operand is a sequence that implements '
                 'sequence\n'
                 '  repetition, and the other is an integer ("int" or "long"), '
                 'sequence\n'
                 '  repetition is invoked.\n'
                 '\n'
                 '* Rich comparisons (implemented by methods "__eq__()" and so '
                 'on)\n'
                 '  never use coercion.  Three-way comparison (implemented by\n'
                 '  "__cmp__()") does use coercion under the same conditions '
                 'as other\n'
                 '  binary operations use it.\n'
                 '\n'
                 '* In the current implementation, the built-in numeric types '
                 '"int",\n'
                 '  "long", "float", and "complex" do not use coercion. All '
                 'these types\n'
                 '  implement a "__coerce__()" method, for use by the '
                 'built-in\n'
                 '  "coerce()" function.\n'
                 '\n'
                 '  Changed in version 2.7: The complex type no longer makes '
                 'implicit\n'
                 '  calls to the "__coerce__()" method for mixed-type binary '
                 'arithmetic\n'
                 '  operations.\n'
                 '\n'
                 '\n'
                 'With Statement Context Managers\n'
                 '===============================\n'
                 '\n'
                 'New in version 2.5.\n'
                 '\n'
                 'A *context manager* is an object that defines the runtime '
                 'context to\n'
                 'be established when executing a "with" statement. The '
                 'context manager\n'
                 'handles the entry into, and the exit from, the desired '
                 'runtime context\n'
                 'for the execution of the block of code.  Context managers '
                 'are normally\n'
                 'invoked using the "with" statement (described in section The '
                 'with\n'
                 'statement), but can also be used by directly invoking their '
                 'methods.\n'
                 '\n'
                 'Typical uses of context managers include saving and '
                 'restoring various\n'
                 'kinds of global state, locking and unlocking resources, '
                 'closing opened\n'
                 'files, etc.\n'
                 '\n'
                 'For more information on context managers, see Context '
                 'Manager Types.\n'
                 '\n'
                 'object.__enter__(self)\n'
                 '\n'
                 '   Enter the runtime context related to this object. The '
                 '"with"\n'
                 "   statement will bind this method's return value to the "
                 'target(s)\n'
                 '   specified in the "as" clause of the statement, if any.\n'
                 '\n'
                 'object.__exit__(self, exc_type, exc_value, traceback)\n'
                 '\n'
                 '   Exit the runtime context related to this object. The '
                 'parameters\n'
                 '   describe the exception that caused the context to be '
                 'exited. If the\n'
                 '   context was exited without an exception, all three '
                 'arguments will\n'
                 '   be "None".\n'
                 '\n'
                 '   If an exception is supplied, and the method wishes to '
                 'suppress the\n'
                 '   exception (i.e., prevent it from being propagated), it '
                 'should\n'
                 '   return a true value. Otherwise, the exception will be '
                 'processed\n'
                 '   normally upon exit from this method.\n'
                 '\n'
                 '   Note that "__exit__()" methods should not reraise the '
                 'passed-in\n'
                 "   exception; this is the caller's responsibility.\n"
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 343** - The "with" statement\n'
                 '     The specification, background, and examples for the '
                 'Python "with"\n'
                 '     statement.\n'
                 '\n'
                 '\n'
                 'Special method lookup for old-style classes\n'
                 '===========================================\n'
                 '\n'
                 'For old-style classes, special methods are always looked up '
                 'in exactly\n'
                 'the same way as any other method or attribute. This is the '
                 'case\n'
                 'regardless of whether the method is being looked up '
                 'explicitly as in\n'
                 '"x.__getitem__(i)" or implicitly as in "x[i]".\n'
                 '\n'
                 'This behaviour means that special methods may exhibit '
                 'different\n'
                 'behaviour for different instances of a single old-style '
                 'class if the\n'
                 'appropriate special attributes are set differently:\n'
                 '\n'
                 '   >>> class C:\n'
                 '   ...     pass\n'
                 '   ...\n'
                 '   >>> c1 = C()\n'
                 '   >>> c2 = C()\n'
                 '   >>> c1.__len__ = lambda: 5\n'
                 '   >>> c2.__len__ = lambda: 9\n'
                 '   >>> len(c1)\n'
                 '   5\n'
                 '   >>> len(c2)\n'
                 '   9\n'
                 '\n'
                 '\n'
                 'Special method lookup for new-style classes\n'
                 '===========================================\n'
                 '\n'
                 'For new-style classes, implicit invocations of special '
                 'methods are\n'
                 "only guaranteed to work correctly if defined on an object's "
                 'type, not\n'
                 "in the object's instance dictionary.  That behaviour is the "
                 'reason why\n'
                 'the following code raises an exception (unlike the '
                 'equivalent example\n'
                 'with old-style classes):\n'
                 '\n'
                 '   >>> class C(object):\n'
                 '   ...     pass\n'
                 '   ...\n'
                 '   >>> c = C()\n'
                 '   >>> c.__len__ = lambda: 5\n'
                 '   >>> len(c)\n'
                 '   Traceback (most recent call last):\n'
                 '     File "<stdin>", line 1, in <module>\n'
                 "   TypeError: object of type 'C' has no len()\n"
                 '\n'
                 'The rationale behind this behaviour lies with a number of '
                 'special\n'
                 'methods such as "__hash__()" and "__repr__()" that are '
                 'implemented by\n'
                 'all objects, including type objects. If the implicit lookup '
                 'of these\n'
                 'methods used the conventional lookup process, they would '
                 'fail when\n'
                 'invoked on the type object itself:\n'
                 '\n'
                 '   >>> 1 .__hash__() == hash(1)\n'
                 '   True\n'
                 '   >>> int.__hash__() == hash(int)\n'
                 '   Traceback (most recent call last):\n'
                 '     File "<stdin>", line 1, in <module>\n'
                 "   TypeError: descriptor '__hash__' of 'int' object needs an "
                 'argument\n'
                 '\n'
                 'Incorrectly attempting to invoke an unbound method of a '
                 'class in this\n'
                 "way is sometimes referred to as 'metaclass confusion', and "
                 'is avoided\n'
                 'by bypassing the instance when looking up special methods:\n'
                 '\n'
                 '   >>> type(1).__hash__(1) == hash(1)\n'
                 '   True\n'
                 '   >>> type(int).__hash__(int) == hash(int)\n'
                 '   True\n'
                 '\n'
                 'In addition to bypassing any instance attributes in the '
                 'interest of\n'
                 'correctness, implicit special method lookup generally also '
                 'bypasses\n'
                 'the "__getattribute__()" method even of the object\'s '
                 'metaclass:\n'
                 '\n'
                 '   >>> class Meta(type):\n'
                 '   ...    def __getattribute__(*args):\n'
                 '   ...       print "Metaclass getattribute invoked"\n'
                 '   ...       return type.__getattribute__(*args)\n'
                 '   ...\n'
                 '   >>> class C(object):\n'
                 '   ...     __metaclass__ = Meta\n'
                 '   ...     def __len__(self):\n'
                 '   ...         return 10\n'
                 '   ...     def __getattribute__(*args):\n'
                 '   ...         print "Class getattribute invoked"\n'
                 '   ...         return object.__getattribute__(*args)\n'
                 '   ...\n'
                 '   >>> c = C()\n'
                 '   >>> c.__len__()                 # Explicit lookup via '
                 'instance\n'
                 '   Class getattribute invoked\n'
                 '   10\n'
                 '   >>> type(c).__len__(c)          # Explicit lookup via '
                 'type\n'
                 '   Metaclass getattribute invoked\n'
                 '   10\n'
                 '   >>> len(c)                      # Implicit lookup\n'
                 '   10\n'
                 '\n'
                 'Bypassing the "__getattribute__()" machinery in this fashion '
                 'provides\n'
                 'significant scope for speed optimisations within the '
                 'interpreter, at\n'
                 'the cost of some flexibility in the handling of special '
                 'methods (the\n'
                 'special method *must* be set on the class object itself in '
                 'order to be\n'
                 'consistently invoked by the interpreter).\n'
                 '\n'
                 '-[ Footnotes ]-\n'
                 '\n'
                 "[1] It *is* possible in some cases to change an object's "
                 'type,\n'
                 "    under certain controlled conditions. It generally isn't "
                 'a good\n'
                 '    idea though, since it can lead to some very strange '
                 'behaviour if\n'
                 '    it is handled incorrectly.\n'
                 '\n'
                 '[2] For operands of the same type, it is assumed that if the '
                 'non-\n'
                 '    reflected method (such as "__add__()") fails the '
                 'operation is not\n'
                 '    supported, which is why the reflected method is not '
                 'called.\n',
 'string-methods': '\n'
                   'String Methods\n'
                   '**************\n'
                   '\n'
                   'Below are listed the string methods which both 8-bit '
                   'strings and\n'
                   'Unicode objects support.  Some of them are also available '
                   'on\n'
                   '"bytearray" objects.\n'
                   '\n'
                   "In addition, Python's strings support the sequence type "
                   'methods\n'
                   'described in the Sequence Types --- str, unicode, list, '
                   'tuple,\n'
                   'bytearray, buffer, xrange section. To output formatted '
                   'strings use\n'
                   'template strings or the "%" operator described in the '
                   'String\n'
                   'Formatting Operations section. Also, see the "re" module '
                   'for string\n'
                   'functions based on regular expressions.\n'
                   '\n'
                   'str.capitalize()\n'
                   '\n'
                   '   Return a copy of the string with its first character '
                   'capitalized\n'
                   '   and the rest lowercased.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.center(width[, fillchar])\n'
                   '\n'
                   '   Return centered in a string of length *width*. Padding '
                   'is done\n'
                   '   using the specified *fillchar* (default is a space).\n'
                   '\n'
                   '   Changed in version 2.4: Support for the *fillchar* '
                   'argument.\n'
                   '\n'
                   'str.count(sub[, start[, end]])\n'
                   '\n'
                   '   Return the number of non-overlapping occurrences of '
                   'substring *sub*\n'
                   '   in the range [*start*, *end*].  Optional arguments '
                   '*start* and\n'
                   '   *end* are interpreted as in slice notation.\n'
                   '\n'
                   'str.decode([encoding[, errors]])\n'
                   '\n'
                   '   Decodes the string using the codec registered for '
                   '*encoding*.\n'
                   '   *encoding* defaults to the default string encoding.  '
                   '*errors* may\n'
                   '   be given to set a different error handling scheme.  The '
                   'default is\n'
                   '   "\'strict\'", meaning that encoding errors raise '
                   '"UnicodeError".\n'
                   '   Other possible values are "\'ignore\'", "\'replace\'" '
                   'and any other\n'
                   '   name registered via "codecs.register_error()", see '
                   'section Codec\n'
                   '   Base Classes.\n'
                   '\n'
                   '   New in version 2.2.\n'
                   '\n'
                   '   Changed in version 2.3: Support for other error '
                   'handling schemes\n'
                   '   added.\n'
                   '\n'
                   '   Changed in version 2.7: Support for keyword arguments '
                   'added.\n'
                   '\n'
                   'str.encode([encoding[, errors]])\n'
                   '\n'
                   '   Return an encoded version of the string.  Default '
                   'encoding is the\n'
                   '   current default string encoding.  *errors* may be given '
                   'to set a\n'
                   '   different error handling scheme.  The default for '
                   '*errors* is\n'
                   '   "\'strict\'", meaning that encoding errors raise a '
                   '"UnicodeError".\n'
                   '   Other possible values are "\'ignore\'", "\'replace\'",\n'
                   '   "\'xmlcharrefreplace\'", "\'backslashreplace\'" and any '
                   'other name\n'
                   '   registered via "codecs.register_error()", see section '
                   'Codec Base\n'
                   '   Classes. For a list of possible encodings, see section '
                   'Standard\n'
                   '   Encodings.\n'
                   '\n'
                   '   New in version 2.0.\n'
                   '\n'
                   '   Changed in version 2.3: Support for '
                   '"\'xmlcharrefreplace\'" and\n'
                   '   "\'backslashreplace\'" and other error handling schemes '
                   'added.\n'
                   '\n'
                   '   Changed in version 2.7: Support for keyword arguments '
                   'added.\n'
                   '\n'
                   'str.endswith(suffix[, start[, end]])\n'
                   '\n'
                   '   Return "True" if the string ends with the specified '
                   '*suffix*,\n'
                   '   otherwise return "False".  *suffix* can also be a tuple '
                   'of suffixes\n'
                   '   to look for.  With optional *start*, test beginning at '
                   'that\n'
                   '   position.  With optional *end*, stop comparing at that '
                   'position.\n'
                   '\n'
                   '   Changed in version 2.5: Accept tuples as *suffix*.\n'
                   '\n'
                   'str.expandtabs([tabsize])\n'
                   '\n'
                   '   Return a copy of the string where all tab characters '
                   'are replaced\n'
                   '   by one or more spaces, depending on the current column '
                   'and the\n'
                   '   given tab size.  Tab positions occur every *tabsize* '
                   'characters\n'
                   '   (default is 8, giving tab positions at columns 0, 8, 16 '
                   'and so on).\n'
                   '   To expand the string, the current column is set to zero '
                   'and the\n'
                   '   string is examined character by character.  If the '
                   'character is a\n'
                   '   tab ("\\t"), one or more space characters are inserted '
                   'in the result\n'
                   '   until the current column is equal to the next tab '
                   'position. (The\n'
                   '   tab character itself is not copied.)  If the character '
                   'is a newline\n'
                   '   ("\\n") or return ("\\r"), it is copied and the current '
                   'column is\n'
                   '   reset to zero.  Any other character is copied unchanged '
                   'and the\n'
                   '   current column is incremented by one regardless of how '
                   'the\n'
                   '   character is represented when printed.\n'
                   '\n'
                   "   >>> '01\\t012\\t0123\\t01234'.expandtabs()\n"
                   "   '01      012     0123    01234'\n"
                   "   >>> '01\\t012\\t0123\\t01234'.expandtabs(4)\n"
                   "   '01  012 0123    01234'\n"
                   '\n'
                   'str.find(sub[, start[, end]])\n'
                   '\n'
                   '   Return the lowest index in the string where substring '
                   '*sub* is\n'
                   '   found within the slice "s[start:end]".  Optional '
                   'arguments *start*\n'
                   '   and *end* are interpreted as in slice notation.  Return '
                   '"-1" if\n'
                   '   *sub* is not found.\n'
                   '\n'
                   '   Note: The "find()" method should be used only if you '
                   'need to know\n'
                   '     the position of *sub*.  To check if *sub* is a '
                   'substring or not,\n'
                   '     use the "in" operator:\n'
                   '\n'
                   "        >>> 'Py' in 'Python'\n"
                   '        True\n'
                   '\n'
                   'str.format(*args, **kwargs)\n'
                   '\n'
                   '   Perform a string formatting operation.  The string on '
                   'which this\n'
                   '   method is called can contain literal text or '
                   'replacement fields\n'
                   '   delimited by braces "{}".  Each replacement field '
                   'contains either\n'
                   '   the numeric index of a positional argument, or the name '
                   'of a\n'
                   '   keyword argument.  Returns a copy of the string where '
                   'each\n'
                   '   replacement field is replaced with the string value of '
                   'the\n'
                   '   corresponding argument.\n'
                   '\n'
                   '   >>> "The sum of 1 + 2 is {0}".format(1+2)\n'
                   "   'The sum of 1 + 2 is 3'\n"
                   '\n'
                   '   See Format String Syntax for a description of the '
                   'various\n'
                   '   formatting options that can be specified in format '
                   'strings.\n'
                   '\n'
                   '   This method of string formatting is the new standard in '
                   'Python 3,\n'
                   '   and should be preferred to the "%" formatting described '
                   'in String\n'
                   '   Formatting Operations in new code.\n'
                   '\n'
                   '   New in version 2.6.\n'
                   '\n'
                   'str.index(sub[, start[, end]])\n'
                   '\n'
                   '   Like "find()", but raise "ValueError" when the '
                   'substring is not\n'
                   '   found.\n'
                   '\n'
                   'str.isalnum()\n'
                   '\n'
                   '   Return true if all characters in the string are '
                   'alphanumeric and\n'
                   '   there is at least one character, false otherwise.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.isalpha()\n'
                   '\n'
                   '   Return true if all characters in the string are '
                   'alphabetic and\n'
                   '   there is at least one character, false otherwise.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.isdigit()\n'
                   '\n'
                   '   Return true if all characters in the string are digits '
                   'and there is\n'
                   '   at least one character, false otherwise.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.islower()\n'
                   '\n'
                   '   Return true if all cased characters [4] in the string '
                   'are lowercase\n'
                   '   and there is at least one cased character, false '
                   'otherwise.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.isspace()\n'
                   '\n'
                   '   Return true if there are only whitespace characters in '
                   'the string\n'
                   '   and there is at least one character, false otherwise.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.istitle()\n'
                   '\n'
                   '   Return true if the string is a titlecased string and '
                   'there is at\n'
                   '   least one character, for example uppercase characters '
                   'may only\n'
                   '   follow uncased characters and lowercase characters only '
                   'cased ones.\n'
                   '   Return false otherwise.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.isupper()\n'
                   '\n'
                   '   Return true if all cased characters [4] in the string '
                   'are uppercase\n'
                   '   and there is at least one cased character, false '
                   'otherwise.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.join(iterable)\n'
                   '\n'
                   '   Return a string which is the concatenation of the '
                   'strings in the\n'
                   '   *iterable* *iterable*.  The separator between elements '
                   'is the\n'
                   '   string providing this method.\n'
                   '\n'
                   'str.ljust(width[, fillchar])\n'
                   '\n'
                   '   Return the string left justified in a string of length '
                   '*width*.\n'
                   '   Padding is done using the specified *fillchar* (default '
                   'is a\n'
                   '   space).  The original string is returned if *width* is '
                   'less than or\n'
                   '   equal to "len(s)".\n'
                   '\n'
                   '   Changed in version 2.4: Support for the *fillchar* '
                   'argument.\n'
                   '\n'
                   'str.lower()\n'
                   '\n'
                   '   Return a copy of the string with all the cased '
                   'characters [4]\n'
                   '   converted to lowercase.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.lstrip([chars])\n'
                   '\n'
                   '   Return a copy of the string with leading characters '
                   'removed.  The\n'
                   '   *chars* argument is a string specifying the set of '
                   'characters to be\n'
                   '   removed.  If omitted or "None", the *chars* argument '
                   'defaults to\n'
                   '   removing whitespace.  The *chars* argument is not a '
                   'prefix; rather,\n'
                   '   all combinations of its values are stripped:\n'
                   '\n'
                   "   >>> '   spacious   '.lstrip()\n"
                   "   'spacious   '\n"
                   "   >>> 'www.example.com'.lstrip('cmowz.')\n"
                   "   'example.com'\n"
                   '\n'
                   '   Changed in version 2.2.2: Support for the *chars* '
                   'argument.\n'
                   '\n'
                   'str.partition(sep)\n'
                   '\n'
                   '   Split the string at the first occurrence of *sep*, and '
                   'return a\n'
                   '   3-tuple containing the part before the separator, the '
                   'separator\n'
                   '   itself, and the part after the separator.  If the '
                   'separator is not\n'
                   '   found, return a 3-tuple containing the string itself, '
                   'followed by\n'
                   '   two empty strings.\n'
                   '\n'
                   '   New in version 2.5.\n'
                   '\n'
                   'str.replace(old, new[, count])\n'
                   '\n'
                   '   Return a copy of the string with all occurrences of '
                   'substring *old*\n'
                   '   replaced by *new*.  If the optional argument *count* is '
                   'given, only\n'
                   '   the first *count* occurrences are replaced.\n'
                   '\n'
                   'str.rfind(sub[, start[, end]])\n'
                   '\n'
                   '   Return the highest index in the string where substring '
                   '*sub* is\n'
                   '   found, such that *sub* is contained within '
                   '"s[start:end]".\n'
                   '   Optional arguments *start* and *end* are interpreted as '
                   'in slice\n'
                   '   notation.  Return "-1" on failure.\n'
                   '\n'
                   'str.rindex(sub[, start[, end]])\n'
                   '\n'
                   '   Like "rfind()" but raises "ValueError" when the '
                   'substring *sub* is\n'
                   '   not found.\n'
                   '\n'
                   'str.rjust(width[, fillchar])\n'
                   '\n'
                   '   Return the string right justified in a string of length '
                   '*width*.\n'
                   '   Padding is done using the specified *fillchar* (default '
                   'is a\n'
                   '   space). The original string is returned if *width* is '
                   'less than or\n'
                   '   equal to "len(s)".\n'
                   '\n'
                   '   Changed in version 2.4: Support for the *fillchar* '
                   'argument.\n'
                   '\n'
                   'str.rpartition(sep)\n'
                   '\n'
                   '   Split the string at the last occurrence of *sep*, and '
                   'return a\n'
                   '   3-tuple containing the part before the separator, the '
                   'separator\n'
                   '   itself, and the part after the separator.  If the '
                   'separator is not\n'
                   '   found, return a 3-tuple containing two empty strings, '
                   'followed by\n'
                   '   the string itself.\n'
                   '\n'
                   '   New in version 2.5.\n'
                   '\n'
                   'str.rsplit([sep[, maxsplit]])\n'
                   '\n'
                   '   Return a list of the words in the string, using *sep* '
                   'as the\n'
                   '   delimiter string. If *maxsplit* is given, at most '
                   '*maxsplit* splits\n'
                   '   are done, the *rightmost* ones.  If *sep* is not '
                   'specified or\n'
                   '   "None", any whitespace string is a separator.  Except '
                   'for splitting\n'
                   '   from the right, "rsplit()" behaves like "split()" which '
                   'is\n'
                   '   described in detail below.\n'
                   '\n'
                   '   New in version 2.4.\n'
                   '\n'
                   'str.rstrip([chars])\n'
                   '\n'
                   '   Return a copy of the string with trailing characters '
                   'removed.  The\n'
                   '   *chars* argument is a string specifying the set of '
                   'characters to be\n'
                   '   removed.  If omitted or "None", the *chars* argument '
                   'defaults to\n'
                   '   removing whitespace.  The *chars* argument is not a '
                   'suffix; rather,\n'
                   '   all combinations of its values are stripped:\n'
                   '\n'
                   "   >>> '   spacious   '.rstrip()\n"
                   "   '   spacious'\n"
                   "   >>> 'mississippi'.rstrip('ipz')\n"
                   "   'mississ'\n"
                   '\n'
                   '   Changed in version 2.2.2: Support for the *chars* '
                   'argument.\n'
                   '\n'
                   'str.split([sep[, maxsplit]])\n'
                   '\n'
                   '   Return a list of the words in the string, using *sep* '
                   'as the\n'
                   '   delimiter string.  If *maxsplit* is given, at most '
                   '*maxsplit*\n'
                   '   splits are done (thus, the list will have at most '
                   '"maxsplit+1"\n'
                   '   elements).  If *maxsplit* is not specified or "-1", '
                   'then there is\n'
                   '   no limit on the number of splits (all possible splits '
                   'are made).\n'
                   '\n'
                   '   If *sep* is given, consecutive delimiters are not '
                   'grouped together\n'
                   '   and are deemed to delimit empty strings (for example,\n'
                   '   "\'1,,2\'.split(\',\')" returns "[\'1\', \'\', '
                   '\'2\']").  The *sep* argument\n'
                   '   may consist of multiple characters (for example,\n'
                   '   "\'1<>2<>3\'.split(\'<>\')" returns "[\'1\', \'2\', '
                   '\'3\']"). Splitting an\n'
                   '   empty string with a specified separator returns '
                   '"[\'\']".\n'
                   '\n'
                   '   If *sep* is not specified or is "None", a different '
                   'splitting\n'
                   '   algorithm is applied: runs of consecutive whitespace '
                   'are regarded\n'
                   '   as a single separator, and the result will contain no '
                   'empty strings\n'
                   '   at the start or end if the string has leading or '
                   'trailing\n'
                   '   whitespace.  Consequently, splitting an empty string or '
                   'a string\n'
                   '   consisting of just whitespace with a "None" separator '
                   'returns "[]".\n'
                   '\n'
                   '   For example, "\' 1  2   3  \'.split()" returns "[\'1\', '
                   '\'2\', \'3\']", and\n'
                   '   "\'  1  2   3  \'.split(None, 1)" returns "[\'1\', '
                   '\'2   3  \']".\n'
                   '\n'
                   'str.splitlines([keepends])\n'
                   '\n'
                   '   Return a list of the lines in the string, breaking at '
                   'line\n'
                   '   boundaries. This method uses the *universal newlines* '
                   'approach to\n'
                   '   splitting lines. Line breaks are not included in the '
                   'resulting list\n'
                   '   unless *keepends* is given and true.\n'
                   '\n'
                   '   For example, "\'ab c\\n\\nde '
                   'fg\\rkl\\r\\n\'.splitlines()" returns "[\'ab\n'
                   '   c\', \'\', \'de fg\', \'kl\']", while the same call '
                   'with\n'
                   '   "splitlines(True)" returns "[\'ab c\\n\', \'\\n\', \'de '
                   'fg\\r\', \'kl\\r\\n\']".\n'
                   '\n'
                   '   Unlike "split()" when a delimiter string *sep* is '
                   'given, this\n'
                   '   method returns an empty list for the empty string, and '
                   'a terminal\n'
                   '   line break does not result in an extra line.\n'
                   '\n'
                   'str.startswith(prefix[, start[, end]])\n'
                   '\n'
                   '   Return "True" if string starts with the *prefix*, '
                   'otherwise return\n'
                   '   "False". *prefix* can also be a tuple of prefixes to '
                   'look for.\n'
                   '   With optional *start*, test string beginning at that '
                   'position.\n'
                   '   With optional *end*, stop comparing string at that '
                   'position.\n'
                   '\n'
                   '   Changed in version 2.5: Accept tuples as *prefix*.\n'
                   '\n'
                   'str.strip([chars])\n'
                   '\n'
                   '   Return a copy of the string with the leading and '
                   'trailing\n'
                   '   characters removed. The *chars* argument is a string '
                   'specifying the\n'
                   '   set of characters to be removed. If omitted or "None", '
                   'the *chars*\n'
                   '   argument defaults to removing whitespace. The *chars* '
                   'argument is\n'
                   '   not a prefix or suffix; rather, all combinations of its '
                   'values are\n'
                   '   stripped:\n'
                   '\n'
                   "   >>> '   spacious   '.strip()\n"
                   "   'spacious'\n"
                   "   >>> 'www.example.com'.strip('cmowz.')\n"
                   "   'example'\n"
                   '\n'
                   '   Changed in version 2.2.2: Support for the *chars* '
                   'argument.\n'
                   '\n'
                   'str.swapcase()\n'
                   '\n'
                   '   Return a copy of the string with uppercase characters '
                   'converted to\n'
                   '   lowercase and vice versa.\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.title()\n'
                   '\n'
                   '   Return a titlecased version of the string where words '
                   'start with an\n'
                   '   uppercase character and the remaining characters are '
                   'lowercase.\n'
                   '\n'
                   '   The algorithm uses a simple language-independent '
                   'definition of a\n'
                   '   word as groups of consecutive letters.  The definition '
                   'works in\n'
                   '   many contexts but it means that apostrophes in '
                   'contractions and\n'
                   '   possessives form word boundaries, which may not be the '
                   'desired\n'
                   '   result:\n'
                   '\n'
                   '      >>> "they\'re bill\'s friends from the UK".title()\n'
                   '      "They\'Re Bill\'S Friends From The Uk"\n'
                   '\n'
                   '   A workaround for apostrophes can be constructed using '
                   'regular\n'
                   '   expressions:\n'
                   '\n'
                   '      >>> import re\n'
                   '      >>> def titlecase(s):\n'
                   '      ...     return re.sub(r"[A-Za-z]+(\'[A-Za-z]+)?",\n'
                   '      ...                   lambda mo: '
                   'mo.group(0)[0].upper() +\n'
                   '      ...                              '
                   'mo.group(0)[1:].lower(),\n'
                   '      ...                   s)\n'
                   '      ...\n'
                   '      >>> titlecase("they\'re bill\'s friends.")\n'
                   '      "They\'re Bill\'s Friends."\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.translate(table[, deletechars])\n'
                   '\n'
                   '   Return a copy of the string where all characters '
                   'occurring in the\n'
                   '   optional argument *deletechars* are removed, and the '
                   'remaining\n'
                   '   characters have been mapped through the given '
                   'translation table,\n'
                   '   which must be a string of length 256.\n'
                   '\n'
                   '   You can use the "maketrans()" helper function in the '
                   '"string"\n'
                   '   module to create a translation table. For string '
                   'objects, set the\n'
                   '   *table* argument to "None" for translations that only '
                   'delete\n'
                   '   characters:\n'
                   '\n'
                   "   >>> 'read this short text'.translate(None, 'aeiou')\n"
                   "   'rd ths shrt txt'\n"
                   '\n'
                   '   New in version 2.6: Support for a "None" *table* '
                   'argument.\n'
                   '\n'
                   '   For Unicode objects, the "translate()" method does not '
                   'accept the\n'
                   '   optional *deletechars* argument.  Instead, it returns a '
                   'copy of the\n'
                   '   *s* where all characters have been mapped through the '
                   'given\n'
                   '   translation table which must be a mapping of Unicode '
                   'ordinals to\n'
                   '   Unicode ordinals, Unicode strings or "None". Unmapped '
                   'characters\n'
                   '   are left untouched. Characters mapped to "None" are '
                   'deleted.  Note,\n'
                   '   a more flexible approach is to create a custom '
                   'character mapping\n'
                   '   codec using the "codecs" module (see "encodings.cp1251" '
                   'for an\n'
                   '   example).\n'
                   '\n'
                   'str.upper()\n'
                   '\n'
                   '   Return a copy of the string with all the cased '
                   'characters [4]\n'
                   '   converted to uppercase.  Note that '
                   '"str.upper().isupper()" might be\n'
                   '   "False" if "s" contains uncased characters or if the '
                   'Unicode\n'
                   '   category of the resulting character(s) is not "Lu" '
                   '(Letter,\n'
                   '   uppercase), but e.g. "Lt" (Letter, titlecase).\n'
                   '\n'
                   '   For 8-bit strings, this method is locale-dependent.\n'
                   '\n'
                   'str.zfill(width)\n'
                   '\n'
                   '   Return the numeric string left filled with zeros in a '
                   'string of\n'
                   '   length *width*.  A sign prefix is handled correctly.  '
                   'The original\n'
                   '   string is returned if *width* is less than or equal to '
                   '"len(s)".\n'
                   '\n'
                   '   New in version 2.2.2.\n'
                   '\n'
                   'The following methods are present only on unicode '
                   'objects:\n'
                   '\n'
                   'unicode.isnumeric()\n'
                   '\n'
                   '   Return "True" if there are only numeric characters in '
                   'S, "False"\n'
                   '   otherwise. Numeric characters include digit characters, '
                   'and all\n'
                   '   characters that have the Unicode numeric value '
                   'property, e.g.\n'
                   '   U+2155, VULGAR FRACTION ONE FIFTH.\n'
                   '\n'
                   'unicode.isdecimal()\n'
                   '\n'
                   '   Return "True" if there are only decimal characters in '
                   'S, "False"\n'
                   '   otherwise. Decimal characters include digit characters, '
                   'and all\n'
                   '   characters that can be used to form decimal-radix '
                   'numbers, e.g.\n'
                   '   U+0660, ARABIC-INDIC DIGIT ZERO.\n',
 'strings': '\n'
            'String literals\n'
            '***************\n'
            '\n'
            'String literals are described by the following lexical '
            'definitions:\n'
            '\n'
            '   stringliteral   ::= [stringprefix](shortstring | longstring)\n'
            '   stringprefix    ::= "r" | "u" | "ur" | "R" | "U" | "UR" | "Ur" '
            '| "uR"\n'
            '                    | "b" | "B" | "br" | "Br" | "bR" | "BR"\n'
            '   shortstring     ::= "\'" shortstringitem* "\'" | \'"\' '
            'shortstringitem* \'"\'\n'
            '   longstring      ::= "\'\'\'" longstringitem* "\'\'\'"\n'
            '                  | \'"""\' longstringitem* \'"""\'\n'
            '   shortstringitem ::= shortstringchar | escapeseq\n'
            '   longstringitem  ::= longstringchar | escapeseq\n'
            '   shortstringchar ::= <any source character except "\\" or '
            'newline or the quote>\n'
            '   longstringchar  ::= <any source character except "\\">\n'
            '   escapeseq       ::= "\\" <any ASCII character>\n'
            '\n'
            'One syntactic restriction not indicated by these productions is '
            'that\n'
            'whitespace is not allowed between the "stringprefix" and the rest '
            'of\n'
            'the string literal. The source character set is defined by the\n'
            'encoding declaration; it is ASCII if no encoding declaration is '
            'given\n'
            'in the source file; see section Encoding declarations.\n'
            '\n'
            'In plain English: String literals can be enclosed in matching '
            'single\n'
            'quotes ("\'") or double quotes (""").  They can also be enclosed '
            'in\n'
            'matching groups of three single or double quotes (these are '
            'generally\n'
            'referred to as *triple-quoted strings*).  The backslash ("\\")\n'
            'character is used to escape characters that otherwise have a '
            'special\n'
            'meaning, such as newline, backslash itself, or the quote '
            'character.\n'
            'String literals may optionally be prefixed with a letter "\'r\'" '
            'or\n'
            '"\'R\'"; such strings are called *raw strings* and use different '
            'rules\n'
            'for interpreting backslash escape sequences.  A prefix of "\'u\'" '
            'or\n'
            '"\'U\'" makes the string a Unicode string.  Unicode strings use '
            'the\n'
            'Unicode character set as defined by the Unicode Consortium and '
            'ISO\n'
            '10646.  Some additional escape sequences, described below, are\n'
            'available in Unicode strings. A prefix of "\'b\'" or "\'B\'" is '
            'ignored in\n'
            'Python 2; it indicates that the literal should become a bytes '
            'literal\n'
            'in Python 3 (e.g. when code is automatically converted with '
            '2to3).  A\n'
            '"\'u\'" or "\'b\'" prefix may be followed by an "\'r\'" prefix.\n'
            '\n'
            'In triple-quoted strings, unescaped newlines and quotes are '
            'allowed\n'
            '(and are retained), except that three unescaped quotes in a row\n'
            'terminate the string.  (A "quote" is the character used to open '
            'the\n'
            'string, i.e. either "\'" or """.)\n'
            '\n'
            'Unless an "\'r\'" or "\'R\'" prefix is present, escape sequences '
            'in\n'
            'strings are interpreted according to rules similar to those used '
            'by\n'
            'Standard C.  The recognized escape sequences are:\n'
            '\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| Escape Sequence   | Meaning                           | Notes   '
            '|\n'
            '+===================+===================================+=========+\n'
            '| "\\newline"        | Ignored                           '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\\\"              | Backslash ("\\")                   '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\\'"              | Single quote ("\'")                '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\""              | Double quote (""")                '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\a"              | ASCII Bell (BEL)                  '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\b"              | ASCII Backspace (BS)              '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\f"              | ASCII Formfeed (FF)               '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\n"              | ASCII Linefeed (LF)               '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\N{name}"        | Character named *name* in the     '
            '|         |\n'
            '|                   | Unicode database (Unicode only)   |         '
            '|\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\r"              | ASCII Carriage Return (CR)        '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\t"              | ASCII Horizontal Tab (TAB)        '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\uxxxx"          | Character with 16-bit hex value   | '
            '(1)     |\n'
            '|                   | *xxxx* (Unicode only)             |         '
            '|\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\Uxxxxxxxx"      | Character with 32-bit hex value   | '
            '(2)     |\n'
            '|                   | *xxxxxxxx* (Unicode only)         |         '
            '|\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\v"              | ASCII Vertical Tab (VT)           '
            '|         |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\ooo"            | Character with octal value *ooo*  | '
            '(3,5)   |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '| "\\xhh"            | Character with hex value *hh*     | '
            '(4,5)   |\n'
            '+-------------------+-----------------------------------+---------+\n'
            '\n'
            'Notes:\n'
            '\n'
            '1. Individual code units which form parts of a surrogate pair '
            'can\n'
            '   be encoded using this escape sequence.\n'
            '\n'
            '2. Any Unicode character can be encoded this way, but characters\n'
            '   outside the Basic Multilingual Plane (BMP) will be encoded '
            'using a\n'
            '   surrogate pair if Python is compiled to use 16-bit code units '
            '(the\n'
            '   default).\n'
            '\n'
            '3. As in Standard C, up to three octal digits are accepted.\n'
            '\n'
            '4. Unlike in Standard C, exactly two hex digits are required.\n'
            '\n'
            '5. In a string literal, hexadecimal and octal escapes denote the\n'
            '   byte with the given value; it is not necessary that the byte\n'
            '   encodes a character in the source character set. In a Unicode\n'
            '   literal, these escapes denote a Unicode character with the '
            'given\n'
            '   value.\n'
            '\n'
            'Unlike Standard C, all unrecognized escape sequences are left in '
            'the\n'
            'string unchanged, i.e., *the backslash is left in the string*.  '
            '(This\n'
            'behavior is useful when debugging: if an escape sequence is '
            'mistyped,\n'
            'the resulting output is more easily recognized as broken.)  It is '
            'also\n'
            'important to note that the escape sequences marked as "(Unicode '
            'only)"\n'
            'in the table above fall into the category of unrecognized escapes '
            'for\n'
            'non-Unicode string literals.\n'
            '\n'
            'When an "\'r\'" or "\'R\'" prefix is present, a character '
            'following a\n'
            'backslash is included in the string without change, and *all\n'
            'backslashes are left in the string*.  For example, the string '
            'literal\n'
            '"r"\\n"" consists of two characters: a backslash and a lowercase '
            '"\'n\'".\n'
            'String quotes can be escaped with a backslash, but the backslash\n'
            'remains in the string; for example, "r"\\""" is a valid string '
            'literal\n'
            'consisting of two characters: a backslash and a double quote; '
            '"r"\\""\n'
            'is not a valid string literal (even a raw string cannot end in an '
            'odd\n'
            'number of backslashes).  Specifically, *a raw string cannot end '
            'in a\n'
            'single backslash* (since the backslash would escape the '
            'following\n'
            'quote character).  Note also that a single backslash followed by '
            'a\n'
            'newline is interpreted as those two characters as part of the '
            'string,\n'
            '*not* as a line continuation.\n'
            '\n'
            'When an "\'r\'" or "\'R\'" prefix is used in conjunction with a '
            '"\'u\'" or\n'
            '"\'U\'" prefix, then the "\\uXXXX" and "\\UXXXXXXXX" escape '
            'sequences are\n'
            'processed while  *all other backslashes are left in the string*. '
            'For\n'
            'example, the string literal "ur"\\u0062\\n"" consists of three '
            'Unicode\n'
            "characters: 'LATIN SMALL LETTER B', 'REVERSE SOLIDUS', and "
            "'LATIN\n"
            "SMALL LETTER N'. Backslashes can be escaped with a preceding\n"
            'backslash; however, both remain in the string.  As a result, '
            '"\\uXXXX"\n'
            'escape sequences are only recognized when there are an odd number '
            'of\n'
            'backslashes.\n',
 'subscriptions': '\n'
                  'Subscriptions\n'
                  '*************\n'
                  '\n'
                  'A subscription selects an item of a sequence (string, tuple '
                  'or list)\n'
                  'or mapping (dictionary) object:\n'
                  '\n'
                  '   subscription ::= primary "[" expression_list "]"\n'
                  '\n'
                  'The primary must evaluate to an object of a sequence or '
                  'mapping type.\n'
                  '\n'
                  'If the primary is a mapping, the expression list must '
                  'evaluate to an\n'
                  'object whose value is one of the keys of the mapping, and '
                  'the\n'
                  'subscription selects the value in the mapping that '
                  'corresponds to that\n'
                  'key.  (The expression list is a tuple except if it has '
                  'exactly one\n'
                  'item.)\n'
                  '\n'
                  'If the primary is a sequence, the expression (list) must '
                  'evaluate to a\n'
                  'plain integer.  If this value is negative, the length of '
                  'the sequence\n'
                  'is added to it (so that, e.g., "x[-1]" selects the last '
                  'item of "x".)\n'
                  'The resulting value must be a nonnegative integer less than '
                  'the number\n'
                  'of items in the sequence, and the subscription selects the '
                  'item whose\n'
                  'index is that value (counting from zero).\n'
                  '\n'
                  "A string's items are characters.  A character is not a "
                  'separate data\n'
                  'type but a string of exactly one character.\n',
 'truth': '\n'
          'Truth Value Testing\n'
          '*******************\n'
          '\n'
          'Any object can be tested for truth value, for use in an "if" or\n'
          '"while" condition or as operand of the Boolean operations below. '
          'The\n'
          'following values are considered false:\n'
          '\n'
          '* "None"\n'
          '\n'
          '* "False"\n'
          '\n'
          '* zero of any numeric type, for example, "0", "0L", "0.0", "0j".\n'
          '\n'
          '* any empty sequence, for example, "\'\'", "()", "[]".\n'
          '\n'
          '* any empty mapping, for example, "{}".\n'
          '\n'
          '* instances of user-defined classes, if the class defines a\n'
          '  "__nonzero__()" or "__len__()" method, when that method returns '
          'the\n'
          '  integer zero or "bool" value "False". [1]\n'
          '\n'
          'All other values are considered true --- so objects of many types '
          'are\n'
          'always true.\n'
          '\n'
          'Operations and built-in functions that have a Boolean result '
          'always\n'
          'return "0" or "False" for false and "1" or "True" for true, unless\n'
          'otherwise stated. (Important exception: the Boolean operations '
          '"or"\n'
          'and "and" always return one of their operands.)\n',
 'try': '\n'
        'The "try" statement\n'
        '*******************\n'
        '\n'
        'The "try" statement specifies exception handlers and/or cleanup code\n'
        'for a group of statements:\n'
        '\n'
        '   try_stmt  ::= try1_stmt | try2_stmt\n'
        '   try1_stmt ::= "try" ":" suite\n'
        '                 ("except" [expression [("as" | ",") identifier]] ":" '
        'suite)+\n'
        '                 ["else" ":" suite]\n'
        '                 ["finally" ":" suite]\n'
        '   try2_stmt ::= "try" ":" suite\n'
        '                 "finally" ":" suite\n'
        '\n'
        'Changed in version 2.5: In previous versions of Python,\n'
        '"try"..."except"..."finally" did not work. "try"..."except" had to '
        'be\n'
        'nested in "try"..."finally".\n'
        '\n'
        'The "except" clause(s) specify one or more exception handlers. When '
        'no\n'
        'exception occurs in the "try" clause, no exception handler is\n'
        'executed. When an exception occurs in the "try" suite, a search for '
        'an\n'
        'exception handler is started.  This search inspects the except '
        'clauses\n'
        'in turn until one is found that matches the exception.  An '
        'expression-\n'
        'less except clause, if present, must be last; it matches any\n'
        'exception.  For an except clause with an expression, that expression\n'
        'is evaluated, and the clause matches the exception if the resulting\n'
        'object is "compatible" with the exception.  An object is compatible\n'
        'with an exception if it is the class or a base class of the '
        'exception\n'
        'object, or a tuple containing an item compatible with the exception.\n'
        '\n'
        'If no except clause matches the exception, the search for an '
        'exception\n'
        'handler continues in the surrounding code and on the invocation '
        'stack.\n'
        '[1]\n'
        '\n'
        'If the evaluation of an expression in the header of an except clause\n'
        'raises an exception, the original search for a handler is canceled '
        'and\n'
        'a search starts for the new exception in the surrounding code and on\n'
        'the call stack (it is treated as if the entire "try" statement '
        'raised\n'
        'the exception).\n'
        '\n'
        'When a matching except clause is found, the exception is assigned to\n'
        'the target specified in that except clause, if present, and the '
        'except\n'
        "clause's suite is executed.  All except clauses must have an\n"
        'executable block.  When the end of this block is reached, execution\n'
        'continues normally after the entire try statement.  (This means that\n'
        'if two nested handlers exist for the same exception, and the '
        'exception\n'
        'occurs in the try clause of the inner handler, the outer handler '
        'will\n'
        'not handle the exception.)\n'
        '\n'
        "Before an except clause's suite is executed, details about the\n"
        'exception are assigned to three variables in the "sys" module:\n'
        '"sys.exc_type" receives the object identifying the exception;\n'
        '"sys.exc_value" receives the exception\'s parameter;\n'
        '"sys.exc_traceback" receives a traceback object (see section The\n'
        'standard type hierarchy) identifying the point in the program where\n'
        'the exception occurred. These details are also available through the\n'
        '"sys.exc_info()" function, which returns a tuple "(exc_type,\n'
        'exc_value, exc_traceback)".  Use of the corresponding variables is\n'
        'deprecated in favor of this function, since their use is unsafe in a\n'
        'threaded program.  As of Python 1.5, the variables are restored to\n'
        'their previous values (before the call) when returning from a '
        'function\n'
        'that handled an exception.\n'
        '\n'
        'The optional "else" clause is executed if and when control flows off\n'
        'the end of the "try" clause. [2] Exceptions in the "else" clause are\n'
        'not handled by the preceding "except" clauses.\n'
        '\n'
        'If "finally" is present, it specifies a \'cleanup\' handler.  The '
        '"try"\n'
        'clause is executed, including any "except" and "else" clauses.  If '
        'an\n'
        'exception occurs in any of the clauses and is not handled, the\n'
        'exception is temporarily saved. The "finally" clause is executed.  '
        'If\n'
        'there is a saved exception, it is re-raised at the end of the\n'
        '"finally" clause. If the "finally" clause raises another exception '
        'or\n'
        'executes a "return" or "break" statement, the saved exception is\n'
        'discarded:\n'
        '\n'
        '   >>> def f():\n'
        '   ...     try:\n'
        '   ...         1/0\n'
        '   ...     finally:\n'
        '   ...         return 42\n'
        '   ...\n'
        '   >>> f()\n'
        '   42\n'
        '\n'
        'The exception information is not available to the program during\n'
        'execution of the "finally" clause.\n'
        '\n'
        'When a "return", "break" or "continue" statement is executed in the\n'
        '"try" suite of a "try"..."finally" statement, the "finally" clause '
        'is\n'
        'also executed \'on the way out.\' A "continue" statement is illegal '
        'in\n'
        'the "finally" clause. (The reason is a problem with the current\n'
        'implementation --- this restriction may be lifted in the future).\n'
        '\n'
        'The return value of a function is determined by the last "return"\n'
        'statement executed.  Since the "finally" clause always executes, a\n'
        '"return" statement executed in the "finally" clause will always be '
        'the\n'
        'last one executed:\n'
        '\n'
        '   >>> def foo():\n'
        '   ...     try:\n'
        "   ...         return 'try'\n"
        '   ...     finally:\n'
        "   ...         return 'finally'\n"
        '   ...\n'
        '   >>> foo()\n'
        "   'finally'\n"
        '\n'
        'Additional information on exceptions can be found in section\n'
        'Exceptions, and information on using the "raise" statement to '
        'generate\n'
        'exceptions may be found in section The raise statement.\n',
 'types': '\n'
          'The standard type hierarchy\n'
          '***************************\n'
          '\n'
          'Below is a list of the types that are built into Python.  '
          'Extension\n'
          'modules (written in C, Java, or other languages, depending on the\n'
          'implementation) can define additional types.  Future versions of\n'
          'Python may add types to the type hierarchy (e.g., rational '
          'numbers,\n'
          'efficiently stored arrays of integers, etc.).\n'
          '\n'
          'Some of the type descriptions below contain a paragraph listing\n'
          "'special attributes.'  These are attributes that provide access to "
          'the\n'
          'implementation and are not intended for general use.  Their '
          'definition\n'
          'may change in the future.\n'
          '\n'
          'None\n'
          '   This type has a single value.  There is a single object with '
          'this\n'
          '   value. This object is accessed through the built-in name "None". '
          'It\n'
          '   is used to signify the absence of a value in many situations, '
          'e.g.,\n'
          "   it is returned from functions that don't explicitly return\n"
          '   anything. Its truth value is false.\n'
          '\n'
          'NotImplemented\n'
          '   This type has a single value.  There is a single object with '
          'this\n'
          '   value. This object is accessed through the built-in name\n'
          '   "NotImplemented". Numeric methods and rich comparison methods '
          'may\n'
          '   return this value if they do not implement the operation for '
          'the\n'
          '   operands provided.  (The interpreter will then try the '
          'reflected\n'
          '   operation, or some other fallback, depending on the operator.)  '
          'Its\n'
          '   truth value is true.\n'
          '\n'
          'Ellipsis\n'
          '   This type has a single value.  There is a single object with '
          'this\n'
          '   value. This object is accessed through the built-in name\n'
          '   "Ellipsis". It is used to indicate the presence of the "..." '
          'syntax\n'
          '   in a slice.  Its truth value is true.\n'
          '\n'
          '"numbers.Number"\n'
          '   These are created by numeric literals and returned as results '
          'by\n'
          '   arithmetic operators and arithmetic built-in functions.  '
          'Numeric\n'
          '   objects are immutable; once created their value never changes.\n'
          '   Python numbers are of course strongly related to mathematical\n'
          '   numbers, but subject to the limitations of numerical '
          'representation\n'
          '   in computers.\n'
          '\n'
          '   Python distinguishes between integers, floating point numbers, '
          'and\n'
          '   complex numbers:\n'
          '\n'
          '   "numbers.Integral"\n'
          '      These represent elements from the mathematical set of '
          'integers\n'
          '      (positive and negative).\n'
          '\n'
          '      There are three types of integers:\n'
          '\n'
          '      Plain integers\n'
          '         These represent numbers in the range -2147483648 through\n'
          '         2147483647. (The range may be larger on machines with a\n'
          '         larger natural word size, but not smaller.)  When the '
          'result\n'
          '         of an operation would fall outside this range, the result '
          'is\n'
          '         normally returned as a long integer (in some cases, the\n'
          '         exception "OverflowError" is raised instead).  For the\n'
          '         purpose of shift and mask operations, integers are assumed '
          'to\n'
          "         have a binary, 2's complement notation using 32 or more "
          'bits,\n'
          '         and hiding no bits from the user (i.e., all 4294967296\n'
          '         different bit patterns correspond to different values).\n'
          '\n'
          '      Long integers\n'
          '         These represent numbers in an unlimited range, subject to\n'
          '         available (virtual) memory only.  For the purpose of '
          'shift\n'
          '         and mask operations, a binary representation is assumed, '
          'and\n'
          "         negative numbers are represented in a variant of 2's\n"
          '         complement which gives the illusion of an infinite string '
          'of\n'
          '         sign bits extending to the left.\n'
          '\n'
          '      Booleans\n'
          '         These represent the truth values False and True.  The two\n'
          '         objects representing the values "False" and "True" are '
          'the\n'
          '         only Boolean objects. The Boolean type is a subtype of '
          'plain\n'
          '         integers, and Boolean values behave like the values 0 and '
          '1,\n'
          '         respectively, in almost all contexts, the exception being\n'
          '         that when converted to a string, the strings ""False"" or\n'
          '         ""True"" are returned, respectively.\n'
          '\n'
          '      The rules for integer representation are intended to give '
          'the\n'
          '      most meaningful interpretation of shift and mask operations\n'
          '      involving negative integers and the least surprises when\n'
          '      switching between the plain and long integer domains.  Any\n'
          '      operation, if it yields a result in the plain integer '
          'domain,\n'
          '      will yield the same result in the long integer domain or '
          'when\n'
          '      using mixed operands.  The switch between domains is '
          'transparent\n'
          '      to the programmer.\n'
          '\n'
          '   "numbers.Real" ("float")\n'
          '      These represent machine-level double precision floating '
          'point\n'
          '      numbers. You are at the mercy of the underlying machine\n'
          '      architecture (and C or Java implementation) for the accepted\n'
          '      range and handling of overflow. Python does not support '
          'single-\n'
          '      precision floating point numbers; the savings in processor '
          'and\n'
          '      memory usage that are usually the reason for using these are\n'
          '      dwarfed by the overhead of using objects in Python, so there '
          'is\n'
          '      no reason to complicate the language with two kinds of '
          'floating\n'
          '      point numbers.\n'
          '\n'
          '   "numbers.Complex"\n'
          '      These represent complex numbers as a pair of machine-level\n'
          '      double precision floating point numbers.  The same caveats '
          'apply\n'
          '      as for floating point numbers. The real and imaginary parts '
          'of a\n'
          '      complex number "z" can be retrieved through the read-only\n'
          '      attributes "z.real" and "z.imag".\n'
          '\n'
          'Sequences\n'
          '   These represent finite ordered sets indexed by non-negative\n'
          '   numbers. The built-in function "len()" returns the number of '
          'items\n'
          '   of a sequence. When the length of a sequence is *n*, the index '
          'set\n'
          '   contains the numbers 0, 1, ..., *n*-1.  Item *i* of sequence *a* '
          'is\n'
          '   selected by "a[i]".\n'
          '\n'
          '   Sequences also support slicing: "a[i:j]" selects all items with\n'
          '   index *k* such that *i* "<=" *k* "<" *j*.  When used as an\n'
          '   expression, a slice is a sequence of the same type.  This '
          'implies\n'
          '   that the index set is renumbered so that it starts at 0.\n'
          '\n'
          '   Some sequences also support "extended slicing" with a third '
          '"step"\n'
          '   parameter: "a[i:j:k]" selects all items of *a* with index *x* '
          'where\n'
          '   "x = i + n*k", *n* ">=" "0" and *i* "<=" *x* "<" *j*.\n'
          '\n'
          '   Sequences are distinguished according to their mutability:\n'
          '\n'
          '   Immutable sequences\n'
          '      An object of an immutable sequence type cannot change once it '
          'is\n'
          '      created.  (If the object contains references to other '
          'objects,\n'
          '      these other objects may be mutable and may be changed; '
          'however,\n'
          '      the collection of objects directly referenced by an '
          'immutable\n'
          '      object cannot change.)\n'
          '\n'
          '      The following types are immutable sequences:\n'
          '\n'
          '      Strings\n'
          '         The items of a string are characters.  There is no '
          'separate\n'
          '         character type; a character is represented by a string of '
          'one\n'
          '         item. Characters represent (at least) 8-bit bytes.  The\n'
          '         built-in functions "chr()" and "ord()" convert between\n'
          '         characters and nonnegative integers representing the byte\n'
          '         values.  Bytes with the values 0-127 usually represent '
          'the\n'
          '         corresponding ASCII values, but the interpretation of '
          'values\n'
          '         is up to the program.  The string data type is also used '
          'to\n'
          '         represent arrays of bytes, e.g., to hold data read from a\n'
          '         file.\n'
          '\n'
          '         (On systems whose native character set is not ASCII, '
          'strings\n'
          '         may use EBCDIC in their internal representation, provided '
          'the\n'
          '         functions "chr()" and "ord()" implement a mapping between\n'
          '         ASCII and EBCDIC, and string comparison preserves the '
          'ASCII\n'
          '         order. Or perhaps someone can propose a better rule?)\n'
          '\n'
          '      Unicode\n'
          '         The items of a Unicode object are Unicode code units.  A\n'
          '         Unicode code unit is represented by a Unicode object of '
          'one\n'
          '         item and can hold either a 16-bit or 32-bit value\n'
          '         representing a Unicode ordinal (the maximum value for the\n'
          '         ordinal is given in "sys.maxunicode", and depends on how\n'
          '         Python is configured at compile time).  Surrogate pairs '
          'may\n'
          '         be present in the Unicode object, and will be reported as '
          'two\n'
          '         separate items.  The built-in functions "unichr()" and\n'
          '         "ord()" convert between code units and nonnegative '
          'integers\n'
          '         representing the Unicode ordinals as defined in the '
          'Unicode\n'
          '         Standard 3.0. Conversion from and to other encodings are\n'
          '         possible through the Unicode method "encode()" and the '
          'built-\n'
          '         in function "unicode()".\n'
          '\n'
          '      Tuples\n'
          '         The items of a tuple are arbitrary Python objects. Tuples '
          'of\n'
          '         two or more items are formed by comma-separated lists of\n'
          "         expressions.  A tuple of one item (a 'singleton') can be\n"
          '         formed by affixing a comma to an expression (an expression '
          'by\n'
          '         itself does not create a tuple, since parentheses must be\n'
          '         usable for grouping of expressions).  An empty tuple can '
          'be\n'
          '         formed by an empty pair of parentheses.\n'
          '\n'
          '   Mutable sequences\n'
          '      Mutable sequences can be changed after they are created.  '
          'The\n'
          '      subscription and slicing notations can be used as the target '
          'of\n'
          '      assignment and "del" (delete) statements.\n'
          '\n'
          '      There are currently two intrinsic mutable sequence types:\n'
          '\n'
          '      Lists\n'
          '         The items of a list are arbitrary Python objects.  Lists '
          'are\n'
          '         formed by placing a comma-separated list of expressions '
          'in\n'
          '         square brackets. (Note that there are no special cases '
          'needed\n'
          '         to form lists of length 0 or 1.)\n'
          '\n'
          '      Byte Arrays\n'
          '         A bytearray object is a mutable array. They are created '
          'by\n'
          '         the built-in "bytearray()" constructor.  Aside from being\n'
          '         mutable (and hence unhashable), byte arrays otherwise '
          'provide\n'
          '         the same interface and functionality as immutable bytes\n'
          '         objects.\n'
          '\n'
          '      The extension module "array" provides an additional example '
          'of a\n'
          '      mutable sequence type.\n'
          '\n'
          'Set types\n'
          '   These represent unordered, finite sets of unique, immutable\n'
          '   objects. As such, they cannot be indexed by any subscript. '
          'However,\n'
          '   they can be iterated over, and the built-in function "len()"\n'
          '   returns the number of items in a set. Common uses for sets are '
          'fast\n'
          '   membership testing, removing duplicates from a sequence, and\n'
          '   computing mathematical operations such as intersection, union,\n'
          '   difference, and symmetric difference.\n'
          '\n'
          '   For set elements, the same immutability rules apply as for\n'
          '   dictionary keys. Note that numeric types obey the normal rules '
          'for\n'
          '   numeric comparison: if two numbers compare equal (e.g., "1" and\n'
          '   "1.0"), only one of them can be contained in a set.\n'
          '\n'
          '   There are currently two intrinsic set types:\n'
          '\n'
          '   Sets\n'
          '      These represent a mutable set. They are created by the '
          'built-in\n'
          '      "set()" constructor and can be modified afterwards by '
          'several\n'
          '      methods, such as "add()".\n'
          '\n'
          '   Frozen sets\n'
          '      These represent an immutable set.  They are created by the\n'
          '      built-in "frozenset()" constructor.  As a frozenset is '
          'immutable\n'
          '      and *hashable*, it can be used again as an element of '
          'another\n'
          '      set, or as a dictionary key.\n'
          '\n'
          'Mappings\n'
          '   These represent finite sets of objects indexed by arbitrary '
          'index\n'
          '   sets. The subscript notation "a[k]" selects the item indexed by '
          '"k"\n'
          '   from the mapping "a"; this can be used in expressions and as '
          'the\n'
          '   target of assignments or "del" statements. The built-in '
          'function\n'
          '   "len()" returns the number of items in a mapping.\n'
          '\n'
          '   There is currently a single intrinsic mapping type:\n'
          '\n'
          '   Dictionaries\n'
          '      These represent finite sets of objects indexed by nearly\n'
          '      arbitrary values.  The only types of values not acceptable '
          'as\n'
          '      keys are values containing lists or dictionaries or other\n'
          '      mutable types that are compared by value rather than by '
          'object\n'
          '      identity, the reason being that the efficient implementation '
          'of\n'
          "      dictionaries requires a key's hash value to remain constant.\n"
          '      Numeric types used for keys obey the normal rules for '
          'numeric\n'
          '      comparison: if two numbers compare equal (e.g., "1" and '
          '"1.0")\n'
          '      then they can be used interchangeably to index the same\n'
          '      dictionary entry.\n'
          '\n'
          '      Dictionaries are mutable; they can be created by the "{...}"\n'
          '      notation (see section Dictionary displays).\n'
          '\n'
          '      The extension modules "dbm", "gdbm", and "bsddb" provide\n'
          '      additional examples of mapping types.\n'
          '\n'
          'Callable types\n'
          '   These are the types to which the function call operation (see\n'
          '   section Calls) can be applied:\n'
          '\n'
          '   User-defined functions\n'
          '      A user-defined function object is created by a function\n'
          '      definition (see section Function definitions).  It should be\n'
          '      called with an argument list containing the same number of '
          'items\n'
          "      as the function's formal parameter list.\n"
          '\n'
          '      Special attributes:\n'
          '\n'
          '      '
          '+-------------------------+---------------------------------+-------------+\n'
          '      | Attribute               | Meaning                         '
          '|             |\n'
          '      '
          '+=========================+=================================+=============+\n'
          '      | "__doc__" "func_doc"    | The function\'s documentation    '
          '| Writable    |\n'
          '      |                         | string, or "None" if            '
          '|             |\n'
          '      |                         | unavailable.                    '
          '|             |\n'
          '      '
          '+-------------------------+---------------------------------+-------------+\n'
          '      | "__name__" "func_name"  | The function\'s name.            '
          '| Writable    |\n'
          '      '
          '+-------------------------+---------------------------------+-------------+\n'
          '      | "__module__"            | The name of the module the      | '
          'Writable    |\n'
          '      |                         | function was defined in, or     '
          '|             |\n'
          '      |                         | "None" if unavailable.          '
          '|             |\n'
          '      '
          '+-------------------------+---------------------------------+-------------+\n'
          '      | "__defaults__"          | A tuple containing default      | '
          'Writable    |\n'
          '      | "func_defaults"         | argument values for those       '
          '|             |\n'
          '      |                         | arguments that have defaults,   '
          '|             |\n'
          '      |                         | or "None" if no arguments have  '
          '|             |\n'
          '      |                         | a default value.                '
          '|             |\n'
          '      '
          '+-------------------------+---------------------------------+-------------+\n'
          '      | "__code__" "func_code"  | The code object representing    | '
          'Writable    |\n'
          '      |                         | the compiled function body.     '
          '|             |\n'
          '      '
          '+-------------------------+---------------------------------+-------------+\n'
          '      | "__globals__"           | A reference to the dictionary   | '
          'Read-only   |\n'
          '      | "func_globals"          | that holds the function\'s       '
          '|             |\n'
          '      |                         | global variables --- the global '
          '|             |\n'
          '      |                         | namespace of the module in      '
          '|             |\n'
          '      |                         | which the function was defined. '
          '|             |\n'
          '      '
          '+-------------------------+---------------------------------+-------------+\n'
          '      | "__dict__" "func_dict"  | The namespace supporting        | '
          'Writable    |\n'
          '      |                         | arbitrary function attributes.  '
          '|             |\n'
          '      '
          '+-------------------------+---------------------------------+-------------+\n'
          '      | "__closure__"           | "None" or a tuple of cells that | '
          'Read-only   |\n'
          '      | "func_closure"          | contain bindings for the        '
          '|             |\n'
          "      |                         | function's free variables.      "
          '|             |\n'
          '      '
          '+-------------------------+---------------------------------+-------------+\n'
          '\n'
          '      Most of the attributes labelled "Writable" check the type of '
          'the\n'
          '      assigned value.\n'
          '\n'
          '      Changed in version 2.4: "func_name" is now writable.\n'
          '\n'
          '      Changed in version 2.6: The double-underscore attributes\n'
          '      "__closure__", "__code__", "__defaults__", and "__globals__"\n'
          '      were introduced as aliases for the corresponding "func_*"\n'
          '      attributes for forwards compatibility with Python 3.\n'
          '\n'
          '      Function objects also support getting and setting arbitrary\n'
          '      attributes, which can be used, for example, to attach '
          'metadata\n'
          '      to functions.  Regular attribute dot-notation is used to get '
          'and\n'
          '      set such attributes. *Note that the current implementation '
          'only\n'
          '      supports function attributes on user-defined functions. '
          'Function\n'
          '      attributes on built-in functions may be supported in the\n'
          '      future.*\n'
          '\n'
          "      Additional information about a function's definition can be\n"
          '      retrieved from its code object; see the description of '
          'internal\n'
          '      types below.\n'
          '\n'
          '   User-defined methods\n'
          '      A user-defined method object combines a class, a class '
          'instance\n'
          '      (or "None") and any callable object (normally a user-defined\n'
          '      function).\n'
          '\n'
          '      Special read-only attributes: "im_self" is the class '
          'instance\n'
          '      object, "im_func" is the function object; "im_class" is the\n'
          '      class of "im_self" for bound methods or the class that asked '
          'for\n'
          '      the method for unbound methods; "__doc__" is the method\'s\n'
          '      documentation (same as "im_func.__doc__"); "__name__" is the\n'
          '      method name (same as "im_func.__name__"); "__module__" is '
          'the\n'
          '      name of the module the method was defined in, or "None" if\n'
          '      unavailable.\n'
          '\n'
          '      Changed in version 2.2: "im_self" used to refer to the class\n'
          '      that defined the method.\n'
          '\n'
          '      Changed in version 2.6: For Python 3 forward-compatibility,\n'
          '      "im_func" is also available as "__func__", and "im_self" as\n'
          '      "__self__".\n'
          '\n'
          '      Methods also support accessing (but not setting) the '
          'arbitrary\n'
          '      function attributes on the underlying function object.\n'
          '\n'
          '      User-defined method objects may be created when getting an\n'
          '      attribute of a class (perhaps via an instance of that class), '
          'if\n'
          '      that attribute is a user-defined function object, an unbound\n'
          '      user-defined method object, or a class method object. When '
          'the\n'
          '      attribute is a user-defined method object, a new method '
          'object\n'
          '      is only created if the class from which it is being retrieved '
          'is\n'
          '      the same as, or a derived class of, the class stored in the\n'
          '      original method object; otherwise, the original method object '
          'is\n'
          '      used as it is.\n'
          '\n'
          '      When a user-defined method object is created by retrieving a\n'
          '      user-defined function object from a class, its "im_self"\n'
          '      attribute is "None" and the method object is said to be '
          'unbound.\n'
          '      When one is created by retrieving a user-defined function '
          'object\n'
          '      from a class via one of its instances, its "im_self" '
          'attribute\n'
          '      is the instance, and the method object is said to be bound. '
          'In\n'
          '      either case, the new method\'s "im_class" attribute is the '
          'class\n'
          '      from which the retrieval takes place, and its "im_func"\n'
          '      attribute is the original function object.\n'
          '\n'
          '      When a user-defined method object is created by retrieving\n'
          '      another method object from a class or instance, the behaviour '
          'is\n'
          '      the same as for a function object, except that the "im_func"\n'
          '      attribute of the new instance is not the original method '
          'object\n'
          '      but its "im_func" attribute.\n'
          '\n'
          '      When a user-defined method object is created by retrieving a\n'
          '      class method object from a class or instance, its "im_self"\n'
          '      attribute is the class itself, and its "im_func" attribute '
          'is\n'
          '      the function object underlying the class method.\n'
          '\n'
          '      When an unbound user-defined method object is called, the\n'
          '      underlying function ("im_func") is called, with the '
          'restriction\n'
          '      that the first argument must be an instance of the proper '
          'class\n'
          '      ("im_class") or of a derived class thereof.\n'
          '\n'
          '      When a bound user-defined method object is called, the\n'
          '      underlying function ("im_func") is called, inserting the '
          'class\n'
          '      instance ("im_self") in front of the argument list.  For\n'
          '      instance, when "C" is a class which contains a definition for '
          'a\n'
          '      function "f()", and "x" is an instance of "C", calling '
          '"x.f(1)"\n'
          '      is equivalent to calling "C.f(x, 1)".\n'
          '\n'
          '      When a user-defined method object is derived from a class '
          'method\n'
          '      object, the "class instance" stored in "im_self" will '
          'actually\n'
          '      be the class itself, so that calling either "x.f(1)" or '
          '"C.f(1)"\n'
          '      is equivalent to calling "f(C,1)" where "f" is the '
          'underlying\n'
          '      function.\n'
          '\n'
          '      Note that the transformation from function object to (unbound '
          'or\n'
          '      bound) method object happens each time the attribute is\n'
          '      retrieved from the class or instance. In some cases, a '
          'fruitful\n'
          '      optimization is to assign the attribute to a local variable '
          'and\n'
          '      call that local variable. Also notice that this '
          'transformation\n'
          '      only happens for user-defined functions; other callable '
          'objects\n'
          '      (and all non-callable objects) are retrieved without\n'
          '      transformation.  It is also important to note that '
          'user-defined\n'
          '      functions which are attributes of a class instance are not\n'
          '      converted to bound methods; this *only* happens when the\n'
          '      function is an attribute of the class.\n'
          '\n'
          '   Generator functions\n'
          '      A function or method which uses the "yield" statement (see\n'
          '      section The yield statement) is called a *generator '
          'function*.\n'
          '      Such a function, when called, always returns an iterator '
          'object\n'
          '      which can be used to execute the body of the function:  '
          'calling\n'
          '      the iterator\'s "next()" method will cause the function to\n'
          '      execute until it provides a value using the "yield" '
          'statement.\n'
          '      When the function executes a "return" statement or falls off '
          'the\n'
          '      end, a "StopIteration" exception is raised and the iterator '
          'will\n'
          '      have reached the end of the set of values to be returned.\n'
          '\n'
          '   Built-in functions\n'
          '      A built-in function object is a wrapper around a C function.\n'
          '      Examples of built-in functions are "len()" and "math.sin()"\n'
          '      ("math" is a standard built-in module). The number and type '
          'of\n'
          '      the arguments are determined by the C function. Special '
          'read-\n'
          '      only attributes: "__doc__" is the function\'s documentation\n'
          '      string, or "None" if unavailable; "__name__" is the '
          "function's\n"
          '      name; "__self__" is set to "None" (but see the next item);\n'
          '      "__module__" is the name of the module the function was '
          'defined\n'
          '      in or "None" if unavailable.\n'
          '\n'
          '   Built-in methods\n'
          '      This is really a different disguise of a built-in function, '
          'this\n'
          '      time containing an object passed to the C function as an\n'
          '      implicit extra argument.  An example of a built-in method is\n'
          '      "alist.append()", assuming *alist* is a list object. In this\n'
          '      case, the special read-only attribute "__self__" is set to '
          'the\n'
          '      object denoted by *alist*.\n'
          '\n'
          '   Class Types\n'
          '      Class types, or "new-style classes," are callable.  These\n'
          '      objects normally act as factories for new instances of\n'
          '      themselves, but variations are possible for class types that\n'
          '      override "__new__()".  The arguments of the call are passed '
          'to\n'
          '      "__new__()" and, in the typical case, to "__init__()" to\n'
          '      initialize the new instance.\n'
          '\n'
          '   Classic Classes\n'
          '      Class objects are described below.  When a class object is\n'
          '      called, a new class instance (also described below) is '
          'created\n'
          "      and returned.  This implies a call to the class's "
          '"__init__()"\n'
          '      method if it has one.  Any arguments are passed on to the\n'
          '      "__init__()" method.  If there is no "__init__()" method, '
          'the\n'
          '      class must be called without arguments.\n'
          '\n'
          '   Class instances\n'
          '      Class instances are described below.  Class instances are\n'
          '      callable only when the class has a "__call__()" method;\n'
          '      "x(arguments)" is a shorthand for "x.__call__(arguments)".\n'
          '\n'
          'Modules\n'
          '   Modules are imported by the "import" statement (see section The\n'
          '   import statement). A module object has a namespace implemented '
          'by a\n'
          '   dictionary object (this is the dictionary referenced by the\n'
          '   func_globals attribute of functions defined in the module).\n'
          '   Attribute references are translated to lookups in this '
          'dictionary,\n'
          '   e.g., "m.x" is equivalent to "m.__dict__["x"]". A module object\n'
          '   does not contain the code object used to initialize the module\n'
          "   (since it isn't needed once the initialization is done).\n"
          '\n'
          "   Attribute assignment updates the module's namespace dictionary,\n"
          '   e.g., "m.x = 1" is equivalent to "m.__dict__["x"] = 1".\n'
          '\n'
          '   Special read-only attribute: "__dict__" is the module\'s '
          'namespace\n'
          '   as a dictionary object.\n'
          '\n'
          '   **CPython implementation detail:** Because of the way CPython\n'
          '   clears module dictionaries, the module dictionary will be '
          'cleared\n'
          '   when the module falls out of scope even if the dictionary still '
          'has\n'
          '   live references.  To avoid this, copy the dictionary or keep '
          'the\n'
          '   module around while using its dictionary directly.\n'
          '\n'
          '   Predefined (writable) attributes: "__name__" is the module\'s '
          'name;\n'
          '   "__doc__" is the module\'s documentation string, or "None" if\n'
          '   unavailable; "__file__" is the pathname of the file from which '
          'the\n'
          '   module was loaded, if it was loaded from a file. The "__file__"\n'
          '   attribute is not present for C modules that are statically '
          'linked\n'
          '   into the interpreter; for extension modules loaded dynamically '
          'from\n'
          '   a shared library, it is the pathname of the shared library '
          'file.\n'
          '\n'
          'Classes\n'
          '   Both class types (new-style classes) and class objects (old-\n'
          '   style/classic classes) are typically created by class '
          'definitions\n'
          '   (see section Class definitions).  A class has a namespace\n'
          '   implemented by a dictionary object. Class attribute references '
          'are\n'
          '   translated to lookups in this dictionary, e.g., "C.x" is '
          'translated\n'
          '   to "C.__dict__["x"]" (although for new-style classes in '
          'particular\n'
          '   there are a number of hooks which allow for other means of '
          'locating\n'
          '   attributes). When the attribute name is not found there, the\n'
          '   attribute search continues in the base classes.  For old-style\n'
          '   classes, the search is depth-first, left-to-right in the order '
          'of\n'
          '   occurrence in the base class list. New-style classes use the '
          'more\n'
          '   complex C3 method resolution order which behaves correctly even '
          'in\n'
          "   the presence of 'diamond' inheritance structures where there "
          'are\n'
          '   multiple inheritance paths leading back to a common ancestor.\n'
          '   Additional details on the C3 MRO used by new-style classes can '
          'be\n'
          '   found in the documentation accompanying the 2.3 release at\n'
          '   https://www.python.org/download/releases/2.3/mro/.\n'
          '\n'
          '   When a class attribute reference (for class "C", say) would '
          'yield a\n'
          '   user-defined function object or an unbound user-defined method\n'
          '   object whose associated class is either "C" or one of its base\n'
          '   classes, it is transformed into an unbound user-defined method\n'
          '   object whose "im_class" attribute is "C". When it would yield a\n'
          '   class method object, it is transformed into a bound '
          'user-defined\n'
          '   method object whose "im_self" attribute is "C".  When it would\n'
          '   yield a static method object, it is transformed into the object\n'
          '   wrapped by the static method object. See section Implementing\n'
          '   Descriptors for another way in which attributes retrieved from '
          'a\n'
          '   class may differ from those actually contained in its '
          '"__dict__"\n'
          '   (note that only new-style classes support descriptors).\n'
          '\n'
          "   Class attribute assignments update the class's dictionary, "
          'never\n'
          '   the dictionary of a base class.\n'
          '\n'
          '   A class object can be called (see above) to yield a class '
          'instance\n'
          '   (see below).\n'
          '\n'
          '   Special attributes: "__name__" is the class name; "__module__" '
          'is\n'
          '   the module name in which the class was defined; "__dict__" is '
          'the\n'
          '   dictionary containing the class\'s namespace; "__bases__" is a '
          'tuple\n'
          '   (possibly empty or a singleton) containing the base classes, in '
          'the\n'
          '   order of their occurrence in the base class list; "__doc__" is '
          'the\n'
          "   class's documentation string, or None if undefined.\n"
          '\n'
          'Class instances\n'
          '   A class instance is created by calling a class object (see '
          'above).\n'
          '   A class instance has a namespace implemented as a dictionary '
          'which\n'
          '   is the first place in which attribute references are searched.\n'
          "   When an attribute is not found there, and the instance's class "
          'has\n'
          '   an attribute by that name, the search continues with the class\n'
          '   attributes.  If a class attribute is found that is a '
          'user-defined\n'
          '   function object or an unbound user-defined method object whose\n'
          '   associated class is the class (call it "C") of the instance for\n'
          '   which the attribute reference was initiated or one of its bases, '
          'it\n'
          '   is transformed into a bound user-defined method object whose\n'
          '   "im_class" attribute is "C" and whose "im_self" attribute is '
          'the\n'
          '   instance. Static method and class method objects are also\n'
          '   transformed, as if they had been retrieved from class "C"; see\n'
          '   above under "Classes". See section Implementing Descriptors for\n'
          '   another way in which attributes of a class retrieved via its\n'
          '   instances may differ from the objects actually stored in the\n'
          '   class\'s "__dict__". If no class attribute is found, and the\n'
          '   object\'s class has a "__getattr__()" method, that is called to\n'
          '   satisfy the lookup.\n'
          '\n'
          "   Attribute assignments and deletions update the instance's\n"
          "   dictionary, never a class's dictionary.  If the class has a\n"
          '   "__setattr__()" or "__delattr__()" method, this is called '
          'instead\n'
          '   of updating the instance dictionary directly.\n'
          '\n'
          '   Class instances can pretend to be numbers, sequences, or '
          'mappings\n'
          '   if they have methods with certain special names.  See section\n'
          '   Special method names.\n'
          '\n'
          '   Special attributes: "__dict__" is the attribute dictionary;\n'
          '   "__class__" is the instance\'s class.\n'
          '\n'
          'Files\n'
          '   A file object represents an open file.  File objects are created '
          'by\n'
          '   the "open()" built-in function, and also by "os.popen()",\n'
          '   "os.fdopen()", and the "makefile()" method of socket objects '
          '(and\n'
          '   perhaps by other functions or methods provided by extension\n'
          '   modules).  The objects "sys.stdin", "sys.stdout" and '
          '"sys.stderr"\n'
          '   are initialized to file objects corresponding to the '
          "interpreter's\n"
          '   standard input, output and error streams.  See File Objects for\n'
          '   complete documentation of file objects.\n'
          '\n'
          'Internal types\n'
          '   A few types used internally by the interpreter are exposed to '
          'the\n'
          '   user. Their definitions may change with future versions of the\n'
          '   interpreter, but they are mentioned here for completeness.\n'
          '\n'
          '   Code objects\n'
          '      Code objects represent *byte-compiled* executable Python '
          'code,\n'
          '      or *bytecode*. The difference between a code object and a\n'
          '      function object is that the function object contains an '
          'explicit\n'
          "      reference to the function's globals (the module in which it "
          'was\n'
          '      defined), while a code object contains no context; also the\n'
          '      default argument values are stored in the function object, '
          'not\n'
          '      in the code object (because they represent values calculated '
          'at\n'
          '      run-time).  Unlike function objects, code objects are '
          'immutable\n'
          '      and contain no references (directly or indirectly) to '
          'mutable\n'
          '      objects.\n'
          '\n'
          '      Special read-only attributes: "co_name" gives the function '
          'name;\n'
          '      "co_argcount" is the number of positional arguments '
          '(including\n'
          '      arguments with default values); "co_nlocals" is the number '
          'of\n'
          '      local variables used by the function (including arguments);\n'
          '      "co_varnames" is a tuple containing the names of the local\n'
          '      variables (starting with the argument names); "co_cellvars" '
          'is a\n'
          '      tuple containing the names of local variables that are\n'
          '      referenced by nested functions; "co_freevars" is a tuple\n'
          '      containing the names of free variables; "co_code" is a '
          'string\n'
          '      representing the sequence of bytecode instructions; '
          '"co_consts"\n'
          '      is a tuple containing the literals used by the bytecode;\n'
          '      "co_names" is a tuple containing the names used by the '
          'bytecode;\n'
          '      "co_filename" is the filename from which the code was '
          'compiled;\n'
          '      "co_firstlineno" is the first line number of the function;\n'
          '      "co_lnotab" is a string encoding the mapping from bytecode\n'
          '      offsets to line numbers (for details see the source code of '
          'the\n'
          '      interpreter); "co_stacksize" is the required stack size\n'
          '      (including local variables); "co_flags" is an integer '
          'encoding a\n'
          '      number of flags for the interpreter.\n'
          '\n'
          '      The following flag bits are defined for "co_flags": bit '
          '"0x04"\n'
          '      is set if the function uses the "*arguments" syntax to accept '
          'an\n'
          '      arbitrary number of positional arguments; bit "0x08" is set '
          'if\n'
          '      the function uses the "**keywords" syntax to accept '
          'arbitrary\n'
          '      keyword arguments; bit "0x20" is set if the function is a\n'
          '      generator.\n'
          '\n'
          '      Future feature declarations ("from __future__ import '
          'division")\n'
          '      also use bits in "co_flags" to indicate whether a code '
          'object\n'
          '      was compiled with a particular feature enabled: bit "0x2000" '
          'is\n'
          '      set if the function was compiled with future division '
          'enabled;\n'
          '      bits "0x10" and "0x1000" were used in earlier versions of\n'
          '      Python.\n'
          '\n'
          '      Other bits in "co_flags" are reserved for internal use.\n'
          '\n'
          '      If a code object represents a function, the first item in\n'
          '      "co_consts" is the documentation string of the function, or\n'
          '      "None" if undefined.\n'
          '\n'
          '   Frame objects\n'
          '      Frame objects represent execution frames.  They may occur in\n'
          '      traceback objects (see below).\n'
          '\n'
          '      Special read-only attributes: "f_back" is to the previous '
          'stack\n'
          '      frame (towards the caller), or "None" if this is the bottom\n'
          '      stack frame; "f_code" is the code object being executed in '
          'this\n'
          '      frame; "f_locals" is the dictionary used to look up local\n'
          '      variables; "f_globals" is used for global variables;\n'
          '      "f_builtins" is used for built-in (intrinsic) names;\n'
          '      "f_restricted" is a flag indicating whether the function is\n'
          '      executing in restricted execution mode; "f_lasti" gives the\n'
          '      precise instruction (this is an index into the bytecode '
          'string\n'
          '      of the code object).\n'
          '\n'
          '      Special writable attributes: "f_trace", if not "None", is a\n'
          '      function called at the start of each source code line (this '
          'is\n'
          '      used by the debugger); "f_exc_type", "f_exc_value",\n'
          '      "f_exc_traceback" represent the last exception raised in the\n'
          '      parent frame provided another exception was ever raised in '
          'the\n'
          '      current frame (in all other cases they are None); "f_lineno" '
          'is\n'
          '      the current line number of the frame --- writing to this '
          'from\n'
          '      within a trace function jumps to the given line (only for '
          'the\n'
          '      bottom-most frame).  A debugger can implement a Jump command\n'
          '      (aka Set Next Statement) by writing to f_lineno.\n'
          '\n'
          '   Traceback objects\n'
          '      Traceback objects represent a stack trace of an exception.  '
          'A\n'
          '      traceback object is created when an exception occurs.  When '
          'the\n'
          '      search for an exception handler unwinds the execution stack, '
          'at\n'
          '      each unwound level a traceback object is inserted in front '
          'of\n'
          '      the current traceback.  When an exception handler is '
          'entered,\n'
          '      the stack trace is made available to the program. (See '
          'section\n'
          '      The try statement.) It is accessible as "sys.exc_traceback", '
          'and\n'
          '      also as the third item of the tuple returned by\n'
          '      "sys.exc_info()".  The latter is the preferred interface, '
          'since\n'
          '      it works correctly when the program is using multiple '
          'threads.\n'
          '      When the program contains no suitable handler, the stack '
          'trace\n'
          '      is written (nicely formatted) to the standard error stream; '
          'if\n'
          '      the interpreter is interactive, it is also made available to '
          'the\n'
          '      user as "sys.last_traceback".\n'
          '\n'
          '      Special read-only attributes: "tb_next" is the next level in '
          'the\n'
          '      stack trace (towards the frame where the exception occurred), '
          'or\n'
          '      "None" if there is no next level; "tb_frame" points to the\n'
          '      execution frame of the current level; "tb_lineno" gives the '
          'line\n'
          '      number where the exception occurred; "tb_lasti" indicates '
          'the\n'
          '      precise instruction.  The line number and last instruction '
          'in\n'
          '      the traceback may differ from the line number of its frame\n'
          '      object if the exception occurred in a "try" statement with '
          'no\n'
          '      matching except clause or with a finally clause.\n'
          '\n'
          '   Slice objects\n'
          '      Slice objects are used to represent slices when *extended '
          'slice\n'
          '      syntax* is used. This is a slice using two colons, or '
          'multiple\n'
          '      slices or ellipses separated by commas, e.g., "a[i:j:step]",\n'
          '      "a[i:j, k:l]", or "a[..., i:j]".  They are also created by '
          'the\n'
          '      built-in "slice()" function.\n'
          '\n'
          '      Special read-only attributes: "start" is the lower bound; '
          '"stop"\n'
          '      is the upper bound; "step" is the step value; each is "None" '
          'if\n'
          '      omitted.  These attributes can have any type.\n'
          '\n'
          '      Slice objects support one method:\n'
          '\n'
          '      slice.indices(self, length)\n'
          '\n'
          '         This method takes a single integer argument *length* and\n'
          '         computes information about the extended slice that the '
          'slice\n'
          '         object would describe if applied to a sequence of '
          '*length*\n'
          '         items.  It returns a tuple of three integers; '
          'respectively\n'
          '         these are the *start* and *stop* indices and the *step* '
          'or\n'
          '         stride length of the slice. Missing or out-of-bounds '
          'indices\n'
          '         are handled in a manner consistent with regular slices.\n'
          '\n'
          '         New in version 2.3.\n'
          '\n'
          '   Static method objects\n'
          '      Static method objects provide a way of defeating the\n'
          '      transformation of function objects to method objects '
          'described\n'
          '      above. A static method object is a wrapper around any other\n'
          '      object, usually a user-defined method object. When a static\n'
          '      method object is retrieved from a class or a class instance, '
          'the\n'
          '      object actually returned is the wrapped object, which is not\n'
          '      subject to any further transformation. Static method objects '
          'are\n'
          '      not themselves callable, although the objects they wrap '
          'usually\n'
          '      are. Static method objects are created by the built-in\n'
          '      "staticmethod()" constructor.\n'
          '\n'
          '   Class method objects\n'
          '      A class method object, like a static method object, is a '
          'wrapper\n'
          '      around another object that alters the way in which that '
          'object\n'
          '      is retrieved from classes and class instances. The behaviour '
          'of\n'
          '      class method objects upon such retrieval is described above,\n'
          '      under "User-defined methods". Class method objects are '
          'created\n'
          '      by the built-in "classmethod()" constructor.\n',
 'typesfunctions': '\n'
                   'Functions\n'
                   '*********\n'
                   '\n'
                   'Function objects are created by function definitions.  The '
                   'only\n'
                   'operation on a function object is to call it: '
                   '"func(argument-list)".\n'
                   '\n'
                   'There are really two flavors of function objects: built-in '
                   'functions\n'
                   'and user-defined functions.  Both support the same '
                   'operation (to call\n'
                   'the function), but the implementation is different, hence '
                   'the\n'
                   'different object types.\n'
                   '\n'
                   'See Function definitions for more information.\n',
 'typesmapping': '\n'
                 'Mapping Types --- "dict"\n'
                 '************************\n'
                 '\n'
                 'A *mapping* object maps *hashable* values to arbitrary '
                 'objects.\n'
                 'Mappings are mutable objects.  There is currently only one '
                 'standard\n'
                 'mapping type, the *dictionary*.  (For other containers see '
                 'the built\n'
                 'in "list", "set", and "tuple" classes, and the "collections" '
                 'module.)\n'
                 '\n'
                 "A dictionary's keys are *almost* arbitrary values.  Values "
                 'that are\n'
                 'not *hashable*, that is, values containing lists, '
                 'dictionaries or\n'
                 'other mutable types (that are compared by value rather than '
                 'by object\n'
                 'identity) may not be used as keys.  Numeric types used for '
                 'keys obey\n'
                 'the normal rules for numeric comparison: if two numbers '
                 'compare equal\n'
                 '(such as "1" and "1.0") then they can be used '
                 'interchangeably to index\n'
                 'the same dictionary entry.  (Note however, that since '
                 'computers store\n'
                 'floating-point numbers as approximations it is usually '
                 'unwise to use\n'
                 'them as dictionary keys.)\n'
                 '\n'
                 'Dictionaries can be created by placing a comma-separated '
                 'list of "key:\n'
                 'value" pairs within braces, for example: "{\'jack\': 4098, '
                 "'sjoerd':\n"
                 '4127}" or "{4098: \'jack\', 4127: \'sjoerd\'}", or by the '
                 '"dict"\n'
                 'constructor.\n'
                 '\n'
                 'class dict(**kwarg)\n'
                 'class dict(mapping, **kwarg)\n'
                 'class dict(iterable, **kwarg)\n'
                 '\n'
                 '   Return a new dictionary initialized from an optional '
                 'positional\n'
                 '   argument and a possibly empty set of keyword arguments.\n'
                 '\n'
                 '   If no positional argument is given, an empty dictionary '
                 'is created.\n'
                 '   If a positional argument is given and it is a mapping '
                 'object, a\n'
                 '   dictionary is created with the same key-value pairs as '
                 'the mapping\n'
                 '   object.  Otherwise, the positional argument must be an '
                 '*iterable*\n'
                 '   object.  Each item in the iterable must itself be an '
                 'iterable with\n'
                 '   exactly two objects.  The first object of each item '
                 'becomes a key\n'
                 '   in the new dictionary, and the second object the '
                 'corresponding\n'
                 '   value.  If a key occurs more than once, the last value '
                 'for that key\n'
                 '   becomes the corresponding value in the new dictionary.\n'
                 '\n'
                 '   If keyword arguments are given, the keyword arguments and '
                 'their\n'
                 '   values are added to the dictionary created from the '
                 'positional\n'
                 '   argument.  If a key being added is already present, the '
                 'value from\n'
                 '   the keyword argument replaces the value from the '
                 'positional\n'
                 '   argument.\n'
                 '\n'
                 '   To illustrate, the following examples all return a '
                 'dictionary equal\n'
                 '   to "{"one": 1, "two": 2, "three": 3}":\n'
                 '\n'
                 '      >>> a = dict(one=1, two=2, three=3)\n'
                 "      >>> b = {'one': 1, 'two': 2, 'three': 3}\n"
                 "      >>> c = dict(zip(['one', 'two', 'three'], [1, 2, 3]))\n"
                 "      >>> d = dict([('two', 2), ('one', 1), ('three', 3)])\n"
                 "      >>> e = dict({'three': 3, 'one': 1, 'two': 2})\n"
                 '      >>> a == b == c == d == e\n'
                 '      True\n'
                 '\n'
                 '   Providing keyword arguments as in the first example only '
                 'works for\n'
                 '   keys that are valid Python identifiers.  Otherwise, any '
                 'valid keys\n'
                 '   can be used.\n'
                 '\n'
                 '   New in version 2.2.\n'
                 '\n'
                 '   Changed in version 2.3: Support for building a dictionary '
                 'from\n'
                 '   keyword arguments added.\n'
                 '\n'
                 '   These are the operations that dictionaries support (and '
                 'therefore,\n'
                 '   custom mapping types should support too):\n'
                 '\n'
                 '   len(d)\n'
                 '\n'
                 '      Return the number of items in the dictionary *d*.\n'
                 '\n'
                 '   d[key]\n'
                 '\n'
                 '      Return the item of *d* with key *key*.  Raises a '
                 '"KeyError" if\n'
                 '      *key* is not in the map.\n'
                 '\n'
                 '      If a subclass of dict defines a method "__missing__()" '
                 'and *key*\n'
                 '      is not present, the "d[key]" operation calls that '
                 'method with\n'
                 '      the key *key* as argument.  The "d[key]" operation '
                 'then returns\n'
                 '      or raises whatever is returned or raised by the\n'
                 '      "__missing__(key)" call. No other operations or '
                 'methods invoke\n'
                 '      "__missing__()". If "__missing__()" is not defined, '
                 '"KeyError"\n'
                 '      is raised. "__missing__()" must be a method; it cannot '
                 'be an\n'
                 '      instance variable:\n'
                 '\n'
                 '         >>> class Counter(dict):\n'
                 '         ...     def __missing__(self, key):\n'
                 '         ...         return 0\n'
                 '         >>> c = Counter()\n'
                 "         >>> c['red']\n"
                 '         0\n'
                 "         >>> c['red'] += 1\n"
                 "         >>> c['red']\n"
                 '         1\n'
                 '\n'
                 '      The example above shows part of the implementation of\n'
                 '      "collections.Counter".  A different "__missing__" '
                 'method is used\n'
                 '      by "collections.defaultdict".\n'
                 '\n'
                 '      New in version 2.5: Recognition of __missing__ methods '
                 'of dict\n'
                 '      subclasses.\n'
                 '\n'
                 '   d[key] = value\n'
                 '\n'
                 '      Set "d[key]" to *value*.\n'
                 '\n'
                 '   del d[key]\n'
                 '\n'
                 '      Remove "d[key]" from *d*.  Raises a "KeyError" if '
                 '*key* is not\n'
                 '      in the map.\n'
                 '\n'
                 '   key in d\n'
                 '\n'
                 '      Return "True" if *d* has a key *key*, else "False".\n'
                 '\n'
                 '      New in version 2.2.\n'
                 '\n'
                 '   key not in d\n'
                 '\n'
                 '      Equivalent to "not key in d".\n'
                 '\n'
                 '      New in version 2.2.\n'
                 '\n'
                 '   iter(d)\n'
                 '\n'
                 '      Return an iterator over the keys of the dictionary.  '
                 'This is a\n'
                 '      shortcut for "iterkeys()".\n'
                 '\n'
                 '   clear()\n'
                 '\n'
                 '      Remove all items from the dictionary.\n'
                 '\n'
                 '   copy()\n'
                 '\n'
                 '      Return a shallow copy of the dictionary.\n'
                 '\n'
                 '   fromkeys(seq[, value])\n'
                 '\n'
                 '      Create a new dictionary with keys from *seq* and '
                 'values set to\n'
                 '      *value*.\n'
                 '\n'
                 '      "fromkeys()" is a class method that returns a new '
                 'dictionary.\n'
                 '      *value* defaults to "None".\n'
                 '\n'
                 '      New in version 2.3.\n'
                 '\n'
                 '   get(key[, default])\n'
                 '\n'
                 '      Return the value for *key* if *key* is in the '
                 'dictionary, else\n'
                 '      *default*. If *default* is not given, it defaults to '
                 '"None", so\n'
                 '      that this method never raises a "KeyError".\n'
                 '\n'
                 '   has_key(key)\n'
                 '\n'
                 '      Test for the presence of *key* in the dictionary.  '
                 '"has_key()"\n'
                 '      is deprecated in favor of "key in d".\n'
                 '\n'
                 '   items()\n'
                 '\n'
                 '      Return a copy of the dictionary\'s list of "(key, '
                 'value)" pairs.\n'
                 '\n'
                 '      **CPython implementation detail:** Keys and values are '
                 'listed in\n'
                 '      an arbitrary order which is non-random, varies across '
                 'Python\n'
                 "      implementations, and depends on the dictionary's "
                 'history of\n'
                 '      insertions and deletions.\n'
                 '\n'
                 '      If "items()", "keys()", "values()", "iteritems()", '
                 '"iterkeys()",\n'
                 '      and "itervalues()" are called with no intervening '
                 'modifications\n'
                 '      to the dictionary, the lists will directly '
                 'correspond.  This\n'
                 '      allows the creation of "(value, key)" pairs using '
                 '"zip()":\n'
                 '      "pairs = zip(d.values(), d.keys())".  The same '
                 'relationship\n'
                 '      holds for the "iterkeys()" and "itervalues()" methods: '
                 '"pairs =\n'
                 '      zip(d.itervalues(), d.iterkeys())" provides the same '
                 'value for\n'
                 '      "pairs". Another way to create the same list is "pairs '
                 '= [(v, k)\n'
                 '      for (k, v) in d.iteritems()]".\n'
                 '\n'
                 '   iteritems()\n'
                 '\n'
                 '      Return an iterator over the dictionary\'s "(key, '
                 'value)" pairs.\n'
                 '      See the note for "dict.items()".\n'
                 '\n'
                 '      Using "iteritems()" while adding or deleting entries '
                 'in the\n'
                 '      dictionary may raise a "RuntimeError" or fail to '
                 'iterate over\n'
                 '      all entries.\n'
                 '\n'
                 '      New in version 2.2.\n'
                 '\n'
                 '   iterkeys()\n'
                 '\n'
                 "      Return an iterator over the dictionary's keys.  See "
                 'the note for\n'
                 '      "dict.items()".\n'
                 '\n'
                 '      Using "iterkeys()" while adding or deleting entries in '
                 'the\n'
                 '      dictionary may raise a "RuntimeError" or fail to '
                 'iterate over\n'
                 '      all entries.\n'
                 '\n'
                 '      New in version 2.2.\n'
                 '\n'
                 '   itervalues()\n'
                 '\n'
                 "      Return an iterator over the dictionary's values.  See "
                 'the note\n'
                 '      for "dict.items()".\n'
                 '\n'
                 '      Using "itervalues()" while adding or deleting entries '
                 'in the\n'
                 '      dictionary may raise a "RuntimeError" or fail to '
                 'iterate over\n'
                 '      all entries.\n'
                 '\n'
                 '      New in version 2.2.\n'
                 '\n'
                 '   keys()\n'
                 '\n'
                 "      Return a copy of the dictionary's list of keys.  See "
                 'the note\n'
                 '      for "dict.items()".\n'
                 '\n'
                 '   pop(key[, default])\n'
                 '\n'
                 '      If *key* is in the dictionary, remove it and return '
                 'its value,\n'
                 '      else return *default*.  If *default* is not given and '
                 '*key* is\n'
                 '      not in the dictionary, a "KeyError" is raised.\n'
                 '\n'
                 '      New in version 2.3.\n'
                 '\n'
                 '   popitem()\n'
                 '\n'
                 '      Remove and return an arbitrary "(key, value)" pair '
                 'from the\n'
                 '      dictionary.\n'
                 '\n'
                 '      "popitem()" is useful to destructively iterate over a\n'
                 '      dictionary, as often used in set algorithms.  If the '
                 'dictionary\n'
                 '      is empty, calling "popitem()" raises a "KeyError".\n'
                 '\n'
                 '   setdefault(key[, default])\n'
                 '\n'
                 '      If *key* is in the dictionary, return its value.  If '
                 'not, insert\n'
                 '      *key* with a value of *default* and return *default*.  '
                 '*default*\n'
                 '      defaults to "None".\n'
                 '\n'
                 '   update([other])\n'
                 '\n'
                 '      Update the dictionary with the key/value pairs from '
                 '*other*,\n'
                 '      overwriting existing keys.  Return "None".\n'
                 '\n'
                 '      "update()" accepts either another dictionary object or '
                 'an\n'
                 '      iterable of key/value pairs (as tuples or other '
                 'iterables of\n'
                 '      length two).  If keyword arguments are specified, the '
                 'dictionary\n'
                 '      is then updated with those key/value pairs: '
                 '"d.update(red=1,\n'
                 '      blue=2)".\n'
                 '\n'
                 '      Changed in version 2.4: Allowed the argument to be an '
                 'iterable\n'
                 '      of key/value pairs and allowed keyword arguments.\n'
                 '\n'
                 '   values()\n'
                 '\n'
                 "      Return a copy of the dictionary's list of values.  See "
                 'the note\n'
                 '      for "dict.items()".\n'
                 '\n'
                 '   viewitems()\n'
                 '\n'
                 '      Return a new view of the dictionary\'s items ("(key, '
                 'value)"\n'
                 '      pairs).  See below for documentation of view objects.\n'
                 '\n'
                 '      New in version 2.7.\n'
                 '\n'
                 '   viewkeys()\n'
                 '\n'
                 "      Return a new view of the dictionary's keys.  See below "
                 'for\n'
                 '      documentation of view objects.\n'
                 '\n'
                 '      New in version 2.7.\n'
                 '\n'
                 '   viewvalues()\n'
                 '\n'
                 "      Return a new view of the dictionary's values.  See "
                 'below for\n'
                 '      documentation of view objects.\n'
                 '\n'
                 '      New in version 2.7.\n'
                 '\n'
                 '   Dictionaries compare equal if and only if they have the '
                 'same "(key,\n'
                 '   value)" pairs.\n'
                 '\n'
                 '\n'
                 'Dictionary view objects\n'
                 '=======================\n'
                 '\n'
                 'The objects returned by "dict.viewkeys()", '
                 '"dict.viewvalues()" and\n'
                 '"dict.viewitems()" are *view objects*.  They provide a '
                 'dynamic view on\n'
                 "the dictionary's entries, which means that when the "
                 'dictionary\n'
                 'changes, the view reflects these changes.\n'
                 '\n'
                 'Dictionary views can be iterated over to yield their '
                 'respective data,\n'
                 'and support membership tests:\n'
                 '\n'
                 'len(dictview)\n'
                 '\n'
                 '   Return the number of entries in the dictionary.\n'
                 '\n'
                 'iter(dictview)\n'
                 '\n'
                 '   Return an iterator over the keys, values or items '
                 '(represented as\n'
                 '   tuples of "(key, value)") in the dictionary.\n'
                 '\n'
                 '   Keys and values are iterated over in an arbitrary order '
                 'which is\n'
                 '   non-random, varies across Python implementations, and '
                 'depends on\n'
                 "   the dictionary's history of insertions and deletions. If "
                 'keys,\n'
                 '   values and items views are iterated over with no '
                 'intervening\n'
                 '   modifications to the dictionary, the order of items will '
                 'directly\n'
                 '   correspond.  This allows the creation of "(value, key)" '
                 'pairs using\n'
                 '   "zip()": "pairs = zip(d.values(), d.keys())".  Another '
                 'way to\n'
                 '   create the same list is "pairs = [(v, k) for (k, v) in '
                 'd.items()]".\n'
                 '\n'
                 '   Iterating views while adding or deleting entries in the '
                 'dictionary\n'
                 '   may raise a "RuntimeError" or fail to iterate over all '
                 'entries.\n'
                 '\n'
                 'x in dictview\n'
                 '\n'
                 '   Return "True" if *x* is in the underlying dictionary\'s '
                 'keys, values\n'
                 '   or items (in the latter case, *x* should be a "(key, '
                 'value)"\n'
                 '   tuple).\n'
                 '\n'
                 'Keys views are set-like since their entries are unique and '
                 'hashable.\n'
                 'If all values are hashable, so that (key, value) pairs are '
                 'unique and\n'
                 'hashable, then the items view is also set-like.  (Values '
                 'views are not\n'
                 'treated as set-like since the entries are generally not '
                 'unique.)  Then\n'
                 'these set operations are available ("other" refers either to '
                 'another\n'
                 'view or a set):\n'
                 '\n'
                 'dictview & other\n'
                 '\n'
                 '   Return the intersection of the dictview and the other '
                 'object as a\n'
                 '   new set.\n'
                 '\n'
                 'dictview | other\n'
                 '\n'
                 '   Return the union of the dictview and the other object as '
                 'a new set.\n'
                 '\n'
                 'dictview - other\n'
                 '\n'
                 '   Return the difference between the dictview and the other '
                 'object\n'
                 "   (all elements in *dictview* that aren't in *other*) as a "
                 'new set.\n'
                 '\n'
                 'dictview ^ other\n'
                 '\n'
                 '   Return the symmetric difference (all elements either in '
                 '*dictview*\n'
                 '   or *other*, but not in both) of the dictview and the '
                 'other object\n'
                 '   as a new set.\n'
                 '\n'
                 'An example of dictionary view usage:\n'
                 '\n'
                 "   >>> dishes = {'eggs': 2, 'sausage': 1, 'bacon': 1, "
                 "'spam': 500}\n"
                 '   >>> keys = dishes.viewkeys()\n'
                 '   >>> values = dishes.viewvalues()\n'
                 '\n'
                 '   >>> # iteration\n'
                 '   >>> n = 0\n'
                 '   >>> for val in values:\n'
                 '   ...     n += val\n'
                 '   >>> print(n)\n'
                 '   504\n'
                 '\n'
                 '   >>> # keys and values are iterated over in the same '
                 'order\n'
                 '   >>> list(keys)\n'
                 "   ['eggs', 'bacon', 'sausage', 'spam']\n"
                 '   >>> list(values)\n'
                 '   [2, 1, 1, 500]\n'
                 '\n'
                 '   >>> # view objects are dynamic and reflect dict changes\n'
                 "   >>> del dishes['eggs']\n"
                 "   >>> del dishes['sausage']\n"
                 '   >>> list(keys)\n'
                 "   ['spam', 'bacon']\n"
                 '\n'
                 '   >>> # set operations\n'
                 "   >>> keys & {'eggs', 'bacon', 'salad'}\n"
                 "   {'bacon'}\n",
 'typesmethods': '\n'
                 'Methods\n'
                 '*******\n'
                 '\n'
                 'Methods are functions that are called using the attribute '
                 'notation.\n'
                 'There are two flavors: built-in methods (such as "append()" '
                 'on lists)\n'
                 'and class instance methods.  Built-in methods are described '
                 'with the\n'
                 'types that support them.\n'
                 '\n'
                 'The implementation adds two special read-only attributes to '
                 'class\n'
                 'instance methods: "m.im_self" is the object on which the '
                 'method\n'
                 'operates, and "m.im_func" is the function implementing the '
                 'method.\n'
                 'Calling "m(arg-1, arg-2, ..., arg-n)" is completely '
                 'equivalent to\n'
                 'calling "m.im_func(m.im_self, arg-1, arg-2, ..., arg-n)".\n'
                 '\n'
                 'Class instance methods are either *bound* or *unbound*, '
                 'referring to\n'
                 'whether the method was accessed through an instance or a '
                 'class,\n'
                 'respectively.  When a method is unbound, its "im_self" '
                 'attribute will\n'
                 'be "None" and if called, an explicit "self" object must be '
                 'passed as\n'
                 'the first argument.  In this case, "self" must be an '
                 'instance of the\n'
                 "unbound method's class (or a subclass of that class), "
                 'otherwise a\n'
                 '"TypeError" is raised.\n'
                 '\n'
                 'Like function objects, methods objects support getting '
                 'arbitrary\n'
                 'attributes. However, since method attributes are actually '
                 'stored on\n'
                 'the underlying function object ("meth.im_func"), setting '
                 'method\n'
                 'attributes on either bound or unbound methods is '
                 'disallowed.\n'
                 'Attempting to set an attribute on a method results in an\n'
                 '"AttributeError" being raised.  In order to set a method '
                 'attribute,\n'
                 'you need to explicitly set it on the underlying function '
                 'object:\n'
                 '\n'
                 '   >>> class C:\n'
                 '   ...     def method(self):\n'
                 '   ...         pass\n'
                 '   ...\n'
                 '   >>> c = C()\n'
                 "   >>> c.method.whoami = 'my name is method'  # can't set on "
                 'the method\n'
                 '   Traceback (most recent call last):\n'
                 '     File "<stdin>", line 1, in <module>\n'
                 "   AttributeError: 'instancemethod' object has no attribute "
                 "'whoami'\n"
                 "   >>> c.method.im_func.whoami = 'my name is method'\n"
                 '   >>> c.method.whoami\n'
                 "   'my name is method'\n"
                 '\n'
                 'See The standard type hierarchy for more information.\n',
 'typesmodules': '\n'
                 'Modules\n'
                 '*******\n'
                 '\n'
                 'The only special operation on a module is attribute access: '
                 '"m.name",\n'
                 'where *m* is a module and *name* accesses a name defined in '
                 "*m*'s\n"
                 'symbol table. Module attributes can be assigned to.  (Note '
                 'that the\n'
                 '"import" statement is not, strictly speaking, an operation '
                 'on a module\n'
                 'object; "import foo" does not require a module object named '
                 '*foo* to\n'
                 'exist, rather it requires an (external) *definition* for a '
                 'module\n'
                 'named *foo* somewhere.)\n'
                 '\n'
                 'A special attribute of every module is "__dict__". This is '
                 'the\n'
                 "dictionary containing the module's symbol table. Modifying "
                 'this\n'
                 "dictionary will actually change the module's symbol table, "
                 'but direct\n'
                 'assignment to the "__dict__" attribute is not possible (you '
                 'can write\n'
                 '"m.__dict__[\'a\'] = 1", which defines "m.a" to be "1", but '
                 "you can't\n"
                 'write "m.__dict__ = {}").  Modifying "__dict__" directly is '
                 'not\n'
                 'recommended.\n'
                 '\n'
                 'Modules built into the interpreter are written like this: '
                 '"<module\n'
                 '\'sys\' (built-in)>".  If loaded from a file, they are '
                 'written as\n'
                 '"<module \'os\' from '
                 '\'/usr/local/lib/pythonX.Y/os.pyc\'>".\n',
 'typesseq': '\n'
             'Sequence Types --- "str", "unicode", "list", "tuple", '
             '"bytearray", "buffer", "xrange"\n'
             '*************************************************************************************\n'
             '\n'
             'There are seven sequence types: strings, Unicode strings, '
             'lists,\n'
             'tuples, bytearrays, buffers, and xrange objects.\n'
             '\n'
             'For other containers see the built in "dict" and "set" classes, '
             'and\n'
             'the "collections" module.\n'
             '\n'
             'String literals are written in single or double quotes: '
             '"\'xyzzy\'",\n'
             '""frobozz"".  See String literals for more about string '
             'literals.\n'
             'Unicode strings are much like strings, but are specified in the '
             'syntax\n'
             'using a preceding "\'u\'" character: "u\'abc\'", "u"def"". In '
             'addition to\n'
             'the functionality described here, there are also '
             'string-specific\n'
             'methods described in the String Methods section. Lists are '
             'constructed\n'
             'with square brackets, separating items with commas: "[a, b, '
             'c]".\n'
             'Tuples are constructed by the comma operator (not within square\n'
             'brackets), with or without enclosing parentheses, but an empty '
             'tuple\n'
             'must have the enclosing parentheses, such as "a, b, c" or "()".  '
             'A\n'
             'single item tuple must have a trailing comma, such as "(d,)".\n'
             '\n'
             'Bytearray objects are created with the built-in function\n'
             '"bytearray()".\n'
             '\n'
             'Buffer objects are not directly supported by Python syntax, but '
             'can be\n'
             'created by calling the built-in function "buffer()".  They '
             "don't\n"
             'support concatenation or repetition.\n'
             '\n'
             'Objects of type xrange are similar to buffers in that there is '
             'no\n'
             'specific syntax to create them, but they are created using the\n'
             '"xrange()" function.  They don\'t support slicing, concatenation '
             'or\n'
             'repetition, and using "in", "not in", "min()" or "max()" on them '
             'is\n'
             'inefficient.\n'
             '\n'
             'Most sequence types support the following operations.  The "in" '
             'and\n'
             '"not in" operations have the same priorities as the comparison\n'
             'operations.  The "+" and "*" operations have the same priority '
             'as the\n'
             'corresponding numeric operations. [3] Additional methods are '
             'provided\n'
             'for Mutable Sequence Types.\n'
             '\n'
             'This table lists the sequence operations sorted in ascending '
             'priority.\n'
             'In the table, *s* and *t* are sequences of the same type; *n*, '
             '*i* and\n'
             '*j* are integers:\n'
             '\n'
             '+--------------------+----------------------------------+------------+\n'
             '| Operation          | Result                           | '
             'Notes      |\n'
             '+====================+==================================+============+\n'
             '| "x in s"           | "True" if an item of *s* is      | '
             '(1)        |\n'
             '|                    | equal to *x*, else "False"       '
             '|            |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "x not in s"       | "False" if an item of *s* is     | '
             '(1)        |\n'
             '|                    | equal to *x*, else "True"        '
             '|            |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "s + t"            | the concatenation of *s* and *t* | '
             '(6)        |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "s * n, n * s"     | equivalent to adding *s* to      | '
             '(2)        |\n'
             '|                    | itself *n* times                 '
             '|            |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "s[i]"             | *i*th item of *s*, origin 0      | '
             '(3)        |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "s[i:j]"           | slice of *s* from *i* to *j*     | '
             '(3)(4)     |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "s[i:j:k]"         | slice of *s* from *i* to *j*     | '
             '(3)(5)     |\n'
             '|                    | with step *k*                    '
             '|            |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "len(s)"           | length of *s*                    '
             '|            |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "min(s)"           | smallest item of *s*             '
             '|            |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "max(s)"           | largest item of *s*              '
             '|            |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "s.index(x)"       | index of the first occurrence of '
             '|            |\n'
             '|                    | *x* in *s*                       '
             '|            |\n'
             '+--------------------+----------------------------------+------------+\n'
             '| "s.count(x)"       | total number of occurrences of   '
             '|            |\n'
             '|                    | *x* in *s*                       '
             '|            |\n'
             '+--------------------+----------------------------------+------------+\n'
             '\n'
             'Sequence types also support comparisons. In particular, tuples '
             'and\n'
             'lists are compared lexicographically by comparing corresponding\n'
             'elements. This means that to compare equal, every element must '
             'compare\n'
             'equal and the two sequences must be of the same type and have '
             'the same\n'
             'length. (For full details see Comparisons in the language '
             'reference.)\n'
             '\n'
             'Notes:\n'
             '\n'
             '1. When *s* is a string or Unicode string object the "in" and '
             '"not\n'
             '   in" operations act like a substring test.  In Python '
             'versions\n'
             '   before 2.3, *x* had to be a string of length 1. In Python 2.3 '
             'and\n'
             '   beyond, *x* may be a string of any length.\n'
             '\n'
             '2. Values of *n* less than "0" are treated as "0" (which yields '
             'an\n'
             '   empty sequence of the same type as *s*).  Note that items in '
             'the\n'
             '   sequence *s* are not copied; they are referenced multiple '
             'times.\n'
             '   This often haunts new Python programmers; consider:\n'
             '\n'
             '   >>> lists = [[]] * 3\n'
             '   >>> lists\n'
             '   [[], [], []]\n'
             '   >>> lists[0].append(3)\n'
             '   >>> lists\n'
             '   [[3], [3], [3]]\n'
             '\n'
             '   What has happened is that "[[]]" is a one-element list '
             'containing\n'
             '   an empty list, so all three elements of "[[]] * 3" are '
             'references\n'
             '   to this single empty list.  Modifying any of the elements of\n'
             '   "lists" modifies this single list. You can create a list of\n'
             '   different lists this way:\n'
             '\n'
             '   >>> lists = [[] for i in range(3)]\n'
             '   >>> lists[0].append(3)\n'
             '   >>> lists[1].append(5)\n'
             '   >>> lists[2].append(7)\n'
             '   >>> lists\n'
             '   [[3], [5], [7]]\n'
             '\n'
             '   Further explanation is available in the FAQ entry How do I '
             'create a\n'
             '   multidimensional list?.\n'
             '\n'
             '3. If *i* or *j* is negative, the index is relative to the end '
             'of\n'
             '   the string: "len(s) + i" or "len(s) + j" is substituted.  But '
             'note\n'
             '   that "-0" is still "0".\n'
             '\n'
             '4. The slice of *s* from *i* to *j* is defined as the sequence '
             'of\n'
             '   items with index *k* such that "i <= k < j".  If *i* or *j* '
             'is\n'
             '   greater than "len(s)", use "len(s)".  If *i* is omitted or '
             '"None",\n'
             '   use "0".  If *j* is omitted or "None", use "len(s)".  If *i* '
             'is\n'
             '   greater than or equal to *j*, the slice is empty.\n'
             '\n'
             '5. The slice of *s* from *i* to *j* with step *k* is defined as '
             'the\n'
             '   sequence of items with index  "x = i + n*k" such that "0 <= n '
             '<\n'
             '   (j-i)/k".  In other words, the indices are "i", "i+k", '
             '"i+2*k",\n'
             '   "i+3*k" and so on, stopping when *j* is reached (but never\n'
             '   including *j*).  If *i* or *j* is greater than "len(s)", use\n'
             '   "len(s)".  If *i* or *j* are omitted or "None", they become '
             '"end"\n'
             '   values (which end depends on the sign of *k*).  Note, *k* '
             'cannot be\n'
             '   zero. If *k* is "None", it is treated like "1".\n'
             '\n'
             '6. **CPython implementation detail:** If *s* and *t* are both\n'
             '   strings, some Python implementations such as CPython can '
             'usually\n'
             '   perform an in-place optimization for assignments of the form '
             '"s = s\n'
             '   + t" or "s += t".  When applicable, this optimization makes\n'
             '   quadratic run-time much less likely.  This optimization is '
             'both\n'
             '   version and implementation dependent.  For performance '
             'sensitive\n'
             '   code, it is preferable to use the "str.join()" method which '
             'assures\n'
             '   consistent linear concatenation performance across versions '
             'and\n'
             '   implementations.\n'
             '\n'
             '   Changed in version 2.4: Formerly, string concatenation never\n'
             '   occurred in-place.\n'
             '\n'
             '\n'
             'String Methods\n'
             '==============\n'
             '\n'
             'Below are listed the string methods which both 8-bit strings '
             'and\n'
             'Unicode objects support.  Some of them are also available on\n'
             '"bytearray" objects.\n'
             '\n'
             "In addition, Python's strings support the sequence type methods\n"
             'described in the Sequence Types --- str, unicode, list, tuple,\n'
             'bytearray, buffer, xrange section. To output formatted strings '
             'use\n'
             'template strings or the "%" operator described in the String\n'
             'Formatting Operations section. Also, see the "re" module for '
             'string\n'
             'functions based on regular expressions.\n'
             '\n'
             'str.capitalize()\n'
             '\n'
             '   Return a copy of the string with its first character '
             'capitalized\n'
             '   and the rest lowercased.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.center(width[, fillchar])\n'
             '\n'
             '   Return centered in a string of length *width*. Padding is '
             'done\n'
             '   using the specified *fillchar* (default is a space).\n'
             '\n'
             '   Changed in version 2.4: Support for the *fillchar* argument.\n'
             '\n'
             'str.count(sub[, start[, end]])\n'
             '\n'
             '   Return the number of non-overlapping occurrences of substring '
             '*sub*\n'
             '   in the range [*start*, *end*].  Optional arguments *start* '
             'and\n'
             '   *end* are interpreted as in slice notation.\n'
             '\n'
             'str.decode([encoding[, errors]])\n'
             '\n'
             '   Decodes the string using the codec registered for '
             '*encoding*.\n'
             '   *encoding* defaults to the default string encoding.  *errors* '
             'may\n'
             '   be given to set a different error handling scheme.  The '
             'default is\n'
             '   "\'strict\'", meaning that encoding errors raise '
             '"UnicodeError".\n'
             '   Other possible values are "\'ignore\'", "\'replace\'" and any '
             'other\n'
             '   name registered via "codecs.register_error()", see section '
             'Codec\n'
             '   Base Classes.\n'
             '\n'
             '   New in version 2.2.\n'
             '\n'
             '   Changed in version 2.3: Support for other error handling '
             'schemes\n'
             '   added.\n'
             '\n'
             '   Changed in version 2.7: Support for keyword arguments added.\n'
             '\n'
             'str.encode([encoding[, errors]])\n'
             '\n'
             '   Return an encoded version of the string.  Default encoding is '
             'the\n'
             '   current default string encoding.  *errors* may be given to '
             'set a\n'
             '   different error handling scheme.  The default for *errors* '
             'is\n'
             '   "\'strict\'", meaning that encoding errors raise a '
             '"UnicodeError".\n'
             '   Other possible values are "\'ignore\'", "\'replace\'",\n'
             '   "\'xmlcharrefreplace\'", "\'backslashreplace\'" and any other '
             'name\n'
             '   registered via "codecs.register_error()", see section Codec '
             'Base\n'
             '   Classes. For a list of possible encodings, see section '
             'Standard\n'
             '   Encodings.\n'
             '\n'
             '   New in version 2.0.\n'
             '\n'
             '   Changed in version 2.3: Support for "\'xmlcharrefreplace\'" '
             'and\n'
             '   "\'backslashreplace\'" and other error handling schemes '
             'added.\n'
             '\n'
             '   Changed in version 2.7: Support for keyword arguments added.\n'
             '\n'
             'str.endswith(suffix[, start[, end]])\n'
             '\n'
             '   Return "True" if the string ends with the specified '
             '*suffix*,\n'
             '   otherwise return "False".  *suffix* can also be a tuple of '
             'suffixes\n'
             '   to look for.  With optional *start*, test beginning at that\n'
             '   position.  With optional *end*, stop comparing at that '
             'position.\n'
             '\n'
             '   Changed in version 2.5: Accept tuples as *suffix*.\n'
             '\n'
             'str.expandtabs([tabsize])\n'
             '\n'
             '   Return a copy of the string where all tab characters are '
             'replaced\n'
             '   by one or more spaces, depending on the current column and '
             'the\n'
             '   given tab size.  Tab positions occur every *tabsize* '
             'characters\n'
             '   (default is 8, giving tab positions at columns 0, 8, 16 and '
             'so on).\n'
             '   To expand the string, the current column is set to zero and '
             'the\n'
             '   string is examined character by character.  If the character '
             'is a\n'
             '   tab ("\\t"), one or more space characters are inserted in the '
             'result\n'
             '   until the current column is equal to the next tab position. '
             '(The\n'
             '   tab character itself is not copied.)  If the character is a '
             'newline\n'
             '   ("\\n") or return ("\\r"), it is copied and the current '
             'column is\n'
             '   reset to zero.  Any other character is copied unchanged and '
             'the\n'
             '   current column is incremented by one regardless of how the\n'
             '   character is represented when printed.\n'
             '\n'
             "   >>> '01\\t012\\t0123\\t01234'.expandtabs()\n"
             "   '01      012     0123    01234'\n"
             "   >>> '01\\t012\\t0123\\t01234'.expandtabs(4)\n"
             "   '01  012 0123    01234'\n"
             '\n'
             'str.find(sub[, start[, end]])\n'
             '\n'
             '   Return the lowest index in the string where substring *sub* '
             'is\n'
             '   found within the slice "s[start:end]".  Optional arguments '
             '*start*\n'
             '   and *end* are interpreted as in slice notation.  Return "-1" '
             'if\n'
             '   *sub* is not found.\n'
             '\n'
             '   Note: The "find()" method should be used only if you need to '
             'know\n'
             '     the position of *sub*.  To check if *sub* is a substring or '
             'not,\n'
             '     use the "in" operator:\n'
             '\n'
             "        >>> 'Py' in 'Python'\n"
             '        True\n'
             '\n'
             'str.format(*args, **kwargs)\n'
             '\n'
             '   Perform a string formatting operation.  The string on which '
             'this\n'
             '   method is called can contain literal text or replacement '
             'fields\n'
             '   delimited by braces "{}".  Each replacement field contains '
             'either\n'
             '   the numeric index of a positional argument, or the name of a\n'
             '   keyword argument.  Returns a copy of the string where each\n'
             '   replacement field is replaced with the string value of the\n'
             '   corresponding argument.\n'
             '\n'
             '   >>> "The sum of 1 + 2 is {0}".format(1+2)\n'
             "   'The sum of 1 + 2 is 3'\n"
             '\n'
             '   See Format String Syntax for a description of the various\n'
             '   formatting options that can be specified in format strings.\n'
             '\n'
             '   This method of string formatting is the new standard in '
             'Python 3,\n'
             '   and should be preferred to the "%" formatting described in '
             'String\n'
             '   Formatting Operations in new code.\n'
             '\n'
             '   New in version 2.6.\n'
             '\n'
             'str.index(sub[, start[, end]])\n'
             '\n'
             '   Like "find()", but raise "ValueError" when the substring is '
             'not\n'
             '   found.\n'
             '\n'
             'str.isalnum()\n'
             '\n'
             '   Return true if all characters in the string are alphanumeric '
             'and\n'
             '   there is at least one character, false otherwise.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.isalpha()\n'
             '\n'
             '   Return true if all characters in the string are alphabetic '
             'and\n'
             '   there is at least one character, false otherwise.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.isdigit()\n'
             '\n'
             '   Return true if all characters in the string are digits and '
             'there is\n'
             '   at least one character, false otherwise.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.islower()\n'
             '\n'
             '   Return true if all cased characters [4] in the string are '
             'lowercase\n'
             '   and there is at least one cased character, false otherwise.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.isspace()\n'
             '\n'
             '   Return true if there are only whitespace characters in the '
             'string\n'
             '   and there is at least one character, false otherwise.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.istitle()\n'
             '\n'
             '   Return true if the string is a titlecased string and there is '
             'at\n'
             '   least one character, for example uppercase characters may '
             'only\n'
             '   follow uncased characters and lowercase characters only cased '
             'ones.\n'
             '   Return false otherwise.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.isupper()\n'
             '\n'
             '   Return true if all cased characters [4] in the string are '
             'uppercase\n'
             '   and there is at least one cased character, false otherwise.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.join(iterable)\n'
             '\n'
             '   Return a string which is the concatenation of the strings in '
             'the\n'
             '   *iterable* *iterable*.  The separator between elements is '
             'the\n'
             '   string providing this method.\n'
             '\n'
             'str.ljust(width[, fillchar])\n'
             '\n'
             '   Return the string left justified in a string of length '
             '*width*.\n'
             '   Padding is done using the specified *fillchar* (default is a\n'
             '   space).  The original string is returned if *width* is less '
             'than or\n'
             '   equal to "len(s)".\n'
             '\n'
             '   Changed in version 2.4: Support for the *fillchar* argument.\n'
             '\n'
             'str.lower()\n'
             '\n'
             '   Return a copy of the string with all the cased characters '
             '[4]\n'
             '   converted to lowercase.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.lstrip([chars])\n'
             '\n'
             '   Return a copy of the string with leading characters removed.  '
             'The\n'
             '   *chars* argument is a string specifying the set of characters '
             'to be\n'
             '   removed.  If omitted or "None", the *chars* argument defaults '
             'to\n'
             '   removing whitespace.  The *chars* argument is not a prefix; '
             'rather,\n'
             '   all combinations of its values are stripped:\n'
             '\n'
             "   >>> '   spacious   '.lstrip()\n"
             "   'spacious   '\n"
             "   >>> 'www.example.com'.lstrip('cmowz.')\n"
             "   'example.com'\n"
             '\n'
             '   Changed in version 2.2.2: Support for the *chars* argument.\n'
             '\n'
             'str.partition(sep)\n'
             '\n'
             '   Split the string at the first occurrence of *sep*, and return '
             'a\n'
             '   3-tuple containing the part before the separator, the '
             'separator\n'
             '   itself, and the part after the separator.  If the separator '
             'is not\n'
             '   found, return a 3-tuple containing the string itself, '
             'followed by\n'
             '   two empty strings.\n'
             '\n'
             '   New in version 2.5.\n'
             '\n'
             'str.replace(old, new[, count])\n'
             '\n'
             '   Return a copy of the string with all occurrences of substring '
             '*old*\n'
             '   replaced by *new*.  If the optional argument *count* is '
             'given, only\n'
             '   the first *count* occurrences are replaced.\n'
             '\n'
             'str.rfind(sub[, start[, end]])\n'
             '\n'
             '   Return the highest index in the string where substring *sub* '
             'is\n'
             '   found, such that *sub* is contained within "s[start:end]".\n'
             '   Optional arguments *start* and *end* are interpreted as in '
             'slice\n'
             '   notation.  Return "-1" on failure.\n'
             '\n'
             'str.rindex(sub[, start[, end]])\n'
             '\n'
             '   Like "rfind()" but raises "ValueError" when the substring '
             '*sub* is\n'
             '   not found.\n'
             '\n'
             'str.rjust(width[, fillchar])\n'
             '\n'
             '   Return the string right justified in a string of length '
             '*width*.\n'
             '   Padding is done using the specified *fillchar* (default is a\n'
             '   space). The original string is returned if *width* is less '
             'than or\n'
             '   equal to "len(s)".\n'
             '\n'
             '   Changed in version 2.4: Support for the *fillchar* argument.\n'
             '\n'
             'str.rpartition(sep)\n'
             '\n'
             '   Split the string at the last occurrence of *sep*, and return '
             'a\n'
             '   3-tuple containing the part before the separator, the '
             'separator\n'
             '   itself, and the part after the separator.  If the separator '
             'is not\n'
             '   found, return a 3-tuple containing two empty strings, '
             'followed by\n'
             '   the string itself.\n'
             '\n'
             '   New in version 2.5.\n'
             '\n'
             'str.rsplit([sep[, maxsplit]])\n'
             '\n'
             '   Return a list of the words in the string, using *sep* as the\n'
             '   delimiter string. If *maxsplit* is given, at most *maxsplit* '
             'splits\n'
             '   are done, the *rightmost* ones.  If *sep* is not specified '
             'or\n'
             '   "None", any whitespace string is a separator.  Except for '
             'splitting\n'
             '   from the right, "rsplit()" behaves like "split()" which is\n'
             '   described in detail below.\n'
             '\n'
             '   New in version 2.4.\n'
             '\n'
             'str.rstrip([chars])\n'
             '\n'
             '   Return a copy of the string with trailing characters '
             'removed.  The\n'
             '   *chars* argument is a string specifying the set of characters '
             'to be\n'
             '   removed.  If omitted or "None", the *chars* argument defaults '
             'to\n'
             '   removing whitespace.  The *chars* argument is not a suffix; '
             'rather,\n'
             '   all combinations of its values are stripped:\n'
             '\n'
             "   >>> '   spacious   '.rstrip()\n"
             "   '   spacious'\n"
             "   >>> 'mississippi'.rstrip('ipz')\n"
             "   'mississ'\n"
             '\n'
             '   Changed in version 2.2.2: Support for the *chars* argument.\n'
             '\n'
             'str.split([sep[, maxsplit]])\n'
             '\n'
             '   Return a list of the words in the string, using *sep* as the\n'
             '   delimiter string.  If *maxsplit* is given, at most '
             '*maxsplit*\n'
             '   splits are done (thus, the list will have at most '
             '"maxsplit+1"\n'
             '   elements).  If *maxsplit* is not specified or "-1", then '
             'there is\n'
             '   no limit on the number of splits (all possible splits are '
             'made).\n'
             '\n'
             '   If *sep* is given, consecutive delimiters are not grouped '
             'together\n'
             '   and are deemed to delimit empty strings (for example,\n'
             '   "\'1,,2\'.split(\',\')" returns "[\'1\', \'\', \'2\']").  The '
             '*sep* argument\n'
             '   may consist of multiple characters (for example,\n'
             '   "\'1<>2<>3\'.split(\'<>\')" returns "[\'1\', \'2\', \'3\']"). '
             'Splitting an\n'
             '   empty string with a specified separator returns "[\'\']".\n'
             '\n'
             '   If *sep* is not specified or is "None", a different '
             'splitting\n'
             '   algorithm is applied: runs of consecutive whitespace are '
             'regarded\n'
             '   as a single separator, and the result will contain no empty '
             'strings\n'
             '   at the start or end if the string has leading or trailing\n'
             '   whitespace.  Consequently, splitting an empty string or a '
             'string\n'
             '   consisting of just whitespace with a "None" separator returns '
             '"[]".\n'
             '\n'
             '   For example, "\' 1  2   3  \'.split()" returns "[\'1\', '
             '\'2\', \'3\']", and\n'
             '   "\'  1  2   3  \'.split(None, 1)" returns "[\'1\', \'2   3  '
             '\']".\n'
             '\n'
             'str.splitlines([keepends])\n'
             '\n'
             '   Return a list of the lines in the string, breaking at line\n'
             '   boundaries. This method uses the *universal newlines* '
             'approach to\n'
             '   splitting lines. Line breaks are not included in the '
             'resulting list\n'
             '   unless *keepends* is given and true.\n'
             '\n'
             '   For example, "\'ab c\\n\\nde fg\\rkl\\r\\n\'.splitlines()" '
             'returns "[\'ab\n'
             '   c\', \'\', \'de fg\', \'kl\']", while the same call with\n'
             '   "splitlines(True)" returns "[\'ab c\\n\', \'\\n\', \'de '
             'fg\\r\', \'kl\\r\\n\']".\n'
             '\n'
             '   Unlike "split()" when a delimiter string *sep* is given, '
             'this\n'
             '   method returns an empty list for the empty string, and a '
             'terminal\n'
             '   line break does not result in an extra line.\n'
             '\n'
             'str.startswith(prefix[, start[, end]])\n'
             '\n'
             '   Return "True" if string starts with the *prefix*, otherwise '
             'return\n'
             '   "False". *prefix* can also be a tuple of prefixes to look '
             'for.\n'
             '   With optional *start*, test string beginning at that '
             'position.\n'
             '   With optional *end*, stop comparing string at that position.\n'
             '\n'
             '   Changed in version 2.5: Accept tuples as *prefix*.\n'
             '\n'
             'str.strip([chars])\n'
             '\n'
             '   Return a copy of the string with the leading and trailing\n'
             '   characters removed. The *chars* argument is a string '
             'specifying the\n'
             '   set of characters to be removed. If omitted or "None", the '
             '*chars*\n'
             '   argument defaults to removing whitespace. The *chars* '
             'argument is\n'
             '   not a prefix or suffix; rather, all combinations of its '
             'values are\n'
             '   stripped:\n'
             '\n'
             "   >>> '   spacious   '.strip()\n"
             "   'spacious'\n"
             "   >>> 'www.example.com'.strip('cmowz.')\n"
             "   'example'\n"
             '\n'
             '   Changed in version 2.2.2: Support for the *chars* argument.\n'
             '\n'
             'str.swapcase()\n'
             '\n'
             '   Return a copy of the string with uppercase characters '
             'converted to\n'
             '   lowercase and vice versa.\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.title()\n'
             '\n'
             '   Return a titlecased version of the string where words start '
             'with an\n'
             '   uppercase character and the remaining characters are '
             'lowercase.\n'
             '\n'
             '   The algorithm uses a simple language-independent definition '
             'of a\n'
             '   word as groups of consecutive letters.  The definition works '
             'in\n'
             '   many contexts but it means that apostrophes in contractions '
             'and\n'
             '   possessives form word boundaries, which may not be the '
             'desired\n'
             '   result:\n'
             '\n'
             '      >>> "they\'re bill\'s friends from the UK".title()\n'
             '      "They\'Re Bill\'S Friends From The Uk"\n'
             '\n'
             '   A workaround for apostrophes can be constructed using '
             'regular\n'
             '   expressions:\n'
             '\n'
             '      >>> import re\n'
             '      >>> def titlecase(s):\n'
             '      ...     return re.sub(r"[A-Za-z]+(\'[A-Za-z]+)?",\n'
             '      ...                   lambda mo: mo.group(0)[0].upper() +\n'
             '      ...                              mo.group(0)[1:].lower(),\n'
             '      ...                   s)\n'
             '      ...\n'
             '      >>> titlecase("they\'re bill\'s friends.")\n'
             '      "They\'re Bill\'s Friends."\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.translate(table[, deletechars])\n'
             '\n'
             '   Return a copy of the string where all characters occurring in '
             'the\n'
             '   optional argument *deletechars* are removed, and the '
             'remaining\n'
             '   characters have been mapped through the given translation '
             'table,\n'
             '   which must be a string of length 256.\n'
             '\n'
             '   You can use the "maketrans()" helper function in the '
             '"string"\n'
             '   module to create a translation table. For string objects, set '
             'the\n'
             '   *table* argument to "None" for translations that only delete\n'
             '   characters:\n'
             '\n'
             "   >>> 'read this short text'.translate(None, 'aeiou')\n"
             "   'rd ths shrt txt'\n"
             '\n'
             '   New in version 2.6: Support for a "None" *table* argument.\n'
             '\n'
             '   For Unicode objects, the "translate()" method does not accept '
             'the\n'
             '   optional *deletechars* argument.  Instead, it returns a copy '
             'of the\n'
             '   *s* where all characters have been mapped through the given\n'
             '   translation table which must be a mapping of Unicode ordinals '
             'to\n'
             '   Unicode ordinals, Unicode strings or "None". Unmapped '
             'characters\n'
             '   are left untouched. Characters mapped to "None" are deleted.  '
             'Note,\n'
             '   a more flexible approach is to create a custom character '
             'mapping\n'
             '   codec using the "codecs" module (see "encodings.cp1251" for '
             'an\n'
             '   example).\n'
             '\n'
             'str.upper()\n'
             '\n'
             '   Return a copy of the string with all the cased characters '
             '[4]\n'
             '   converted to uppercase.  Note that "str.upper().isupper()" '
             'might be\n'
             '   "False" if "s" contains uncased characters or if the Unicode\n'
             '   category of the resulting character(s) is not "Lu" (Letter,\n'
             '   uppercase), but e.g. "Lt" (Letter, titlecase).\n'
             '\n'
             '   For 8-bit strings, this method is locale-dependent.\n'
             '\n'
             'str.zfill(width)\n'
             '\n'
             '   Return the numeric string left filled with zeros in a string '
             'of\n'
             '   length *width*.  A sign prefix is handled correctly.  The '
             'original\n'
             '   string is returned if *width* is less than or equal to '
             '"len(s)".\n'
             '\n'
             '   New in version 2.2.2.\n'
             '\n'
             'The following methods are present only on unicode objects:\n'
             '\n'
             'unicode.isnumeric()\n'
             '\n'
             '   Return "True" if there are only numeric characters in S, '
             '"False"\n'
             '   otherwise. Numeric characters include digit characters, and '
             'all\n'
             '   characters that have the Unicode numeric value property, '
             'e.g.\n'
             '   U+2155, VULGAR FRACTION ONE FIFTH.\n'
             '\n'
             'unicode.isdecimal()\n'
             '\n'
             '   Return "True" if there are only decimal characters in S, '
             '"False"\n'
             '   otherwise. Decimal characters include digit characters, and '
             'all\n'
             '   characters that can be used to form decimal-radix numbers, '
             'e.g.\n'
             '   U+0660, ARABIC-INDIC DIGIT ZERO.\n'
             '\n'
             '\n'
             'String Formatting Operations\n'
             '============================\n'
             '\n'
             'String and Unicode objects have one unique built-in operation: '
             'the "%"\n'
             'operator (modulo).  This is also known as the string '
             '*formatting* or\n'
             '*interpolation* operator.  Given "format % values" (where '
             '*format* is\n'
             'a string or Unicode object), "%" conversion specifications in '
             '*format*\n'
             'are replaced with zero or more elements of *values*.  The effect '
             'is\n'
             'similar to the using "sprintf()" in the C language.  If *format* '
             'is a\n'
             'Unicode object, or if any of the objects being converted using '
             'the\n'
             '"%s" conversion are Unicode objects, the result will also be a '
             'Unicode\n'
             'object.\n'
             '\n'
             'If *format* requires a single argument, *values* may be a single '
             'non-\n'
             'tuple object. [5]  Otherwise, *values* must be a tuple with '
             'exactly\n'
             'the number of items specified by the format string, or a single\n'
             'mapping object (for example, a dictionary).\n'
             '\n'
             'A conversion specifier contains two or more characters and has '
             'the\n'
             'following components, which must occur in this order:\n'
             '\n'
             '1. The "\'%\'" character, which marks the start of the '
             'specifier.\n'
             '\n'
             '2. Mapping key (optional), consisting of a parenthesised '
             'sequence\n'
             '   of characters (for example, "(somename)").\n'
             '\n'
             '3. Conversion flags (optional), which affect the result of some\n'
             '   conversion types.\n'
             '\n'
             '4. Minimum field width (optional).  If specified as an "\'*\'"\n'
             '   (asterisk), the actual width is read from the next element of '
             'the\n'
             '   tuple in *values*, and the object to convert comes after the\n'
             '   minimum field width and optional precision.\n'
             '\n'
             '5. Precision (optional), given as a "\'.\'" (dot) followed by '
             'the\n'
             '   precision.  If specified as "\'*\'" (an asterisk), the actual '
             'width\n'
             '   is read from the next element of the tuple in *values*, and '
             'the\n'
             '   value to convert comes after the precision.\n'
             '\n'
             '6. Length modifier (optional).\n'
             '\n'
             '7. Conversion type.\n'
             '\n'
             'When the right argument is a dictionary (or other mapping type), '
             'then\n'
             'the formats in the string *must* include a parenthesised mapping '
             'key\n'
             'into that dictionary inserted immediately after the "\'%\'" '
             'character.\n'
             'The mapping key selects the value to be formatted from the '
             'mapping.\n'
             'For example:\n'
             '\n'
             ">>> print '%(language)s has %(number)03d quote types.' % \\\n"
             '...       {"language": "Python", "number": 2}\n'
             'Python has 002 quote types.\n'
             '\n'
             'In this case no "*" specifiers may occur in a format (since '
             'they\n'
             'require a sequential parameter list).\n'
             '\n'
             'The conversion flag characters are:\n'
             '\n'
             '+-----------+-----------------------------------------------------------------------+\n'
             '| Flag      | '
             'Meaning                                                               '
             '|\n'
             '+===========+=======================================================================+\n'
             '| "\'#\'"     | The value conversion will use the "alternate '
             'form" (where defined     |\n'
             '|           | '
             'below).                                                               '
             '|\n'
             '+-----------+-----------------------------------------------------------------------+\n'
             '| "\'0\'"     | The conversion will be zero padded for numeric '
             'values.                |\n'
             '+-----------+-----------------------------------------------------------------------+\n'
             '| "\'-\'"     | The converted value is left adjusted (overrides '
             'the "\'0\'" conversion  |\n'
             '|           | if both are '
             'given).                                                   |\n'
             '+-----------+-----------------------------------------------------------------------+\n'
             '| "\' \'"     | (a space) A blank should be left before a '
             'positive number (or empty   |\n'
             '|           | string) produced by a signed '
             'conversion.                              |\n'
             '+-----------+-----------------------------------------------------------------------+\n'
             '| "\'+\'"     | A sign character ("\'+\'" or "\'-\'") will '
             'precede the conversion         |\n'
             '|           | (overrides a "space" '
             'flag).                                           |\n'
             '+-----------+-----------------------------------------------------------------------+\n'
             '\n'
             'A length modifier ("h", "l", or "L") may be present, but is '
             'ignored as\n'
             'it is not necessary for Python -- so e.g. "%ld" is identical to '
             '"%d".\n'
             '\n'
             'The conversion types are:\n'
             '\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| Conversion   | '
             'Meaning                                               | Notes   '
             '|\n'
             '+==============+=======================================================+=========+\n'
             '| "\'d\'"        | Signed integer '
             'decimal.                               |         |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'i\'"        | Signed integer '
             'decimal.                               |         |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'o\'"        | Signed octal '
             'value.                                   | (1)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'u\'"        | Obsolete type -- it is identical to '
             '"\'d\'".            | (7)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'x\'"        | Signed hexadecimal '
             '(lowercase).                       | (2)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'X\'"        | Signed hexadecimal '
             '(uppercase).                       | (2)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'e\'"        | Floating point exponential format '
             '(lowercase).        | (3)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'E\'"        | Floating point exponential format '
             '(uppercase).        | (3)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'f\'"        | Floating point decimal '
             'format.                        | (3)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'F\'"        | Floating point decimal '
             'format.                        | (3)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'g\'"        | Floating point format. Uses lowercase '
             'exponential     | (4)     |\n'
             '|              | format if exponent is less than -4 or not less '
             'than   |         |\n'
             '|              | precision, decimal format '
             'otherwise.                  |         |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'G\'"        | Floating point format. Uses uppercase '
             'exponential     | (4)     |\n'
             '|              | format if exponent is less than -4 or not less '
             'than   |         |\n'
             '|              | precision, decimal format '
             'otherwise.                  |         |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'c\'"        | Single character (accepts integer or single '
             'character |         |\n'
             '|              | '
             'string).                                              |         '
             '|\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'r\'"        | String (converts any Python object using '
             'repr()).     | (5)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'s\'"        | String (converts any Python object using '
             '"str()").    | (6)     |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '| "\'%\'"        | No argument is converted, results in a '
             '"\'%\'"          |         |\n'
             '|              | character in the '
             'result.                              |         |\n'
             '+--------------+-------------------------------------------------------+---------+\n'
             '\n'
             'Notes:\n'
             '\n'
             '1. The alternate form causes a leading zero ("\'0\'") to be '
             'inserted\n'
             '   between left-hand padding and the formatting of the number if '
             'the\n'
             '   leading character of the result is not already a zero.\n'
             '\n'
             '2. The alternate form causes a leading "\'0x\'" or "\'0X\'" '
             '(depending\n'
             '   on whether the "\'x\'" or "\'X\'" format was used) to be '
             'inserted\n'
             '   between left-hand padding and the formatting of the number if '
             'the\n'
             '   leading character of the result is not already a zero.\n'
             '\n'
             '3. The alternate form causes the result to always contain a '
             'decimal\n'
             '   point, even if no digits follow it.\n'
             '\n'
             '   The precision determines the number of digits after the '
             'decimal\n'
             '   point and defaults to 6.\n'
             '\n'
             '4. The alternate form causes the result to always contain a '
             'decimal\n'
             '   point, and trailing zeroes are not removed as they would '
             'otherwise\n'
             '   be.\n'
             '\n'
             '   The precision determines the number of significant digits '
             'before\n'
             '   and after the decimal point and defaults to 6.\n'
             '\n'
             '5. The "%r" conversion was added in Python 2.0.\n'
             '\n'
             '   The precision determines the maximal number of characters '
             'used.\n'
             '\n'
             '6. If the object or format provided is a "unicode" string, the\n'
             '   resulting string will also be "unicode".\n'
             '\n'
             '   The precision determines the maximal number of characters '
             'used.\n'
             '\n'
             '7. See **PEP 237**.\n'
             '\n'
             'Since Python strings have an explicit length, "%s" conversions '
             'do not\n'
             'assume that "\'\\0\'" is the end of the string.\n'
             '\n'
             'Changed in version 2.7: "%f" conversions for numbers whose '
             'absolute\n'
             'value is over 1e50 are no longer replaced by "%g" conversions.\n'
             '\n'
             'Additional string operations are defined in standard modules '
             '"string"\n'
             'and "re".\n'
             '\n'
             '\n'
             'XRange Type\n'
             '===========\n'
             '\n'
             'The "xrange" type is an immutable sequence which is commonly '
             'used for\n'
             'looping.  The advantage of the "xrange" type is that an '
             '"xrange"\n'
             'object will always take the same amount of memory, no matter the '
             'size\n'
             'of the range it represents.  There are no consistent '
             'performance\n'
             'advantages.\n'
             '\n'
             'XRange objects have very little behavior: they only support '
             'indexing,\n'
             'iteration, and the "len()" function.\n'
             '\n'
             '\n'
             'Mutable Sequence Types\n'
             '======================\n'
             '\n'
             'List and "bytearray" objects support additional operations that '
             'allow\n'
             'in-place modification of the object. Other mutable sequence '
             'types\n'
             '(when added to the language) should also support these '
             'operations.\n'
             'Strings and tuples are immutable sequence types: such objects '
             'cannot\n'
             'be modified once created. The following operations are defined '
             'on\n'
             'mutable sequence types (where *x* is an arbitrary object):\n'
             '\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| Operation                      | '
             'Result                           | Notes                 |\n'
             '+================================+==================================+=======================+\n'
             '| "s[i] = x"                     | item *i* of *s* is replaced '
             'by   |                       |\n'
             '|                                | '
             '*x*                              |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s[i:j] = t"                   | slice of *s* from *i* to *j* '
             'is  |                       |\n'
             '|                                | replaced by the contents of '
             'the  |                       |\n'
             '|                                | iterable '
             '*t*                     |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "del s[i:j]"                   | same as "s[i:j] = '
             '[]"            |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s[i:j:k] = t"                 | the elements of "s[i:j:k]" '
             'are   | (1)                   |\n'
             '|                                | replaced by those of '
             '*t*         |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "del s[i:j:k]"                 | removes the elements '
             'of          |                       |\n'
             '|                                | "s[i:j:k]" from the '
             'list         |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.append(x)"                  | same as "s[len(s):len(s)] = '
             '[x]" | (2)                   |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.extend(x)" or "s += t"      | for the most part the same '
             'as    | (3)                   |\n'
             '|                                | "s[len(s):len(s)] = '
             'x"           |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s *= n"                       | updates *s* with its '
             'contents    | (11)                  |\n'
             '|                                | repeated *n* '
             'times               |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.count(x)"                   | return number of *i*\'s for '
             'which |                       |\n'
             '|                                | "s[i] == '
             'x"                      |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.index(x[, i[, j]])"         | return smallest *k* such '
             'that    | (4)                   |\n'
             '|                                | "s[k] == x" and "i <= k < '
             'j"     |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.insert(i, x)"               | same as "s[i:i] = '
             '[x]"           | (5)                   |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.pop([i])"                   | same as "x = s[i]; del '
             's[i];     | (6)                   |\n'
             '|                                | return '
             'x"                        |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.remove(x)"                  | same as "del '
             's[s.index(x)]"      | (4)                   |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.reverse()"                  | reverses the items of *s* '
             'in     | (7)                   |\n'
             '|                                | '
             'place                            |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.sort([cmp[, key[,           | sort the items of *s* in '
             'place   | (7)(8)(9)(10)         |\n'
             '| reverse]]])"                   '
             '|                                  |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '\n'
             'Notes:\n'
             '\n'
             '1. *t* must have the same length as the slice it is  replacing.\n'
             '\n'
             '2. The C implementation of Python has historically accepted\n'
             '   multiple parameters and implicitly joined them into a tuple; '
             'this\n'
             '   no longer works in Python 2.0.  Use of this misfeature has '
             'been\n'
             '   deprecated since Python 1.4.\n'
             '\n'
             '3. *x* can be any iterable object.\n'
             '\n'
             '4. Raises "ValueError" when *x* is not found in *s*. When a\n'
             '   negative index is passed as the second or third parameter to '
             'the\n'
             '   "index()" method, the list length is added, as for slice '
             'indices.\n'
             '   If it is still negative, it is truncated to zero, as for '
             'slice\n'
             '   indices.\n'
             '\n'
             '   Changed in version 2.3: Previously, "index()" didn\'t have '
             'arguments\n'
             '   for specifying start and stop positions.\n'
             '\n'
             '5. When a negative index is passed as the first parameter to '
             'the\n'
             '   "insert()" method, the list length is added, as for slice '
             'indices.\n'
             '   If it is still negative, it is truncated to zero, as for '
             'slice\n'
             '   indices.\n'
             '\n'
             '   Changed in version 2.3: Previously, all negative indices '
             'were\n'
             '   truncated to zero.\n'
             '\n'
             '6. The "pop()" method\'s optional argument *i* defaults to "-1", '
             'so\n'
             '   that by default the last item is removed and returned.\n'
             '\n'
             '7. The "sort()" and "reverse()" methods modify the list in '
             'place\n'
             '   for economy of space when sorting or reversing a large list.  '
             'To\n'
             "   remind you that they operate by side effect, they don't "
             'return the\n'
             '   sorted or reversed list.\n'
             '\n'
             '8. The "sort()" method takes optional arguments for controlling '
             'the\n'
             '   comparisons.\n'
             '\n'
             '   *cmp* specifies a custom comparison function of two arguments '
             '(list\n'
             '   items) which should return a negative, zero or positive '
             'number\n'
             '   depending on whether the first argument is considered smaller '
             'than,\n'
             '   equal to, or larger than the second argument: "cmp=lambda '
             'x,y:\n'
             '   cmp(x.lower(), y.lower())".  The default value is "None".\n'
             '\n'
             '   *key* specifies a function of one argument that is used to '
             'extract\n'
             '   a comparison key from each list element: "key=str.lower".  '
             'The\n'
             '   default value is "None".\n'
             '\n'
             '   *reverse* is a boolean value.  If set to "True", then the '
             'list\n'
             '   elements are sorted as if each comparison were reversed.\n'
             '\n'
             '   In general, the *key* and *reverse* conversion processes are '
             'much\n'
             '   faster than specifying an equivalent *cmp* function.  This '
             'is\n'
             '   because *cmp* is called multiple times for each list element '
             'while\n'
             '   *key* and *reverse* touch each element only once.  Use\n'
             '   "functools.cmp_to_key()" to convert an old-style *cmp* '
             'function to\n'
             '   a *key* function.\n'
             '\n'
             '   Changed in version 2.3: Support for "None" as an equivalent '
             'to\n'
             '   omitting *cmp* was added.\n'
             '\n'
             '   Changed in version 2.4: Support for *key* and *reverse* was '
             'added.\n'
             '\n'
             '9. Starting with Python 2.3, the "sort()" method is guaranteed '
             'to\n'
             '   be stable.  A sort is stable if it guarantees not to change '
             'the\n'
             '   relative order of elements that compare equal --- this is '
             'helpful\n'
             '   for sorting in multiple passes (for example, sort by '
             'department,\n'
             '   then by salary grade).\n'
             '\n'
             '10. **CPython implementation detail:** While a list is being\n'
             '    sorted, the effect of attempting to mutate, or even inspect, '
             'the\n'
             '    list is undefined.  The C implementation of Python 2.3 and '
             'newer\n'
             '    makes the list appear empty for the duration, and raises\n'
             '    "ValueError" if it can detect that the list has been '
             'mutated\n'
             '    during a sort.\n'
             '\n'
             '11. The value *n* is an integer, or an object implementing\n'
             '    "__index__()".  Zero and negative values of *n* clear the\n'
             '    sequence.  Items in the sequence are not copied; they are\n'
             '    referenced multiple times, as explained for "s * n" under '
             'Sequence\n'
             '    Types --- str, unicode, list, tuple, bytearray, buffer, '
             'xrange.\n',
 'typesseq-mutable': '\n'
                     'Mutable Sequence Types\n'
                     '**********************\n'
                     '\n'
                     'List and "bytearray" objects support additional '
                     'operations that allow\n'
                     'in-place modification of the object. Other mutable '
                     'sequence types\n'
                     '(when added to the language) should also support these '
                     'operations.\n'
                     'Strings and tuples are immutable sequence types: such '
                     'objects cannot\n'
                     'be modified once created. The following operations are '
                     'defined on\n'
                     'mutable sequence types (where *x* is an arbitrary '
                     'object):\n'
                     '\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| Operation                      | '
                     'Result                           | Notes                 '
                     '|\n'
                     '+================================+==================================+=======================+\n'
                     '| "s[i] = x"                     | item *i* of *s* is '
                     'replaced by   |                       |\n'
                     '|                                | '
                     '*x*                              |                       '
                     '|\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s[i:j] = t"                   | slice of *s* from *i* '
                     'to *j* is  |                       |\n'
                     '|                                | replaced by the '
                     'contents of the  |                       |\n'
                     '|                                | iterable '
                     '*t*                     |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "del s[i:j]"                   | same as "s[i:j] = '
                     '[]"            |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s[i:j:k] = t"                 | the elements of '
                     '"s[i:j:k]" are   | (1)                   |\n'
                     '|                                | replaced by those of '
                     '*t*         |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "del s[i:j:k]"                 | removes the elements '
                     'of          |                       |\n'
                     '|                                | "s[i:j:k]" from the '
                     'list         |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.append(x)"                  | same as '
                     '"s[len(s):len(s)] = [x]" | (2)                   |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.extend(x)" or "s += t"      | for the most part the '
                     'same as    | (3)                   |\n'
                     '|                                | "s[len(s):len(s)] = '
                     'x"           |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s *= n"                       | updates *s* with its '
                     'contents    | (11)                  |\n'
                     '|                                | repeated *n* '
                     'times               |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.count(x)"                   | return number of '
                     "*i*'s for which |                       |\n"
                     '|                                | "s[i] == '
                     'x"                      |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.index(x[, i[, j]])"         | return smallest *k* '
                     'such that    | (4)                   |\n'
                     '|                                | "s[k] == x" and "i <= '
                     'k < j"     |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.insert(i, x)"               | same as "s[i:i] = '
                     '[x]"           | (5)                   |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.pop([i])"                   | same as "x = s[i]; '
                     'del s[i];     | (6)                   |\n'
                     '|                                | return '
                     'x"                        |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.remove(x)"                  | same as "del '
                     's[s.index(x)]"      | (4)                   |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.reverse()"                  | reverses the items of '
                     '*s* in     | (7)                   |\n'
                     '|                                | '
                     'place                            |                       '
                     '|\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.sort([cmp[, key[,           | sort the items of *s* '
                     'in place   | (7)(8)(9)(10)         |\n'
                     '| reverse]]])"                   '
                     '|                                  '
                     '|                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '\n'
                     'Notes:\n'
                     '\n'
                     '1. *t* must have the same length as the slice it is  '
                     'replacing.\n'
                     '\n'
                     '2. The C implementation of Python has historically '
                     'accepted\n'
                     '   multiple parameters and implicitly joined them into a '
                     'tuple; this\n'
                     '   no longer works in Python 2.0.  Use of this '
                     'misfeature has been\n'
                     '   deprecated since Python 1.4.\n'
                     '\n'
                     '3. *x* can be any iterable object.\n'
                     '\n'
                     '4. Raises "ValueError" when *x* is not found in *s*. '
                     'When a\n'
                     '   negative index is passed as the second or third '
                     'parameter to the\n'
                     '   "index()" method, the list length is added, as for '
                     'slice indices.\n'
                     '   If it is still negative, it is truncated to zero, as '
                     'for slice\n'
                     '   indices.\n'
                     '\n'
                     '   Changed in version 2.3: Previously, "index()" didn\'t '
                     'have arguments\n'
                     '   for specifying start and stop positions.\n'
                     '\n'
                     '5. When a negative index is passed as the first '
                     'parameter to the\n'
                     '   "insert()" method, the list length is added, as for '
                     'slice indices.\n'
                     '   If it is still negative, it is truncated to zero, as '
                     'for slice\n'
                     '   indices.\n'
                     '\n'
                     '   Changed in version 2.3: Previously, all negative '
                     'indices were\n'
                     '   truncated to zero.\n'
                     '\n'
                     '6. The "pop()" method\'s optional argument *i* defaults '
                     'to "-1", so\n'
                     '   that by default the last item is removed and '
                     'returned.\n'
                     '\n'
                     '7. The "sort()" and "reverse()" methods modify the list '
                     'in place\n'
                     '   for economy of space when sorting or reversing a '
                     'large list.  To\n'
                     '   remind you that they operate by side effect, they '
                     "don't return the\n"
                     '   sorted or reversed list.\n'
                     '\n'
                     '8. The "sort()" method takes optional arguments for '
                     'controlling the\n'
                     '   comparisons.\n'
                     '\n'
                     '   *cmp* specifies a custom comparison function of two '
                     'arguments (list\n'
                     '   items) which should return a negative, zero or '
                     'positive number\n'
                     '   depending on whether the first argument is considered '
                     'smaller than,\n'
                     '   equal to, or larger than the second argument: '
                     '"cmp=lambda x,y:\n'
                     '   cmp(x.lower(), y.lower())".  The default value is '
                     '"None".\n'
                     '\n'
                     '   *key* specifies a function of one argument that is '
                     'used to extract\n'
                     '   a comparison key from each list element: '
                     '"key=str.lower".  The\n'
                     '   default value is "None".\n'
                     '\n'
                     '   *reverse* is a boolean value.  If set to "True", then '
                     'the list\n'
                     '   elements are sorted as if each comparison were '
                     'reversed.\n'
                     '\n'
                     '   In general, the *key* and *reverse* conversion '
                     'processes are much\n'
                     '   faster than specifying an equivalent *cmp* function.  '
                     'This is\n'
                     '   because *cmp* is called multiple times for each list '
                     'element while\n'
                     '   *key* and *reverse* touch each element only once.  '
                     'Use\n'
                     '   "functools.cmp_to_key()" to convert an old-style '
                     '*cmp* function to\n'
                     '   a *key* function.\n'
                     '\n'
                     '   Changed in version 2.3: Support for "None" as an '
                     'equivalent to\n'
                     '   omitting *cmp* was added.\n'
                     '\n'
                     '   Changed in version 2.4: Support for *key* and '
                     '*reverse* was added.\n'
                     '\n'
                     '9. Starting with Python 2.3, the "sort()" method is '
                     'guaranteed to\n'
                     '   be stable.  A sort is stable if it guarantees not to '
                     'change the\n'
                     '   relative order of elements that compare equal --- '
                     'this is helpful\n'
                     '   for sorting in multiple passes (for example, sort by '
                     'department,\n'
                     '   then by salary grade).\n'
                     '\n'
                     '10. **CPython implementation detail:** While a list is '
                     'being\n'
                     '    sorted, the effect of attempting to mutate, or even '
                     'inspect, the\n'
                     '    list is undefined.  The C implementation of Python '
                     '2.3 and newer\n'
                     '    makes the list appear empty for the duration, and '
                     'raises\n'
                     '    "ValueError" if it can detect that the list has been '
                     'mutated\n'
                     '    during a sort.\n'
                     '\n'
                     '11. The value *n* is an integer, or an object '
                     'implementing\n'
                     '    "__index__()".  Zero and negative values of *n* '
                     'clear the\n'
                     '    sequence.  Items in the sequence are not copied; '
                     'they are\n'
                     '    referenced multiple times, as explained for "s * n" '
                     'under Sequence\n'
                     '    Types --- str, unicode, list, tuple, bytearray, '
                     'buffer, xrange.\n',
 'unary': '\n'
          'Unary arithmetic and bitwise operations\n'
          '***************************************\n'
          '\n'
          'All unary arithmetic and bitwise operations have the same '
          'priority:\n'
          '\n'
          '   u_expr ::= power | "-" u_expr | "+" u_expr | "~" u_expr\n'
          '\n'
          'The unary "-" (minus) operator yields the negation of its numeric\n'
          'argument.\n'
          '\n'
          'The unary "+" (plus) operator yields its numeric argument '
          'unchanged.\n'
          '\n'
          'The unary "~" (invert) operator yields the bitwise inversion of '
          'its\n'
          'plain or long integer argument.  The bitwise inversion of "x" is\n'
          'defined as "-(x+1)".  It only applies to integral numbers.\n'
          '\n'
          'In all three cases, if the argument does not have the proper type, '
          'a\n'
          '"TypeError" exception is raised.\n',
 'while': '\n'
          'The "while" statement\n'
          '*********************\n'
          '\n'
          'The "while" statement is used for repeated execution as long as an\n'
          'expression is true:\n'
          '\n'
          '   while_stmt ::= "while" expression ":" suite\n'
          '                  ["else" ":" suite]\n'
          '\n'
          'This repeatedly tests the expression and, if it is true, executes '
          'the\n'
          'first suite; if the expression is false (which may be the first '
          'time\n'
          'it is tested) the suite of the "else" clause, if present, is '
          'executed\n'
          'and the loop terminates.\n'
          '\n'
          'A "break" statement executed in the first suite terminates the '
          'loop\n'
          'without executing the "else" clause\'s suite.  A "continue" '
          'statement\n'
          'executed in the first suite skips the rest of the suite and goes '
          'back\n'
          'to testing the expression.\n',
 'with': '\n'
         'The "with" statement\n'
         '********************\n'
         '\n'
         'New in version 2.5.\n'
         '\n'
         'The "with" statement is used to wrap the execution of a block with\n'
         'methods defined by a context manager (see section With Statement\n'
         'Context Managers). This allows common "try"..."except"..."finally"\n'
         'usage patterns to be encapsulated for convenient reuse.\n'
         '\n'
         '   with_stmt ::= "with" with_item ("," with_item)* ":" suite\n'
         '   with_item ::= expression ["as" target]\n'
         '\n'
         'The execution of the "with" statement with one "item" proceeds as\n'
         'follows:\n'
         '\n'
         '1. The context expression (the expression given in the "with_item")\n'
         '   is evaluated to obtain a context manager.\n'
         '\n'
         '2. The context manager\'s "__exit__()" is loaded for later use.\n'
         '\n'
         '3. The context manager\'s "__enter__()" method is invoked.\n'
         '\n'
         '4. If a target was included in the "with" statement, the return\n'
         '   value from "__enter__()" is assigned to it.\n'
         '\n'
         '   Note: The "with" statement guarantees that if the "__enter__()"\n'
         '     method returns without an error, then "__exit__()" will always '
         'be\n'
         '     called. Thus, if an error occurs during the assignment to the\n'
         '     target list, it will be treated the same as an error occurring\n'
         '     within the suite would be. See step 6 below.\n'
         '\n'
         '5. The suite is executed.\n'
         '\n'
         '6. The context manager\'s "__exit__()" method is invoked. If an\n'
         '   exception caused the suite to be exited, its type, value, and\n'
         '   traceback are passed as arguments to "__exit__()". Otherwise, '
         'three\n'
         '   "None" arguments are supplied.\n'
         '\n'
         '   If the suite was exited due to an exception, and the return '
         'value\n'
         '   from the "__exit__()" method was false, the exception is '
         'reraised.\n'
         '   If the return value was true, the exception is suppressed, and\n'
         '   execution continues with the statement following the "with"\n'
         '   statement.\n'
         '\n'
         '   If the suite was exited for any reason other than an exception, '
         'the\n'
         '   return value from "__exit__()" is ignored, and execution '
         'proceeds\n'
         '   at the normal location for the kind of exit that was taken.\n'
         '\n'
         'With more than one item, the context managers are processed as if\n'
         'multiple "with" statements were nested:\n'
         '\n'
         '   with A() as a, B() as b:\n'
         '       suite\n'
         '\n'
         'is equivalent to\n'
         '\n'
         '   with A() as a:\n'
         '       with B() as b:\n'
         '           suite\n'
         '\n'
         'Note: In Python 2.5, the "with" statement is only allowed when the\n'
         '  "with_statement" feature has been enabled.  It is always enabled '
         'in\n'
         '  Python 2.6.\n'
         '\n'
         'Changed in version 2.7: Support for multiple context expressions.\n'
         '\n'
         'See also:\n'
         '\n'
         '  **PEP 343** - The "with" statement\n'
         '     The specification, background, and examples for the Python '
         '"with"\n'
         '     statement.\n',
 'yield': '\n'
          'The "yield" statement\n'
          '*********************\n'
          '\n'
          '   yield_stmt ::= yield_expression\n'
          '\n'
          'The "yield" statement is only used when defining a generator '
          'function,\n'
          'and is only used in the body of the generator function. Using a\n'
          '"yield" statement in a function definition is sufficient to cause '
          'that\n'
          'definition to create a generator function instead of a normal\n'
          'function.\n'
          '\n'
          'When a generator function is called, it returns an iterator known '
          'as a\n'
          'generator iterator, or more commonly, a generator.  The body of '
          'the\n'
          "generator function is executed by calling the generator's "
          '"next()"\n'
          'method repeatedly until it raises an exception.\n'
          '\n'
          'When a "yield" statement is executed, the state of the generator '
          'is\n'
          'frozen and the value of "expression_list" is returned to '
          '"next()"\'s\n'
          'caller.  By "frozen" we mean that all local state is retained,\n'
          'including the current bindings of local variables, the instruction\n'
          'pointer, and the internal evaluation stack: enough information is\n'
          'saved so that the next time "next()" is invoked, the function can\n'
          'proceed exactly as if the "yield" statement were just another '
          'external\n'
          'call.\n'
          '\n'
          'As of Python version 2.5, the "yield" statement is now allowed in '
          'the\n'
          '"try" clause of a "try" ...  "finally" construct.  If the generator '
          'is\n'
          'not resumed before it is finalized (by reaching a zero reference '
          'count\n'
          "or by being garbage collected), the generator-iterator's "
          '"close()"\n'
          'method will be called, allowing any pending "finally" clauses to\n'
          'execute.\n'
          '\n'
          'For full details of "yield" semantics, refer to the Yield '
          'expressions\n'
          'section.\n'
          '\n'
          'Note: In Python 2.2, the "yield" statement was only allowed when '
          'the\n'
          '  "generators" feature has been enabled.  This "__future__" import\n'
          '  statement was used to enable the feature:\n'
          '\n'
          '     from __future__ import generators\n'
          '\n'
          'See also:\n'
          '\n'
          '  **PEP 255** - Simple Generators\n'
          '     The proposal for adding generators and the "yield" statement '
          'to\n'
          '     Python.\n'
          '\n'
          '  **PEP 342** - Coroutines via Enhanced Generators\n'
          '     The proposal that, among other generator enhancements, '
          'proposed\n'
          '     allowing "yield" to appear inside a "try" ... "finally" '
          'block.\n'}
