/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ScrollableHitSource;

public class BulkByScrollResponse
extends ActionResponse
implements ToXContentFragment {
    private TimeValue took;
    private BulkByScrollTask.Status status;
    private List<BulkItemResponse.Failure> bulkFailures;
    private List<ScrollableHitSource.SearchFailure> searchFailures;
    private boolean timedOut;

    public BulkByScrollResponse() {
    }

    public BulkByScrollResponse(TimeValue took, BulkByScrollTask.Status status, List<BulkItemResponse.Failure> bulkFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        this.took = took;
        this.status = Objects.requireNonNull(status, "Null status not supported");
        this.bulkFailures = bulkFailures;
        this.searchFailures = searchFailures;
        this.timedOut = timedOut;
    }

    public BulkByScrollResponse(Iterable<BulkByScrollResponse> toMerge, @Nullable String reasonCancelled) {
        long mergedTook = 0L;
        ArrayList<BulkByScrollTask.StatusOrException> statuses = new ArrayList<BulkByScrollTask.StatusOrException>();
        this.bulkFailures = new ArrayList<BulkItemResponse.Failure>();
        this.searchFailures = new ArrayList<ScrollableHitSource.SearchFailure>();
        for (BulkByScrollResponse response : toMerge) {
            mergedTook = Math.max(mergedTook, response.getTook().nanos());
            statuses.add(new BulkByScrollTask.StatusOrException(response.status));
            this.bulkFailures.addAll(response.getBulkFailures());
            this.searchFailures.addAll(response.getSearchFailures());
            this.timedOut |= response.isTimedOut();
        }
        this.took = TimeValue.timeValueNanos(mergedTook);
        this.status = new BulkByScrollTask.Status(statuses, reasonCancelled);
    }

    public TimeValue getTook() {
        return this.took;
    }

    public BulkByScrollTask.Status getStatus() {
        return this.status;
    }

    public long getCreated() {
        return this.status.getCreated();
    }

    public long getDeleted() {
        return this.status.getDeleted();
    }

    public long getUpdated() {
        return this.status.getUpdated();
    }

    public int getBatches() {
        return this.status.getBatches();
    }

    public long getVersionConflicts() {
        return this.status.getVersionConflicts();
    }

    public long getNoops() {
        return this.status.getNoops();
    }

    public String getReasonCancelled() {
        return this.status.getReasonCancelled();
    }

    public long getBulkRetries() {
        return this.status.getBulkRetries();
    }

    public long getSearchRetries() {
        return this.status.getSearchRetries();
    }

    public List<BulkItemResponse.Failure> getBulkFailures() {
        return this.bulkFailures;
    }

    public List<ScrollableHitSource.SearchFailure> getSearchFailures() {
        return this.searchFailures;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.took.writeTo(out);
        this.status.writeTo(out);
        out.writeList(this.bulkFailures);
        out.writeList(this.searchFailures);
        out.writeBoolean(this.timedOut);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.took = new TimeValue(in);
        this.status = new BulkByScrollTask.Status(in);
        this.bulkFailures = in.readList(BulkItemResponse.Failure::new);
        this.searchFailures = in.readList(ScrollableHitSource.SearchFailure::new);
        this.timedOut = in.readBoolean();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("took", this.took.millis());
        builder.field("timed_out", this.timedOut);
        this.status.innerXContent(builder, params);
        builder.startArray("failures");
        for (BulkItemResponse.Failure failure : this.bulkFailures) {
            builder.startObject();
            failure.toXContent(builder, params);
            builder.endObject();
        }
        for (ScrollableHitSource.SearchFailure searchFailure : this.searchFailures) {
            searchFailure.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("[");
        builder.append("took=").append(this.took).append(',');
        builder.append("timed_out=").append(this.timedOut).append(',');
        this.status.innerToString(builder);
        builder.append(",bulk_failures=").append(this.getBulkFailures().subList(0, Math.min(3, this.getBulkFailures().size())));
        builder.append(",search_failures=").append(this.getSearchFailures().subList(0, Math.min(3, this.getSearchFailures().size())));
        return builder.append(']').toString();
    }
}

