/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.tray;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditServer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.tray.JEditTrayIcon;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.util.StringList;

public class JEditSwingTrayIcon
extends JEditTrayIcon
implements EBComponent {
    private boolean restore;
    private String userDir;
    private String[] args;

    public JEditSwingTrayIcon() {
        super(GUIUtilities.getEditorIcon(), "jEdit");
        this.setImageAutoSize(true);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("tray.newView.label"));
        JMenuItem jMenuItem2 = new JMenuItem(jEdit.getProperty("tray.newPlainView.label"));
        JMenuItem jMenuItem3 = new JMenuItem(jEdit.getProperty("tray.exit.label"));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem3);
        MyActionListener myActionListener = new MyActionListener(jMenuItem, jMenuItem2, jMenuItem3);
        jMenuItem.addActionListener(myActionListener);
        jMenuItem2.addActionListener(myActionListener);
        jMenuItem3.addActionListener(myActionListener);
        this.setMenu(jPopupMenu);
        this.addMouseListener(new MyMouseAdapter());
    }

    @Override
    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof EditPaneUpdate && ((EditPaneUpdate)eBMessage).getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
            StringList stringList = new StringList();
            for (View view : jEdit.getViews()) {
                stringList.add(view.getTitle());
            }
            this.setToolTip(stringList.join(" | "));
        }
    }

    @Override
    void setTrayIconArgs(boolean bl, String string, String[] stringArray) {
        this.restore = bl;
        this.userDir = string;
        this.args = stringArray;
    }

    private static class MyActionListener
    implements ActionListener {
        private final JMenuItem newViewItem;
        private final JMenuItem newPlainViewItem;
        private final JMenuItem exitItem;

        MyActionListener(JMenuItem jMenuItem, JMenuItem jMenuItem2, JMenuItem jMenuItem3) {
            this.newViewItem = jMenuItem;
            this.newPlainViewItem = jMenuItem2;
            this.exitItem = jMenuItem3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.newViewItem) {
                jEdit.newView(null);
            } else if (actionEvent.getSource() == this.newPlainViewItem) {
                jEdit.newView(null, null, true);
            } else if (actionEvent.getSource() == this.exitItem) {
                jEdit.exit(null, true);
            }
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private final Map<Window, Boolean> windowState = new HashMap<Window, Boolean>();

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            if (jEdit.getViewCount() == 0) {
                EditServer.handleClient(JEditSwingTrayIcon.this.restore, true, false, JEditSwingTrayIcon.this.userDir, JEditSwingTrayIcon.this.args);
            } else {
                boolean bl;
                boolean bl2 = bl = !jEdit.getActiveView().isVisible();
                if (bl) {
                    for (Window window : Window.getOwnerlessWindows()) {
                        if (this.skipWindow(window)) continue;
                        Boolean bl3 = this.windowState.get(window);
                        if (bl3 == null) {
                            window.setVisible(true);
                            continue;
                        }
                        if (!bl3.booleanValue()) continue;
                        window.setVisible(bl3);
                    }
                    this.windowState.clear();
                    if (jEdit.getActiveView().getState() == 1) {
                        jEdit.getActiveView().setState(0);
                    }
                    jEdit.getActiveView().toFront();
                } else {
                    for (Window window : Window.getOwnerlessWindows()) {
                        if (this.skipWindow(window)) continue;
                        this.windowState.put(window, window.isVisible());
                        window.setVisible(false);
                    }
                }
            }
        }

        private boolean skipWindow(Window window) {
            return window.getClass().getName().contains("Tray");
        }
    }
}

