/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javajs.api.GenericPlatform;
import javajs.api.GenericZipTools;
import javajs.util.AU;
import javajs.util.CompoundDocument;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class JmolUtil {
    public Object getImage(Viewer vwr, Object fullPathNameOrBytes, String echoName, boolean forceSync) {
        Object image = null;
        Object[] info = null;
        GenericPlatform apiPlatform = vwr.apiPlatform;
        boolean createImage = false;
        String fullPathName = "" + fullPathNameOrBytes;
        if (fullPathNameOrBytes instanceof String) {
            boolean isBMP = fullPathName.toUpperCase().endsWith("BMP");
            if (forceSync || fullPathName.indexOf("|") > 0 || isBMP) {
                Object ret = vwr.fm.getFileAsBytes(fullPathName, null);
                if (!AU.isAB(ret)) {
                    return "" + ret;
                }
                if (vwr.isJS) {
                    info = new Object[]{echoName, fullPathNameOrBytes, ret};
                } else {
                    image = apiPlatform.createImage(ret);
                }
            } else if (OC.urlTypeIndex(fullPathName) >= 0) {
                if (vwr.isJS) {
                    info = new Object[]{echoName, fullPathNameOrBytes, null};
                } else {
                    try {
                        image = apiPlatform.createImage(new URL((URL)null, fullPathName, null));
                    }
                    catch (Exception e) {
                        return "bad URL: " + fullPathName;
                    }
                }
            } else {
                createImage = true;
            }
        } else if (vwr.isJS) {
            info = new Object[]{echoName, Rdr.guessMimeTypeForBytes((byte[])fullPathNameOrBytes), fullPathNameOrBytes};
        } else {
            createImage = true;
        }
        if (createImage) {
            image = apiPlatform.createImage("\u0001close".equals(fullPathNameOrBytes) ? "\u0001close" + echoName : fullPathNameOrBytes);
        } else if (info != null) {
            image = apiPlatform.createImage(info);
        }
        if (image == null) {
            return null;
        }
        try {
            if (!apiPlatform.waitForDisplay(info, image)) {
                return null;
            }
            return apiPlatform.getImageWidth(image) < 1 ? "invalid or missing image " + fullPathName : image;
        }
        catch (Exception e) {
            return e.toString() + " opening " + fullPathName;
        }
    }

    public Object getAtomSetCollectionOrBufferedReaderFromZip(Viewer vwr, InputStream is, String fileName, String[] zipDirectory, Map<String, Object> htParams, int subFilePtr, boolean asBufferedReader) {
        String path;
        boolean exceptFiles;
        boolean haveManifest;
        String manifest;
        boolean useFileManifest;
        String subFileName;
        JmolAdapter adapter = vwr.getModelAdapter();
        boolean doCombine = subFilePtr == 1;
        htParams.put("zipSet", fileName);
        String[] subFileList = (String[])htParams.get("subFileList");
        if (subFileList == null) {
            subFileList = this.getSpartanSubfiles(zipDirectory);
        }
        String string = subFileName = subFileList == null || subFilePtr >= subFileList.length ? (String)htParams.get("SubFileName") : subFileList[subFilePtr];
        if (subFileName != null && (subFileName.startsWith("/") || subFileName.startsWith("\\"))) {
            subFileName = subFileName.substring(1);
        }
        int selectedFile = 0;
        if (subFileName == null && htParams.containsKey("modelNumber") && (selectedFile = ((Integer)htParams.get("modelNumber")).intValue()) > 0 && doCombine) {
            htParams.remove("modelNumber");
        }
        boolean bl = useFileManifest = (manifest = (String)htParams.get("manifest")) == null;
        if (useFileManifest) {
            manifest = zipDirectory.length > 0 ? zipDirectory[0] : "";
        }
        boolean bl2 = haveManifest = manifest.length() > 0;
        if (haveManifest && Logger.debugging) {
            Logger.debug("manifest for  " + fileName + ":\n" + manifest);
        }
        boolean ignoreErrors = manifest.indexOf("IGNORE_ERRORS") >= 0;
        boolean selectAll = manifest.indexOf("IGNORE_MANIFEST") >= 0;
        boolean bl3 = exceptFiles = manifest.indexOf("EXCEPT_FILES") >= 0;
        if (selectAll || subFileName != null) {
            haveManifest = false;
        }
        if (useFileManifest && haveManifest && (path = FileManager.getManifestScriptPath(manifest)) != null) {
            return "NOTE: file recognized as a script file: " + fileName + path + "\n";
        }
        Lst<Object> vCollections = new Lst<Object>();
        Hashtable<String, Object> htCollections = haveManifest ? new Hashtable<String, Object>() : null;
        boolean nFiles = false;
        try {
            AtomSetCollection result;
            ZipEntry ze;
            SB spartanData = this.isSpartanZip(zipDirectory) ? vwr.fm.spartanUtil().getData(is, zipDirectory) : null;
            GenericZipTools zpt = vwr.getJzt();
            if (spartanData != null) {
                BufferedReader reader = Rdr.getBR(spartanData.toString());
                if (asBufferedReader) {
                    return reader;
                }
                Object ret = adapter.getAtomSetCollectionFromReader(fileName, reader, htParams);
                if (ret instanceof String) {
                    return ret;
                }
                if (ret instanceof AtomSetCollection) {
                    AtomSetCollection atomSetCollection = (AtomSetCollection)ret;
                    if (atomSetCollection.errorMessage != null) {
                        if (ignoreErrors) {
                            return null;
                        }
                        return atomSetCollection.errorMessage;
                    }
                    return atomSetCollection;
                }
                if (ignoreErrors) {
                    return null;
                }
                return "unknown reader error";
            }
            if (is instanceof BufferedInputStream) {
                is = Rdr.getPngZipStream((BufferedInputStream)is, true);
            }
            ZipInputStream zis = (ZipInputStream)((Object)zpt.newZipInputStream(is));
            if (haveManifest) {
                manifest = '|' + manifest.replace('\r', '|').replace('\n', '|') + '|';
            }
            while ((ze = zis.getNextEntry()) != null && (selectedFile <= 0 || vCollections.size() < selectedFile)) {
                String sData;
                BufferedInputStream bis;
                if (ze.isDirectory()) continue;
                String thisEntry = ze.getName();
                if (subFileName != null && !thisEntry.equals(subFileName)) continue;
                if (subFileName != null) {
                    htParams.put("subFileName", subFileName);
                }
                if (thisEntry.startsWith("JmolManifest") || haveManifest && exceptFiles == manifest.indexOf("|" + thisEntry + "|") >= 0) continue;
                byte[] bytes = Rdr.getLimitedStreamBytes(zis, ze.getSize());
                if (Rdr.isGzipB(bytes)) {
                    bytes = Rdr.getLimitedStreamBytes(zpt.getUnGzippedInputStream(bytes), -1L);
                }
                if (Rdr.isZipB(bytes) || Rdr.isPngZipB(bytes)) {
                    bis = Rdr.getBIS(bytes);
                    String[] zipDir2 = zpt.getZipDirectoryAndClose(bis, "JmolManifest");
                    bis = Rdr.getBIS(bytes);
                    Object atomSetCollections = this.getAtomSetCollectionOrBufferedReaderFromZip(vwr, bis, fileName + "|" + thisEntry, zipDir2, htParams, ++subFilePtr, asBufferedReader);
                    if (atomSetCollections instanceof String) {
                        if (ignoreErrors) continue;
                        return atomSetCollections;
                    }
                    if (atomSetCollections instanceof AtomSetCollection || atomSetCollections instanceof Lst) {
                        if (haveManifest && !exceptFiles) {
                            htCollections.put(thisEntry, atomSetCollections);
                            continue;
                        }
                        vCollections.addLast(atomSetCollections);
                        continue;
                    }
                    if (atomSetCollections instanceof BufferedReader) {
                        if (doCombine) {
                            zis.close();
                        }
                        return atomSetCollections;
                    }
                    if (ignoreErrors) continue;
                    zis.close();
                    return "unknown zip reader error";
                }
                if (Rdr.isPickleB(bytes)) {
                    bis = Rdr.getBIS(bytes);
                    if (doCombine) {
                        zis.close();
                    }
                    return bis;
                }
                if (Rdr.isCompoundDocumentB(bytes)) {
                    CompoundDocument jd = (CompoundDocument)Interface.getInterface("javajs.util.CompoundDocument", vwr, "file");
                    jd.setDocStream(zpt, Rdr.getBIS(bytes));
                    sData = jd.getAllDataFiles("Molecule", "Input").toString();
                } else {
                    sData = Rdr.fixUTF(bytes);
                }
                BufferedReader reader = Rdr.getBR(sData);
                if (asBufferedReader) {
                    if (doCombine) {
                        zis.close();
                    }
                    return reader;
                }
                String fname = fileName + "|" + ze.getName();
                Object ret = adapter.getAtomSetCollectionFromReader(fname, reader, htParams);
                if (!(ret instanceof AtomSetCollection)) {
                    if (ignoreErrors) continue;
                    zis.close();
                    return "" + ret;
                }
                if (haveManifest && !exceptFiles) {
                    htCollections.put(thisEntry, ret);
                } else {
                    vCollections.addLast(ret);
                }
                AtomSetCollection a = (AtomSetCollection)ret;
                if (a.errorMessage == null || ignoreErrors) continue;
                zis.close();
                return a.errorMessage;
            }
            if (doCombine) {
                zis.close();
            }
            if (haveManifest && !exceptFiles) {
                String[] list = PT.split(manifest, "|");
                for (int i = 0; i < list.length; ++i) {
                    String file = list[i];
                    if (file.length() == 0 || file.indexOf("#") == 0) continue;
                    if (htCollections.containsKey(file)) {
                        vCollections.addLast(htCollections.get(file));
                        continue;
                    }
                    if (!Logger.debugging) continue;
                    Logger.debug("manifested file " + file + " was not found in " + fileName);
                }
            }
            if (!doCombine) {
                return vCollections;
            }
            AtomSetCollection atomSetCollection = result = vCollections.size() == 1 && vCollections.get(0) instanceof AtomSetCollection ? (AtomSetCollection)vCollections.get(0) : new AtomSetCollection("Array", null, null, vCollections);
            if (result.errorMessage != null) {
                if (ignoreErrors) {
                    return null;
                }
                return result.errorMessage;
            }
            if (nFiles) {
                selectedFile = 1;
            }
            if (selectedFile > 0 && selectedFile <= vCollections.size()) {
                return vCollections.get(selectedFile - 1);
            }
            return result;
        }
        catch (Exception e) {
            if (ignoreErrors) {
                return null;
            }
            Logger.error("" + e);
            return "" + e;
        }
        catch (Error er) {
            Logger.errorEx(null, er);
            return "" + er;
        }
    }

    public byte[] getCachedPngjBytes(FileManager fm, String pathName) {
        boolean isMin;
        if (pathName.startsWith("file:///")) {
            pathName = "file:" + pathName.substring(7);
        }
        Logger.info("JmolUtil checking PNGJ cache for " + pathName);
        String shortName = this.shortSceneFilename(pathName);
        if (fm.pngjCache == null && !this.clearAndCachePngjFile(fm, new String[]{pathName, null})) {
            return null;
        }
        Map<String, Object> cache = fm.pngjCache;
        boolean bl = isMin = pathName.indexOf(".min.") >= 0;
        if (!isMin) {
            String cName = fm.getCanonicalName(Rdr.getZipRoot(pathName));
            if (!cache.containsKey(cName) && !this.clearAndCachePngjFile(fm, new String[]{pathName, null})) {
                return null;
            }
            if (pathName.indexOf("|") < 0) {
                shortName = cName;
            }
        }
        if (cache.containsKey(shortName)) {
            Logger.info("FileManager using memory cache " + shortName);
            return (byte[])fm.pngjCache.get(shortName);
        }
        if (!isMin || !this.clearAndCachePngjFile(fm, new String[]{pathName, null})) {
            return null;
        }
        Logger.info("FileManager using memory cache " + shortName);
        return (byte[])cache.get(shortName);
    }

    private boolean clearAndCachePngjFile(FileManager fm, String[] data) {
        fm.pngjCache = new Hashtable<String, Object>();
        if (data == null || data[0] == null) {
            return false;
        }
        data[0] = Rdr.getZipRoot(data[0]);
        String shortName = this.shortSceneFilename(data[0]);
        Map<String, Object> cache = fm.pngjCache;
        try {
            data[1] = fm.vwr.getJzt().cacheZipContents(Rdr.getPngZipStream((BufferedInputStream)fm.getBufferedInputStreamOrErrorMessageFromName(data[0], null, false, false, null, false, true), true), shortName, cache, false);
        }
        catch (Exception e) {
            return false;
        }
        if (data[1] == null) {
            return false;
        }
        byte[] bytes = data[1].getBytes();
        cache.put(fm.getCanonicalName(data[0]), bytes);
        if (shortName.indexOf("_scene_") >= 0) {
            cache.put(this.shortSceneFilename(data[0]), bytes);
            bytes = (byte[])cache.remove(shortName + "|state.spt");
            if (bytes != null) {
                cache.put(this.shortSceneFilename(data[0] + "|state.spt"), bytes);
            }
        }
        return true;
    }

    private String shortSceneFilename(String pathName) {
        int pt = pathName.indexOf("_scene_") + 7;
        if (pt < 7) {
            return pathName;
        }
        String s = "";
        if (pathName.endsWith("|state.spt")) {
            int pt1 = pathName.indexOf(46, pt);
            if (pt1 < 0) {
                return pathName;
            }
            s = pathName.substring(pt, pt1);
        }
        int pt2 = pathName.lastIndexOf("|");
        return pathName.substring(0, pt) + s + (pt2 > 0 ? pathName.substring(pt2) : "");
    }

    private String[] getSpartanSubfiles(String[] zipDirectory) {
        String[] stringArray;
        String name;
        String string = name = zipDirectory.length < 2 ? null : zipDirectory[1];
        if (name == null || zipDirectory.length != 2 || !name.endsWith(".spardir/")) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "";
            stringArray = stringArray2;
            stringArray2[1] = PT.trim(name, "/");
        }
        return stringArray;
    }

    private boolean isSpartanZip(String[] zipDirectory) {
        for (int i = 1; i < zipDirectory.length; ++i) {
            if (!zipDirectory[i].endsWith(".spardir/") && zipDirectory[i].indexOf("_spartandir") < 0) continue;
            return true;
        }
        return false;
    }
}

