#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.1.1
id: pandoc-2.1.1-3RTAWYZqK6r98FrWM1c6UE
key: pandoc-2.1.1-3RTAWYZqK6r98FrWM1c6UE
license: GPL
copyright: (c) 2006-2018 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: http://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, and Textile, and it can write
    Markdown, reStructuredText, XHTML, HTML 5, LaTeX, ConTeXt,
    DocBook, JATS, OPML, TEI, OpenDocument, ODT, Word docx,
    RTF, MediaWiki, DokuWiki, ZimWiki, Textile, groff man,
    groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, LaTeX beamer slides, PowerPoint, and several
    kinds of HTML/JavaScript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
indefinite: False
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.JATS
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.LaTeX.Types
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.Odt
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Vimwiki Text.Pandoc.SelfContained
    Text.Pandoc.Shared Text.Pandoc.Templates Text.Pandoc.UTF8
    Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Filter Text.Pandoc.Filter.JSON
                Text.Pandoc.Filter.Lua Text.Pandoc.Filter.Path
                Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
                Text.Pandoc.Readers.Docx.Parse Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.StyleMap Text.Pandoc.Readers.Docx.Fields
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared
                Text.Pandoc.Writers.Powerpoint.Presentation
                Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Init Text.Pandoc.Lua.Module.MediaBag
                Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.Utils
                Text.Pandoc.Lua.Packages Text.Pandoc.Lua.StackInstances
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Text.Pandoc.Compat.Time Paths_pandoc
abi: 5d07e57582e7592626d37a44109ad83f
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.1.1
library-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.1.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.1.1-3RTAWYZqK6r98FrWM1c6UE
depends:
    base-4.10.1.0 syb-0.7-3Lq8MQxmYP07qktjI1jxu0 containers-0.5.10.2
    unordered-containers-0.2.9.0-G7T2IXGR99p4cQdXRUBkNA
    parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp
    mtl-2.2.2-8XubxMJDT8QLsstvlNotkc
    exceptions-0.8.3-FtqgxeR4VUg9hGcIqYr2bq filepath-1.4.1.2
    process-1.6.1.0 directory-1.3.0.2 bytestring-0.10.8.2
    text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    zip-archive-0.3.2.4-L5rPJisQTF76RL55yTJeLS
    HTTP-4000.3.9-AEzAqPD9ZldFxUjbXqdax
    texmath-0.10.1.1-Konh5HFuOHW3ZuiFILNs20
    xml-1.3.14-1QOvnW05iRMh383OQN419
    split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    pandoc-types-1.17.3.1-CjkQCzfxYmYDD4ekOU8LoN
    aeson-1.2.4.0-J0IgGfvF9B28Ryy7NsOCPv
    aeson-pretty-0.8.5-2n9YmRnzj169EG5qetDWF3
    tagsoup-0.14.6-EpRlmpegpADxmAsmqZBMq
    base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be
    zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM
    skylighting-0.6-FpKYdv1vBIf1eL6DPFBt3i
    data-default-0.7.1.1-AA4CT1Ft3yBIiqFbrFdPSr
    temporary-1.2.1.1-C4Oi7my6bSWB1kyblmdgo2
    blaze-html-0.9.0.1-DmW7Dgz0bGH6bjMUMT1XF
    blaze-markup-0.8.2.0-8grjG6g3OXI4E0IG9asDfS
    yaml-0.8.28-ENExEWMUGhxLvo4HvUPiNp
    scientific-0.3.5.2-8Zc2VroUo3iF9E3c5Pz1Qw
    vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA
    hslua-0.9.5-EBpDCOX3BRFLlz08UKDbUv
    hslua-module-text-0.1.2.1-Jt4aCXQP0xZ6WYCdB7X5jU binary-0.8.5.1
    SHA-1.6.4.2-1gNz0XEXVc9D2LWQ8o29zI
    haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n deepseq-1.4.3.0
    JuicyPixels-3.2.9.4-FFKaIONRZiF8glmZMfQ0se
    Glob-0.9.1-1jlN1ehAGqLLunIsQd25SJ
    cmark-gfm-0.1.3-9JIYiVDhJ65KYe2mtb4tmu
    doctemplates-0.2.1-4XKkLQ9GrOeLMnPMQdFLFS
    http-client-0.5.10-HLDKIWCSE4P5fAhIOZCIPF
    http-client-tls-0.3.5.3-EJS8K6DHRkm3VmoPD3qkKK
    http-types-0.9.1-BD2l1Kzs7Ve6mp82UloTud
    case-insensitive-1.2.0.10-GRPPAHSQhw7C2Z7MHdpRXL unix-2.7.2.2
    time-1.8.0.2 network-uri-2.6.1.0-6DCcjXT6KQAGJ7ruji2glJ
    network-2.6.3.4-9dk35Sk3nk1BI7Jw9SJICT
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             syb-0.7-3Lq8MQxmYP07qktjI1jxu0=f985ea42a9fa578e0f67572a93e19b5d
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             unordered-containers-0.2.9.0-G7T2IXGR99p4cQdXRUBkNA=bcd116646f2dca4381cb4b7cc7ba7fb1
             parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp=b942a04aec0a266706b2e8e67bd137e3
             mtl-2.2.2-8XubxMJDT8QLsstvlNotkc=9d788b97813db77c2d48570ade6e04a9
             exceptions-0.8.3-FtqgxeR4VUg9hGcIqYr2bq=349f1b5172af08123dc6c444b05979b3
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz=29872508833c96394f0471371217bab0
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             zip-archive-0.3.2.4-L5rPJisQTF76RL55yTJeLS=7d9674a67ccfac2dfcd2848cf68e5c15
             HTTP-4000.3.9-AEzAqPD9ZldFxUjbXqdax=3fb62cbd6ef21176204bcbba68ffe4c8
             texmath-0.10.1.1-Konh5HFuOHW3ZuiFILNs20=8ce4aa6da86ff96e5ddea37c6f77c291
             xml-1.3.14-1QOvnW05iRMh383OQN419=a7056b3de174482244e4897529e3aaf7
             split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7=b6b8499789ca23888d2f286cbdde6707
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             pandoc-types-1.17.3.1-CjkQCzfxYmYDD4ekOU8LoN=903b5da69afc1d7c71611ff2c737f4b9
             aeson-1.2.4.0-J0IgGfvF9B28Ryy7NsOCPv=cb689fc7acd6290bc554164c78e4d251
             aeson-pretty-0.8.5-2n9YmRnzj169EG5qetDWF3=c7ccb083843f157652466a33ff4d81e7
             tagsoup-0.14.6-EpRlmpegpADxmAsmqZBMq=9b9175fd900a6ae25e03eceb85425b3c
             base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be=fd5db0dc9688093c1ac2c3223371478e
             zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM=fc994ec0331fc01f98e1d968398a1aa2
             skylighting-0.6-FpKYdv1vBIf1eL6DPFBt3i=100b8cf00daa4cb6454a2ecc9ee56f91
             data-default-0.7.1.1-AA4CT1Ft3yBIiqFbrFdPSr=0186e0f4b96bc201d2baef8ade597d90
             temporary-1.2.1.1-C4Oi7my6bSWB1kyblmdgo2=0ece841d14e2532f171448f112ccf0bd
             blaze-html-0.9.0.1-DmW7Dgz0bGH6bjMUMT1XF=e2fc24073886c12f340191d7d20d8f49
             blaze-markup-0.8.2.0-8grjG6g3OXI4E0IG9asDfS=fc34522ff2b8baf7b23fd99c42be7f28
             yaml-0.8.28-ENExEWMUGhxLvo4HvUPiNp=7c3ae30d99a0802e7bc0ad598e644f6c
             scientific-0.3.5.2-8Zc2VroUo3iF9E3c5Pz1Qw=11abcce15758b0e3fff5fe5ecd138e8b
             vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA=137c9db50bf637e10c6e6dd9e685ce59
             hslua-0.9.5-EBpDCOX3BRFLlz08UKDbUv=b70c4fe398dbec25cca109b49466111c
             hslua-module-text-0.1.2.1-Jt4aCXQP0xZ6WYCdB7X5jU=bed5077d507a7d778858be750a58cfb1
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             SHA-1.6.4.2-1gNz0XEXVc9D2LWQ8o29zI=a1e214e4043a6e8594f125021a39000f
             haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n=6190889e581e299524df9ddefc6f117b
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             JuicyPixels-3.2.9.4-FFKaIONRZiF8glmZMfQ0se=1c313a5f89f9fcc642fa0b3c99766096
             Glob-0.9.1-1jlN1ehAGqLLunIsQd25SJ=c0a281738b078a8f7a943b88a390d12a
             cmark-gfm-0.1.3-9JIYiVDhJ65KYe2mtb4tmu=d22d75de2ab8c0680d26bbc3f3b0f946
             doctemplates-0.2.1-4XKkLQ9GrOeLMnPMQdFLFS=729490dc1f45b416f250016b50898f72
             http-client-0.5.10-HLDKIWCSE4P5fAhIOZCIPF=7070c341ccebf232fdd13bca3f27776c
             http-client-tls-0.3.5.3-EJS8K6DHRkm3VmoPD3qkKK=93efd30979b08e937f76d07631baad21
             http-types-0.9.1-BD2l1Kzs7Ve6mp82UloTud=1efefe4d9e28b8d4aa72d634a67d063f
             case-insensitive-1.2.0.10-GRPPAHSQhw7C2Z7MHdpRXL=d72f46a4e5510e3f66a60c13889d0387
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             network-uri-2.6.1.0-6DCcjXT6KQAGJ7ruji2glJ=17ff77631878cfceba90438df04f39d6
             network-2.6.3.4-9dk35Sk3nk1BI7Jw9SJICT=3bb40bf00d3257de945a134963a298b0
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

