// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are created either via the
 * {@link Registry} object or via the registry client <tt>SessionManager</tt>
 * object.
 *
 * @see Registry
 *
 **/
public interface SessionPrx extends Glacier2.SessionPrx
{
    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @see Registry#getSessionTimeout
     *
     **/
    public void keepAlive();

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @see Registry#getSessionTimeout
     *
     * @param context The Context map to send with the invocation.
     **/
    public void keepAlive(java.util.Map<String, String> context);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive();

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(Ice.Callback cb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(Callback_Session_keepAlive cb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context, Callback_Session_keepAlive cb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context,
                                           IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context,
                                           IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param result The asynchronous result object.
     * @see Registry#getSessionTimeout
     *
     **/
    public void end_keepAlive(Ice.AsyncResult result);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @return The proxy of the allocated object.
     *
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @throws AllocationException Raised if the object can't be
     * allocated.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     *
     **/
    public Ice.ObjectPrx allocateObjectById(Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     *
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @throws AllocationException Raised if the object can't be
     * allocated.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     *
     **/
    public Ice.ObjectPrx allocateObjectById(Ice.Identity id, java.util.Map<String, String> context)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, java.util.Map<String, String> context);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, Ice.Callback cb);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, Callback_Session_allocateObjectById cb);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, java.util.Map<String, String> context, Callback_Session_allocateObjectById cb);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id,
                                                    IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id,
                                                    IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param id The identity of the object to allocate.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     *
     * @param result The asynchronous result object.
     * @return The proxy of the allocated object.
     *
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @throws AllocationException Raised if the object can't be
     * allocated.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     *
     **/
    public Ice.ObjectPrx end_allocateObjectById(Ice.AsyncResult result)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @return The proxy of the allocated object.
     *
     * @throws AllocationException Raised if the object could not be allocated.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     *
     **/
    public Ice.ObjectPrx allocateObjectByType(String type)
        throws AllocationException;

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     *
     * @throws AllocationException Raised if the object could not be allocated.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     *
     **/
    public Ice.ObjectPrx allocateObjectByType(String type, java.util.Map<String, String> context)
        throws AllocationException;

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, java.util.Map<String, String> context);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, Ice.Callback cb);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, Callback_Session_allocateObjectByType cb);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, java.util.Map<String, String> context, Callback_Session_allocateObjectByType cb);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type,
                                                      IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type,
                                                      IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type,
                                                      java.util.Map<String, String> context,
                                                      IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type,
                                                      java.util.Map<String, String> context,
                                                      IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     *
     * @param result The asynchronous result object.
     * @return The proxy of the allocated object.
     *
     * @throws AllocationException Raised if the object could not be allocated.
     *
     * @see #setAllocationTimeout
     * @see #releaseObject
     *
     **/
    public Ice.ObjectPrx end_allocateObjectByType(Ice.AsyncResult result)
        throws AllocationException;

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     *
     **/
    public void releaseObject(Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void releaseObject(Ice.Identity id, java.util.Map<String, String> context)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, java.util.Map<String, String> context);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, Ice.Callback cb);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, Callback_Session_releaseObject cb);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, java.util.Map<String, String> context, Callback_Session_releaseObject cb);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id,
                                               IceInternal.Functional_VoidCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id,
                                               IceInternal.Functional_VoidCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_VoidCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param id The identity of the object to release.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_VoidCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Release an object that was allocated using <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt>.
     *
     * @param result The asynchronous result object.
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     *
     **/
    public void end_releaseObject(Ice.AsyncResult result)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     **/
    public void setAllocationTimeout(int timeout);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void setAllocationTimeout(int timeout, java.util.Map<String, String> context);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, java.util.Map<String, String> context);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, Ice.Callback cb);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, Callback_Session_setAllocationTimeout cb);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, java.util.Map<String, String> context, Callback_Session_setAllocationTimeout cb);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout,
                                                      IceInternal.Functional_VoidCallback responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout,
                                                      IceInternal.Functional_VoidCallback responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout,
                                                      java.util.Map<String, String> context,
                                                      IceInternal.Functional_VoidCallback responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout,
                                                      java.util.Map<String, String> context,
                                                      IceInternal.Functional_VoidCallback responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <tt>allocateObjectById</tt> or
     * <tt>allocateObjectByType</tt> will block for the duration of this
     * timeout.
     *
     * @param result The asynchronous result object.
     **/
    public void end_setAllocationTimeout(Ice.AsyncResult result);
}
