// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The Ice router interface. Routers can be set either globally with
 * {@link Communicator#setDefaultRouter}, or with <tt>ice_router</tt> on specific
 * proxies.
 *
 **/
public interface RouterPrx extends Ice.ObjectPrx
{
    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param hasRoutingTable Indicates whether or not the router supports a routing
     * table. If it is supported, the Ice runtime will call addProxies to populate the
     * routing table. This out parameter is only supported starting with Ice 3.7.
     * The Ice runtime assumes the router has a routing table if the optional is not
     * set.
     *
     * @return The router's client proxy.
     *
     **/
    public Ice.ObjectPrx getClientProxy(Ice.BooleanOptional hasRoutingTable);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param hasRoutingTable Indicates whether or not the router supports a routing
     * table. If it is supported, the Ice runtime will call addProxies to populate the
     * routing table. This out parameter is only supported starting with Ice 3.7.
     * The Ice runtime assumes the router has a routing table if the optional is not
     * set.
     *
     * @param context The Context map to send with the invocation.
     * @return The router's client proxy.
     *
     **/
    public Ice.ObjectPrx getClientProxy(Ice.BooleanOptional hasRoutingTable, java.util.Map<String, String> context);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy();

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy(java.util.Map<String, String> context);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy(Ice.Callback cb);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy(Callback_Router_getClientProxy cb);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy(java.util.Map<String, String> context, Callback_Router_getClientProxy cb);

    public interface FunctionalCallback_Router_getClientProxy_Response
    {
        void apply(Ice.ObjectPrx ret, Ice.BooleanOptional hasRoutingTable);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy(FunctionalCallback_Router_getClientProxy_Response responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy(FunctionalCallback_Router_getClientProxy_Response responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy(java.util.Map<String, String> context,
                                                FunctionalCallback_Router_getClientProxy_Response responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getClientProxy(java.util.Map<String, String> context,
                                                FunctionalCallback_Router_getClientProxy_Response responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param hasRoutingTable Indicates whether or not the router supports a routing
     * table. If it is supported, the Ice runtime will call addProxies to populate the
     * routing table. This out parameter is only supported starting with Ice 3.7.
     * The Ice runtime assumes the router has a routing table if the optional is not
     * set.
     *
     * @param result The asynchronous result object.
     * @return The router's client proxy.
     *
     **/
    public Ice.ObjectPrx end_getClientProxy(Ice.BooleanOptional hasRoutingTable, Ice.AsyncResult result);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @return The router's server proxy.
     *
     **/
    public Ice.ObjectPrx getServerProxy();

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param context The Context map to send with the invocation.
     * @return The router's server proxy.
     *
     **/
    public Ice.ObjectPrx getServerProxy(java.util.Map<String, String> context);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy();

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy(java.util.Map<String, String> context);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy(Ice.Callback cb);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy(Callback_Router_getServerProxy cb);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy(java.util.Map<String, String> context, Callback_Router_getServerProxy cb);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy(IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy(IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerProxy(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @param result The asynchronous result object.
     * @return The router's server proxy.
     *
     **/
    public Ice.ObjectPrx end_getServerProxy(Ice.AsyncResult result);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @return Proxies discarded by the router.
     *
     **/
    public Ice.ObjectPrx[] addProxies(Ice.ObjectPrx[] proxies);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param context The Context map to send with the invocation.
     * @return Proxies discarded by the router.
     *
     **/
    public Ice.ObjectPrx[] addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> context);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> context);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, Ice.Callback cb);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, Callback_Router_addProxies cb);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> context, Callback_Router_addProxies cb);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies,
                                            IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies,
                                            IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                            IceInternal.Functional_BoolCallback sentCb);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies,
                                            java.util.Map<String, String> context,
                                            IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies,
                                            java.util.Map<String, String> context,
                                            IceInternal.Functional_GenericCallback1<Ice.ObjectPrx[]> responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                            IceInternal.Functional_BoolCallback sentCb);

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param result The asynchronous result object.
     * @return Proxies discarded by the router.
     *
     **/
    public Ice.ObjectPrx[] end_addProxies(Ice.AsyncResult result);
}
