/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.IceBoxDescriptor;
import com.zeroc.IceGrid.ServerInstanceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.AbstractServerEditor;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.ListTextField;
import com.zeroc.IceGridGUI.Application.Node;
import com.zeroc.IceGridGUI.Application.ParameterValuesField;
import com.zeroc.IceGridGUI.Application.PropertiesField;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.Application.ServerInstance;
import com.zeroc.IceGridGUI.Application.ServerTemplate;
import com.zeroc.IceGridGUI.Application.ServerTemplates;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class ServerInstanceEditor
extends AbstractServerEditor {
    private JComboBox _template = new JComboBox();
    private JButton _templateButton;
    private ParameterValuesField _parameters;
    private ListTextField _propertySets = new ListTextField(20);
    private PropertiesField _properties;

    @Override
    protected void writeDescriptor() {
        ServerInstanceDescriptor descriptor = this.getDescriptor();
        ServerTemplate t = (ServerTemplate)this._template.getSelectedItem();
        descriptor.template = t.getId();
        descriptor.parameterValues = this._parameters.getValues();
        descriptor.propertySet.references = this._propertySets.getList().toArray(new String[0]);
        descriptor.propertySet.properties = this._properties.getProperties();
        ((ServerInstance)this._target).isIceBox(((TemplateDescriptor)t.getDescriptor()).descriptor instanceof IceBoxDescriptor);
    }

    @Override
    protected boolean isSimpleUpdate() {
        ServerInstanceDescriptor descriptor = this.getDescriptor();
        ServerTemplate t = (ServerTemplate)this._template.getSelectedItem();
        return descriptor.template.equals(t.getId()) && descriptor.parameterValues.equals(this._parameters.getValues());
    }

    ServerInstanceEditor() {
        this._template.setToolTipText("Server template");
        AbstractAction gotoTemplate = new AbstractAction("", Utils.getIcon("/icons/16x16/goto.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeNode t = (TreeNode)ServerInstanceEditor.this._template.getSelectedItem();
                if (t != null) {
                    t.getRoot().setSelectedNode(t);
                }
            }
        };
        gotoTemplate.putValue("ShortDescription", "Goto this server template");
        this._templateButton = new JButton(gotoTemplate);
        this._parameters = new ParameterValuesField(this);
        this._propertySets.getDocument().addDocumentListener(this._updateListener);
        this._propertySets.setToolTipText("Property Set References");
        this._properties = new PropertiesField(this);
    }

    ServerInstanceDescriptor getDescriptor() {
        return (ServerInstanceDescriptor)this._target.getDescriptor();
    }

    @Override
    Utils.Resolver getDetailResolver() {
        if (this._target.getCoordinator().substitute()) {
            return this._target.getResolver();
        }
        return null;
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Template", (Component)this._template);
        builder.append(this._templateButton);
        builder.nextLine();
        builder.append("Parameters");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        JScrollPane scrollPane = new JScrollPane(this._parameters);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Property Sets");
        builder.append((Component)this._propertySets, 3);
        builder.nextLine();
        builder.append("Properties");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._properties);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    void show(ServerInstance server) {
        this.detectUpdates(false);
        this._target = server;
        ServerInstanceDescriptor descriptor = this.getDescriptor();
        Root root = server.getRoot();
        boolean isEditable = server.isEphemeral() || !root.getCoordinator().substitute();
        Utils.Resolver resolver = isEditable ? null : ((Node)this._target.getParent()).getResolver();
        this._template.setEnabled(true);
        ServerTemplates serverTemplates = root.getServerTemplates();
        this._template.setModel(serverTemplates.createComboBoxModel());
        ServerTemplate t = (ServerTemplate)serverTemplates.findChild(descriptor.template);
        assert (t != null);
        this._template.setSelectedItem(t);
        ListDataListener templateListener = new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                ServerInstanceEditor.this.updated();
                ServerTemplate t = (ServerTemplate)ServerInstanceEditor.this._template.getModel().getSelectedItem();
                TemplateDescriptor td = (TemplateDescriptor)t.getDescriptor();
                ServerInstanceEditor.this._parameters.set(td.parameters, Editor.makeParameterValues(ServerInstanceEditor.this._parameters.getValues(), td.parameters), td.parameterDefaults, null);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        };
        this._template.getModel().addListDataListener(templateListener);
        this._template.setEnabled(isEditable);
        TemplateDescriptor td = (TemplateDescriptor)t.getDescriptor();
        this._parameters.set(td.parameters, descriptor.parameterValues, td.parameterDefaults, resolver);
        this._propertySets.setList(Arrays.asList(descriptor.propertySet.references), this.getDetailResolver());
        this._propertySets.setEditable(isEditable);
        this._properties.setProperties(descriptor.propertySet.properties, null, null, this.getDetailResolver(), isEditable);
        this._applyButton.setEnabled(server.isEphemeral());
        this._discardButton.setEnabled(server.isEphemeral());
        this.detectUpdates(true);
        if (server.isEphemeral()) {
            this.updated();
        }
    }
}

