/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ClassLoaderRepository
implements Repository {
    private ClassLoader loader;
    private HashMap loadedClasses = new HashMap();

    public ClassLoaderRepository(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        if (this.loadedClasses.containsKey(className)) {
            return (JavaClass)this.loadedClasses.get(className);
        }
        return null;
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        String classFile = className.replace('.', '/');
        JavaClass RC = this.findClass(className);
        if (RC != null) {
            return RC;
        }
        try {
            InputStream is = this.loader.getResourceAsStream(classFile + ".class");
            if (is == null) {
                throw new ClassNotFoundException(className + " not found.");
            }
            ClassParser parser = new ClassParser(is, className);
            RC = parser.parse();
            this.storeClass(RC);
            return RC;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }
}

