/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import com.sun.jmx.mbeanserver.DefaultMXBeanMappingFactory;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.MXBeanMapping;
import com.sun.jmx.mbeanserver.MXBeanMappingFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.openmbean.CompositeData;

public class CompositeDataInvocationHandler
implements InvocationHandler {
    private final CompositeData compositeData;
    private final MXBeanLookup lookup;

    public CompositeDataInvocationHandler(CompositeData compositeData) {
        this(compositeData, null);
    }

    CompositeDataInvocationHandler(CompositeData compositeData, MXBeanLookup lookup) {
        if (compositeData == null) {
            throw new IllegalArgumentException("compositeData");
        }
        this.compositeData = compositeData;
        this.lookup = lookup;
    }

    public CompositeData getCompositeData() {
        assert (this.compositeData != null);
        return this.compositeData;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object openValue;
        String methodName = method.getName();
        if (method.getDeclaringClass() == Object.class) {
            if (methodName.equals("toString") && args == null) {
                return "Proxy[" + this.compositeData + "]";
            }
            if (methodName.equals("hashCode") && args == null) {
                return this.compositeData.hashCode() + 1128548680;
            }
            if (methodName.equals("equals") && args.length == 1 && method.getParameterTypes()[0] == Object.class) {
                return this.equals(proxy, args[0]);
            }
            return method.invoke(this, args);
        }
        String propertyName = DefaultMXBeanMappingFactory.propertyName(method);
        if (propertyName == null) {
            throw new IllegalArgumentException("Method is not getter: " + method.getName());
        }
        if (this.compositeData.containsKey(propertyName)) {
            openValue = this.compositeData.get(propertyName);
        } else {
            String decap = DefaultMXBeanMappingFactory.decapitalize(propertyName);
            if (this.compositeData.containsKey(decap)) {
                openValue = this.compositeData.get(decap);
            } else {
                String msg = "No CompositeData item " + propertyName + (decap.equals(propertyName) ? "" : " or " + decap) + " to match " + methodName;
                throw new IllegalArgumentException(msg);
            }
        }
        MXBeanMapping mapping = MXBeanMappingFactory.DEFAULT.mappingForType(method.getGenericReturnType(), MXBeanMappingFactory.DEFAULT);
        return mapping.fromOpenValue(openValue);
    }

    private boolean equals(Object proxy, Object other) {
        Class<?> otherClass;
        if (other == null) {
            return false;
        }
        Class<?> proxyClass = proxy.getClass();
        if (proxyClass != (otherClass = other.getClass())) {
            return false;
        }
        InvocationHandler otherih = Proxy.getInvocationHandler(other);
        if (!(otherih instanceof CompositeDataInvocationHandler)) {
            return false;
        }
        CompositeDataInvocationHandler othercdih = (CompositeDataInvocationHandler)otherih;
        return this.compositeData.equals(othercdih.compositeData);
    }
}

