/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;

public class PSSParameterSpec
implements AlgorithmParameterSpec {
    private String mdName = "SHA-1";
    private String mgfName = "MGF1";
    private AlgorithmParameterSpec mgfSpec = MGF1ParameterSpec.SHA1;
    private int saltLen = 20;
    private int trailerField = 1;
    public static final PSSParameterSpec DEFAULT = new PSSParameterSpec();

    private PSSParameterSpec() {
    }

    public PSSParameterSpec(String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, int n, int n2) {
        if (string == null) {
            throw new NullPointerException("digest algorithm is null");
        }
        if (string2 == null) {
            throw new NullPointerException("mask generation function algorithm is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("negative saltLen value: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative trailerField: " + n2);
        }
        this.mdName = string;
        this.mgfName = string2;
        this.mgfSpec = algorithmParameterSpec;
        this.saltLen = n;
        this.trailerField = n2;
    }

    public PSSParameterSpec(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative saltLen value: " + n);
        }
        this.saltLen = n;
    }

    public String getDigestAlgorithm() {
        return this.mdName;
    }

    public String getMGFAlgorithm() {
        return this.mgfName;
    }

    public AlgorithmParameterSpec getMGFParameters() {
        return this.mgfSpec;
    }

    public int getSaltLength() {
        return this.saltLen;
    }

    public int getTrailerField() {
        return this.trailerField;
    }
}

